/*
 * Decompiled with CFR 0.152.
 */
package esecurity.tsl.sqllite;

import esecurity.tsl.CertDb;
import esecurity.tsl.CertDbBuilder;
import esecurity.tsl.CertDbType;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.tsl.X509ServiceDbItem;
import esecurity.tsl.sqllite.DefaultManifestSignatureValidator;
import esecurity.tsl.sqllite.ManifestValidator;
import esecurity.tsl.sqllite.SqlDbManifest;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import java.io.IOException;
import org.bouncycastle.util.encoders.Base64;

public class ArubaCdbManifestValidator
implements ManifestValidator {
    private static final String ARUBA_CDB_SIGNER_ROOT = "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";
    private final DefaultManifestSignatureValidator validator;

    public ArubaCdbManifestValidator() throws CapiException {
        CertDb certDb;
        try {
            certDb = CertDbBuilder.get().setType(CertDbType.MEMORY).setNetworkConfig(new NetworkConfig()).build();
        }
        catch (IOException iOException) {
            throw new CapiException("Unable to initialize the manifest validator cdb", 1003, iOException);
        }
        X509ServiceDbItem x509ServiceDbItem = new X509ServiceDbItem(new Certificate(Base64.decode((String)ARUBA_CDB_SIGNER_ROOT)), TSLServiceTypeIdentifiers.QC);
        certDb.importService(x509ServiceDbItem);
        this.validator = new DefaultManifestSignatureValidator(certDb);
    }

    @Override
    public boolean verify(SqlDbManifest sqlDbManifest) throws CapiException {
        return this.validator.verify(sqlDbManifest);
    }

    @Override
    public boolean isValidSigner(Certificate certificate) {
        return this.validator.isValidSigner(certificate);
    }
}

