/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml;

import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.xml.DOMSubTreeData;
import it.actalis.ellips.capi.xml.a;
import it.actalis.vol.utils.Constants;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InternalKeySelector
extends KeySelector {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private Document b;

    public InternalKeySelector(Document document) {
        this.b = document;
    }

    @Override
    public KeySelectorResult select(KeyInfo arrayList, KeySelector.Purpose purpose, AlgorithmMethod object, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        if (arrayList == null) {
            throw new KeySelectorException("Null KeyInfo object!");
        }
        arrayList = arrayList.getContent();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (XMLStructure)arrayList.get(i);
            if (!(object instanceof X509Data)) continue;
            arrayList = new ArrayList<X509Certificate>();
            Object object2 = ((X509Data)object).getContent();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof X509Certificate)) continue;
                object = (X509Certificate)object;
                arrayList.add((X509Certificate)object);
            }
            if (arrayList.size() == 1) {
                return new InternalKeySelectorResult(arrayList);
            }
            object2 = this.a(arrayList, xMLCryptoContext);
            if (object2 == null) {
                if (arrayList.isEmpty()) {
                    throw new KeySelectorException("No KeyValue element found!");
                }
                object2 = (X509Certificate)arrayList.get(0);
            }
            return new InternalKeySelectorResult(arrayList, (X509Certificate)object2);
        }
        throw new KeySelectorException("No KeyValue element found!");
    }

    private X509Certificate a(List<X509Certificate> list, XMLCryptoContext xMLCryptoContext) {
        NodeList nodeList = this.b.getElementsByTagName("ds:SignedInfo");
        if (nodeList.getLength() == 0) {
            nodeList = this.b.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignedInfo");
        }
        X509Certificate x509Certificate = null;
        if (nodeList.getLength() > 1) {
            for (int i = 0; x509Certificate == null && i < nodeList.getLength(); ++i) {
                x509Certificate = this.a((Element)nodeList.item(i), list, xMLCryptoContext);
            }
        } else if (nodeList.getLength() == 1) {
            Element element = (Element)nodeList.item(0);
            x509Certificate = this.a(element, list, xMLCryptoContext);
        }
        return x509Certificate;
    }

    /*
     * WARNING - void declaration
     */
    private X509Certificate a(Element element, List<X509Certificate> list, XMLCryptoContext xMLCryptoContext) {
        NodeList nodeList = element.getElementsByTagName("ds:Reference");
        if (nodeList.getLength() == 0) {
            nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object = (Element)nodeList.item(i);
            if (!"http://uri.etsi.org/01903#SignedProperties".equals(object.getAttribute("Type"))) continue;
            String string = object.getAttribute("URI");
            try {
                String string2;
                void var8_19;
                String string3;
                void var8_16;
                void var8_13;
                object = xMLCryptoContext.getURIDereferencer().dereference(new a(this, (Element)object, string), xMLCryptoContext);
                Object object2 = object = (Element)((DOMSubTreeData)object).getRoot();
                NodeList nodeList2 = object.getElementsByTagName("xades:SigningCertificateV2");
                if (nodeList2.getLength() == 0) {
                    NodeList nodeList3 = object2.getElementsByTagName("xades:SigningCertificate");
                }
                if (((object = (object2 = (Element)var8_13.item(0)).getElementsByTagName("xades:Cert")).getLength() == 0 ? null : (object = (object = ((Element)object.item(0)).getElementsByTagName("xades:CertDigest")).getLength() == 0 ? null : (Element)object.item(0))) == null) {
                    return list.get(0);
                }
                object2 = object;
                NodeList nodeList4 = object2.getElementsByTagName("ds:DigestMethod");
                if (nodeList4.getLength() == 0) {
                    NodeList nodeList5 = object2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
                }
                if (var8_16.getLength() == 0) {
                    string3 = null;
                } else {
                    object2 = (Element)var8_16.item(0);
                    string3 = object2.getAttribute("Algorithm");
                }
                string = string3;
                object2 = object;
                NodeList nodeList6 = object2.getElementsByTagName("ds:DigestValue");
                if (nodeList6.getLength() == 0) {
                    NodeList nodeList7 = object2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "DigestValue");
                }
                if (var8_19.getLength() == 0) {
                    string2 = null;
                } else {
                    object2 = (Element)var8_19.item(0);
                    string2 = object2.getTextContent();
                }
                object = string2;
                for (X509Certificate x509Certificate : list) {
                    try {
                        String string4 = string;
                        Object object3 = MessageDigest.getInstance(string4.substring(string4.lastIndexOf("#") + 1), ProvUtils.bcProvider);
                        byte[] byArray = ((MessageDigest)object3).digest(x509Certificate.getEncoded());
                        object3 = byArray;
                        object3 = Base64.toBase64String((byte[])byArray);
                        if (!((String)object3).equals(object)) continue;
                        return x509Certificate;
                    }
                    catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
                        a.error(generalSecurityException.getMessage(), (Throwable)generalSecurityException);
                    }
                }
                continue;
            }
            catch (URIReferenceException uRIReferenceException) {
                a.error(uRIReferenceException.getMessage(), (Throwable)uRIReferenceException);
            }
        }
        return null;
    }

    public static class InternalKeySelectorResult
    implements KeySelectorResult {
        private X509Certificate a;
        private List<X509Certificate> b;

        InternalKeySelectorResult(List<X509Certificate> list) {
            this.b = list;
            this.a = list.get(0);
        }

        InternalKeySelectorResult(List<X509Certificate> list, X509Certificate x509Certificate) {
            this.b = list;
            this.a = x509Certificate;
        }

        @Override
        public Key getKey() {
            return this.a.getPublicKey();
        }

        public X509Certificate getX509() {
            return this.a;
        }

        public List<X509Certificate> getX509List() {
            return this.b;
        }
    }
}

