/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class StepSignatureDigestAlgorithmCheck
extends SingleValidationSubStepImpl {
    public StepSignatureDigestAlgorithmCheck() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> object, ValidationContextParameters validationContextParameters) {
        object = validationContextParameters.getCalculatedValidationDate().getDate();
        if ((validationContextParameters.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE || validationContextParameters.getProfile() == ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE) && ((Date)object).after(Constants.DPCM_AGID_121_2019)) {
            if (validationContextParameters.getSignature() == null) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
            }
            object = validationContextParameters.getSignature().getSignerInfoData();
            if (object == null || ((SignerInfoData)object).getDigestAlgo() == null) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
            }
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.valueFromCadesId(((SignerInfoData)object).getDigestAlgo());
            if (digestAlgorithm == null) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, ((SignerInfoData)object).getDigestAlgo(), this.getClass().getName());
            }
            if (digestAlgorithm.isForbidden()) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, digestAlgorithm.name(), this.getClass().getName());
            }
            if (!digestAlgorithm.isRecommended()) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, digestAlgorithm.name(), this.getClass().getName());
            }
            return null;
        }
        return null;
    }
}

