/*
 * Decompiled with CFR 0.152.
 */
package esecurity.tsl.sqllite;

import esecurity.tsl.AtrDbItem;
import esecurity.tsl.CertDb;
import esecurity.tsl.CertDbItemFilter;
import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.SignableItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.tsl.TslServiceDbItem;
import esecurity.tsl.X509ServiceDbItem;
import esecurity.tsl.sqllite.ManifestSigner;
import esecurity.tsl.sqllite.ManifestValidator;
import esecurity.tsl.sqllite.SqlDbManifest;
import esecurity.tsl.sqllite.SqlLiteAtrEntry;
import esecurity.tsl.sqllite.SqlLiteEntry;
import esecurity.tsl.v5.TSPServiceType;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.sqlite.SQLiteConfig;

public class SqlLiteCdb
extends CertDb {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final String MANIFEST = "MANIFEST";
    private Connection objConn = null;
    private SqlDbManifest manifest;
    private File file;
    private ManifestValidator validator;
    private static final String WHITELIST_TABLE = "whitelist";
    private static final String BLACKLIST_TABLE = "blacklist";

    public SqlLiteCdb(NetworkConfig networkConfig, File file, ManifestValidator manifestValidator) throws IOException {
        super(networkConfig);
        this.file = file;
        this.validator = manifestValidator;
        try {
            this.objConn = this.getConnection(false);
            this.createNewTable();
            return;
        }
        catch (Exception exception) {
            Util.closeQuietly(this.objConn);
            throw new IOException("Invalid CDB Format", exception);
        }
    }

    private Connection getConnection(boolean bl) throws SQLException {
        Object object = "jdbc:sqlite:file:" + this.file.getAbsolutePath();
        SQLiteConfig sQLiteConfig = new SQLiteConfig();
        sQLiteConfig.setReadOnly(bl);
        object = sQLiteConfig.createConnection((String)object);
        object.setReadOnly(bl);
        return object;
    }

    private void createNewTable() throws SQLException {
        String string = "CREATE TABLE IF NOT EXISTS services (\n\tservice_id VARCHAR(70) NOT NULL,\n\turi_type VARCHAR(200) NOT NULL,\n\tcn VARCHAR(200) NOT NULL,\n\tcert_type VARCHAR(20) NOT NULL,\n\t\"value_type\" VARCHAR(10) NOT NULL,\n\tdigest VARCHAR(70) NOT NULL,\n\tvalue BLOB NOT NULL,\n\tCONSTRAINT services_PK PRIMARY KEY (service_id,uri_type)\n);";
        String string2 = "CREATE INDEX IF NOT EXISTS idx_cn ON services (cn);";
        String string3 = "CREATE INDEX IF NOT EXISTS idx_certType ON services (cert_type);";
        Statement statement = null;
        try {
            statement = this.objConn.createStatement();
            statement.execute(string);
            statement.execute(string2);
            statement.execute(string3);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(statement);
            throw throwable;
        }
        Util.closeQuietly(statement);
    }

    @Override
    protected List<ServiceDbItem> getServiceItems(String string) {
        CertDbItemFilter certDbItemFilter = new CertDbItemFilter();
        new CertDbItemFilter().serviceId = string;
        return this.queryServiceItems(certDbItemFilter);
    }

    private SqlLiteEntry getEntry(String list, String string) {
        CertDbItemFilter certDbItemFilter = new CertDbItemFilter();
        new CertDbItemFilter().serviceId = list;
        certDbItemFilter.uriType = string;
        list = this.getEntries(certDbItemFilter);
        if (!list.isEmpty()) {
            return (SqlLiteEntry)list.get(0);
        }
        return null;
    }

    private List<SqlLiteEntry> getEntries(CertDbItemFilter certDbItemFilter) {
        ArrayList<SqlLiteEntry> arrayList;
        block7: {
            arrayList = new ArrayList<SqlLiteEntry>();
            this.throwExceptionIfClosed();
            Object object = "select * from services";
            Object object2 = this.whereFilter(certDbItemFilter);
            if (!((String)object2).isEmpty()) {
                object = (String)object + " where " + (String)object2;
            }
            object2 = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                connection = this.getConnection(true);
                object2 = connection.prepareStatement((String)object);
                this.applayFilter((PreparedStatement)object2, certDbItemFilter);
                resultSet = object2.executeQuery();
                while (resultSet.next()) {
                    object = new SqlLiteEntry();
                    ((SqlLiteEntry)object).setValue(this.unCompressBlob(resultSet.getBytes("value")));
                    ((SqlLiteEntry)object).setServiceId(resultSet.getString("service_id"));
                    ((SqlLiteEntry)object).setCn(resultSet.getString("cn"));
                    ((SqlLiteEntry)object).setCertType(resultSet.getString("cert_type"));
                    ((SqlLiteEntry)object).setUriType(resultSet.getString("uri_type"));
                    ((SqlLiteEntry)object).setValueType(resultSet.getString("value_type"));
                    ((SqlLiteEntry)object).setDigest(resultSet.getBytes("digest"));
                    arrayList.add((SqlLiteEntry)object);
                }
                Util.closeQuietly((AutoCloseable)object2);
            }
            catch (Exception exception) {
                logger.error("Errore nel recupero del servizio {}", (Object)certDbItemFilter, (Object)exception);
                break block7;
            }
            finally {
                Util.closeQuietly((AutoCloseable)object2);
                Util.closeQuietly(resultSet);
                Util.closeQuietly(connection);
            }
            Util.closeQuietly(resultSet);
            Util.closeQuietly(connection);
        }
        return arrayList;
    }

    private String whereFilter(CertDbItemFilter certDbItemFilter) {
        String string = "";
        if (certDbItemFilter == null) {
            return string;
        }
        if (certDbItemFilter.serviceId != null) {
            string = this.whereAddField(string, "service_id");
        }
        if (certDbItemFilter.certType != null) {
            string = this.whereAddField(string, "cert_type");
        }
        if (certDbItemFilter.commonName != null) {
            if (!string.isEmpty()) {
                string = string + " and ";
            }
            string = string + " cn like ? ";
        }
        if (certDbItemFilter.uriType != null) {
            string = this.whereAddField(string, "uri_type");
        }
        return string;
    }

    private String whereAddField(String string, String string2) {
        if (!string.isEmpty()) {
            string = string + " and ";
        }
        string = string + " " + string2 + "=? ";
        return string;
    }

    private void applayFilter(PreparedStatement preparedStatement, CertDbItemFilter certDbItemFilter) throws SQLException {
        int n = 1;
        if (certDbItemFilter == null) {
            return;
        }
        if (certDbItemFilter.serviceId != null) {
            preparedStatement.setString(1, certDbItemFilter.serviceId);
            ++n;
        }
        if (certDbItemFilter.certType != null) {
            preparedStatement.setString(n, certDbItemFilter.certType.toString());
            ++n;
        }
        if (certDbItemFilter.commonName != null) {
            preparedStatement.setString(n, "%" + certDbItemFilter.commonName + "%");
            ++n;
        }
        if (certDbItemFilter.uriType != null) {
            preparedStatement.setString(n, certDbItemFilter.uriType);
        }
    }

    @Override
    public void importService(ServiceDbItem serviceDbItem) throws CapiException {
        String string = this.calculateServiceIdFromSubject(serviceDbItem.getCert(), serviceDbItem.getCert().getSubjectDN());
        byte[] byArray = serviceDbItem.getCert().getDerEncoded();
        String string2 = "X509";
        if (serviceDbItem instanceof TslServiceDbItem) {
            byArray = ((TslServiceDbItem)serviceDbItem).getRowData();
            string2 = "TSL";
        }
        SqlLiteEntry sqlLiteEntry = new SqlLiteEntry();
        sqlLiteEntry.setServiceId(string);
        sqlLiteEntry.setUriType(serviceDbItem.getServiceType().getUri());
        sqlLiteEntry.setCertType(serviceDbItem.getCert().getCertificateType().toString());
        if (serviceDbItem.getCert().getSubjectCommonName() != null) {
            sqlLiteEntry.setCn(serviceDbItem.getCert().getSubjectCommonName());
        } else {
            sqlLiteEntry.setCn(serviceDbItem.getCert().getSubjectDN());
        }
        sqlLiteEntry.setValueType(string2);
        sqlLiteEntry.setValue(byArray);
        sqlLiteEntry.setDigest(this.calculateDigest(sqlLiteEntry));
        this.addEntry(sqlLiteEntry);
    }

    private void addEntry(SqlLiteEntry sqlLiteEntry) throws CapiException {
        Object object = "INSERT INTO services\n(service_id, uri_type, \"cn\", \"cert_type\", \"value_type\", value, digest)\nVALUES(?, ?,?,?, ?, ?, ?);";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.objConn.prepareStatement((String)object);
            preparedStatement.setString(1, sqlLiteEntry.getServiceId());
            preparedStatement.setString(2, sqlLiteEntry.getUriType());
            preparedStatement.setString(3, sqlLiteEntry.getCn());
            preparedStatement.setString(4, sqlLiteEntry.getCertType());
            preparedStatement.setString(5, sqlLiteEntry.getValueType());
            preparedStatement.setBytes(6, this.compressBlob(sqlLiteEntry.getValue()));
            preparedStatement.setBytes(7, sqlLiteEntry.getDigest());
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                object = exception;
                if (!exception.getMessage().contains("PRIMARY KEY constraint failed")) {
                    logger.error("Unable to add the Entry", (Throwable)object);
                    throw new CapiException("Unable to add the CertDb Entry", 1003, (Throwable)object);
                }
                this.updateEntry(sqlLiteEntry);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(preparedStatement);
                throw throwable;
            }
            Util.closeQuietly(preparedStatement);
            return;
        }
        Util.closeQuietly(preparedStatement);
        return;
    }

    private void updateEntry(SqlLiteEntry sqlLiteEntry) throws CapiException {
        PreparedStatement preparedStatement;
        block4: {
            String string = "update services\nset cn=?, cert_type= ?, value_type=?, value=?, digest=?\nwhere service_id = ? and uri_type = ? and digest <> ?";
            preparedStatement = null;
            try {
                preparedStatement = this.objConn.prepareStatement(string);
                preparedStatement.setString(1, sqlLiteEntry.getCn());
                preparedStatement.setString(2, sqlLiteEntry.getCertType());
                preparedStatement.setString(3, sqlLiteEntry.getValueType());
                preparedStatement.setBytes(4, this.compressBlob(sqlLiteEntry.getValue()));
                preparedStatement.setBytes(5, sqlLiteEntry.getDigest());
                preparedStatement.setString(6, sqlLiteEntry.getServiceId());
                preparedStatement.setString(7, sqlLiteEntry.getUriType());
                preparedStatement.setBytes(8, sqlLiteEntry.getDigest());
                int n = preparedStatement.executeUpdate();
                if (!logger.isDebugEnabled() || n <= 0) break block4;
                logger.debug("Aggionata entry {} ", (Object)sqlLiteEntry.getCn());
            }
            catch (Exception exception) {
                try {
                    throw new CapiException("Unable to add the CertDb Entry", 1003, exception);
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(preparedStatement);
                    throw throwable;
                }
            }
        }
        Util.closeQuietly(preparedStatement);
        return;
    }

    @Override
    public int getServiceCount() {
        Connection connection;
        PreparedStatement preparedStatement;
        block4: {
            int n;
            this.throwExceptionIfClosed();
            Object object = "select count(*) from services";
            preparedStatement = null;
            connection = null;
            try {
                connection = this.getConnection(true);
                preparedStatement = connection.prepareStatement((String)object);
                object = preparedStatement.executeQuery();
                if (!object.next()) break block4;
                n = object.getInt(1);
            }
            catch (Exception exception) {
                try {
                    logger.error("Errore new recupero del manifest", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(preparedStatement);
                    Util.closeQuietly(connection);
                    throw throwable;
                }
                Util.closeQuietly(preparedStatement);
                Util.closeQuietly(connection);
            }
            Util.closeQuietly(preparedStatement);
            Util.closeQuietly(connection);
            return n;
        }
        Util.closeQuietly(preparedStatement);
        Util.closeQuietly(connection);
        return 0;
    }

    @Override
    public List<ServiceDbItem> queryServiceItems(CertDbItemFilter certDbItemFilter) {
        LinkedList<ServiceDbItem> linkedList = new LinkedList<ServiceDbItem>();
        Object object = this.getEntries(certDbItemFilter);
        try {
            object = object.iterator();
            while (object.hasNext()) {
                ServiceDbItem serviceDbItem;
                SqlLiteEntry sqlLiteEntry = (SqlLiteEntry)object.next();
                if (sqlLiteEntry.getServiceId().equals(MANIFEST) || (serviceDbItem = this.buildItem(sqlLiteEntry)) == null) continue;
                if (serviceDbItem instanceof SignableItem) {
                    this.verifyEntrySignature(sqlLiteEntry, serviceDbItem);
                }
                linkedList.add(serviceDbItem);
            }
        }
        catch (Exception exception) {
            logger.error("Errore nel recupero delle entry {}", (Object)certDbItemFilter, (Object)exception);
        }
        return linkedList;
    }

    @Override
    public List<ServiceDbItem> queryServiceItems(Certificate certificate) {
        Object object = this.calculateServiceIdFromSubject(certificate, null);
        if (object != null) {
            return this.getServiceItems((String)object);
        }
        object = new CertDbItemFilter();
        try {
            ((CertDbItemFilter)object).commonName = certificate.getSubjectCommonName();
        }
        catch (CapiException capiException) {
            return null;
        }
        return this.queryServiceItems((CertDbItemFilter)object);
    }

    @Override
    public List<AtrDbItem> getAtrWhiteList() {
        SqlLiteCdb sqlLiteCdb = this;
        return sqlLiteCdb.getAtrList(sqlLiteCdb.getSqlLiteAtrEntries(WHITELIST_TABLE));
    }

    private List<AtrDbItem> getAtrList(List<SqlLiteAtrEntry> object) {
        ArrayList<AtrDbItem> arrayList = new ArrayList<AtrDbItem>();
        object = object.iterator();
        while (object.hasNext()) {
            SqlLiteAtrEntry sqlLiteAtrEntry = (SqlLiteAtrEntry)object.next();
            AtrDbItem atrDbItem = new AtrDbItem();
            atrDbItem.setAtr(sqlLiteAtrEntry.getAtr());
            this.verifyAtrSignature(atrDbItem, sqlLiteAtrEntry);
            arrayList.add(atrDbItem);
        }
        return arrayList;
    }

    @Override
    public void removeServiceItem(Certificate object) throws CapiException {
        if ((object = this.calculateServiceIdFromSubject((Certificate)object, null)) == null) {
            return;
        }
        String string = "DELETE FROM services WHERE service_id=?;";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.objConn.prepareStatement(string);
            preparedStatement.setString(1, (String)object);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                throw new CapiException("Unable to remove item " + (String)object + " from table services", 1003, exception);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(preparedStatement);
                throw throwable;
            }
        }
        Util.closeQuietly(preparedStatement);
        return;
    }

    @Override
    public boolean isAtrInWhitelist(String string) {
        return this.isAtrInList(WHITELIST_TABLE, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAtrInList(String string, String string2) {
        boolean bl;
        string2 = "select * from " + string + " where atr='" + string2.toUpperCase() + "';";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.getConnection(true);
            preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            bl = resultSet.first();
        }
        catch (Exception exception) {
            try {
                logger.error("Errore nel controllo della presenza dell'ATR dalla tabella " + string, (Throwable)exception);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(preparedStatement);
                Util.closeQuietly(resultSet);
                Util.closeQuietly(connection);
                throw throwable;
            }
            Util.closeQuietly(preparedStatement);
            Util.closeQuietly(resultSet);
            Util.closeQuietly(connection);
            return false;
        }
        Util.closeQuietly(preparedStatement);
        Util.closeQuietly(resultSet);
        Util.closeQuietly(connection);
        return bl;
    }

    @Override
    public void replaceAtrWhitelist(List<String> object) throws CapiException {
        this.replaceAtrTable(WHITELIST_TABLE);
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.addAtrToDatabase(WHITELIST_TABLE, string);
        }
    }

    @Override
    public List<AtrDbItem> getAtrBlackList() {
        SqlLiteCdb sqlLiteCdb = this;
        return sqlLiteCdb.getAtrList(sqlLiteCdb.getSqlLiteAtrEntries(BLACKLIST_TABLE));
    }

    private List<SqlLiteAtrEntry> getSqlLiteAtrEntries(String string) {
        ArrayList<SqlLiteAtrEntry> arrayList = new ArrayList<SqlLiteAtrEntry>();
        Object object = "select * from " + string + ";";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.getConnection(true);
            preparedStatement = connection.prepareStatement((String)object);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new SqlLiteAtrEntry();
                ((SqlLiteAtrEntry)object).setAtr(resultSet.getString("atr").toUpperCase());
                ((SqlLiteAtrEntry)object).setDigest(resultSet.getBytes("digest"));
                arrayList.add((SqlLiteAtrEntry)object);
            }
        }
        catch (Exception exception) {
            try {
                logger.error("Errore nel recupero ATR dalla tabella " + string, (Throwable)exception);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(preparedStatement);
                Util.closeQuietly(resultSet);
                Util.closeQuietly(connection);
                throw throwable;
            }
            Util.closeQuietly(preparedStatement);
            Util.closeQuietly(resultSet);
            Util.closeQuietly(connection);
        }
        Util.closeQuietly(preparedStatement);
        Util.closeQuietly(resultSet);
        Util.closeQuietly(connection);
        return arrayList;
    }

    @Override
    public void removeAtrWhitelist(String string) throws CapiException {
        this.removeAtrFromList(WHITELIST_TABLE, string);
    }

    private void removeAtrFromList(String string, String string2) throws CapiException {
        string = "DELETE FROM " + string + " WHERE atr=?;";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.objConn.prepareStatement(string);
            preparedStatement.setString(1, string2.toUpperCase());
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                throw new CapiException("Unable to remove the ATR Blacklist Entry", 1003, exception);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(preparedStatement);
                throw throwable;
            }
        }
        Util.closeQuietly(preparedStatement);
        return;
    }

    @Override
    public boolean isAtrInBlacklist(String string) {
        return this.isAtrInList(BLACKLIST_TABLE, string);
    }

    @Override
    public AtrDbItem getWhiteListAtrItem(String string) {
        return this.getAtrItem(WHITELIST_TABLE, string);
    }

    @Override
    public AtrDbItem getBlackListAtrItem(String string) {
        return this.getAtrItem(BLACKLIST_TABLE, string);
    }

    private AtrDbItem getAtrItem(String object, String object2) {
        if ((object = this.getSqlLiteAtrEntry((String)object, (String)object2)) == null) {
            return null;
        }
        object2 = new AtrDbItem();
        ((AtrDbItem)object2).setAtr(((SqlLiteAtrEntry)object).getAtr());
        this.verifyAtrSignature((AtrDbItem)object2, (SqlLiteAtrEntry)object);
        return object2;
    }

    private SqlLiteAtrEntry getSqlLiteAtrEntry(String string, String string2) {
        SqlLiteAtrEntry sqlLiteAtrEntry;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block4: {
            String string3 = "select * FROM " + string + " WHERE atr=?;";
            preparedStatement = null;
            resultSet = null;
            sqlLiteAtrEntry = null;
            try {
                preparedStatement = this.objConn.prepareStatement(string3);
                preparedStatement.setString(1, string2.toUpperCase());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                sqlLiteAtrEntry = new SqlLiteAtrEntry();
                sqlLiteAtrEntry.setAtr(resultSet.getString("atr").toUpperCase());
                sqlLiteAtrEntry.setDigest(resultSet.getBytes("digest"));
            }
            catch (Exception exception) {
                try {
                    logger.error("Errore nel recupero dalla tabella " + string, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(preparedStatement);
                    Util.closeQuietly(resultSet);
                    throw throwable;
                }
                Util.closeQuietly(preparedStatement);
                Util.closeQuietly(resultSet);
            }
        }
        Util.closeQuietly(preparedStatement);
        Util.closeQuietly(resultSet);
        return sqlLiteAtrEntry;
    }

    @Override
    public void replaceAtrBlacklist(List<String> object) throws CapiException {
        this.replaceAtrTable(BLACKLIST_TABLE);
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.addAtrToDatabase(BLACKLIST_TABLE, string);
        }
    }

    private void replaceAtrTable(String string) throws CapiException {
        String string2 = "DROP TABLE IF EXISTS " + string + ";";
        String string3 = "CREATE TABLE IF NOT EXISTS " + string + " (atr VARCHAR(66) NOT NULL, digest VARCHAR(70), \n\tCONSTRAINT atr_PK PRIMARY KEY (atr));";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.objConn.prepareStatement(string2);
            preparedStatement.execute();
            preparedStatement = this.objConn.prepareStatement(string3);
            preparedStatement.execute();
        }
        catch (Exception exception) {
            try {
                throw new CapiException("Unable to execute drop or create " + string + " table", 1003, exception);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(preparedStatement);
                throw throwable;
            }
        }
        Util.closeQuietly(preparedStatement);
        return;
    }

    private void addAtrToDatabase(String string, String string2) throws CapiException {
        String string3 = "INSERT INTO " + string + " (atr, digest) VALUES(?, ?);";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.objConn.prepareStatement(string3);
            preparedStatement.setString(1, string2.toUpperCase());
            preparedStatement.setBytes(2, this.calculateDigestAtr(string2.toUpperCase()));
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                throw new CapiException("Unable to add atr to " + string + " Entry", 1003, exception);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(preparedStatement);
                throw throwable;
            }
        }
        Util.closeQuietly(preparedStatement);
        return;
    }

    @Override
    public void removeAtrBlacklist(String string) throws CapiException {
        this.removeAtrFromList(BLACKLIST_TABLE, string);
    }

    private ServiceDbItem buildItem(SqlLiteEntry sqlLiteEntry) throws CapiException {
        byte[] byArray = sqlLiteEntry.getValue();
        Object object = sqlLiteEntry.getValueType();
        if ("X509".equals(object)) {
            object = TSLServiceTypeIdentifiers.fromUri(sqlLiteEntry.getUriType());
            return new X509ServiceDbItem(new Certificate(byArray, false), (TSLServiceTypeIdentifiers)((Object)object));
        }
        try {
            object = (TSPServiceType)TslServiceDbItem.getDefaultObjectMapper().readValue(byArray, TSPServiceType.class);
            return new TslServiceDbItem((TSPServiceType)object);
        }
        catch (Throwable throwable) {
            logger.error("Item non valido {} Type {}", (Object)sqlLiteEntry.getServiceId(), (Object)sqlLiteEntry.getUriType());
            if (logger.isDebugEnabled()) {
                logger.debug("info :{}", (Object)new String(byArray));
            }
            return null;
        }
    }

    private void verifyEntrySignature(SqlLiteEntry sqlLiteEntry, ServiceDbItem serviceDbItem) {
        Object object = this.manifestKeyFromEntry(sqlLiteEntry);
        SqlDbManifest sqlDbManifest = this.manifest;
        if (sqlDbManifest == null) {
            sqlDbManifest = this.reloadManifest();
        }
        if (sqlDbManifest == null) {
            return;
        }
        object = sqlDbManifest.getEntries().get(object);
        if (Arrays.equals(sqlLiteEntry.getDigest(), (byte[])object)) {
            serviceDbItem.setValidSignature(true);
        }
    }

    private void verifyAtrSignature(AtrDbItem atrDbItem, SqlLiteAtrEntry sqlLiteAtrEntry) {
        Object object = Base64.toBase64String((byte[])sqlLiteAtrEntry.getAtr().getBytes());
        SqlDbManifest sqlDbManifest = this.manifest;
        if (sqlDbManifest == null) {
            sqlDbManifest = this.reloadManifest();
        }
        if (sqlDbManifest == null) {
            return;
        }
        object = sqlDbManifest.getEntries().get(object);
        if (Arrays.equals(sqlLiteAtrEntry.getDigest(), (byte[])object)) {
            atrDbItem.setValidSignature(true);
        }
    }

    @Override
    public void close() {
        Util.closeQuietly(this.objConn);
        this.objConn = null;
        this.close = true;
    }

    public void finalize() throws Throwable {
        Util.closeQuietly(this);
        super.finalize();
    }

    private synchronized SqlDbManifest reloadManifest() {
        if (this.manifest != null) {
            return this.manifest;
        }
        try {
            Object object = this.getEntry(MANIFEST, MANIFEST);
            if (object == null) {
                return this.manifest;
            }
            byte[] byArray = ((SqlLiteEntry)object).getValue();
            object = byArray;
            object = SqlDbManifest.fromData(byArray);
            this.manifest = this.validator.verify((SqlDbManifest)object) ? object : null;
        }
        catch (Exception exception) {
            logger.error("Errore nel recupero del manifest", (Throwable)exception);
            this.manifest = null;
        }
        return this.manifest;
    }

    public void signManifest(ManifestSigner manifestSigner) throws CapiException {
        if (manifestSigner == null) {
            throw new CapiException("Invalid Signer NULL", 1001);
        }
        this.throwExceptionIfClosed();
        SqlDbManifest sqlDbManifest = new SqlDbManifest();
        Object object = this.getEntries(null);
        try {
            object = object.iterator();
            while (object.hasNext()) {
                SqlLiteEntry object2 = (SqlLiteEntry)object.next();
                if (object2.getUriType().equals(MANIFEST)) continue;
                String string = this.manifestKeyFromEntry(object2);
                byte[] byArray = this.calculateDigest(object2);
                if (Arrays.equals(byArray, object2.getDigest())) {
                    sqlDbManifest.addEntry(string, byArray);
                    continue;
                }
                logger.info("Entry corrotta non sar\u00e0 firmata. serviceId:{}", (Object)object2.getServiceId());
            }
            for (SqlLiteAtrEntry sqlLiteAtrEntry : this.getSqlLiteAtrEntries(BLACKLIST_TABLE)) {
                sqlDbManifest.addEntry(Base64.toBase64String((byte[])sqlLiteAtrEntry.getAtr().getBytes()), sqlLiteAtrEntry.getDigest());
            }
            for (SqlLiteAtrEntry sqlLiteAtrEntry : this.getSqlLiteAtrEntries(WHITELIST_TABLE)) {
                sqlDbManifest.addEntry(Base64.toBase64String((byte[])sqlLiteAtrEntry.getAtr().getBytes()), sqlLiteAtrEntry.getDigest());
            }
            sqlDbManifest.sign(manifestSigner);
            object = new SqlLiteEntry();
            ((SqlLiteEntry)object).setServiceId(MANIFEST);
            ((SqlLiteEntry)object).setUriType(MANIFEST);
            ((SqlLiteEntry)object).setValueType(MANIFEST);
            ((SqlLiteEntry)object).setCertType(MANIFEST);
            ((SqlLiteEntry)object).setCn(MANIFEST);
            ((SqlLiteEntry)object).setValue(SqlDbManifest.toData(sqlDbManifest));
            ((SqlLiteEntry)object).setDigest(this.calculateDigest((SqlLiteEntry)object));
            this.addEntry((SqlLiteEntry)object);
            this.manifest = sqlDbManifest;
            return;
        }
        catch (Exception exception) {
            logger.error("Errore nelle firma del manifest", (Throwable)exception);
            throw new CapiException("Unable to sign manifest", 1003, exception);
        }
    }

    private String manifestKeyFromEntry(SqlLiteEntry sqlLiteEntry) {
        return Base64.toBase64String((byte[])(sqlLiteEntry.getServiceId() + "-" + TSLServiceTypeIdentifiers.fromUri(sqlLiteEntry.getUriType()).getShortName()).getBytes());
    }

    private byte[] calculateDigest(SqlLiteEntry sqlLiteEntry) {
        SHA256Digest sHA256Digest = new SHA256Digest();
        byte[] byArray = new byte[sHA256Digest.getDigestSize()];
        sHA256Digest.update(sqlLiteEntry.getServiceId().getBytes(), 0, sqlLiteEntry.getServiceId().getBytes().length);
        sHA256Digest.update(sqlLiteEntry.getUriType().getBytes(), 0, sqlLiteEntry.getUriType().getBytes().length);
        sHA256Digest.update(sqlLiteEntry.getValueType().getBytes(), 0, sqlLiteEntry.getValueType().getBytes().length);
        sHA256Digest.update(sqlLiteEntry.getValue(), 0, sqlLiteEntry.getValue().length);
        sHA256Digest.doFinal(byArray, 0);
        return byArray;
    }

    private byte[] calculateDigestAtr(String string) {
        SHA256Digest sHA256Digest = new SHA256Digest();
        byte[] byArray = new byte[sHA256Digest.getDigestSize()];
        sHA256Digest.update(string.getBytes(), 0, string.getBytes().length);
        sHA256Digest.doFinal(byArray, 0);
        return byArray;
    }

    private byte[] compressBlob(byte[] byArray) throws CapiException {
        if (byArray == null) {
            throw new CapiException("Empty Blob", 1003);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = null;
        try {
            gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            try {
                throw new CapiException("Ubable to compress Stream", 1003);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(gZIPOutputStream);
                Util.closeQuietly(byteArrayOutputStream);
                throw throwable;
            }
        }
        Util.closeQuietly(gZIPOutputStream);
        Util.closeQuietly(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] unCompressBlob(byte[] byArray) throws CapiException {
        if (byArray == null) {
            throw new CapiException("Empty Blob", 1003);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPInputStream gZIPInputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            int n;
            byte[] byArray2 = new byte[1024];
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
        }
        catch (IOException iOException) {
            try {
                throw new CapiException("Ubable to compress Stream", 1003);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(byteArrayOutputStream);
                Util.closeQuietly(gZIPInputStream);
                Util.closeQuietly(byteArrayInputStream);
                throw throwable;
            }
        }
        Util.closeQuietly(byteArrayOutputStream);
        Util.closeQuietly(gZIPInputStream);
        Util.closeQuietly(byteArrayInputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void merge(CertDb certDb) throws CapiException {
        Object object = certDb.queryServiceItems((CertDbItemFilter)null);
        object = object.iterator();
        while (object.hasNext()) {
            ServiceDbItem serviceDbItem = (ServiceDbItem)object.next();
            this.importService(serviceDbItem);
        }
        if (!(certDb instanceof SqlLiteCdb)) {
            return;
        }
        object = ((SqlLiteCdb)certDb).getEntry(MANIFEST, MANIFEST);
        if (object == null) {
            return;
        }
        this.reloadManifest();
        this.deleteSqlLiteEntryNotPresent((SqlLiteCdb)certDb);
        this.addEntry((SqlLiteEntry)object);
        this.manifest = null;
        this.reloadManifest();
    }

    @Override
    public void addAtrToBlackList(String string) throws CapiException {
        this.addAtrToDatabase(BLACKLIST_TABLE, string);
    }

    @Override
    public void addAtrToWhiteList(String string) throws CapiException {
        this.addAtrToDatabase(WHITELIST_TABLE, string);
    }

    public void deleteSqlLiteEntryNotPresent(SqlLiteCdb sqlLiteCdb) {
        if (this.manifest == null) {
            return;
        }
        for (Map.Entry<String, byte[]> exception : this.manifest.getEntries().entrySet()) {
            if (sqlLiteCdb.manifest.getEntries().containsKey(exception.getKey())) continue;
            byte[] byArray = Base64.decode((String)exception.getKey());
            String string = new String(byArray);
            Object object = string.split("-");
            if (((String[])object).length > 2) {
                object = new String[2];
                if (string.contains("TSS-QC")) {
                    object[0] = string.substring(0, string.lastIndexOf("TSS-QC") - 1);
                    object[1] = "TSS-QC";
                } else {
                    object[0] = string.substring(0, string.lastIndexOf("-"));
                    String string2 = string;
                    object[1] = string2.substring(string2.lastIndexOf("-") + 1);
                }
            }
            if (((String[])object).length <= 1) continue;
            try {
                TSLServiceTypeIdentifiers tSLServiceTypeIdentifiers = TSLServiceTypeIdentifiers.fromShortName(object[1]);
                String string3 = tSLServiceTypeIdentifiers != null ? tSLServiceTypeIdentifiers.getUri() : null;
                object = object[0];
                this.removeServiceFromKey((String)object, string3);
            }
            catch (Exception exception2) {
                logger.error(exception2.getMessage(), (Throwable)exception2);
            }
        }
    }

    public void removeServiceFromKey(String string, String string2) throws CapiException {
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            return;
        }
        String string3 = "DELETE FROM services WHERE service_id=? and uri_type=?;";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.objConn.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            try {
                throw new CapiException("Unable to remove item " + string + " from table services", 1003, exception);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(preparedStatement);
                throw throwable;
            }
        }
        Util.closeQuietly(preparedStatement);
        return;
    }
}

