/*
 * Decompiled with CFR 0.152.
 */
package jnasmartcardio;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByReference;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactorySpi;
import jnasmartcardio.Winscard;
import jnasmartcardio.a;

public class Smartcardio
extends Provider {
    private static final long serialVersionUID = 1L;
    public static final String PROVIDER_NAME = "JNA2PCSC";
    public static final int SCARD_S_SUCCESS = 0;
    public static final int SCARD_E_NO_READERS_AVAILABLE = -2146435026;
    public static final int SCARD_E_READER_UNAVAILABLE = -2146435049;
    public static final int SCARD_E_NO_SMARTCARD = -2146435060;

    public Smartcardio() {
        super(PROVIDER_NAME, 0.2, "JNA-to-PCSC Provider");
        this.put("TerminalFactory.PC/SC", JnaTerminalFactorySpi.class.getName());
    }

    private static void b(String string, long l) throws JnaPCSCException {
        if (l == 0L) {
            return;
        }
        int n = (int)l;
        String string2 = a.b.get(n);
        String string3 = a.a.get(n);
        throw new JnaPCSCException(l, String.format("%s got response 0x%x (%s: %s)", string, n, string2, string3));
    }

    static /* synthetic */ List a(byte[] byArray) {
        Charset charset = Charset.forName("UTF-8");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            if (n == i) {
                return arrayList;
            }
            byte[] byArray2 = Arrays.copyOfRange(byArray, n, i);
            arrayList.add(new String(byArray2, charset));
            n = i + 1;
        }
        throw new IllegalArgumentException("Multistring must be end with a null-terminated empty string.");
    }

    public static class JnaCardException
    extends CardException {
        private static final long serialVersionUID = 1L;
        public final int sw;

        public JnaCardException(int n, String string) {
            this(n, string, null);
        }

        public JnaCardException(int n, String string, Throwable throwable) {
            super(string, throwable);
            this.sw = n;
        }
    }

    public static class JnaCardNotPresentException
    extends CardNotPresentException {
        private static final long serialVersionUID = 1L;
        public final long code;

        public JnaCardNotPresentException(long l, String string) {
            super(string);
            this.code = l;
        }
    }

    public static class EstablishContextException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public EstablishContextException(JnaPCSCException jnaPCSCException) {
            super(jnaPCSCException);
        }

        @Override
        public JnaPCSCException getCause() {
            return (JnaPCSCException)super.getCause();
        }
    }

    public static class JnaPCSCException
    extends CardException {
        private static final long serialVersionUID = 1L;
        public final long code;

        public JnaPCSCException(String string) {
            this(0L, string, null);
        }

        public JnaPCSCException(Throwable throwable) {
            this(0L, null, throwable);
        }

        public JnaPCSCException(long l, String string) {
            this(l, string, null);
        }

        public JnaPCSCException(long l, String string, Throwable throwable) {
            super(string, throwable);
            this.code = l;
        }
    }

    public static class JnaCardChannel
    extends CardChannel {
        private final JnaCard a;
        private final int b;
        private boolean c;

        public JnaCardChannel(JnaCard jnaCard, int n) {
            this.a = jnaCard;
            this.b = n;
        }

        @Override
        public void close() throws CardException {
            if (this.c) {
                return;
            }
            this.c = true;
            if (this.b != 0) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(new CommandAPDU(0, 112, 128, this.b).getBytes());
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(2);
                this.a(byteBuffer, byteBuffer2);
                byteBuffer2.rewind();
                int n = 0xFFFF & byteBuffer2.getShort();
                if (n != 36864) {
                    throw new JnaCardException(n, "Could not close channel.");
                }
                return;
            }
            throw new IllegalStateException("Basic channel can not be closed");
        }

        @Override
        public Card getCard() {
            return this.a;
        }

        @Override
        public int getChannelNumber() {
            return this.b;
        }

        @Override
        public ResponseAPDU transmit(CommandAPDU object) throws CardException {
            if (object == null) {
                throw new IllegalArgumentException("command is null");
            }
            object = ((CommandAPDU)object).getBytes();
            ByteBuffer byteBuffer = this.a((byte[])object, null);
            object = byteBuffer;
            object = byteBuffer;
            byte[] byArray = new byte[byteBuffer.position()];
            ((ByteBuffer)object).rewind();
            ((ByteBuffer)object).get(byArray);
            object = new ResponseAPDU(byArray);
            return object;
        }

        @Override
        public int transmit(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws CardException {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("command is null");
            }
            if (byteBuffer2 == null) {
                throw new IllegalArgumentException("response is null");
            }
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            int n = byteBuffer2.position();
            this.a(byArray, byteBuffer2);
            int n2 = byteBuffer2.position();
            return n2 - n;
        }

        private ByteBuffer a(byte[] byArray, ByteBuffer byteBuffer) throws CardException, JnaPCSCException {
            byte by;
            if (this.a.d == 1) {
                byte[] byArray2 = byArray;
                if (byArray.length >= 7 && byArray2[4] == 0) {
                    throw new CardException("Extended APDU requires T=1");
                }
            }
            int n = this.getChannelNumber();
            int n2 = byArray[0];
            if ((0x80 & n2) != 0) {
                by = n2;
            } else {
                if (n >= 0 && n <= 3) {
                    n2 = n2 & 0x1C | n;
                } else if (4 <= n && n <= 19) {
                    n2 = n2 & 0x30 | (n -= 4) | 0x40;
                } else {
                    throw new IllegalStateException("Bad channel number; expected 0-19; got " + n);
                }
                by = (byte)n2;
            }
            byArray[0] = by;
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
            if (byteBuffer == null) {
                byteBuffer = ByteBuffer.allocate(8192);
            }
            for (n = 0; n < 8; ++n) {
                int n3 = byteBuffer.position();
                this.a(byteBuffer2, byteBuffer);
                ByteBuffer byteBuffer3 = byteBuffer;
                byteBuffer3.position(byteBuffer3.position() - 2);
                byte by2 = byteBuffer.get();
                byte by3 = byteBuffer.get();
                if (108 == by2) {
                    byArray[byArray.length - 1] = by3;
                    byteBuffer.position(n3);
                    byteBuffer2.rewind();
                    continue;
                }
                if (97 != by2) break;
                byArray[1] = -64;
                byArray[2] = 0;
                byArray[3] = 0;
                byArray[4] = by3;
                byteBuffer2.position(0);
                byteBuffer2.limit(5);
                ByteBuffer byteBuffer4 = byteBuffer;
                byteBuffer4.position(byteBuffer4.position() - 2);
            }
            return byteBuffer;
        }

        private int a(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws JnaPCSCException {
            Winscard.ScardIoRequest scardIoRequest = new Winscard.ScardIoRequest();
            new Winscard.ScardIoRequest().dwProtocol = new Winscard.Dword(this.a.d);
            scardIoRequest.cbPciLength = new Winscard.Dword(scardIoRequest.size());
            Winscard.DwordByReference dwordByReference = new Winscard.DwordByReference(new Winscard.Dword(byteBuffer2.remaining()));
            Smartcardio.b("SCardTransmit", ((JnaCard)this.a).a.lib.SCardTransmit(this.a.b, scardIoRequest, byteBuffer, new Winscard.Dword(byteBuffer.remaining()), null, byteBuffer2, dwordByReference).longValue());
            int n = dwordByReference.getValue().intValue();
            assert (n >= 0);
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer3.position(byteBuffer3.limit());
            int n2 = byteBuffer2.position() + n;
            byteBuffer2.position(n2);
            return n;
        }

        public String toString() {
            return String.format("%s{card=%s, channel=%d}", this.getClass().getSimpleName(), this.a, this.b);
        }
    }

    public static class JnaCard
    extends Card {
        private final Winscard.WinscardLibInfo a;
        private final Winscard.SCardHandle b;
        private final ATR c;
        private final int d;
        public static final int SCARD_LEAVE_CARD = 0;
        public static final int SCARD_RESET_CARD = 1;
        public static final int SCARD_UNPOWER_CARD = 2;
        public static final int SCARD_EJECT_CARD = 3;

        public JnaCard(Winscard.WinscardLibInfo winscardLibInfo, JnaCardTerminal jnaCardTerminal, Winscard.SCardHandle sCardHandle, ATR aTR, int n) {
            this.a = winscardLibInfo;
            this.b = sCardHandle;
            this.c = aTR;
            this.d = n;
            this.getProtocol();
        }

        @Override
        public void beginExclusive() throws CardException {
            Smartcardio.b("SCardBeginTransaction", this.a.lib.SCardBeginTransaction(this.b).longValue());
        }

        @Override
        public void endExclusive() throws CardException {
            Smartcardio.b("SCardEndTransaction", this.a.lib.SCardEndTransaction(this.b, new Winscard.Dword(0L)).longValue());
        }

        @Override
        public void disconnect(boolean bl) throws CardException {
            bl = bl;
            Smartcardio.b("SCardDisconnect", this.a.lib.SCardDisconnect(this.b, new Winscard.Dword((long)bl)).longValue());
        }

        @Override
        public ATR getATR() {
            return this.c;
        }

        @Override
        public String getProtocol() {
            switch (this.d) {
                case 1: {
                    return "T=0";
                }
                case 2: {
                    return "T=1";
                }
            }
            return "DIRECT";
        }

        @Override
        public JnaCardChannel getBasicChannel() {
            return new JnaCardChannel(this, 0);
        }

        @Override
        public CardChannel openLogicalChannel() throws CardException {
            Object object = this.getBasicChannel();
            int n = ((ResponseAPDU)(object = ((JnaCardChannel)object).transmit(new CommandAPDU(0, 112, 0, 0, 1)))).getSW();
            if (36864 == n) {
                byte[] byArray = ((ResponseAPDU)object).getData();
                object = byArray;
                if (byArray.length == 1) {
                    int n2 = 0xFF & object[0];
                    if (n2 == 0 || n2 > 19) {
                        throw new JnaCardException(n, String.format("Expected manage channel response to contain channel number in 1-19; got %d", n2));
                    }
                    return new JnaCardChannel(this, n2);
                }
                throw new JnaCardException(n, String.format("Expected body of length 1 in response to manage channel request; got %d", ((Object)object).length));
            }
            throw new JnaCardException(n, String.format("Error: sw=%04x in response to manage channel command.", n));
        }

        @Override
        public byte[] transmitControlCommand(int n, byte[] byArray) throws CardException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
            Winscard.DwordByReference dwordByReference = new Winscard.DwordByReference();
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
            Smartcardio.b("SCardControl", this.a.lib.SCardControl(this.b, new Winscard.Dword(n), byteBuffer2, new Winscard.Dword(byArray.length), byteBuffer, new Winscard.Dword(byteBuffer.remaining()), dwordByReference).longValue());
            n = dwordByReference.getValue().intValue();
            byteBuffer.limit(n);
            byte[] byArray2 = new byte[n];
            byteBuffer.get(byArray2);
            return byArray2;
        }

        public String toString() {
            return String.format("%s{scardHandle=%s}", new Object[]{this.getClass().getSimpleName(), this.b});
        }
    }

    public static class JnaCardTerminal
    extends CardTerminal {
        private final Winscard.WinscardLibInfo a;
        private final JnaCardTerminals b;
        private final String c;
        public static final int SCARD_SHARE_EXCLUSIVE = 1;
        public static final int SCARD_SHARE_SHARED = 2;
        public static final int SCARD_SHARE_DIRECT = 3;
        public static final int SCARD_PROTOCOL_T0 = 1;
        public static final int SCARD_PROTOCOL_T1 = 2;
        public static final int SCARD_PROTOCOL_ANY = 3;
        public static final int SCARD_UNKNOWN = 1;
        public static final int SCARD_ABSENT = 2;
        public static final int SCARD_PRESENT = 4;
        public static final int SCARD_SWALLOWED = 8;
        public static final int SCARD_POWERED = 16;
        public static final int SCARD_NEGOTIABLE = 32;
        public static final int SCARD_SPECIFIC = 64;

        public JnaCardTerminal(Winscard.WinscardLibInfo winscardLibInfo, JnaCardTerminals jnaCardTerminals, String string) {
            this.a = winscardLibInfo;
            this.b = jnaCardTerminals;
            this.c = string;
        }

        @Override
        public String getName() {
            return this.c;
        }

        @Override
        public Card connect(String string) throws CardException {
            int n;
            int n2 = 2;
            if ((string = string.toUpperCase()).startsWith("EXCLUSIVE;")) {
                n2 = 1;
                string = string.substring(10);
            }
            if ("T=0".equals(string)) {
                n = 1;
            } else if ("T=1".equals(string)) {
                n = 2;
            } else if ("*".equals(string)) {
                n = 3;
            } else if ("DIRECT".equalsIgnoreCase(string)) {
                n = 0;
                if (Platform.isMac()) {
                    n = 3;
                }
                n2 = 3;
            } else {
                throw new IllegalArgumentException("Protocol should be one of (prepended with EXCLUSIVE;) T=0, T=1, *, DIRECT. Got " + string);
            }
            ByReference byReference = new Winscard.SCardHandleByReference();
            Winscard.DwordByReference dwordByReference = new Winscard.DwordByReference();
            long l = this.a.lib.SCardConnect(this.b.a, this.c, new Winscard.Dword(n2), new Winscard.Dword(n), (Winscard.SCardHandleByReference)byReference, dwordByReference).longValue();
            switch ((int)l) {
                case 0: {
                    Winscard.SCardHandle sCardHandle = byReference.getValue();
                    Winscard.DwordByReference dwordByReference2 = new Winscard.DwordByReference();
                    byReference = new Winscard.DwordByReference();
                    dwordByReference = new Winscard.DwordByReference();
                    ByteBuffer byteBuffer = ByteBuffer.allocate(33);
                    Winscard.DwordByReference dwordByReference3 = new Winscard.DwordByReference(new Winscard.Dword(33L));
                    Smartcardio.b("SCardStatus", this.a.lib.SCardStatus(sCardHandle, null, dwordByReference2, (Winscard.DwordByReference)byReference, dwordByReference, byteBuffer, dwordByReference3).longValue());
                    int n3 = dwordByReference3.getValue().intValue();
                    byteBuffer.limit(n3);
                    Object object = new byte[byteBuffer.remaining()];
                    byteBuffer.get((byte[])object);
                    object = new ATR((byte[])object);
                    int n4 = dwordByReference.getValue().intValue();
                    return new JnaCard(this.a, this, sCardHandle, (ATR)object, n4);
                }
                case -2146434967: {
                    throw new JnaCardNotPresentException(l, "Card not present.");
                }
            }
            Smartcardio.b("SCardConnect", l);
            throw new RuntimeException("Should not reach here.");
        }

        @Override
        public boolean isCardPresent() throws CardException {
            Winscard.SCardReaderState[] sCardReaderStateArray = new Winscard.SCardReaderState[1];
            new Winscard.SCardReaderState().toArray(sCardReaderStateArray);
            sCardReaderStateArray[0].szReader = this.c;
            Winscard.SCardReaderState sCardReaderState = sCardReaderStateArray[0];
            Smartcardio.b("SCardGetStatusChange", this.a.lib.SCardGetStatusChange(this.b.a, new Winscard.Dword(0L), sCardReaderStateArray, new Winscard.Dword(1L)).longValue());
            return 0 != (sCardReaderState.dwEventState.intValue() & 0x20);
        }

        private boolean a(long l, boolean bl) throws JnaPCSCException {
            if (l < 0L) {
                throw new IllegalArgumentException("Negative timeout " + l);
            }
            if (l == 0L) {
                l = -1L;
            }
            Winscard.SCardReaderState[] sCardReaderStateArray = new Winscard.SCardReaderState[1];
            new Winscard.SCardReaderState().toArray(sCardReaderStateArray);
            Winscard.SCardReaderState sCardReaderState = sCardReaderStateArray[0];
            sCardReaderStateArray[0].szReader = this.c;
            Smartcardio.b("SCardGetStatusChange", this.a.lib.SCardGetStatusChange(this.b.a, new Winscard.Dword(0L), sCardReaderStateArray, new Winscard.Dword(1L)).longValue());
            int n = (int)l;
            while (bl != (0 != (sCardReaderState.dwEventState.intValue() & 0x20))) {
                sCardReaderState.dwCurrentState = sCardReaderState.dwEventState;
                sCardReaderState.dwEventState = new Winscard.Dword(0L);
                long l2 = System.currentTimeMillis();
                Winscard.Dword dword = this.a.lib.SCardGetStatusChange(this.b.a, new Winscard.Dword(n), sCardReaderStateArray, new Winscard.Dword(1L));
                long l3 = System.currentTimeMillis();
                if (-2146435062 == dword.intValue()) {
                    return false;
                }
                Smartcardio.b("SCardGetStatusChange", dword.longValue());
                if (n == -1) continue;
                if ((long)n < l3 - l2) {
                    return false;
                }
                n = (int)((long)n - (l3 - l2));
            }
            return true;
        }

        @Override
        public boolean waitForCardAbsent(long l) throws CardException {
            return this.a(l, false);
        }

        @Override
        public boolean waitForCardPresent(long l) throws CardException {
            return this.a(l, true);
        }

        public String toString() {
            return String.format("%s{scardHandle=%s, name=%s}", new Object[]{this.getClass().getSimpleName(), this.b.a, this.c});
        }
    }

    public static class JnaCardTerminals
    extends CardTerminals {
        private final Winscard.SCardContext a;
        private final Winscard.WinscardLibInfo b;
        private Winscard.SCardReaderState[] c;
        private final List<Winscard.SCardReaderState> d;
        private boolean e;

        public JnaCardTerminals(Winscard.WinscardLibInfo winscardLibInfo, Winscard.SCardContext sCardContext) {
            this.b = winscardLibInfo;
            this.a = sCardContext;
            this.c = JnaCardTerminals.a(Collections.emptyList(), true, new Winscard.SCardReaderState[0]);
            this.d = new ArrayList<Winscard.SCardReaderState>();
        }

        @Override
        public List<CardTerminal> list(CardTerminals.State state) throws CardException {
            int n;
            Winscard.SCardReaderState[] sCardReaderStateArray;
            List<String> list;
            if (state == null) {
                throw new NullPointerException("State must be non-null. To get all terminals, call list() or list(State.ALL).");
            }
            if (state == CardTerminals.State.CARD_REMOVAL || state == CardTerminals.State.CARD_INSERTION) {
                boolean bl;
                Winscard.SCardReaderState sCardReaderState;
                int n2;
                ArrayList<CardTerminal> arrayList = new ArrayList<CardTerminal>();
                for (n2 = 0; n2 < this.c.length; ++n2) {
                    sCardReaderState = this.c[n2];
                    if ("\\\\?PnP?\\Notification".equals(sCardReaderState.szReader)) continue;
                    bl = 0 != (sCardReaderState.dwCurrentState.intValue() & 0x20);
                    boolean bl2 = 0 != (sCardReaderState.dwEventState.intValue() & 0x20);
                    int n3 = sCardReaderState.dwCurrentState.intValue() >> 16 & 0xFFFF;
                    int n4 = sCardReaderState.dwEventState.intValue() >> 16 & 0xFFFF;
                    boolean bl3 = !bl && bl2 || bl2 && n3 < n4 || n3 + 1 < n4;
                    bl = bl && !bl2 || !bl2 && n3 < n4 || n3 + 1 < n4;
                    bl = state == CardTerminals.State.CARD_INSERTION && bl3 || state == CardTerminals.State.CARD_REMOVAL && bl;
                    if (!bl) continue;
                    arrayList.add(new JnaCardTerminal(this.b, this, sCardReaderState.szReader));
                }
                if (state == CardTerminals.State.CARD_REMOVAL) {
                    for (n2 = 0; n2 < this.d.size(); ++n2) {
                        sCardReaderState = this.d.get(n2);
                        bl = 0 != (sCardReaderState.dwCurrentState.intValue() & 0x20);
                        if (!bl) continue;
                        arrayList.add(new JnaCardTerminal(this.b, this, sCardReaderState.szReader));
                    }
                }
                return arrayList;
            }
            List<String> list2 = this.a();
            if (list2.isEmpty()) {
                return Collections.emptyList();
            }
            if (state == CardTerminals.State.ALL) {
                list = list2;
            } else {
                sCardReaderStateArray = new Winscard.SCardReaderState[list2.size()];
                new Winscard.SCardReaderState().toArray(sCardReaderStateArray);
                for (n = 0; n < sCardReaderStateArray.length; ++n) {
                    sCardReaderStateArray[n].szReader = list2.get(n);
                }
                Smartcardio.b("SCardGetStatusChange", this.b.lib.SCardGetStatusChange(this.a, new Winscard.Dword(0L), sCardReaderStateArray, new Winscard.Dword(sCardReaderStateArray.length)).longValue());
                list = new ArrayList<String>();
                n = state == CardTerminals.State.CARD_PRESENT ? 1 : 0;
                for (int i = 0; i < sCardReaderStateArray.length; ++i) {
                    int n5;
                    int n6 = n5 = 0 != (0x20 & sCardReaderStateArray[i].dwEventState.intValue()) ? 1 : 0;
                    if (n != n5) continue;
                    list.add(sCardReaderStateArray[i].szReader);
                }
            }
            sCardReaderStateArray = new CardTerminal[list.size()];
            for (n = 0; n < list.size(); ++n) {
                String string = list.get(n);
                sCardReaderStateArray[n] = new JnaCardTerminal(this.b, this, string);
            }
            return Collections.unmodifiableList(Arrays.asList(sCardReaderStateArray));
        }

        private List<String> a() throws JnaPCSCException {
            long l;
            Object object = new Winscard.DwordByReference();
            byte[] byArray = null;
            ByteBuffer byteBuffer = ByteBuffer.allocate(16 + 2);
            byteBuffer.put("SCard$AllReaders".getBytes(Charset.forName("ascii")));
            while ((l = this.b.lib.SCardListReaders(this.a, byteBuffer, null, (Winscard.DwordByReference)((Object)object)).longValue()) == 0L && (int)(l = this.b.lib.SCardListReaders(this.a, byteBuffer, ByteBuffer.wrap(byArray = new byte[object.getValue().intValue()]), (Winscard.DwordByReference)((Object)object)).longValue()) == -2146435064) {
            }
            switch ((int)l) {
                case 0: {
                    object = Smartcardio.a(byArray);
                    return object;
                }
                case -2146435049: 
                case -2146435026: {
                    return Collections.emptyList();
                }
            }
            Smartcardio.b("SCardListReaders", l);
            throw new IllegalStateException();
        }

        private static Winscard.SCardReaderState[] a(List<String> object, boolean bl, Winscard.SCardReaderState[] sCardReaderStateArray) {
            Structure[] structureArray = new Winscard.SCardReaderState[object.size() + 1];
            new Winscard.SCardReaderState().toArray(structureArray);
            int n = 0;
            structureArray[0].szReader = "\\\\?PnP?\\Notification";
            ++n;
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                Structure structure = structureArray[n];
                structureArray[n].szReader = string;
                Winscard.SCardReaderState sCardReaderState = null;
                for (int i = 0; i < sCardReaderStateArray.length; ++i) {
                    if (!string.equals(sCardReaderStateArray[i].szReader)) continue;
                    sCardReaderState = sCardReaderStateArray[i];
                    break;
                }
                if (sCardReaderState != null) {
                    structure.dwCurrentState = sCardReaderState.dwCurrentState;
                    structure.dwEventState = sCardReaderState.dwEventState;
                    structure.cbAtr = sCardReaderState.cbAtr;
                    structure.pvUserData = sCardReaderState.pvUserData;
                    System.arraycopy(sCardReaderState.rgbAtr, 0, structure.rgbAtr, 0, sCardReaderState.cbAtr.intValue());
                }
                ++n;
            }
            return structureArray;
        }

        private boolean b() throws JnaPCSCException {
            List<String> list = this.a();
            boolean bl = false;
            int n = 0;
            Winscard.SCardReaderState[] sCardReaderStateArray = this.c;
            int n2 = this.c.length;
            for (int i = 0; i < n2; ++i) {
                Winscard.SCardReaderState sCardReaderState = sCardReaderStateArray[i];
                if ("\\\\?PnP?\\Notification".equals(sCardReaderState.szReader)) continue;
                ++n;
                if (list.contains(sCardReaderState.szReader)) continue;
                bl = true;
                this.d.add(sCardReaderState);
            }
            if (!(bl = bl || n != list.size())) {
                return bl;
            }
            this.c = JnaCardTerminals.a(list, true, this.c);
            sCardReaderStateArray = this.c.length == 0 ? new Winscard.SCardReaderState[1] : this.c;
            Smartcardio.b("SCardGetStatusChange", this.b.lib.SCardGetStatusChange(this.a, new Winscard.Dword(0L), sCardReaderStateArray, new Winscard.Dword(this.c.length)).longValue());
            return true;
        }

        @Override
        public boolean waitForChange(long l) throws CardException {
            if (l < 0L) {
                throw new IllegalArgumentException("Negative timeout " + l);
            }
            if (l == 0L) {
                l = -1L;
            }
            this.d.clear();
            if ((Platform.isLinux() || Platform.isMac()) && this.b()) {
                return true;
            }
            Winscard.SCardReaderState[] sCardReaderStateArray = this.c;
            int n = this.c.length;
            for (int i = 0; i < n; ++i) {
                Winscard.SCardReaderState sCardReaderState = sCardReaderStateArray[i];
                sCardReaderStateArray[i].dwCurrentState = sCardReaderState.dwEventState;
                sCardReaderState.dwEventState = new Winscard.Dword(0L);
            }
            sCardReaderStateArray = this.c.length == 0 ? new Winscard.SCardReaderState[1] : this.c;
            Winscard.Dword dword = this.b.lib.SCardGetStatusChange(this.a, new Winscard.Dword(l), sCardReaderStateArray, new Winscard.Dword(sCardReaderStateArray.length));
            if (-2146435062 == dword.intValue()) {
                return false;
            }
            Smartcardio.b("SCardGetStatusChange", dword.longValue());
            Winscard.SCardReaderState sCardReaderState = this.c[0];
            boolean bl = 0 != (sCardReaderState.dwEventState.intValue() & 2);
            if (bl) {
                this.b();
            }
            return true;
        }

        public String toString() {
            return String.format("%s{scardContext=%s}", new Object[]{this.getClass().getSimpleName(), this.a});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws JnaPCSCException {
            JnaCardTerminals jnaCardTerminals = this;
            synchronized (jnaCardTerminals) {
                if (this.e) {
                    return;
                }
                this.e = true;
            }
            Smartcardio.b("SCardReleaseContext", this.b.lib.SCardReleaseContext(this.a).longValue());
        }

        public void finalize() throws JnaPCSCException {
            this.close();
        }
    }

    public static class JnaTerminalFactorySpi
    extends TerminalFactorySpi {
        public static final int SCARD_SCOPE_USER = 0;
        public static final int SCARD_SCOPE_TERMINAL = 1;
        public static final int SCARD_SCOPE_SYSTEM = 2;
        private final Winscard.WinscardLibInfo a;

        public JnaTerminalFactorySpi(Object object) {
            object = Platform.isWindows() ? "WinSCard.dll" : (Platform.isMac() ? "/System/Library/Frameworks/PCSC.framework/PCSC" : "libpcsclite.so.1");
            Object object2 = new HashMap<String, Object>();
            if (Platform.isWindows()) {
                ((HashMap)object2).put("function-mapper", new Winscard.b(0));
            } else if (Platform.isMac()) {
                ((HashMap)object2).put("function-mapper", new Winscard.a(0));
            }
            object2 = (Winscard.WinscardLibrary)Native.loadLibrary((String)object, Winscard.WinscardLibrary.class, object2);
            object = NativeLibrary.getInstance((String)object);
            Winscard.ScardIoRequest scardIoRequest = new Winscard.ScardIoRequest(object.getGlobalVariableAddress("g_rgSCardT0Pci"));
            Winscard.ScardIoRequest scardIoRequest2 = new Winscard.ScardIoRequest(object.getGlobalVariableAddress("g_rgSCardT1Pci"));
            object = new Winscard.ScardIoRequest(object.getGlobalVariableAddress("g_rgSCardRawPci"));
            scardIoRequest.read();
            scardIoRequest2.read();
            object.read();
            scardIoRequest.setAutoSynch(false);
            scardIoRequest2.setAutoSynch(false);
            object.setAutoSynch(false);
            this(new Winscard.WinscardLibInfo((Winscard.WinscardLibrary)object2, scardIoRequest, scardIoRequest2, (Winscard.ScardIoRequest)((Object)object)));
        }

        public JnaTerminalFactorySpi(Winscard.WinscardLibInfo winscardLibInfo) {
            this.a = winscardLibInfo;
        }

        @Override
        public CardTerminals engineTerminals() throws EstablishContextException {
            Object object = new Winscard.SCardContextByReference();
            try {
                Smartcardio.b("SCardEstablishContext", this.a.lib.SCardEstablishContext(new Winscard.Dword(2L), null, null, (Winscard.SCardContextByReference)((Object)object)).longValue());
            }
            catch (JnaPCSCException jnaPCSCException) {
                throw new EstablishContextException(jnaPCSCException);
            }
            object = object.getValue();
            return new JnaCardTerminals(this.a, (Winscard.SCardContext)((Object)object));
        }
    }
}

