/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11;

import it.actalis.pkcs11.CapiPKCS11Exception;
import it.actalis.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.util.Date;

public abstract class PKCS11Object {
    public static final long CLASS = 0L;
    public static final long TOKEN = 1L;
    public static final long PRIVATE = 2L;
    public static final long LABEL = 3L;
    public static final long APPLICATION = 16L;
    public static final long VALUE = 17L;
    public static final long CERTIFICATE_TYPE = 128L;
    public static final long ISSUER = 129L;
    public static final long SERIAL_NUMBER = 130L;
    public static final long KEY_TYPE = 256L;
    public static final long SUBJECT = 257L;
    public static final long ID = 258L;
    public static final long SENSITIVE = 259L;
    public static final long ENCRYPT = 260L;
    public static final long DECRYPT = 261L;
    public static final long WRAP = 262L;
    public static final long UNWRAP = 263L;
    public static final long SIGN = 264L;
    public static final long SIGN_RECOVER = 265L;
    public static final long VERIFY = 266L;
    public static final long VERIFY_RECOVER = 267L;
    public static final long DERIVE = 268L;
    public static final long START_DATE = 272L;
    public static final long END_DATE = 273L;
    public static final long MODULUS = 288L;
    public static final long MODULUS_BITS = 289L;
    public static final long PUBLIC_EXPONENT = 290L;
    public static final long PRIVATE_EXPONENT = 291L;
    public static final long PRIME_1 = 292L;
    public static final long PRIME_2 = 293L;
    public static final long EXPONENT_1 = 294L;
    public static final long EXPONENT_2 = 295L;
    public static final long COEFFICIENT = 296L;
    public static final long PRIME = 304L;
    public static final long SUBPRIME = 305L;
    public static final long BASE = 306L;
    public static final long VALUE_BITS = 352L;
    public static final long VALUE_LEN = 353L;
    public static final long EXTRACTABLE = 354L;
    public static final long LOCAL = 355L;
    public static final long NEVER_EXTRACTABLE = 356L;
    public static final long ALWAYS_SENSITIVE = 357L;
    public static final long MODIFIABLE = 368L;
    public static final long COPYABLE = 369L;
    public static final long DESTROYABLE = 370L;
    public static final long ECDSA_PARAMS = 384L;
    public static final long EC_POINT = 385L;
    public static final long VENDOR_DEFINED = Integer.MIN_VALUE;
    public static final long INVALID = -1L;
    public static final Integer DATA = 0;
    public static final Long CERTIFICATE = 1L;
    public static final Long PUBLIC_KEY = 2L;
    public static final Long PRIVATE_KEY = 3L;
    public static final Integer SECRET_KEY = 4;
    public static final Integer RSA;
    public static final Integer DSA;
    public static final Integer DH;
    public static final Integer ECDSA;
    public static final Integer MAYFLY;
    public static final Integer KEA;
    public static final Integer GENERIC_SECRET;
    public static final Integer RC2;
    public static final Integer RC4;
    public static final Integer DES;
    public static final Integer DES2;
    public static final Integer DES3;
    public static final Integer CAST;
    public static final Integer CAST3;
    public static final Integer CAST5;
    public static final Integer CAST128;
    public static final Integer RC5;
    public static final Integer IDEA;
    public static final Integer SKIPJACK;
    public static final Integer BATON;
    public static final Integer JUNIPER;
    public static final Integer CDMF;
    public static final Integer X_509;
    public static final Boolean TRUE;
    public static final Boolean FALSE;
    private static final String[] a;
    private static final int[] b;
    private static final String[] c;
    private static final Class[] d;
    private static final Integer[] e;
    private static final String[] f;
    private static final char[] g;

    protected PKCS11Object() {
    }

    public abstract PKCS11Session getSession() throws CapiPKCS11Exception;

    public abstract PKCS11Object copy(long[] var1, Object[] var2) throws CapiPKCS11Exception;

    public abstract void destroy() throws CapiPKCS11Exception;

    public abstract long size() throws CapiPKCS11Exception;

    public Object[] getAttributeValues(int[] nArray) throws CapiPKCS11Exception {
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this.getAttributeValue(nArray[i]);
        }
        return objectArray;
    }

    public abstract Object getAttributeValue(long var1) throws CapiPKCS11Exception;

    public boolean getBoolAttributeValue(long l) throws CapiPKCS11Exception {
        if (PKCS11Object.valueClass((int)l) != Boolean.class) {
            throw new CapiPKCS11Exception(18L);
        }
        Object object = this.getAttributeValue(l);
        if (object == null) {
            throw new CapiPKCS11Exception(Integer.MIN_VALUE, "VOID boolean field");
        }
        return (Boolean)object;
    }

    public int getIntAttributeValue(long l) throws CapiPKCS11Exception {
        if (PKCS11Object.valueClass((int)l) != Integer.class) {
            throw new CapiPKCS11Exception(18L);
        }
        Object object = this.getAttributeValue(l);
        if (object == null) {
            throw new CapiPKCS11Exception(Integer.MIN_VALUE, "VOID int field");
        }
        return ((Long)object).intValue();
    }

    public String getStringAttributeValue(long l) throws CapiPKCS11Exception {
        if (PKCS11Object.valueClass((int)l) != String.class) {
            throw new CapiPKCS11Exception(18L);
        }
        Object object = this.getAttributeValue(l);
        if (object == null) {
            return "";
        }
        return new String((char[])object);
    }

    public byte[] getByteArrayAttributeValue(long l) throws CapiPKCS11Exception {
        if (PKCS11Object.valueClass((int)l) != byte[].class) {
            throw new CapiPKCS11Exception(18L);
        }
        Object object = this.getAttributeValue(l);
        if (object == null) {
            return new byte[0];
        }
        return (byte[])object;
    }

    public Date getDateAttributeValue(long l) throws CapiPKCS11Exception {
        if (PKCS11Object.valueClass((int)l) != Date.class) {
            throw new CapiPKCS11Exception(18L);
        }
        Object object = this.getAttributeValue(l);
        if (object == null) {
            throw new CapiPKCS11Exception(Integer.MIN_VALUE, "VOID Date field");
        }
        return (Date)object;
    }

    public BigInteger getBigIntegerAttributeValue(long l) throws CapiPKCS11Exception {
        if (PKCS11Object.valueClass((int)l) != BigInteger.class) {
            throw new CapiPKCS11Exception(18L);
        }
        Object object = this.getAttributeValue(l);
        if (object == null) {
            throw new CapiPKCS11Exception(Integer.MIN_VALUE, "VOID BigInteger field");
        }
        byte[] byArray = (byte[])object;
        object = byArray;
        byte[] byArray2 = new byte[byArray.length + 1];
        byte[] byArray3 = byArray2;
        byArray2[0] = 0;
        System.arraycopy(object, 0, byArray3, 1, ((Object)object).length);
        return new BigInteger(byArray3);
    }

    public abstract void setAttributeValues(long[] var1, Object[] var2) throws CapiPKCS11Exception;

    public abstract void setAttributeValue(long var1, Object var3) throws CapiPKCS11Exception;

    public void setBoolAttributeValue(long l, boolean bl) throws CapiPKCS11Exception {
        if (PKCS11Object.valueClass((int)l) != Boolean.class) {
            throw new CapiPKCS11Exception(18L);
        }
        this.setAttributeValue(l, bl);
    }

    public void setIntAttributeValue(long l, int n) throws CapiPKCS11Exception {
        if (PKCS11Object.valueClass((int)l) != Integer.class) {
            throw new CapiPKCS11Exception(18L);
        }
        this.setAttributeValue(l, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = "                    ";
        stringBuffer.append("object:\n");
        for (int i = 0; i < 45; ++i) {
            String string2;
            String string3;
            block5: {
                Object object;
                int n = b[i];
                string3 = PKCS11Object.typeToString(n);
                string2 = null;
                try {
                    object = this.getAttributeValue(n);
                    string2 = PKCS11Object.attrToString(n, object);
                }
                catch (CapiPKCS11Exception capiPKCS11Exception) {
                    object = capiPKCS11Exception;
                    if (capiPKCS11Exception.getErrorCode() != 17L) break block5;
                    string2 = "(ATTRIBUTE_SENSITIVE)";
                }
            }
            if (string2 == null) continue;
            stringBuffer.append("\t").append(string3).append(":");
            stringBuffer.append(string.substring(string3.length()));
            stringBuffer.append(string2).append("\n");
        }
        try {
            long l = this.size();
            stringBuffer.append("\tSIZE:").append(string.substring(4)).append(l).append("\n");
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {}
        return stringBuffer.toString();
    }

    public static Class valueClass(int n) {
        for (int i = 0; i < 45; ++i) {
            if (b[i] != n) continue;
            return d[i];
        }
        return null;
    }

    public static String typeToString(int n) {
        for (int i = 0; i < 45; ++i) {
            if (b[i] != n) continue;
            return c[i];
        }
        return "0x" + Integer.toString(n, 16);
    }

    public static String classToString(Integer n) {
        int n2 = n;
        if (n2 >= 0 && n2 < 5) {
            return a[n2];
        }
        return "0x" + Integer.toString(n2, 16);
    }

    public static String keyToString(Integer n) {
        int n2 = n;
        for (int i = 0; i < 21; ++i) {
            if (e[i] != n2) continue;
            return f[i];
        }
        return "0x" + Integer.toHexString(n2);
    }

    public static String certToString(Integer n) {
        if (n.equals(X_509)) {
            return "X_509";
        }
        return n.toString();
    }

    public static String attrToString(int n, Object object) {
        if (object == null) {
            return "null";
        }
        switch (n) {
            case 0: {
                return PKCS11Object.classToString((Integer)object);
            }
            case 256: {
                return PKCS11Object.keyToString((Integer)object);
            }
            case 128: {
                return PKCS11Object.certToString((Integer)object);
            }
            case 17: 
            case 129: 
            case 130: 
            case 257: 
            case 258: {
                return PKCS11Object.bytesToString((byte[])object, 10);
            }
            case 288: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 304: 
            case 305: 
            case 306: {
                return "0x" + ((BigInteger)object).toString(16);
            }
        }
        return object.toString();
    }

    public static String bytesToString(byte[] byArray, int n) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            if (n != 0 && n3 > n) {
                stringBuffer.append(" ... (").append(byArray.length).append(" bytes)");
                break;
            }
            if (n2 == 16) {
                stringBuffer.append('\n');
                n2 = 0;
            }
            if (n2 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(g[byArray[n3] >> 4 & 0xF]);
            stringBuffer.append(g[byArray[n3] & 0xF]);
            ++n3;
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String docuTable() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("  * <TABLE BORDER RULES=ALL CELLPADDING=3>\n");
        stringBuffer.append("  * <TR> <TH> attribute type     <TH> object type\n");
        for (int i = 0; i < 45; ++i) {
            String string;
            String string2 = d[i].getName();
            if (string2.endsWith("[B")) {
                string = "byte[]";
            } else {
                String string3 = string2;
                string = string3.substring(string3.lastIndexOf(46) + 1);
            }
            string2 = string;
            stringBuffer.append("  * <TR> <TD> <TT>").append(c[i]);
            stringBuffer.append("</TT> <TD> <TT>").append(string2).append("</TT>\n");
        }
        stringBuffer.append("  * </TABLE> <P>\n");
        return stringBuffer.toString();
    }

    static {
        CAST128 = 24;
        X_509 = 0;
        a = new String[]{"DATA", "CERTIFICATE", "PUBLIC_KEY", "PRIVATE_KEY", "SECRET_KEY"};
        b = new int[]{0, 1, 2, 3, 16, 17, 128, 129, 130, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 272, 273, 288, 289, 290, 291, 292, 293, 294, 295, 296, 304, 305, 306, 352, 353, 354, 355, 356, 357, 368, 384, 385};
        c = new String[]{"CLASS", "TOKEN", "PRIVATE", "LABEL", "APPLICATION", "VALUE", "CERTIFICATE_TYPE", "ISSUER", "SERIAL_NUMBER", "KEY_TYPE", "SUBJECT", "ID", "SENSITIVE", "ENCRYPT", "DECRYPT", "WRAP", "UNWRAP", "SIGN", "SIGN_RECOVER", "VERIFY", "VERIFY_RECOVER", "DERIVE", "START_DATE", "END_DATE", "MODULUS", "MODULUS_BITS", "PUBLIC_EXPONENT", "PRIVATE_EXPONENT", "PRIME_1", "PRIME_2", "EXPONENT_1", "EXPONENT_2", "COEFFICIENT", "PRIME", "SUBPRIME", "BASE", "VALUE_BITS", "VALUE_LEN", "EXTRACTABLE", "LOCAL", "NEVER_EXTRACTABLE", "ALWAYS_SENSITIVE", "MODIFIABLE", "ECDSA_PARAMS", "EC_POINT"};
        f = new String[]{"RSA", "DSA", "DH", "ECDSA", "MAYFLY", "KEA", "GENERIC_SECRET", "RC2", "RC4", "DES", "DES2", "DES3", "CAST", "CAST3", "CAST5", "RC5", "IDEA", "SKIPJACK", "BATON", "JUNIPER", "CDMF"};
        g = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        RSA = 0;
        DSA = 1;
        DH = 2;
        ECDSA = 3;
        MAYFLY = 4;
        KEA = 5;
        GENERIC_SECRET = 16;
        RC2 = 17;
        RC4 = 18;
        DES = 19;
        DES2 = 20;
        DES3 = 21;
        CAST = 22;
        CAST3 = 23;
        CAST5 = 24;
        RC5 = 25;
        IDEA = 26;
        SKIPJACK = 27;
        BATON = 28;
        JUNIPER = 29;
        CDMF = 30;
        TRUE = Boolean.TRUE;
        FALSE = Boolean.FALSE;
        d = new Class[]{Integer.class, Boolean.class, Boolean.class, String.class, String.class, byte[].class, Integer.class, byte[].class, byte[].class, Integer.class, byte[].class, byte[].class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Date.class, Date.class, BigInteger.class, Integer.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, BigInteger.class, Integer.class, Integer.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, byte[].class, byte[].class};
        e = new Integer[]{RSA, DSA, DH, ECDSA, MAYFLY, KEA, GENERIC_SECRET, RC2, RC4, DES, DES2, DES3, CAST, CAST3, CAST5, RC5, IDEA, SKIPJACK, BATON, JUNIPER, CDMF};
    }
}

