/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.rs;

import esecurity.enroll.constants.KeyAlgo;
import esecurity.rest.RestException;
import esecurity.rest.SimpleRest;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.core.VerifiedSignatureToken;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.provider.RemoteToken;
import it.actalis.ellips.capi.rs.util.ArssReturn;
import it.actalis.ellips.capi.rs.util.Auth;
import it.actalis.ellips.capi.rs.util.AuthMethodsReturn;
import it.actalis.ellips.capi.rs.util.BodyRequestAuthMethod;
import it.actalis.ellips.capi.rs.util.BodyRequestListCert;
import it.actalis.ellips.capi.rs.util.BodyRequestOpenSession;
import it.actalis.ellips.capi.rs.util.BodyRequestSendCredential;
import it.actalis.ellips.capi.rs.util.Cert;
import it.actalis.ellips.capi.rs.util.CredentialsType;
import it.actalis.ellips.capi.rs.util.SignHashInnerRequest;
import it.actalis.ellips.capi.rs.util.SignHashRequest;
import it.actalis.ellips.capi.rs.util.SignHashReturn;
import it.actalis.ellips.capi.rs.util.UserCertList;
import it.actalis.vol.utils.Constants;
import it.arubapec.signservice.CertsListRequest;
import it.arubapec.signservice.SignRequest;
import it.arubapec.signservice.SignResponse;
import it.arubapec.signservice.TempPwdRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Element;

public class ARSSToken
extends RemoteToken
implements VerifiedSignatureToken {
    private static final DocumentBuilderFactory a = DocumentBuilderFactory.newInstance();
    public static final String TOKEN_RS = "ARSSAutomaticSignatureToken";
    protected String password;
    protected String cns_otp;
    protected boolean publicSessionOpen = false;
    protected String delegatedUser;
    protected String delegatedDomain;
    protected String delegatedPassword;
    protected LoginCache login = null;
    protected String openSession = null;
    protected UrlClient urlClient = null;
    protected String sessionOtp = null;
    protected it.arubapec.signservice.Auth identity = null;
    protected URLCredentials cred = null;
    protected String cacheKey = "";
    protected boolean useRestService = false;
    protected SimpleRest simplerest = null;

    public String[] getLibInfo() {
        String string = "ARSS Signature";
        String string2 = "";
        String string3 = "Ellips ARSS Signature Token";
        String string4 = "1.0";
        String string5 = "Actalis S.p.A.";
        String string6 = "";
        String string7 = "Actalis S.p.A.";
        String string8 = "";
        String string9 = "Actalis S.p.A.";
        return new String[]{string, string2, string3, string4, string5, string6, string7, string8, string9};
    }

    public String getLabel() throws CapiException {
        throw new CapiException("ARSS Signature doesn't support retrieving key's information", 1004);
    }

    public void changePIN(String string, String string2) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support PIN changing", 1004);
    }

    public void changePUK(String string, String string2) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support PUK changing", 1004);
    }

    public void unblockPIN(String string, String string2) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support unblocking", 1004);
    }

    public void closeSession() throws CapiException {
        logger.debug("Closing session");
        this.sessionOtp = null;
        this.openSession = null;
        this.publicSessionOpen = false;
    }

    public byte[] getData(String string) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support exporting certificates", 1004);
    }

    public void setData(String string, byte[] byArray, int n) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support storing genric data", 1004);
    }

    public String getCert(String string) throws CapiException {
        if (this.login.getResp() != null) {
            for (Certificato certificato : this.login.getResp().getCertlist()) {
                if (!certificato.getId().equals(string)) continue;
                return new String(Base64.encode((byte[])certificato.getContent()));
            }
        }
        return null;
    }

    public void setCert(String string, byte[] byArray, int n, boolean bl) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support setting certificates into the token", 1004);
    }

    public String installCertificate(Certificate certificate) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support setting certificates into the token", 1004);
    }

    public void genKeyPair(String string, int n, int n2, int n3) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support generating key pair", 1004);
    }

    public void genKeyPair(String string, KeyAlgo keyAlgo, int n, int n2, int n3) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support generating key pair", 1004);
    }

    public String impCred(String string, PrivateKey privateKey, int n, int n2) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support importing credentials", 1004);
    }

    public PrivateKey expCred(String string) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support exporting a PrivateKey", 1004);
    }

    public PublicKey getPublicKey(String string) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support retrieving public keys", 1004);
    }

    public PrivateKey getPrivateKey(String string) throws CapiException {
        return null;
    }

    public void instCert(String string, Certificate certificate, boolean bl, boolean bl2) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support installing certificates", 1004);
    }

    public int getKeyUsage(String string, boolean bl) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support retrieving key's information", 1004);
    }

    public int getKeyLength(String string) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support retrieving key's information", 1004);
    }

    public byte[] doDecrypt(byte[] byArray, String string, int n) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support the Decrypt functionality", 1004);
    }

    public String[] listObjects(String string, byte by) throws CapiException {
        if (this.login.getResp() == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            String[] stringArray = new String[this.login.getResp().getCertlist().length];
            if (this.login.getResp().getCertlist().length == 0) {
                return stringArray;
            }
            int n = 0;
            for (Certificato certificato : this.login.getResp().getCertlist()) {
                String object = certificato.getId();
                if ((this.getObjectType(object) & by) == 0 || string != null && object.indexOf(string) < 0) continue;
                stringArray[n] = object;
                ++n;
            }
            if (n == 0) {
                return new String[0];
            }
            Object[] objectArray = new String[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = stringArray[i];
            }
            return objectArray;
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 10040);
        }
    }

    public void deleteObject(String string) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support storing objects", 1004);
    }

    public int getObjectSize(String string) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support storing objects", 1004);
    }

    public void renameObject(String string, String string2, int n) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support storing objects", 1004);
    }

    public String generateID(String[] stringArray) {
        return this.argsResolver(stringArray, 2) + "@" + this.argsResolver(stringArray, 3);
    }

    public String[] getAuth_methods() {
        return this.login.getAuthMethods();
    }

    public byte[] verifiedSignature(byte[] byArray, String string) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support verifiedSignarute functionality", 1004);
    }

    public String getSelected_url() {
        return this.login.getSelectedUrl();
    }

    protected SignResponse signop(String string, SignRequest signRequest) throws IOException {
        if (this.useRestService) {
            return this.a(string, signRequest);
        }
        return this.b(string, signRequest);
    }

    private SignResponse a(String object, SignRequest object2) throws IOException {
        SignResponse signResponse = new SignResponse();
        signResponse.setReturn_code("0002");
        SignHashRequest signHashRequest = new SignHashRequest();
        SignHashInnerRequest signHashInnerRequest = new SignHashInnerRequest();
        signHashInnerRequest.setHashtype(Constants.SHA256);
        signHashInnerRequest.setCertID(object2.getCertID());
        signHashInnerRequest.setHash(new String(Base64.encode((byte[])object2.getDataToSign())));
        signHashInnerRequest.setRequirecert(false);
        if (this.openSession != null) {
            signHashInnerRequest.setSession_id(this.openSession);
        }
        object2 = ARSSToken.a(object2.getIdentity());
        signHashInnerRequest.setIdentity((Auth)object2);
        signHashRequest.setRequest(signHashInnerRequest);
        object = ((String)object).endsWith("/") ? (String)object + "signhash" : (String)object + "/signhash";
        try {
            object = (SignHashReturn)this.simplerest.post((String)object).body((Object)signHashRequest, "application/json").auth(this.cred).asObject(SignHashReturn.class);
            if (object != null) {
                signResponse.setReturn_code(((SignHashReturn)object).getReturn_code());
                signResponse.setStatus(((SignHashReturn)object).getStatus());
                signResponse.setSignData(Base64.decode((String)((SignHashReturn)object).getSignature()));
                signResponse.setCert_id(((SignHashReturn)object).getCertID());
                signResponse.setDescription(((SignHashReturn)object).getDescription());
            }
        }
        catch (RestException restException) {
            logger.error(restException.getMessage(), (Throwable)restException);
        }
        return signResponse;
    }

    private SignResponse b(String object, SignRequest object2) throws IOException {
        SignResponse signResponse = new SignResponse();
        signResponse.setReturn_code("0002");
        String string = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:signhash>\n         <SignHashRequest>\n            <certID>" + object2.getCertID() + "</certID>\n            <hash>" + new String(Base64.encode((byte[])object2.getDataToSign())) + "</hash>\n            <hashtype>SHA256</hashtype>\n           <identity>\n";
        if (object2.getIdentity().getOtpPwd() != null) {
            string = string + "             \t<otpPwd>" + object2.getIdentity().getOtpPwd() + "</otpPwd>\n";
        }
        string = string + "          \t<typeHSM>COSIGN</typeHSM>\n";
        if (object2.getIdentity().getTypeOtpAuth() != null && object2.getIdentity().getDomain() == null) {
            string = string + "          \t<typeOtpAuth>" + object2.getIdentity().getTypeOtpAuth() + "</typeOtpAuth>\n";
        }
        if (object2.getIdentity().getDomain() != null) {
            string = string + "          \t<typeOtpAuth>" + object2.getIdentity().getDomain() + "</typeOtpAuth>\n";
        }
        string = string + "          \t<user>" + object2.getIdentity().getUser() + "</user>\n";
        if (object2.getIdentity().getUserPWD() != null) {
            string = string + "          \t<userPWD>" + object2.getIdentity().getUserPWD() + "</userPWD>\n";
        }
        if (object2.getIdentity().getDelegated_domain() != null) {
            string = string + "          \t<delegated_domain>" + object2.getIdentity().getDelegated_domain() + "</delegated_domain>\n";
        }
        if (object2.getIdentity().getDelegated_password() != null) {
            string = string + "          \t<delegated_password>" + object2.getIdentity().getDelegated_password() + "</delegated_password>\n";
        }
        if (object2.getIdentity().getDelegated_user() != null) {
            string = string + "          \t<delegated_user>" + object2.getIdentity().getDelegated_user() + "</delegated_user>\n";
        }
        string = string + "         </identity>\n            <requirecert>false</requirecert>\n";
        if (this.openSession != null) {
            string = string + "            <session_id>" + this.openSession + "</session_id>\n";
        }
        if ((object = this.a((String)object, string = string + "         </SignHashRequest>\n      </arub:signhash>\n   </soapenv:Body>\n</soapenv:Envelope>")) != null) {
            try {
                object2 = a.newDocumentBuilder();
                object = ((DocumentBuilder)object2).parse(new ByteArrayInputStream(((String)object).getBytes()));
                object2 = object.getElementsByTagName("return");
                if (object2.getLength() > 0 && (object = object.getElementsByTagName("return")).getLength() > 0) {
                    object = (Element)object.item(0);
                    object2 = object.getElementsByTagName("signature");
                    object = object.getElementsByTagName("ide");
                    string = null;
                    String string2 = null;
                    if (object2.getLength() > 0) {
                        string = ((Element)object2.item(0)).getTextContent();
                    }
                    if (object.getLength() > 0) {
                        string2 = ((Element)object2.item(0)).getTextContent();
                    }
                    if (string != null) {
                        signResponse.setReturn_code("0000");
                        signResponse.setSignData(Base64.decode((String)string));
                        signResponse.setCert_id(string2);
                    }
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return signResponse;
    }

    private String a(String string, String string2) throws UnsupportedEncodingException {
        RequestData requestData = new RequestData();
        requestData.setSoapAction("\"\"");
        requestData.setPostdata(string2.getBytes("UTF8"));
        requestData.setType("SOAP");
        string = this.urlClient.downloadUrl(string, requestData, this.cred);
        if (string.getStatus().startsWith("OK")) {
            return new String(string.getData());
        }
        return null;
    }

    protected CertListResponse certlistop(String string, CertsListRequest certsListRequest) throws IOException, CapiException {
        if (this.useRestService) {
            return this.certlistopRest(string, certsListRequest);
        }
        return this.certlistopSoap(string, certsListRequest);
    }

    protected CertListResponse certlistopRest(String object, CertsListRequest object2) throws IOException {
        CertListResponse certListResponse = new CertListResponse(this);
        certListResponse.setReturn_code("0002");
        Object object3 = new BodyRequestListCert();
        ((BodyRequestListCert)object3).setIdentity(ARSSToken.a(object2.getIdentity()));
        object = object.endsWith("/") ? (String)object + "listCert" : (String)object + "/listCert";
        try {
            object = (UserCertList)this.simplerest.post((String)object).body(object3, "application/json").auth(this.cred).asObject(UserCertList.class);
            if (object != null) {
                object2 = null;
                object3 = null;
                List<Cert> list = object.getApp1();
                object = object.getApp2();
                if (list != null && list.size() > 0 && list.get(0) != null) {
                    object2 = Base64.decode((String)list.get(0).getValue());
                    object3 = list.get(0).getId();
                } else if (object != null && object.size() > 0 && object.get(0) != null) {
                    object2 = Base64.decode((String)list.get(0).getValue());
                    object3 = ((Cert)object.get(0)).getId();
                }
                if (object2 != null) {
                    certListResponse.setReturn_code("0000");
                    Certificato[] certificatoArray = new Certificato[1];
                    object = certificatoArray;
                    certificatoArray[0] = new Certificato(this);
                    object[0].setId((String)object3);
                    object[0].setContent((byte[])object2);
                    certListResponse.setCertlist((Certificato[])object);
                }
            }
        }
        catch (RestException restException) {
            logger.error(restException.getMessage(), (Throwable)restException);
        }
        return certListResponse;
    }

    protected CertListResponse certlistopSoap(String certificatoArray, CertsListRequest object) throws IOException, CapiException {
        CertListResponse certListResponse;
        block15: {
            certListResponse = new CertListResponse(this);
            certListResponse.setReturn_code("0002");
            String string = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:listCert>\n         <Identity>\n";
            if (object.getIdentity().getOtpPwd() != null) {
                string = string + "             \t<otpPwd>" + object.getIdentity().getOtpPwd() + "</otpPwd>\n";
            }
            string = string + "          \t<typeHSM>COSIGN</typeHSM>\n";
            if (object.getIdentity().getTypeOtpAuth() != null && object.getIdentity().getDomain() == null) {
                string = string + "          \t<typeOtpAuth>" + object.getIdentity().getTypeOtpAuth() + "</typeOtpAuth>\n";
            }
            if (object.getIdentity().getDomain() != null) {
                string = string + "          \t<typeOtpAuth>" + object.getIdentity().getDomain() + "</typeOtpAuth>\n";
            }
            string = string + "          \t<user>" + object.getIdentity().getUser() + "</user>\n";
            if (object.getIdentity().getUserPWD() != null) {
                string = string + "          \t<userPWD>" + object.getIdentity().getUserPWD() + "</userPWD>\n";
            }
            if (object.getIdentity().getDelegated_domain() != null) {
                string = string + "          \t<delegated_domain>" + object.getIdentity().getDelegated_domain() + "</delegated_domain>\n";
            }
            if (object.getIdentity().getDelegated_password() != null) {
                string = string + "          \t<delegated_password>" + object.getIdentity().getDelegated_password() + "</delegated_password>\n";
            }
            if (object.getIdentity().getDelegated_user() != null) {
                string = string + "          \t<delegated_user>" + object.getIdentity().getDelegated_user() + "</delegated_user>\n";
            }
            if ((certificatoArray = this.a((String)certificatoArray, string = string + "         </Identity>\n      </arub:listCert>\n   </soapenv:Body>\n</soapenv:Envelope>")) != null) {
                try {
                    object = a.newDocumentBuilder();
                    certificatoArray = ((DocumentBuilder)object).parse(new ByteArrayInputStream(certificatoArray.getBytes()));
                    object = certificatoArray.getElementsByTagName("return");
                    if (object.getLength() <= 0 || (certificatoArray = certificatoArray.getElementsByTagName("return")).getLength() <= 0) break block15;
                    certificatoArray = (Element)certificatoArray.item(0);
                    object = certificatoArray.getElementsByTagName("app1");
                    string = null;
                    String string2 = null;
                    if (object.getLength() > 0) {
                        string = ((Element)object.item(0)).getElementsByTagName("value").item(0).getTextContent();
                        string2 = ((Element)object.item(0)).getElementsByTagName("id").item(0).getTextContent();
                    } else if ((certificatoArray = certificatoArray.getElementsByTagName("app2")).getLength() > 0) {
                        string = ((Element)certificatoArray.item(0)).getElementsByTagName("value").item(0).getTextContent();
                        string2 = ((Element)certificatoArray.item(0)).getElementsByTagName("id").item(0).getTextContent();
                    }
                    if (string != null) {
                        certListResponse.setReturn_code("0000");
                        Certificato[] certificatoArray2 = new Certificato[1];
                        certificatoArray = certificatoArray2;
                        certificatoArray2[0] = new Certificato(this);
                        certificatoArray[0].setId(string2);
                        certificatoArray[0].setContent(Base64.decode((String)string));
                        certListResponse.setCertlist(certificatoArray);
                    }
                }
                catch (Exception exception) {
                    logger.error(exception.getMessage(), (Throwable)exception);
                }
            } else {
                throw new CapiException("Network Error", 1003);
            }
        }
        return certListResponse;
    }

    public void send_credentialRest(String object) throws IOException {
        BodyRequestSendCredential bodyRequestSendCredential = new BodyRequestSendCredential();
        bodyRequestSendCredential.setIdentity(ARSSToken.a(this.identity));
        bodyRequestSendCredential.setType(CredentialsType.valueOf((String)object));
        object = this.login.getSelectedUrl();
        object = ((String)object).endsWith("/") ? (String)object + "sendCredential" : (String)object + "/sendCredential";
        try {
            object = (ArssReturn)this.simplerest.post((String)object).body((Object)bodyRequestSendCredential, "application/json").auth(this.cred).asObject(ArssReturn.class);
            if (object == null || ((ArssReturn)object).getStatus() == null || !((ArssReturn)object).getStatus().equals("0000")) {
                throw new IOException("Internal Error");
            }
            return;
        }
        catch (RestException restException) {
            logger.error(restException.getMessage(), (Throwable)restException);
            return;
        }
    }

    public void send_credential(String object) throws IOException, CapiException {
        Object object2 = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:sendCredential>\n         <Identity>              \n";
        if (this.identity.getOtpPwd() != null) {
            object2 = (String)object2 + "             \t<otpPwd>" + this.identity.getOtpPwd() + "</otpPwd>\n";
        }
        object2 = (String)object2 + "          \t<typeHSM>COSIGN</typeHSM>\n";
        if (this.identity.getTypeOtpAuth() != null && this.identity.getDomain() == null) {
            object2 = (String)object2 + "          \t<typeOtpAuth>" + this.identity.getTypeOtpAuth() + "</typeOtpAuth>\n";
        }
        if (this.identity.getDomain() != null) {
            object2 = (String)object2 + "          \t<typeOtpAuth>" + this.identity.getDomain() + "</typeOtpAuth>\n";
        }
        object2 = (String)object2 + "          \t<user>" + this.identity.getUser() + "</user>\n";
        if (this.identity.getUserPWD() != null) {
            object2 = (String)object2 + "          \t<userPWD>" + this.identity.getUserPWD() + "</userPWD>\n";
        }
        if (this.identity.getDelegated_domain() != null) {
            object2 = (String)object2 + "          \t<delegated_domain>" + this.identity.getDelegated_domain() + "</delegated_domain>\n";
        }
        if (this.identity.getDelegated_password() != null) {
            object2 = (String)object2 + "          \t<delegated_password>" + this.identity.getDelegated_password() + "</delegated_password>\n";
        }
        if (this.identity.getDelegated_user() != null) {
            object2 = (String)object2 + "          \t<delegated_user>" + this.identity.getDelegated_user() + "</delegated_user>\n";
        }
        object2 = (String)object2 + "         </Identity>\n         <type>" + (String)object + "</type>\n      </arub:sendCredential>\n   </soapenv:Body>\n</soapenv:Envelope>";
        ARSSToken aRSSToken = this;
        object = aRSSToken.a(aRSSToken.login.getSelectedUrl(), (String)object2);
        if (object != null) {
            try {
                object2 = a.newDocumentBuilder();
                object = ((DocumentBuilder)object2).parse(new ByteArrayInputStream(((String)object).getBytes()));
                object = object.getElementsByTagName("return_code");
                if (object.getLength() > 0 && !((String)(object = object.item(0).getTextContent())).equals("0000")) {
                    throw new CapiException("Internal Error", 1003);
                }
                return;
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), (Throwable)exception);
                return;
            }
        }
        throw new CapiException("Network Error", 1003);
    }

    protected String[] auth_methods(String string, it.arubapec.signservice.Auth auth) throws IOException {
        if (this.useRestService) {
            return this.a(string, auth);
        }
        return this.b(string, auth);
    }

    /*
     * WARNING - void declaration
     */
    private String[] a(String object, it.arubapec.signservice.Auth auth) throws IOException {
        ArrayList<String> arrayList;
        block7: {
            void var2_9;
            arrayList = new ArrayList<String>();
            BodyRequestAuthMethod bodyRequestAuthMethod = new BodyRequestAuthMethod();
            bodyRequestAuthMethod.setIdentity(ARSSToken.a((it.arubapec.signservice.Auth)var2_9));
            Object restException = object;
            if (((String)restException).endsWith("/")) {
                String string = (String)restException + "authMethods";
            } else {
                String string = (String)restException + "/authMethods";
            }
            try {
                void var1_5;
                AuthMethodsReturn authMethodsReturn = (AuthMethodsReturn)this.simplerest.post((String)var1_5).body((Object)bodyRequestAuthMethod, "application/json").auth(this.cred).asObject(AuthMethodsReturn.class);
                if (authMethodsReturn != null && authMethodsReturn.getReturn_code() != null && authMethodsReturn.getReturn_code().equals("0000")) {
                    if (authMethodsReturn.getMethods() != null) {
                        for (String string : authMethodsReturn.getMethods()) {
                            if (string == null) continue;
                            arrayList.add(string);
                        }
                    }
                    break block7;
                }
                throw new IOException("Internal Error");
            }
            catch (RestException restException2) {
                logger.error(restException2.getMessage(), (Throwable)restException2);
                throw new IOException(restException2);
            }
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    private String[] b(String object, it.arubapec.signservice.Auth object2) throws IOException {
        ArrayList<String> arrayList;
        block12: {
            arrayList = new ArrayList<String>();
            String string = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:auth_methods>\n             <identity>\n";
            if (object2.getOtpPwd() != null) {
                string = string + "             \t<otpPwd>" + object2.getOtpPwd() + "</otpPwd>\n";
            }
            string = string + "          \t<typeHSM>COSIGN</typeHSM>\n";
            if (object2.getTypeOtpAuth() != null && object2.getDomain() == null) {
                string = string + "          \t<typeOtpAuth>" + object2.getTypeOtpAuth() + "</typeOtpAuth>\n";
            }
            if (object2.getDomain() != null) {
                string = string + "          \t<typeOtpAuth>" + object2.getDomain() + "</typeOtpAuth>\n";
            }
            string = string + "          \t<user>" + object2.getUser() + "</user>\n";
            if (object2.getUserPWD() != null) {
                string = string + "          \t<userPWD>" + object2.getUserPWD() + "</userPWD>\n";
            }
            if (object2.getDelegated_domain() != null) {
                string = string + "          \t<delegated_domain>" + object2.getDelegated_domain() + "</delegated_domain>\n";
            }
            if (object2.getDelegated_password() != null) {
                string = string + "          \t<delegated_password>" + object2.getDelegated_password() + "</delegated_password>\n";
            }
            if (object2.getDelegated_user() != null) {
                string = string + "          \t<delegated_user>" + object2.getDelegated_user() + "</delegated_user>\n";
            }
            if ((object = this.a((String)object, string = string + "         </identity>\n    </arub:auth_methods>\n   </soapenv:Body>\n</soapenv:Envelope>")) != null) {
                try {
                    object2 = a.newDocumentBuilder();
                    object = ((DocumentBuilder)object2).parse(new ByteArrayInputStream(((String)object).getBytes()));
                    object2 = object.getElementsByTagName("return_code");
                    if (object2.getLength() <= 0) break block12;
                    if (((String)(object2 = object2.item(0).getTextContent())).equals("0000")) {
                        object = object.getElementsByTagName("methods");
                        for (int i = 0; i < object.getLength(); ++i) {
                            arrayList.add(object.item(i).getTextContent());
                        }
                        break block12;
                    }
                    throw new CapiException("Internal Error", 1003);
                }
                catch (Exception exception) {
                    logger.error(exception.getMessage(), (Throwable)exception);
                }
            }
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    protected String opensession(String string, TempPwdRequest tempPwdRequest) throws IOException {
        if (this.useRestService) {
            return this.a(tempPwdRequest);
        }
        return this.a(string, tempPwdRequest);
    }

    private String a(TempPwdRequest object) throws IOException {
        BodyRequestOpenSession bodyRequestOpenSession = new BodyRequestOpenSession();
        bodyRequestOpenSession.setIdentity(ARSSToken.a(object.getIdentity()));
        object = this.login.getSelectedUrl();
        object = object.endsWith("/") ? (String)object + "opensession" : (String)object + "/opensession";
        try {
            object = (String)this.simplerest.post((String)object).body((Object)bodyRequestOpenSession, "application/json").auth(this.cred).asObject(String.class);
        }
        catch (RestException restException) {
            logger.error(restException.getMessage(), (Throwable)restException);
            throw new IOException(restException);
        }
        return object;
    }

    private String a(String object, TempPwdRequest object2) throws IOException {
        String string = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:opensession>\n         <Identity>\n";
        if (object2.getIdentity().getOtpPwd() != null) {
            string = string + "             \t<otpPwd>" + object2.getIdentity().getOtpPwd() + "</otpPwd>\n";
        }
        string = string + "          \t<typeHSM>COSIGN</typeHSM>\n";
        if (object2.getIdentity().getTypeOtpAuth() != null && object2.getIdentity().getDomain() == null) {
            string = string + "          \t<typeOtpAuth>" + object2.getIdentity().getTypeOtpAuth() + "</typeOtpAuth>\n";
        }
        if (object2.getIdentity().getDomain() != null) {
            string = string + "          \t<typeOtpAuth>" + object2.getIdentity().getDomain() + "</typeOtpAuth>\n";
        }
        string = string + "          \t<user>" + object2.getIdentity().getUser() + "</user>\n";
        if (object2.getIdentity().getUserPWD() != null) {
            string = string + "          \t<userPWD>" + object2.getIdentity().getUserPWD() + "</userPWD>\n";
        }
        if (object2.getIdentity().getDelegated_domain() != null) {
            string = string + "          \t<delegated_domain>" + object2.getIdentity().getDelegated_domain() + "</delegated_domain>\n";
        }
        if (object2.getIdentity().getDelegated_password() != null) {
            string = string + "          \t<delegated_password>" + object2.getIdentity().getDelegated_password() + "</delegated_password>\n";
        }
        if (object2.getIdentity().getDelegated_user() != null) {
            string = string + "          \t<delegated_user>" + object2.getIdentity().getDelegated_user() + "</delegated_user>\n";
        }
        if ((object = this.a((String)object, string = string + "         </Identity>\n      </arub:opensession>\n   </soapenv:Body>\n</soapenv:Envelope>")) != null) {
            try {
                object2 = a.newDocumentBuilder();
                object = object2.parse(new ByteArrayInputStream(((String)object).getBytes()));
                object2 = object.getElementsByTagName("return");
                if (object2.getLength() > 0) {
                    object = object.getElementsByTagName("return");
                    object = (Element)object.item(0);
                    return object.getTextContent();
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return null;
    }

    public byte[] xmlVerifiedSignature(byte[] byArray, String string) throws CapiException {
        throw new CapiException("ARSS Signature doesn't support verifiedSignarute functionality", 1004);
    }

    private static Auth a(it.arubapec.signservice.Auth auth) {
        if (auth == null) {
            return null;
        }
        Auth auth2 = new Auth();
        auth2.setDelegated_domain(auth.getDelegated_domain());
        auth2.setDelegated_password(auth.getDelegated_password());
        auth2.setDelegated_user(auth.getDelegated_user());
        auth2.setOtpPwd(auth.getOtpPwd());
        auth2.setTypeHSM("COSIGN");
        auth2.setTypeOtpAuth(auth.getTypeOtpAuth());
        auth2.setUser(auth.getUser());
        auth2.setUserPWD(auth.getUserPWD());
        return auth2;
    }

    public RecoverySessionCredential openSessionWithExtendedAuth(boolean bl, String string, ExtendedCredentials extendedCredentials) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected String digestWithSalt(String string) throws CapiException {
        string = "dkajfw39o2jn1ndwndvcp" + string;
        return Util.dumpHex((byte[])Util.digestStreams((String)Constants.SHA256, (InputStream[])new InputStream[]{new ByteArrayInputStream(string.getBytes())}));
    }

    protected class LoginCache {
        private CertListResponse a;
        private String[] b;
        private String c;

        public LoginCache(ARSSToken aRSSToken, CertListResponse certListResponse, String[] stringArray, String string) {
            this.a = certListResponse;
            this.b = stringArray;
            this.c = string;
        }

        public CertListResponse getResp() {
            return this.a;
        }

        public String[] getAuthMethods() {
            return this.b;
        }

        public String getSelectedUrl() {
            return this.c;
        }
    }

    protected class CertListResponse {
        private Certificato[] a;
        private String b;

        protected CertListResponse(ARSSToken aRSSToken) {
        }

        public Certificato[] getCertlist() {
            return this.a;
        }

        public void setCertlist(Certificato[] certificatoArray) {
            this.a = certificatoArray;
        }

        public String getReturn_code() {
            return this.b;
        }

        public void setReturn_code(String string) {
            this.b = string;
        }
    }

    protected class Certificato {
        private String a;
        private byte[] b;

        protected Certificato(ARSSToken aRSSToken) {
        }

        public String getId() {
            return this.a;
        }

        public void setId(String string) {
            this.a = string;
        }

        public byte[] getContent() {
            return this.b;
        }

        public void setContent(byte[] byArray) {
            this.b = byArray;
        }
    }
}

