/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.core.http.utils;

import esecurity.dsd.core.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class DSDTrustStore {
    private static KeyStore trustStoreRs;

    public static KeyStore getTrustStore() {
        return trustStoreRs;
    }

    static {
        InputStream is = null;
        try {
            File file;
            trustStoreRs = KeyStore.getInstance("JKS");
            String dsdTs = System.getProperty("esecurity.dsd.ts");
            if (dsdTs != null && !dsdTs.isEmpty() && (file = new File(dsdTs)).exists()) {
                is = new FileInputStream(file);
            }
            if (is == null) {
                is = DSDTrustStore.class.getResourceAsStream("/esecurity/dsd/core/http/ts");
            }
            trustStoreRs.load(is, "AmPJz+RpQF0JaEKc/vk6SrCZMtCp46bM44bgKEMGyHsYjLAk7H".toCharArray());
        }
        catch (IOException ex) {
            Log.logger().error(ex.getMessage());
        }
        catch (NoSuchAlgorithmException ex) {
            Log.logger().error(ex.getMessage());
        }
        catch (CertificateException ex) {
            Log.logger().error(ex.getMessage());
        }
        catch (KeyStoreException ex) {
            Log.logger().error(ex.getMessage());
        }
        catch (Throwable ex) {
            Log.logger().error(ex.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Log.logger().warn("Cannot close input stream", (Throwable)ex);
                }
            }
        }
    }
}

