/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.core.http;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import esecurity.dsd.core.PropertyContainer;
import esecurity.dsd.core.http.ProxyConfiguration;
import esecurity.dsd.core.http.Token;
import esecurity.dsd.core.http.providers.HTTPUrl;
import esecurity.dsd.core.http.providers.RESTClientProvider;
import esecurity.dsd.core.http.utils.DSDTrustStore;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class RESTClient {
    private EnumMap<Timeouts, Long> timeouts = new EnumMap(Timeouts.class);
    private HTTPUrl baseURL = null;

    public RESTClient(String hostName, int portNo, String servicePath, boolean secured, long connectionTimeout, long readTimeout, long writeTimeout, ProxyConfiguration proxy) {
        this.baseURL = new HTTPUrl.Builder().scheme(secured ? "https" : "http").host(hostName).port(portNo).addPathSegment(servicePath).build();
        this.timeouts.put(Timeouts.CONNECTION, connectionTimeout);
        this.timeouts.put(Timeouts.READ, readTimeout);
        this.timeouts.put(Timeouts.WRITE, writeTimeout);
        RESTClientProvider.Factory.getDefault().initialize(this.baseURL, this.timeouts, secured ? DSDTrustStore.getTrustStore() : null, proxy);
    }

    public static RESTClient getInstance(PropertyContainer properties) {
        String hostName = properties.getValue("host", String.class).orElseThrow(() -> new IllegalArgumentException("Configuration Error: hostName not provided, but required. "));
        Integer portNo = properties.getValue("port", Integer.class).orElse(0);
        String servicePath = properties.getValue("service", String.class).orElse("dsd-server");
        Boolean secured = properties.getValue("secured", Boolean.class).orElse(true);
        Integer connTimeoutSec = properties.getValue("connectionTimeout", Integer.class).orElse(60);
        Integer readTimeoutSec = properties.getValue("readTimeout", Integer.class).orElse(60);
        Integer writeTimeoutSec = properties.getValue("writeTimeout", Integer.class).orElse(60);
        ProxyConfiguration proxy = properties.getValue("proxy.addr", String.class).map(proxy_addr -> properties.getValue("proxy.port", Integer.class).map(proxy_port -> properties.getValue("proxy.user", String.class).map(proxy_user -> properties.getValue("proxy.pwd", String.class).map(proxy_password -> new ProxyConfiguration((String)proxy_addr, (Integer)proxy_port, (String)proxy_user, (String)proxy_password)).orElse(null)).orElse(null)).orElse(null)).orElse(null);
        return new RESTClient(hostName, portNo, servicePath, secured, connTimeoutSec.intValue(), readTimeoutSec.intValue(), writeTimeoutSec.intValue(), proxy);
    }

    public HTTPUrl getServiceUrl(Services service, String ... params) {
        return service.build(this.baseURL.newBuilder(), params);
    }

    public Token getToken(String username, String pwd, boolean encrypted) throws UnhautorizedException, TimeoutException, HTTPException, NotFoundException {
        HTTPResponse response = RESTClientProvider.Factory.getDefault().call(HTTPMethod.POST, this.getServiceUrl(Services.AUTHORIZE, new String[0]), null, username, pwd, (JsonElement)JsonNull.INSTANCE);
        if (response != null) {
            switch (response.code()) {
                case 200: {
                    return new Token(response.body().getAsString());
                }
                case 401: {
                    throw new UnhautorizedException(response.message());
                }
                case 404: {
                    throw new NotFoundException("404 - Not found");
                }
                case 408: {
                    throw new TimeoutException(response.message());
                }
            }
            throw new HTTPException(response.code(), response.message());
        }
        return Token.invalidToken();
    }

    public JsonElement getDomainList(Token token) throws HTTPException, UnhautorizedException, TimeoutException, DuplicationException, NotFoundException {
        Optional<HTTPResponse> response = this.sendRequest(token, HTTPMethod.GET, Services.DOMAINS, Optional.empty(), new String[0]).filter(HTTPResponse::isSuccessful);
        return response.isPresent() ? response.get().body() : new JsonArray();
    }

    public Optional<HTTPResponse> sendRequest(Token token, HTTPMethod method, Services service, Optional<JsonElement> requestBody, String ... parameters) throws HTTPException, UnhautorizedException, TimeoutException, DuplicationException, NotFoundException {
        HTTPResponse response = null;
        if (token != null && token.isValid() && (response = RESTClientProvider.Factory.getDefault().call(method, this.getServiceUrl(service, parameters), HTTPHeader.build("Authorization", token.getToken()), null, null, requestBody.orElse((JsonElement)JsonNull.INSTANCE))) != null) {
            token.invalidate(response.code());
            if (!response.isSuccessful()) {
                int code = response.code();
                if (code == 401 || code == 403) {
                    throw new UnhautorizedException(response.message());
                }
                if (code == 404) {
                    throw new NotFoundException("404 - Not found");
                }
                if (code == 408) {
                    throw new TimeoutException(response.message());
                }
                if (code == 409) {
                    throw new DuplicationException(response.message());
                }
                throw new HTTPException(code, response.message());
            }
        }
        return Optional.ofNullable(response);
    }

    public JsonElement getDomain(Token token, String domain) throws HTTPException, UnhautorizedException, TimeoutException, DuplicationException, NotFoundException {
        Optional<HTTPResponse> response = this.sendRequest(token, HTTPMethod.GET, Services.DOMAIN_PROPERTIES, Optional.empty(), "domain", domain).filter(HTTPResponse::isSuccessful);
        return response.isPresent() ? response.get().body() : null;
    }

    public JsonElement getDomainRestricted(Token token, String domain) throws HTTPException, UnhautorizedException, TimeoutException, DuplicationException, NotFoundException {
        Optional<HTTPResponse> response = this.sendRequest(token, HTTPMethod.GET, Services.DOMAIN_RESTRICTED_PROPERTIES, Optional.empty(), "domain", domain).filter(HTTPResponse::isSuccessful);
        return response.isPresent() ? response.get().body() : null;
    }

    public boolean createDomain(Token token, String domain, JsonObject initProperties) throws HTTPException, UnhautorizedException, TimeoutException, DuplicationException, NotFoundException {
        return this.sendRequest(token, HTTPMethod.POST, Services.DOMAIN_PROPERTIES, Optional.ofNullable(initProperties), "domain", domain).filter(HTTPResponse::isSuccessful).isPresent();
    }

    public boolean editDomain(Token token, String domain, JsonObject initProperties) throws HTTPException, UnhautorizedException, TimeoutException, DuplicationException, NotFoundException {
        return this.sendRequest(token, HTTPMethod.PUT, Services.DOMAIN_PROPERTIES, Optional.ofNullable(initProperties), "domain", domain).filter(HTTPResponse::isSuccessful).isPresent();
    }

    public boolean deleteDomain(Token token, String domain) throws HTTPException, UnhautorizedException, TimeoutException, DuplicationException, NotFoundException {
        return this.sendRequest(token, HTTPMethod.DELETE, Services.DOMAIN_PROPERTIES, Optional.empty(), "domain", domain).filter(HTTPResponse::isSuccessful).isPresent();
    }

    public static class HTTPResponse {
        private int code;
        private JsonElement body;
        private String message;

        public static boolean isSuccessful(int code) {
            return code >= 200 && code < 300;
        }

        public HTTPResponse(Builder builder) {
            this.code = builder.code;
            this.message = new String(builder.message);
            this.body = new Gson().toJsonTree((Object)builder.body);
        }

        public boolean isSuccessful() {
            return HTTPResponse.isSuccessful(this.code);
        }

        public int code() {
            return this.code;
        }

        public JsonElement body() {
            return this.body;
        }

        public String message() {
            return this.message;
        }

        public static class Builder {
            int code;
            JsonElement body = JsonNull.INSTANCE;
            String message;

            public Builder code(int code) {
                this.code = code;
                return this;
            }

            public Builder message(String msg) {
                this.message = msg;
                return this;
            }

            public Builder body(JsonElement json) {
                this.body = json;
                return this;
            }

            public HTTPResponse build() {
                return new HTTPResponse(this);
            }
        }
    }

    public static class HTTPHeader {
        public static final String AUTHORIZATION = "Authorization";
        private Map<String, String> map = new HashMap<String, String>();

        public static HTTPHeader build(String ... pairs) {
            if (pairs.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters must be a pair of name and value. ");
            }
            HTTPHeader result = new HTTPHeader();
            result.map = new HashMap<String, String>(pairs.length / 2 + 1);
            int i = 0;
            while (i < pairs.length) {
                result.map.put(pairs[i++], pairs[i++]);
            }
            return result;
        }

        public boolean contains(String key) {
            return this.map.containsKey(key);
        }

        public String get(String key) {
            return this.map.get(key);
        }

        public Set<String> keyset() {
            return this.map.keySet();
        }
    }

    public static enum Services {
        AUTHORIZE{

            @Override
            public HTTPUrl build(HTTPUrl.Builder builder, String ... params) {
                return builder.addPathSegments("authorize/token/j_security_check").build();
            }
        }
        ,
        DOMAINS{

            @Override
            public HTTPUrl build(HTTPUrl.Builder builder, String ... params) {
                return builder.addPathSegments("api/domains").build();
            }
        }
        ,
        DOMAIN_PROPERTIES{

            @Override
            public HTTPUrl build(HTTPUrl.Builder builder, String ... params) {
                Map<String, String> map = this.getParams(params);
                HTTPUrl.Builder segments = builder.addPathSegments("api/domain");
                segments.addPathSegment(map.get("domain"));
                this.setup_query_params(map, segments, "replica");
                this.setup_query_params(map, segments, "withData");
                this.setup_query_params(map, segments, "private");
                this.setup_query_params(map, segments, "delete");
                return segments.build();
            }
        }
        ,
        DOMAIN_RESTRICTED_PROPERTIES{

            @Override
            public HTTPUrl build(HTTPUrl.Builder builder, String ... params) {
                Map<String, String> map = this.getParams(params);
                HTTPUrl.Builder segments = builder.addPathSegments("api/domain");
                segments.addPathSegment(map.get("domain"));
                segments.addPathSegment("restricted");
                return segments.build();
            }
        }
        ,
        ADMIN_USERS{

            @Override
            public HTTPUrl build(HTTPUrl.Builder builder, String ... params) {
                return builder.addPathSegments("api/users").addPathSegment(this.getParams(params).get("username")).build();
            }
        }
        ,
        ADMIN_USERS_CHANGEPWD{

            @Override
            public HTTPUrl build(HTTPUrl.Builder builder, String ... params) {
                return builder.addPathSegments("api/users").addPathSegment(this.getParams(params).get("username")).addPathSegment("chgpwd").build();
            }
        }
        ,
        ADMIN_USERS_CHANGEROLES{

            @Override
            public HTTPUrl build(HTTPUrl.Builder builder, String ... params) {
                return builder.addPathSegments("api/users").addPathSegment(this.getParams(params).get("username")).addPathSegment("chgroles").build();
            }
        };


        public Map<String, String> getParams(String ... params) {
            if (params.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters must be a pair of name and value. ");
            }
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            int i = 0;
            while (i < params.length) {
                result.put(params[i++], params[i++]);
            }
            return result;
        }

        void setup_query_params(Map<String, String> map, HTTPUrl.Builder segments, String key) {
            if (map.containsKey(key)) {
                map.forEach((k, v) -> {
                    if (k.equals(key)) {
                        segments.addQueryParameter((String)k, (String)v);
                    }
                });
            }
        }

        public abstract HTTPUrl build(HTTPUrl.Builder var1, String ... var2);
    }

    public static enum Timeouts {
        CONNECTION,
        READ,
        WRITE;

    }

    public static enum HTTPMethod {
        HEAD,
        GET,
        POST,
        PUT,
        DELETE;

    }

    public static final class Credentials {
        private Credentials() {
        }

        public static String basic(String userName, String password) {
            String usernameAndPassword = userName.concat(":").concat(password);
            String encoded = Base64.getEncoder().encodeToString(usernameAndPassword.getBytes(Charset.forName("UTF-8")));
            return "Basic " + encoded;
        }
    }

    public static class HTTPException
    extends Exception {
        private int code;

        public HTTPException(int code, String message) {
            super(message);
            this.code = code;
        }

        public HTTPException(int code, String message, Exception cause) {
            super(message, cause);
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }

    public static class DuplicationException
    extends Exception {
        public DuplicationException(String message) {
            super(message);
        }
    }

    public static class TimeoutException
    extends Exception {
        public TimeoutException(String message) {
            super(message);
        }
    }

    public static class NotFoundException
    extends Exception {
        public NotFoundException(String message) {
            super(message);
        }
    }

    public static class UnhautorizedException
    extends Exception {
        public UnhautorizedException(String message) {
            super(message);
        }
    }
}

