/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.utils.files;

import com.sun.jna.Platform;
import esecurity.crypto.gui.utils.Constants;
import esecurity.crypto.gui.utils.swt.ImageHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class FileSystemUtils {
    private static final EllipsLogger a = EllipsLoggerFactory.getLogger((String)it.actalis.vol.utils.Constants.CAPI_LOGGER_NAME);

    public static boolean testWritableDir(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        boolean bl = false;
        try {
            file = new File(file.getAbsolutePath() + File.separator + "Dummy_test_filedjsjfkdskk.fff");
            bl = file.createNewFile();
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        return bl;
    }

    public static boolean areFilesInSameFolder(List<? extends File> object) {
        if (object.size() <= 1) {
            return true;
        }
        String string = object.get(0).getParent();
        object = object.iterator();
        while (object.hasNext()) {
            File file = (File)object.next();
            if (string.equals(file.getParent())) continue;
            return false;
        }
        return true;
    }

    public static void openFolder(File file) {
        block5: {
            if (!file.exists()) {
                a.error("Folder " + file.getAbsolutePath() + " does not exist");
                return;
            }
            try {
                if (Platform.isLinux()) {
                    a.debug("Exec xdg-open {}", (Object)file.getAbsolutePath());
                    Runtime.getRuntime().exec(new String[]{"xdg-open", file.getAbsolutePath()});
                    break block5;
                }
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().open(file);
                    break block5;
                }
                a.error("Desktop not supported");
                return;
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    public static File renameFilesWithSameName(File object, String string, String object2) throws IOException {
        object = new File(object + File.separator + string + (String)object2);
        int n = 1;
        while (((File)object).exists()) {
            object2 = new File(((File)object).getParentFile().getCanonicalPath() + File.separator + ((File)object).getName().substring(0, ((File)object).getName().indexOf(".")) + "(" + n + ")" + ((File)object).getName().substring(((File)object).getName().indexOf(".")));
            if (!((File)object2).exists()) {
                object = object2;
            }
            ++n;
        }
        return object;
    }

    public static void listFilesForFolderSubfolder(List<File> list, File fileArray) {
        if ((fileArray = fileArray.listFiles()) == null) {
            return;
        }
        for (File file : fileArray) {
            if (Files.isSymbolicLink(file.toPath()) || FilenameUtils.getExtension((String)file.getName()).equals("lnk")) continue;
            if (file.isDirectory()) {
                FileSystemUtils.listFilesForFolderSubfolder(list, file);
                continue;
            }
            list.add(file);
        }
    }

    public static List<File> getFilesFromPath(String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            File object = new File(string);
            if (Files.isSymbolicLink(object.toPath())) continue;
            if (object.isDirectory()) {
                FileSystemUtils.listFilesForFolderSubfolder(arrayList, object);
                continue;
            }
            if (!object.isFile()) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public static boolean isFileSafeToOpen(InputHandler stringArray, String string) {
        if (string.equals("")) {
            string = ImageHandler.retrieveFileType((InputHandler)stringArray);
        }
        stringArray = Constants.SECURE_TO_OPEN_EXT;
        int n = Constants.SECURE_TO_OPEN_EXT.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }
}

