/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.StringsResourceTranslator;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public final class HtmlAssetTranslator {
    private static final Pattern COMMA = Pattern.compile(",");

    private HtmlAssetTranslator() {
    }

    public static void main(String[] args) throws IOException {
        File assetsDir = new File(args[0]);
        Collection<String> languagesToTranslate = HtmlAssetTranslator.parseLanguagesToTranslate(assetsDir, args[1]);
        Collection<String> filesToTranslate = HtmlAssetTranslator.parseFilesToTranslate(args);
        for (String language : languagesToTranslate) {
            HtmlAssetTranslator.translateOneLanguage(assetsDir, language, filesToTranslate);
        }
    }

    private static Collection<String> parseLanguagesToTranslate(File assetsDir, CharSequence languageArg) {
        ArrayList<String> languages = new ArrayList<String>();
        if ("all".equals(languageArg)) {
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && file.getName().startsWith("html-") && !"html-en".equals(file.getName());
                }
            };
            for (File languageDir : assetsDir.listFiles(fileFilter)) {
                languages.add(languageDir.getName().substring(5));
            }
        } else {
            languages.addAll(Arrays.asList(COMMA.split(languageArg)));
        }
        return languages;
    }

    private static Collection<String> parseFilesToTranslate(String[] args) {
        ArrayList<String> fileNamesToTranslate = new ArrayList<String>();
        for (int i = 2; i < args.length; ++i) {
            fileNamesToTranslate.add(args[i]);
        }
        return fileNamesToTranslate;
    }

    private static void translateOneLanguage(File assetsDir, String language, final Collection<String> filesToTranslate) throws IOException {
        File[] sourceFiles;
        File targetHtmlDir = new File(assetsDir, "html-" + language);
        targetHtmlDir.mkdirs();
        File englishHtmlDir = new File(assetsDir, "html-en");
        String translationTextTranslated = StringsResourceTranslator.translateString("Translated by Google Translate.", language);
        for (File sourceFile : sourceFiles = englishHtmlDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".html") && (filesToTranslate.isEmpty() || filesToTranslate.contains(name));
            }
        })) {
            HtmlAssetTranslator.translateOneFile(language, targetHtmlDir, sourceFile, translationTextTranslated);
        }
    }

    private static void translateOneFile(String language, File targetHtmlDir, File sourceFile, String translationTextTranslated) throws IOException {
        DOMImplementationRegistry registry;
        Document document;
        File destFile = new File(targetHtmlDir, sourceFile.getName());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(sourceFile);
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalStateException(pce);
        }
        catch (SAXException sae) {
            throw new IOException(sae);
        }
        Element rootElement = document.getDocumentElement();
        rootElement.normalize();
        LinkedList<Node> nodes = new LinkedList<Node>();
        nodes.add(rootElement);
        while (!nodes.isEmpty()) {
            String text;
            Node node = (Node)nodes.poll();
            if (HtmlAssetTranslator.shouldTranslate(node)) {
                NodeList children = node.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    nodes.add(children.item(i));
                }
            }
            if (node.getNodeType() != 3 || (text = node.getTextContent()).trim().length() <= 0) continue;
            text = StringsResourceTranslator.translateString(text, language);
            node.setTextContent(' ' + text + ' ');
        }
        Text translateText = document.createTextNode(translationTextTranslated);
        Element paragraph = document.createElement("p");
        paragraph.appendChild(translateText);
        Node body = rootElement.getElementsByTagName("body").item(0);
        body.appendChild(paragraph);
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException(iae);
        }
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer writer = impl.createLSSerializer();
        writer.writeToURI(document, destFile.toURI().toString());
    }

    private static boolean shouldTranslate(Node node) {
        String textContent;
        Node classAttribute;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (classAttribute = attributes.getNamedItem("class")) != null && (textContent = classAttribute.getTextContent()) != null && textContent.contains("notranslate")) {
            return false;
        }
        String nodeName = node.getNodeName();
        if ("script".equalsIgnoreCase(nodeName)) {
            return false;
        }
        textContent = node.getTextContent();
        if (textContent != null) {
            for (int i = 0; i < textContent.length(); ++i) {
                if (!Character.isLetter(textContent.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }
}

