/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.Config;
import com.google.zxing.client.j2se.Inputs;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import javax.imageio.ImageIO;

final class DecodeThread
extends Thread {
    private int successful;
    private final Config config;
    private final Inputs inputs;

    DecodeThread(Config config, Inputs inputs) {
        this.config = config;
        this.inputs = inputs;
    }

    @Override
    public void run() {
        String input;
        while ((input = this.inputs.getNextInput()) != null) {
            File inputFile = new File(input);
            if (inputFile.exists()) {
                try {
                    if (this.config.isMulti()) {
                        Result[] results = this.decodeMulti(inputFile.toURI(), this.config.getHints());
                        if (results == null) continue;
                        ++this.successful;
                        if (!this.config.isDumpResults()) continue;
                        DecodeThread.dumpResultMulti(inputFile, results);
                        continue;
                    }
                    Result result = this.decode(inputFile.toURI(), this.config.getHints());
                    if (result == null) continue;
                    ++this.successful;
                    if (!this.config.isDumpResults()) continue;
                    DecodeThread.dumpResult(inputFile, result);
                }
                catch (IOException e) {}
                continue;
            }
            try {
                if (this.decode(new URI(input), this.config.getHints()) == null) continue;
                ++this.successful;
            }
            catch (Exception exception) {}
        }
    }

    public int getSuccessful() {
        return this.successful;
    }

    private static void dumpResult(File input, Result result) throws IOException {
        String name = input.getCanonicalPath();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        File dump = new File(name + ".txt");
        DecodeThread.writeStringToFile(result.getText(), dump);
    }

    private static void dumpResultMulti(File input, Result[] results) throws IOException {
        String name = input.getCanonicalPath();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        File dump = new File(name + ".txt");
        DecodeThread.writeResultsToFile(results, dump);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStringToFile(String value, File file) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF8"));
        try {
            out.write(value);
        }
        finally {
            ((Writer)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResultsToFile(Result[] results, File file) throws IOException {
        String newline = System.getProperty("line.separator");
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF8"));
        try {
            for (Result result : results) {
                out.write(result.getText());
                out.write(newline);
            }
        }
        finally {
            ((Writer)out).close();
        }
    }

    private Result decode(URI uri, Map<DecodeHintType, ?> hints) throws IOException {
        BufferedImage image;
        try {
            image = ImageIO.read(uri.toURL());
        }
        catch (IllegalArgumentException iae) {
            throw new FileNotFoundException("Resource not found: " + uri);
        }
        if (image == null) {
            System.err.println(uri.toString() + ": Could not load image");
            return null;
        }
        try {
            BufferedImageLuminanceSource source;
            if (this.config.getCrop() == null) {
                source = new BufferedImageLuminanceSource(image);
            } else {
                int[] crop = this.config.getCrop();
                source = new BufferedImageLuminanceSource(image, crop[0], crop[1], crop[2], crop[3]);
            }
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            if (this.config.isDumpBlackPoint()) {
                DecodeThread.dumpBlackPoint(uri, image, bitmap);
            }
            Result result = new MultiFormatReader().decode(bitmap, hints);
            if (this.config.isBrief()) {
                System.out.println(uri.toString() + ": Success");
            } else {
                ParsedResult parsedResult = ResultParser.parseResult((Result)result);
                System.out.println(uri.toString() + " (format: " + result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                System.out.println("Found " + result.getResultPoints().length + " result points.");
                for (int i = 0; i < result.getResultPoints().length; ++i) {
                    ResultPoint rp = result.getResultPoints()[i];
                    System.out.println("  Point " + i + ": (" + rp.getX() + ',' + rp.getY() + ')');
                }
            }
            return result;
        }
        catch (NotFoundException nfe) {
            System.out.println(uri.toString() + ": No barcode found");
            return null;
        }
    }

    private Result[] decodeMulti(URI uri, Map<DecodeHintType, ?> hints) throws IOException {
        BufferedImage image;
        try {
            image = ImageIO.read(uri.toURL());
        }
        catch (IllegalArgumentException iae) {
            throw new FileNotFoundException("Resource not found: " + uri);
        }
        if (image == null) {
            System.err.println(uri.toString() + ": Could not load image");
            return null;
        }
        try {
            BufferedImageLuminanceSource source;
            if (this.config.getCrop() == null) {
                source = new BufferedImageLuminanceSource(image);
            } else {
                int[] crop = this.config.getCrop();
                source = new BufferedImageLuminanceSource(image, crop[0], crop[1], crop[2], crop[3]);
            }
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            if (this.config.isDumpBlackPoint()) {
                DecodeThread.dumpBlackPoint(uri, image, bitmap);
            }
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            GenericMultipleBarcodeReader reader = new GenericMultipleBarcodeReader((Reader)multiFormatReader);
            Result[] results = reader.decodeMultiple(bitmap, hints);
            if (this.config.isBrief()) {
                System.out.println(uri.toString() + ": Success");
            } else {
                for (Result result : results) {
                    ParsedResult parsedResult = ResultParser.parseResult((Result)result);
                    System.out.println(uri.toString() + " (format: " + result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                    System.out.println("Found " + result.getResultPoints().length + " result points.");
                    for (int i = 0; i < result.getResultPoints().length; ++i) {
                        ResultPoint rp = result.getResultPoints()[i];
                        System.out.println("  Point " + i + ": (" + rp.getX() + ',' + rp.getY() + ')');
                    }
                }
            }
            return results;
        }
        catch (NotFoundException nfe) {
            System.out.println(uri.toString() + ": No barcode found");
            return null;
        }
    }

    private static void dumpBlackPoint(URI uri, BufferedImage image, BinaryBitmap bitmap) {
        int x;
        int offset;
        int y;
        String inputName = uri.getPath();
        if (inputName.contains(".mono.png")) {
            return;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int stride = width * 3;
        int[] pixels = new int[stride * height];
        int[] argb = new int[width];
        for (int y2 = 0; y2 < height; ++y2) {
            image.getRGB(0, y2, width, 1, argb, 0, width);
            System.arraycopy(argb, 0, pixels, y2 * stride, width);
        }
        BitArray row = new BitArray(width);
        for (y = 0; y < height; ++y) {
            try {
                row = bitmap.getBlackRow(y, row);
            }
            catch (NotFoundException nfe) {
                offset = y * stride + width;
                for (x = 0; x < width; ++x) {
                    pixels[offset + x] = -65536;
                }
                continue;
            }
            int offset2 = y * stride + width;
            for (int x2 = 0; x2 < width; ++x2) {
                pixels[offset2 + x2] = row.get(x2) ? -16777216 : -1;
            }
        }
        try {
            for (y = 0; y < height; ++y) {
                BitMatrix matrix = bitmap.getBlackMatrix();
                offset = y * stride + width * 2;
                for (x = 0; x < width; ++x) {
                    pixels[offset + x] = matrix.get(x, y) ? -16777216 : -1;
                }
            }
        }
        catch (NotFoundException nfe) {
            // empty catch block
        }
        DecodeThread.writeResultImage(stride, height, pixels, uri, inputName, ".mono.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResultImage(int stride, int height, int[] pixels, URI uri, String inputName, String suffix) {
        int pos;
        BufferedImage result = new BufferedImage(stride, height, 2);
        result.setRGB(0, 0, stride, height, pixels, 0, stride);
        String resultName = inputName;
        if ("http".equals(uri.getScheme()) && (pos = resultName.lastIndexOf(47)) > 0) {
            resultName = '.' + resultName.substring(pos);
        }
        if ((pos = resultName.lastIndexOf(46)) > 0) {
            resultName = resultName.substring(0, pos);
        }
        resultName = resultName + suffix;
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(resultName);
            if (!ImageIO.write((RenderedImage)result, "png", outStream)) {
                System.err.println("Could not encode an image to " + resultName);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not create " + resultName);
        }
        catch (IOException e) {
            System.err.println("Could not write to " + resultName);
        }
        finally {
            try {
                if (outStream != null) {
                    ((OutputStream)outStream).close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

