/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.armpclient.utils;

import it.arubapec.armpclient.exception.CertVerificationException;
import it.arubapec.armpclient.utils.CRLClient$OCSPClient;
import it.arubapec.armpclient.utils.OCSPClient$CRLClient;
import it.arubapec.armpclient.utils.OCSPClient$OCSPClient;
import it.arubapec.armpclient.utils.auchrzch;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;

public class OCSPClient {
    private static final Logger logger = OCSPClient.uu("nf3mni", OCSPClient.class);

    private static OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws CertificateEncodingException, OperatorCreationException, OCSPException {
        char[] cArray = "\ue0cf\u1abc\u693c\u9434\u1694\u50a1\u8f98\u4f6d\u1460\udcb4\ueeba\u5f7e\u3224\u465e\u8114\u863c\uccab\uac7b\ua5d8\u7481\ud75c\u4265\u3e8f\u2c2e\u5b0e".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x2DB6);
        logger.info(CRLClient$OCSPClient.i(cArray, (short)20264, false, true));
        OCSPClient.uu("14ndmnj", new BouncyCastleProvider());
        CertificateID id = new CertificateID(OCSPClient.uu("-1lr897o", new JcaDigestCalculatorProviderBuilder()).get(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE)), (X509CertificateHolder)new JcaX509CertificateHolder(issuerCert), serialNumber);
        OCSPReqBuilder gen = new OCSPReqBuilder();
        OCSPClient.uu("-72497n", gen, id);
        Object nonce = OCSPClient.uu("1gbrmor", (long)OCSPClient.uu("-6f8976"));
        Extension ext = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, true, (ASN1OctetString)new DEROctetString((byte[])OCSPClient.uu("-th2974", nonce)));
        OCSPClient.uu("8qpmot", gen, new Extensions(ext));
        return OCSPClient.uu("-1bnk972", gen);
    }

    public static boolean checkRevocation(X509Certificate userCert, X509Certificate caCert) throws CertificateEncodingException, OperatorCreationException, OCSPException, IOException, CertVerificationException {
        return OCSPClient.checkRevocation(userCert, caCert, false);
    }

    public static boolean checkRevocation(X509Certificate userCert, X509Certificate caCert, boolean checkResponseSignature) throws CertificateEncodingException, OperatorCreationException, OCSPException, IOException, CertVerificationException {
        char[] cArray = "\u2d86\uf101\u5537\ud165\u1d30\ua47a\u41f0\uadfe\u23e5\u1aab\u22ab\u7f3c\uc790\u94bf\u9404\u0fd8\u5dcb".toCharArray();
        cArray[10] = (char)(cArray[10] ^ 0x31C8);
        logger.info(CRLClient$OCSPClient.i(cArray, (short)26062, false, false));
        OCSPReq request = OCSPClient.generateOCSPRequest(caCert, (BigInteger)OCSPClient.uu("-1plm971", userCert));
        byte[] array = (byte[])OCSPClient.uu("fvnmp0", request);
        String serviceAddr = OCSPClient.getAuthorityInformationAccessOcspUrl(userCert);
        try {
            if (serviceAddr != null) {
                char[] cArray2 = "\u7c91\u1550\u0317\ub0ce\u790e".toCharArray();
                cArray2[3] = (char)(cArray2[3] ^ 0x590A);
                if (OCSPClient.uu("1mfjmnn", serviceAddr, CRLClient$OCSPClient.i(cArray2, (short)25531, false, false)) != false) {
                    char[] cArray3 = "\uc03b\u8d6b\uadf9\ua24b\ub337\u01c4\ud2bf\u8fe2\u206a\u5be8\uce08\u3cc9\ub8d1\u54d1\u6780\ub3bd\u3b83\ufae2\u6403\uad74\uddf3\ufb9b\u1031\u09c6\u6952\u9fd5\u4fab".toCharArray();
                    cArray3[16] = (char)(cArray3[16] ^ 0x4E89);
                    logger.info((String)OCSPClient.uu("hapme6", OCSPClient.uu("fn9me5", OCSPClient.uu("fn9me5", new StringBuilder(), CRLClient$OCSPClient.i(cArray3, (short)25940, false, false)), serviceAddr)));
                    URL url = new URL(serviceAddr);
                    HttpURLConnection con = (HttpURLConnection)OCSPClient.uu("1os5mp1", url);
                    char[] cArray4 = "\u730a\ubb5e\u28e8\u6726\uf890\uc9ed\u37a3\uafb7\u6841\u74fe\uce68\ue82a\u2ca9".toCharArray();
                    cArray4[9] = (char)(cArray4[9] ^ 0xD57);
                    char[] cArray5 = "\ucd28\u48ba\u6e1a\uc1b7\u8c45\u12c0\uca2f\ub331\u33fa\ud6fc\u7e8b\ude1b\u6158\uc568\u0a21\u18d8\uf2eb\u0396\u397b\ufafc\ucd2a\u2e4f\ufab4\ufaa9\u3ca6".toCharArray();
                    cArray5[4] = (char)(cArray5[4] ^ 0x593C);
                    OCSPClient.uu("s6dmoi", con, CRLClient$OCSPClient.i(cArray4, (short)11069, false, true), (Object)CRLClient$OCSPClient.i(cArray5, (short)19386, false, true));
                    char[] cArray6 = "\u3a6d\ucef2\ud3eb\ua7c6\u68f4\u279b\u24db".toCharArray();
                    cArray6[4] = (char)(cArray6[4] ^ 0x2FA7);
                    char[] cArray7 = "\u1c46\uc83a\u8502\uc19c\ub6c0\u421d\u5e7f\ufc1c\ud4ed\u910e\u86e5\u05d6\u6a70\u9ebb\ufc83\u3589\u8ffe\ub713\u130b\u4f03\u24b5\u28c4\ud76c\uad62\ue718\u278e".toCharArray();
                    cArray7[10] = (char)(cArray7[10] ^ 0x214);
                    OCSPClient.uu("s6dmoi", con, CRLClient$OCSPClient.i(cArray6, (short)5129, true, true), (Object)CRLClient$OCSPClient.i(cArray7, (short)29874, true, false));
                    OCSPClient.uu("manmoj", con, true);
                    Object out = OCSPClient.uu("1cmlmok", con);
                    DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream((OutputStream)out));
                    OCSPClient.uu("-jt697b", dataOut, array);
                    OCSPClient.uu("-101c97a", dataOut);
                    OCSPClient.uu("-cps979", dataOut);
                    if (OCSPClient.uu("1msjmoo", con) / 100 != 2) {
                        char[] cArray8 = "\u0455\u7635\uc0e1\ue13f\u2fdf\u5ab3\u6971\u93f9\ube01\u905e\u736c\u730c\u30ad\u2c75\u918e\ue468\u571b\uec23\ua29c\uf962\u7c03\u0a85\ub767\u83c7\u6ef1\u3cd9\u1794\u21c1".toCharArray();
                        cArray8[10] = (char)(cArray8[10] ^ 0x54A6);
                        logger.error((String)OCSPClient.uu("hapme6", OCSPClient.uu("813mle", OCSPClient.uu("fn9me5", new StringBuilder(), CRLClient$OCSPClient.i(cArray8, (short)32642, false, true)), (int)OCSPClient.uu("1msjmoo", con))));
                        char[] cArray9 = "\ua768\ud228\u4d0f\u7542\u119e\u143e\ua022\ua42c\ub19c\u1bdb\ud66a\u83ee\u9760\u4f7b\ucc72\ub315\u77e6\u9734\u8637\u77c2\uf878\ua8d8\uae5d\ub458\u8414\u8e84\u8468\u3fcd\u614f\u6168\u9d1c\uc24b\u7b42".toCharArray();
                        cArray9[2] = (char)(cArray9[2] ^ 0x190D);
                        throw new Exception((String)OCSPClient.uu("hapme6", OCSPClient.uu("813mle", OCSPClient.uu("fn9me5", new StringBuilder(), CRLClient$OCSPClient.i(cArray9, (short)2213, true, false)), (int)OCSPClient.uu("1msjmoo", con))));
                    }
                    char[] cArray10 = "\u62b9\u3731\u309e\u8369\ua581\uc6bb\ub3c8\u8bc6\u8c07\uc2b8\uaf25\ub116\ub489\ue957\u1b50\uaa37\uf980\u1950\uee50\uc661\u2e0d\ufab7\u6ee1\u318f\u83b0\ua5d6\ub8eb\u5b19".toCharArray();
                    cArray10[6] = (char)(cArray10[6] ^ 0x2BC8);
                    logger.info(CRLClient$OCSPClient.i(cArray10, (short)16482, true, true));
                    char[] cArray11 = "\u913d\u9562\u1f64\uc4d5\u3ef5\ube07\ufa8b\u7de5\udebc\u230e".toCharArray();
                    cArray11[4] = (char)(cArray11[4] ^ 0x3886);
                    logger.info(CRLClient$OCSPClient.i(cArray11, (short)9863, false, false));
                    InputStream in = (InputStream)OCSPClient.uu("-1c7s977", con);
                    OCSPResp ocspResponse = new OCSPResp(in);
                    switch (OCSPClient.uu("h91mpa", ocspResponse)) {
                        case 0: {
                            char[] cArray12 = "\ua906\ub6e9\u3f6f\ue5be\u141e\udc3f\ub9a7\u535f".toCharArray();
                            cArray12[3] = (char)(cArray12[3] ^ 0x5139);
                            logger.info(CRLClient$OCSPClient.i(cArray12, (short)2220, false, true));
                            BasicOCSPResp or = (BasicOCSPResp)OCSPClient.uu("-19kq96l", ocspResponse);
                            if (checkResponseSignature) {
                                OCSPClient.validateOCSPResponseSignature(caCert, or);
                            }
                            if (((SingleResp[])OCSPClient.uu("-4ng96k", or)).length == 1) {
                                SingleResp resp = ((SingleResp[])OCSPClient.uu("-4ng96k", or))[0];
                                OCSPClient.validateNonce(request, or);
                                OCSPClient.validateCertificateId(caCert, userCert, (CertificateID)OCSPClient.uu("hdfmpd", resp));
                                Object certificateStatus = OCSPClient.uu("-16ti98i", resp);
                                if (certificateStatus == CertificateStatus.GOOD) {
                                    char[] cArray13 = "\u8c7a\u5889\ud9aa\u4cf0#\u0f56\u3ece\ua3d3\u8660\u6a30\u43e5\uaa98\u0b9f\u8a01\u25c6\u7528\u5c0f\u0f43\ua83d\ubd25\u4b70\ub51c\u77d5\u7797\u74c9\u68cd\u1607\ua5ec\u0b77\u4b5a\uc5ad\u8c9c\u69b9\u5f17\ue8a5\u7e83\uc990\ue441\u618f\ubfba\u1b21".toCharArray();
                                    cArray13[20] = (char)(cArray13[20] ^ 0x1D51);
                                    logger.info(CRLClient$OCSPClient.i(cArray13, (short)5596, false, false));
                                    return true;
                                }
                                char[] cArray14 = "\u2fbb\u8fc6\ub924\u6b2b\u7b43\uc34f\ue53a\u2df7\ub0e1\u3253\u28e9\u558d\ubfd9\u80aa\u3a9b\u4da7\u9c93\u163d\u22e4\uab9f\u8a77\u743c\u3a3e\uee6f\u27d8\u7acb\uc2ca\ue18b\u1eeb\u6f20\u9987\u043a\u1e52\u4641\uc86f\u5c6e\uff08\u8ed6\u0215\u542d\u7a70".toCharArray();
                                cArray14[9] = (char)(cArray14[9] ^ 0xFA2);
                                logger.error(CRLClient$OCSPClient.i(cArray14, (short)17056, true, true));
                                return false;
                            }
                        }
                        case 1: {
                            char[] cArray15 = "\u382b\u26d3\ub7af\u4fa0\u7efc\u5f5d\u9b23\u0bd6\u50f4\u490d\uf7d5\u798c\ue42f\u64e3\u26a3\ud81a\ueb94\u1e3b".toCharArray();
                            cArray15[16] = (char)(cArray15[16] ^ 0x40FB);
                            logger.error(CRLClient$OCSPClient.i(cArray15, (short)1125, false, true));
                            char[] cArray16 = "\u1d0c\u98ec\ub849\u9a84\u8fef\u0137\u2f2b\u882c\u0426\u448e\u1188\u4b15\u92fc\u86e7\ub502\ubffc\ua33f\u09b5".toCharArray();
                            cArray16[6] = (char)(cArray16[6] ^ 0x7E1B);
                            throw new CertVerificationException(CRLClient$OCSPClient.i(cArray16, (short)5736, false, false));
                        }
                        case 2: {
                            char[] cArray17 = "\u5949\u9e3a\uf6df\udcb3\u163c\u2bda\u4d26\u0af5\u4425\ubc4f\u3ce0\ub4db\udd3e\ufd93\u110b".toCharArray();
                            cArray17[13] = (char)(cArray17[13] ^ 0x6E3F);
                            logger.error(CRLClient$OCSPClient.i(cArray17, (short)4839, false, false));
                            char[] cArray18 = "\u5a62\u1e49\udd4f\u0b1f\uaee5\u55c8\u05c3\u62e7\ube5b\u4921\ucec4\u10ed\uec2d\ue860\u339d".toCharArray();
                            cArray18[5] = (char)(cArray18[5] ^ 0x5E66);
                            throw new CertVerificationException(CRLClient$OCSPClient.i(cArray18, (short)26952, true, true));
                        }
                        case 3: {
                            char[] cArray19 = "\u085b\u980e\u8f3e\ueb39\ua4ce\u56d3\uad30\uced3\u19a8\u218c".toCharArray();
                            cArray19[3] = (char)(cArray19[3] ^ 0x56A1);
                            logger.error(CRLClient$OCSPClient.i(cArray19, (short)8777, false, true));
                            char[] cArray20 = "\ufcd0\u1968\uafad\u4f15\u0b54\ueda2\u2179\u2ff3\u4af3\u3217".toCharArray();
                            cArray20[5] = (char)(cArray20[5] ^ 0x48A1);
                            throw new CertVerificationException(CRLClient$OCSPClient.i(cArray20, (short)2791, true, false));
                        }
                        case 5: {
                            char[] cArray21 = "\ub7ec\u2312\u9ff4\ub1b7\u9d91\u3026\u2e2f\u6afe\u30de\u9226\uaa34\u19ca\u2b44".toCharArray();
                            cArray21[5] = (char)(cArray21[5] ^ 0x1887);
                            logger.error(CRLClient$OCSPClient.i(cArray21, (short)25913, true, false));
                            char[] cArray22 = "\u7281\u8fa0\u32d1\ua587\u819a\uda19\u0f20\u95c9\u91e1\u7b8f\u6fc4\ue2c3\u1dec".toCharArray();
                            cArray22[0] = (char)(cArray22[0] ^ 0x372A);
                            throw new CertVerificationException(CRLClient$OCSPClient.i(cArray22, (short)18910, false, true));
                        }
                        case 6: {
                            char[] cArray23 = "\u8ff6\u1a32\u4935\u8de9\u311d\u1ffc\u6ed9\u12f9\uc426\u99b0\ue361\u1eea\u721b".toCharArray();
                            cArray23[1] = (char)(cArray23[1] ^ 0x4963);
                            logger.error(CRLClient$OCSPClient.i(cArray23, (short)16251, true, true));
                            char[] cArray24 = "\ueba9\u7a26\u0929\uab0c\ua439\u7960\u4580\ud326\ua197\u1387\ub9cf\u83ef\u2859".toCharArray();
                            cArray24[1] = (char)(cArray24[1] ^ 0x1D62);
                            throw new CertVerificationException(CRLClient$OCSPClient.i(cArray24, (short)25451, true, true));
                        }
                    }
                    char[] cArray25 = "\u7d92\ub3d2\u67fe\u5d93\u3679\u860e\u5f47".toCharArray();
                    cArray25[5] = (char)(cArray25[5] ^ 0x4B05);
                    logger.error(CRLClient$OCSPClient.i(cArray25, (short)21012, false, false));
                    char[] cArray26 = "\u1589\u98ef\ua157\uae31\u5c67\u25e9\u2252".toCharArray();
                    cArray26[0] = (char)(cArray26[0] ^ 0x2B15);
                    throw new CertVerificationException(CRLClient$OCSPClient.i(cArray26, (short)18624, false, false));
                }
            }
            char[] cArray27 = "\u20c5\uf7fd\ue07e\u7f3d\ub287\u9bd7\u803f\u5967\uefa8\u20f6\u8f27\ud149\u5582\u711f\ue4b2\uf439\u0bd9\u0e4d\u4bb4".toCharArray();
            cArray27[2] = (char)(cArray27[2] ^ 0x1DE1);
            logger.error(CRLClient$OCSPClient.i(cArray27, (short)27200, false, true));
            char[] cArray28 = "\u3185\u0a4d\ua5bb\udc38\u7ff2\ua577\u8e1e\u139a\u9b20\ua23b\u5952\u9815\ud309\ueeeb\u06fd\u4535\u3695\u439e\u05dc".toCharArray();
            cArray28[17] = (char)(cArray28[17] ^ 0x1410);
            throw new CertVerificationException(CRLClient$OCSPClient.i(cArray28, (short)17607, true, true));
        }
        catch (Exception ex) {
            logger.error((String)OCSPClient.uu("1k2pmmt", ex), (Throwable)ex);
            throw new CertVerificationException((String)OCSPClient.uu("1k2pmmt", ex), ex);
        }
    }

    public static String getAuthorityInformationAccessOcspUrl(X509Certificate cert) throws CertVerificationException {
        char[] cArray = "\uccbd\u1fde\u9fef\u5ee7\u2d12\ufece\uec86\u2da6\u6a1f\u326a\u36e5\u2dd6\ud4a6\u20d7\u43ea\uea3b\u946c\u5a59".toCharArray();
        cArray[11] = (char)(cArray[11] ^ 0x4B77);
        logger.info(OCSPClient$OCSPClient.q(cArray, (short)27160, (short)5, (short)2));
        try {
            ASN1Primitive obj = OCSPClient.getExtensionValue(cert, (String)OCSPClient.uu("-tas987", Extension.authorityInfoAccess));
            if (obj == null) {
                return null;
            }
            ASN1Sequence AccessDescriptions = (ASN1Sequence)obj;
            for (int i = 0; i < OCSPClient.uu("10rdmnf", AccessDescriptions); ++i) {
                ASN1Sequence AccessDescription = (ASN1Sequence)OCSPClient.uu("-3fk98g", AccessDescriptions, i);
                if (OCSPClient.uu("10rdmnf", AccessDescription) != 2 || !(OCSPClient.uu("-3fk98g", AccessDescription, 0) instanceof ASN1ObjectIdentifier)) continue;
                ASN1ObjectIdentifier id = (ASN1ObjectIdentifier)OCSPClient.uu("-3fk98g", AccessDescription, 0);
                char[] cArray2 = "\u1d07\u11cd\u8c8a\u15b2\u041f\u741e\ud94a\u08a5\ufe94\u6559\ua0b8\uc071\u3c48\u952f\ue35e\ud576\u4351\u627e\u24b1".toCharArray();
                cArray2[5] = (char)(cArray2[5] ^ 0x7A4);
                if (OCSPClient.uu("-1nps98l", OCSPClient$OCSPClient.q(cArray2, (short)14772, (short)0, (short)1), OCSPClient.uu("-tas987", id)) == false) continue;
                ASN1Primitive description = (ASN1Primitive)OCSPClient.uu("-3fk98g", AccessDescription, 1);
                String accessLocation = OCSPClient.getStringFromGeneralName(description);
                if (accessLocation == null) {
                    return null;
                }
                char[] cArray3 = "\uf234\ube8e\u5fd5\u9788\u43bf\u7f25\u3cb1\u5516\u2ba5\u03dd\u6aeb".toCharArray();
                cArray3[0] = (char)(cArray3[0] ^ 0x5610);
                logger.info((String)OCSPClient.uu("hapme6", OCSPClient.uu("fn9me5", OCSPClient.uu("fn9me5", new StringBuilder(), OCSPClient$OCSPClient.q(cArray3, (short)1088, (short)0, (short)2)), accessLocation)));
                return accessLocation;
            }
        }
        catch (Exception e) {
            char[] cArray4 = "\u4358\uae5a\ufe8b\ud1d7\ub095\u4ddf\u2424\ud20d\u684a\ud6a1\ua78e\ufa28\u338d\u6aae\ue4f6\u72e9\u1971\uc113\u5486".toCharArray();
            cArray4[0] = (char)(cArray4[0] ^ 0x1225);
            logger.error(OCSPClient$OCSPClient.q(cArray4, (short)4700, (short)2, (short)3));
            throw new CertVerificationException(e);
        }
        return null;
    }

    private static String getStringFromGeneralName(ASN1Primitive names) throws IOException {
        ASN1TaggedObject taggedObject = (ASN1TaggedObject)names;
        char[] cArray = "\u308c\u11d7\u3e86\ub532\ub564\u094e\u9da8\u9a14\ub78c\u927b\u23d8".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x4BD1);
        return new String((byte[])OCSPClient.uu("-13f496u", OCSPClient.uu("1mljmnh", taggedObject, false)), OCSPClient$CRLClient.Z(cArray, (short)28129, false, false));
    }

    protected static ASN1Primitive getExtensionValue(X509Certificate cert, String oid) throws IOException {
        byte[] bytes = (byte[])OCSPClient.uu("-1ldq97m", cert, oid);
        if (bytes == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(bytes));
        ASN1OctetString octs = (ASN1OctetString)OCSPClient.uu("1d6vmob", aIn);
        aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])OCSPClient.uu("-13f496u", octs)));
        return OCSPClient.uu("1d6vmob", aIn);
    }

    private static void validateCertificateId(X509Certificate issuerCert, X509Certificate eeCert, CertificateID certificateId) throws CertificateEncodingException, OperatorCreationException, OCSPException, CertVerificationException {
        char[] cArray = "\u8b65\u0615\u3fa5\u1a13\u4528\uea43\u28aa\ue192\u1f07\u852e\u1e8b\u2717\ua794\uf906\ub025\ua7eb\uc3fc\u72b7\u3403\u1db5\u30d5\u9270\u4490\ub5cd\u118e\u36b8\u5c80".toCharArray();
        cArray[24] = (char)(cArray[24] ^ 0x7D38);
        logger.info(OCSPClient$CRLClient.Z(cArray, (short)21338, true, true));
        CertificateID expectedId = new CertificateID(OCSPClient.uu("-1lr897o", new JcaDigestCalculatorProviderBuilder()).get(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE)), (X509CertificateHolder)new JcaX509CertificateHolder(issuerCert), (BigInteger)OCSPClient.uu("-1plm971", eeCert));
        if (OCSPClient.uu("-1klk96s", OCSPClient.uu("-8l696t", expectedId), OCSPClient.uu("-8l696t", certificateId)) == false) {
            char[] cArray2 = "\ua556\u3faa\u8d99\u91d4\ud8af\u4364\u8637\uabb6\udffd\uc3aa\ub3f1\ub819\u7564\u2e4f\uad9f\u432c\u9025\u29a1\u3d52\u6bfe\udb2a\u9bab\u22cb\u05c3\u7232\u4018\u95d2\ub351\u3e25\ub26c\u3571\u92c9\ufc3c\ue0f3\u07fa".toCharArray();
            cArray2[11] = (char)(cArray2[11] ^ 0x4D2B);
            throw new CertVerificationException(OCSPClient$CRLClient.Z(cArray2, (short)29047, true, true));
        }
        if (OCSPClient.uu("-dji96q", (byte[])OCSPClient.uu("1uq5mp5", expectedId), (byte[])OCSPClient.uu("1uq5mp5", certificateId)) == false) {
            char[] cArray3 = "\u812f\ue918\uc9bf\uc003\u6dec\uf91d\u0167\u4365\u87fe\ue8ee\u333d\uaf93\u108c\uc489\ua95e\u768b\ubdea\u56f4\u9004\u6738\ua0dc\ub676\u1142\u4cc3\u1377\ue6ac\u2fda\u3f30\uc3a0\u3222\u7c03\ue044\u1e2d\u1aec\u3fd0\u6bea\u3f0c\u0f3c\u42b3".toCharArray();
            cArray3[28] = (char)(cArray3[28] ^ 0x18D9);
            throw new CertVerificationException(OCSPClient$CRLClient.Z(cArray3, (short)19577, true, false));
        }
        char[] cArray4 = "\ua94e\u3697\u7150\udd5a\ue193\ua774\uda60\u8168\u3d2f\u828e\u7fe0\udeb5\uc87a\u9b5f\u07b5\u0c7b\ub97e\uc603\u9682\u000e\u98e6\u4b84\uc8c6\u9ef2\u7e91\ub33b\uf20a\u1544\u14d6\u1aeb\u0ba5\u087d\u36a5\u517b\u727b\u3a90\uc07d\u4686".toCharArray();
        cArray4[8] = (char)(cArray4[8] ^ 0x6D5A);
        logger.info(OCSPClient$CRLClient.Z(cArray4, (short)18847, false, false));
    }

    private static void validateNonce(OCSPReq request, BasicOCSPResp basicOcspResp) throws IOException, CertVerificationException {
        byte[] respNonce;
        byte[] reqNonce = (byte[])OCSPClient.uu("6dbmp8", OCSPClient.uu("-qs096p", request, OCSPObjectIdentifiers.id_pkix_ocsp_nonce));
        if (OCSPClient.uu("14dtmpq", reqNonce, respNonce = (byte[])OCSPClient.uu("6dbmp8", OCSPClient.uu("qetmp9", basicOcspResp, OCSPObjectIdentifiers.id_pkix_ocsp_nonce))) == false) {
            char[] cArray = "\uf15e\ua3bd\u1d0f\u023e\u896d\u6442\u7e60\ud92f\ua84e\uafe9\u7786\u492c\u8438\ub316\u58b1\u94b9\u09e6\ub2f3\u63e8\ud02f\u21ba\ue9ea\uffc5\u4ad5\u6a6a\u2767".toCharArray();
            cArray[19] = (char)(cArray[19] ^ 0x4BF6);
            throw new CertVerificationException(OCSPClient$OCSPClient.q(cArray, (short)25030, (short)4, (short)0));
        }
    }

    private static void validateOCSPResponseSignature(X509Certificate issuerCert, BasicOCSPResp basicResp) throws OperatorCreationException, OCSPException, CertVerificationException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        char[] cArray = "\u4018\u9fb4\u6c7e".toCharArray();
        cArray[1] = (char)(cArray[1] ^ 0x2D23);
        Object contentVerifierProvider = OCSPClient.uu("nohmps", OCSPClient.uu("-1ka8965", new JcaContentVerifierProviderBuilder(), OCSPClient$OCSPClient.q(cArray, (short)10940, (short)0, (short)1)), OCSPClient.uu("-1ii098k", issuerCert));
        if (OCSPClient.uu("-1alu963", basicResp, contentVerifierProvider) != false) {
            char[] cArray2 = "\u3479\u8f97\u6131\u3649\u108f\u45c9\u4780\u99b5\ud6ba\u0877\u2e92\u5817\udab7\ucf60\u63c9\ub1f3\u5214\u5596\uc817\u9137\u3260\u854a\udd9d\u57c8\u7654\ua199\u2af7\u9cb7\u8d48\ufed0\u215a\uaa7a\u8f91\u4307\u7631\u0d95\u6008\u7d90\u78ed\ua425\uf0ba\u1709\u6f5a".toCharArray();
            cArray2[37] = (char)(cArray2[37] ^ 0x300);
            logger.info(OCSPClient$OCSPClient.q(cArray2, (short)30917, (short)2, (short)5));
            return;
        }
        X509CertificateHolder[] respCerts = (X509CertificateHolder[])OCSPClient.uu("-1278962", basicResp);
        if (respCerts == null || respCerts.length == 0) {
            char[] cArray3 = "\u3ff1\u06c5\u6790\uf580\uc686\uc652\u3dd1\udc92\ua6b1\uf99e\u32fb\ue6f7\ufedf\uc630\ue6e9\u5ad4\u67dd\ud82a\u885b\ubd10\u0d00\ua682\u1437\u0c83\uefda\u68d6\ua119\u9222\ub716\u93b2\ueafe\u7aed".toCharArray();
            cArray3[10] = (char)(cArray3[10] ^ 0x3434);
            logger.info(OCSPClient$OCSPClient.q(cArray3, (short)29020, (short)5, (short)1));
            char[] cArray4 = "\ubfa8\ubf1e\u0229\u9ad3\ueb83\ue84c\u2e62\u122b\u5562\u8df7\ucb68\ua71a\u7b42\u6887\u1a4d\u63bd\uf1bf\ubfef\u816e\uc4e9\u218b\u215c\uaa12\u501c\u969e\u4f7f\uf90a\u5525\uff96\u979b\uecf9\u4f33".toCharArray();
            cArray4[20] = (char)(cArray4[20] ^ 0x6A42);
            throw new CertVerificationException(OCSPClient$OCSPClient.q(cArray4, (short)3718, (short)2, (short)4));
        }
        boolean authorizedResponder = false;
        for (X509CertificateHolder respCert : respCerts) {
            X509Certificate x509RespCert = OCSPClient.getX509Certificate(respCert);
            Object listExtendedKeyUsage = OCSPClient.uu("1ortmpv", x509RespCert);
            if (listExtendedKeyUsage == null) continue;
            boolean bIdKpOCSPSigning = false;
            Iterator iterator = listExtendedKeyUsage.iterator();
            while (iterator.hasNext()) {
                String extKeyUsage = (String)iterator.next();
                if (OCSPClient.uu("-1nps98l", extKeyUsage, OCSPClient.uu("-nno960", KeyPurposeId.id_kp_OCSPSigning)) == false) continue;
                bIdKpOCSPSigning = true;
                break;
            }
            if (!bIdKpOCSPSigning) continue;
            try {
                OCSPClient.uu("1fffmnd", x509RespCert, OCSPClient.uu("-1ii098k", issuerCert));
            }
            catch (SignatureException sgnExcp) {
                continue;
            }
            catch (InvalidKeyException ikExcp) {
                continue;
            }
            char[] cArray5 = "\ubda8\u9825\u2f4b".toCharArray();
            cArray5[1] = (char)(cArray5[1] ^ 0x196E);
            contentVerifierProvider = OCSPClient.uu("nohmps", OCSPClient.uu("-1ka8965", new JcaContentVerifierProviderBuilder(), OCSPClient$OCSPClient.q(cArray5, (short)12175, (short)5, (short)1)), OCSPClient.uu("-1ii098k", x509RespCert));
            if (OCSPClient.uu("-1alu963", basicResp, contentVerifierProvider) == false) continue;
            char[] cArray6 = "\u20de\u7ad2\uffd6\u2159\u137e\u4874\ue7d2\udd5d\u7799\u25bf\ub320\u72d3\u143d\u0f87\ub876\u7464\ua471\uc918\u4555\u6508\u8466\u67b2\u15bb\u00fc\u083a".toCharArray();
            cArray6[1] = (char)(cArray6[1] ^ 0x328D);
            logger.info((String)OCSPClient.uu("hapme6", OCSPClient.uu("fn9me5", OCSPClient.uu("fn9me5", new StringBuilder(), OCSPClient$OCSPClient.q(cArray6, (short)17, (short)3, (short)5)), OCSPClient.uu("75hmpi", OCSPClient.uu("-106m95v", respCert)))));
            authorizedResponder = true;
            break;
        }
        if (!authorizedResponder) {
            char[] cArray7 = "\uafe5\u4ff4\u72c1\ua7ea\ueba7\u820c\u7495\u5996\u4723\u0852\u8573\u3370\u9783\u861d\u4b03\ua495\ufed0\u91f0\uebe9\u8599\u621e\u93a6\u503a\uc1c5\ub34f\u38e4\u2d20\uc72d\uf2b6\u60bb\u595f\u69e4".toCharArray();
            cArray7[19] = (char)(cArray7[19] ^ 0x7ED9);
            throw new CertVerificationException(OCSPClient$OCSPClient.q(cArray7, (short)10218, (short)2, (short)2));
        }
    }

    private static X509Certificate getX509Certificate(X509CertificateHolder x509CertteHolder) throws CertificateException, IOException {
        char[] cArray = "\ue25e\u9541\ub982\ue679\uf465\u2be5".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x78E4);
        Object cf = OCSPClient.uu("-5oa99a", CRLClient$OCSPClient.i(cArray, (short)7932, true, true));
        return (X509Certificate)OCSPClient.uu("-i52999", cf, new ByteArrayInputStream((byte[])OCSPClient.uu("-6t496d", x509CertteHolder)));
    }

    private static Object uu(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(auchrzch.h(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

