/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.logging;

import it.actalis.ellips.capi.logging.FileAppender;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class StreamFileAppender
extends FileAppender {
    protected FileOutputStream logOutPutStream;
    protected FileOutputStream lockFile;
    protected FileLock lockAppender;

    public StreamFileAppender(String logFilePath) throws FileNotFoundException, IOException {
        super(logFilePath);
        File file = new File(logFilePath);
        this.logOutPutStream = new FileOutputStream(file, true);
        String tempPath = System.getProperty("java.io.tmpdir");
        File lockFileName = new File(tempPath + File.separator + file.getName() + ".lck");
        lockFileName.deleteOnExit();
        this.lockFile = new FileOutputStream(lockFileName, true);
        this.lockAppender = null;
        this.nReferences = 1;
    }

    @Override
    public synchronized void release() throws IOException {
        if (this.nReferences > 0) {
            --this.nReferences;
        }
        if (this.nReferences == 0) {
            this.unlock();
            this.logOutPutStream.close();
            this.lockFile.close();
            new File(this.appenderPath + ".lck").delete();
            this.appenderPath = "";
        }
    }

    @Override
    synchronized void writeData(byte[] data) throws IOException {
        this.logOutPutStream.write(data);
    }

    @Override
    public synchronized void addReference() {
        ++this.nReferences;
    }

    @Override
    public int getReferences() {
        return this.nReferences;
    }

    @Override
    protected synchronized void lock() throws IOException {
        if (this.isLocked()) {
            return;
        }
        this.lockAppender = this.lockFile.getChannel().tryLock();
        if (this.lockAppender == null) {
            System.err.println("Appender resource file not available for " + this.appenderPath);
            throw new IOException("Appender resource file not available for " + this.appenderPath);
        }
    }

    @Override
    protected synchronized void unlock() throws IOException {
        if (!this.isLocked()) {
            return;
        }
        try {
            this.lockAppender.release();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            throw new IOException("Appender resource cannot be released! " + ex.getMessage(), ex);
        }
    }

    @Override
    public synchronized boolean isLocked() {
        return this.lockAppender != null && this.lockAppender.isValid();
    }

    @Override
    public synchronized void backup(String backupFilePath, String backupFileExtension, int baseIndex, boolean compress) throws IOException {
        if (!this.isLocked()) {
            boolean fileCreated = false;
            File backupFile = null;
            try {
                this.lock();
                File fappender = new File(this.appenderPath);
                if (fappender.length() > 0L) {
                    if (baseIndex >= 0) {
                        backupFile = new File(backupFilePath + "-" + baseIndex + backupFileExtension);
                        while (!backupFile.createNewFile()) {
                            backupFile = new File(backupFilePath + "-" + ++baseIndex + backupFileExtension);
                        }
                        ++baseIndex;
                    } else {
                        backupFile = new File(backupFilePath + backupFileExtension);
                        if (backupFile.exists()) {
                            return;
                        }
                        if (!backupFile.createNewFile()) {
                            throw new IOException("Unable to create backup file: " + backupFilePath + backupFileExtension);
                        }
                    }
                    fileCreated = true;
                    if (compress) {
                        this.zipFile(backupFile);
                    } else {
                        this.copyFile(backupFile);
                    }
                    this.logOutPutStream.getChannel().truncate(0L);
                }
            }
            catch (Throwable t) {
                if (fileCreated) {
                    backupFile.delete();
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new IOException("Unable to backup file: " + t.getMessage(), t);
            }
            finally {
                if (this.isLocked()) {
                    this.unlock();
                }
            }
        }
    }

    private boolean zipFile(File fileZipPath) throws IOException {
        if (fileZipPath == null) {
            return false;
        }
        if (this.logOutPutStream == null) {
            return false;
        }
        FileInputStream input = null;
        String entryName = new File(this.appenderPath).getName();
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            input = new FileInputStream(this.appenderPath);
            fos = new FileOutputStream(fileZipPath);
            zos = new ZipOutputStream(fos);
            zos.putNextEntry(new ZipEntry(entryName));
            this.copy(input, zos);
            zos.closeEntry();
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage());
            throw new IOException("Unable to compress the backup: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            throw new IOException("Unable to compress the backup " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (zos != null) {
                    zos.close();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
            try {
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
        return true;
    }

    private boolean copyFile(File backupFilePath) throws IOException {
        if (backupFilePath == null) {
            return false;
        }
        if (this.logOutPutStream == null) {
            return false;
        }
        FileInputStream input = null;
        FileOutputStream fos = null;
        try {
            input = new FileInputStream(this.appenderPath);
            fos = new FileOutputStream(backupFilePath);
            this.copy(input, fos);
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage());
            throw new IOException("Unable copy into backup: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            throw new IOException("Unable copy into backup: " + ex.getMessage(), ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
            try {
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
        return true;
    }

    private long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[64000];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }
}

