/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.vol.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfigFile {
    protected static final String FALSE = "false";
    protected static final String TRUE = "true";
    protected static final String DEF_DATE_FORMAT = "dd/MM/yyyy HH:mm:ss zzz";
    protected static final String EQ_SEP = "=";
    protected static final String LINK_INDICATOR = "@";
    protected Properties configdb = null;
    protected String fullPath = null;

    public ConfigFile(String string) {
        if (string != null) {
            this.fullPath = new File(string).getAbsolutePath();
        }
        this.configdb = new Properties();
    }

    public ConfigFile(ConfigFile configFile, String string) {
        if (string != null) {
            this.fullPath = new File(string).getAbsolutePath();
        }
        this.configdb = new Properties(configFile.configdb);
    }

    public void loadConfigFile() throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.fullPath);
            this.configdb.load(fileInputStream);
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
    }

    public String getElement(String string) {
        return this.getElement(string, null);
    }

    public String getElement(String string, String string2) {
        if ((string = this.configdb.getProperty(string, string2)) != null && (string = string.trim()).startsWith(LINK_INDICATOR)) {
            string = string.substring(1);
            string = this.getElement(string, string2);
        }
        return string;
    }

    public int getIntElement(String string, int n) {
        try {
            return Integer.parseInt(this.getElement(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    public boolean getBinElement(String string, boolean bl) {
        if ((string = this.getElement(string)) == null) {
            return bl;
        }
        return TRUE.equals(string = string.toLowerCase());
    }

    public String[] getElements(String string, String string2, int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            stringArray[i] = this.getElement(string + n2, string2);
        }
        return stringArray;
    }

    public void setElement(String string, String string2) {
        if (string2 == null) {
            this.configdb.setProperty(string.trim(), null);
            return;
        }
        this.configdb.setProperty(string.trim(), string2.trim());
    }

    public void setBinElement(String string, boolean bl) {
        if (bl) {
            this.configdb.setProperty(string.trim(), TRUE);
            return;
        }
        this.configdb.setProperty(string.trim(), FALSE);
    }

    public boolean saveConfigFile() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fullPath, false);
            this.configdb.store(fileOutputStream, null);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        return false;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String string) {
        if (string != null) {
            this.fullPath = new File(string).getAbsolutePath();
        }
    }

    public Properties getConfigDB() {
        return this.configdb;
    }

    public static enum TAG {
        isTimeZoneUTC,
        timeZone;

    }
}

