/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.capi.provider.DummyExternalServerHelper;
import it.actalis.ellips.capi.provider.ExternalServerHelper;
import it.actalis.ellips.capi.provider.RemoteToken;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;

public class ExternalServerToken
extends RemoteToken {
    public static final String TOKEN_RS = "ExternServerToken";
    private ExternalServerHelper a = new DummyExternalServerHelper();

    @Override
    public void initializeLib(String[] stringArray) throws CapiException {
        ExternalServerToken externalServerToken = this;
        externalServerToken.initProviders(externalServerToken);
    }

    @Override
    public void initializeLib(String[] stringArray, boolean bl) throws CapiException {
        logger.debug("initializeLib() with tokenSoftSia parameter");
        this.initializeLib(stringArray);
    }

    @Override
    public String[] getLibInfo() {
        String string = "External Server Token";
        String string2 = "";
        String string3 = "Ellips Remote Signature Token";
        String string4 = "1.0";
        String string5 = "Actalis S.p.A.";
        String string6 = "";
        String string7 = "Actalis S.p.A.";
        String string8 = "";
        String string9 = "Actalis S.p.A.";
        return new String[]{string, string2, string3, string4, string5, string6, string7, string8, string9};
    }

    @Override
    public void openSession(boolean bl, String string) throws CapiException {
        this.a.openSession(bl, string);
    }

    @Override
    public void closeSession() throws CapiException {
        this.a.closeSession();
    }

    @Override
    public boolean isSessionOpen() throws CapiException {
        return this.a.isSessionOpen();
    }

    @Override
    public String getCert(String string) throws CapiException {
        return this.a.getCert(string);
    }

    @Override
    public void setCert(String string, byte[] byArray, int n, boolean bl) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    @Override
    public String installCertificate(Certificate certificate) throws CapiException {
        throw new CapiException("Remote Signature doesn't support install certificates into the token", 1004);
    }

    @Override
    public PublicKey getPublicKey(String string) throws CapiException {
        return this.a.getPublicKey(string);
    }

    @Override
    public PrivateKey getPrivateKey(String object) throws CapiException {
        Object object2 = this.getCert((String)object);
        if (object2 != null) {
            object2 = new Certificate(Base64.decode((String)object2));
            object = new Actalis_PrivateKey((String)object);
            ((Actalis_PrivateKey)object).setPublicInfo(((Certificate)object2).getInternalCert().getPublicKey());
            ((Actalis_PrivateKey)object).setCryptoDev(this);
            return object;
        }
        return null;
    }

    @Override
    public byte[] doSign(byte[] byArray, String string, int n) throws CapiException {
        return this.a.doSign(byArray, string, n);
    }

    @Override
    public byte[] doDecrypt(byte[] byArray, String string, int n) throws CapiException {
        throw new CapiException("Remote Signature doesn't support the Decrypt functionality", 1004);
    }

    @Override
    public String[] listObjects(String string, byte by) throws CapiException {
        return this.a.listObjects(string, by);
    }

    @Override
    public boolean exist(String string) throws CapiException {
        return this.a.exist(string);
    }

    public ExternalServerHelper getCurrentHelper() {
        return this.a;
    }

    public void setCurrentHelper(ExternalServerHelper externalServerHelper) {
        this.a = externalServerHelper;
    }

    @Override
    public CertificationRequest generatePKCS10CertificationRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) throws Exception {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        if (x500Name == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        try {
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), publicKey.getEncoded());
            publicKey = new CertificationRequestInfo(x500Name, subjectPublicKeyInfo, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't encode public key");
        }
        Signature signature = Signature.getInstance("SHA1withRSA", ActalisSingleton.getActalisProvider());
        signature.initSign(privateKey);
        try {
            signature.update(publicKey.getEncoded("DER"));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("exception encoding TBS cert request - " + exception);
        }
        x500Name = new CertificationRequestInfo(x500Name, subjectPublicKeyInfo, null);
        x500Name = new CertificationRequest((CertificationRequestInfo)x500Name, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE), new DERBitString(signature.sign()));
        return x500Name;
    }

    @Override
    public void initializeLib(TokenParameters tokenParameters) throws CapiException {
        ExternalServerToken externalServerToken = this;
        externalServerToken.initProviders(externalServerToken);
    }

    @Override
    public RecoverySessionCredential openSessionWithExtendedAuth(boolean bl, String string, ExtendedCredentials extendedCredentials) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, String string) throws CapiException {
        return this.certReq(x500Name, publicKey, privateKey, Security.getProvider(string));
    }

    @Override
    public String certReq(String string, X500Name x500Name) throws CapiException {
        return this.certReq(x500Name, this.getPublicKey(string), this.getPrivateKey(string), ProvUtils.actalisProvider);
    }

    @Override
    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int n, String string, GeneralNames[] generalNamesArray, String string2) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name object, PublicKey publicKey, PrivateKey privateKey, Provider provider) throws CapiException {
        try {
            logger.debug("creating and signing certreq...");
            logger.debug("subject: " + object.toString());
            try {
                object = new JcaPKCS10CertificationRequestBuilder(object, publicKey);
                object = object.build(new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider((Provider)ActalisSingleton.getActalisProvider()).build(privateKey));
            }
            catch (Exception exception) {
                object = exception;
                throw exception;
            }
            logger.debug("certRequest ok");
        }
        catch (IllegalStateException illegalStateException) {
            logger.debug(illegalStateException.getMessage(), (Throwable)illegalStateException);
            throw new CapiException("IllegalStateException", 1003);
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("NoSuchProviderException", 1003);
        }
        try {
            return Util.objectToPEMString(object);
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Exception saving PEM certificate Request", 1003);
        }
    }
}

