/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.vol.utils.Constants;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class Crypto {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String HASH_ALG_SHA1 = "SHA-1";
    public static final String HASH_ALG_MD2 = "MD2";
    public static final String HASH_ALG_MD5 = "MD5";
    public static final String HASH_ALG_RIPEMD128 = "RIPEMD128";
    public static final String HASH_ALG_RIPEMD160 = "RIPEMD160";
    public static final String HASH_ALG_SHA256 = Constants.SHA256;

    public Crypto() {
        a.debug("constructor OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sign(String object, byte[] byArray) throws CapiException {
        a.debug("sign using alias " + (String)object);
        if (byArray == null || object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        TokenSpi tokenSpi = Token.getTokenSpi((String)object);
        if (tokenSpi == null) {
            throw new CapiException("Token not initialized", 10003);
        }
        TokenSpi tokenSpi2 = tokenSpi;
        synchronized (tokenSpi2) {
            object = tokenSpi.getPrivateKey((String)object);
            return Crypto.a(byArray, (PrivateKey)object);
        }
    }

    public void verify(byte[] byArray, byte[] byArray2, byte[] object) throws CapiException {
        a.debug("verify");
        if (byArray == null || byArray2 == null || object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        Certificate certificate = new Certificate((byte[])object);
        object = certificate;
        object = certificate.getPublicKey();
        boolean bl = false;
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", ProvUtils.bcProvider);
            cipher.init(2, (Key)object);
            byArray2 = cipher.doFinal(byArray2);
            if (Util.equalsBlock(byArray2, byArray)) {
                bl = true;
            } else {
                a.debug("failed verify without errors:");
                a.debug("orig.hash: " + new String(Hex.encode((byte[])byArray)));
                a.debug("resulting: " + new String(Hex.encode((byte[])byArray2)));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("Internal error", 1003);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            a.debug(noSuchPaddingException.getMessage(), (Throwable)noSuchPaddingException);
            throw new CapiException("Internal error", 1003);
        }
        catch (BadPaddingException badPaddingException) {
            a.debug(badPaddingException.getMessage(), (Throwable)badPaddingException);
            throw new CapiException("Invalid signature", 3010);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            a.debug(illegalBlockSizeException.getMessage(), (Throwable)illegalBlockSizeException);
            throw new CapiException("Invalid signature", 3010);
        }
        catch (InvalidKeyException invalidKeyException) {
            a.debug(invalidKeyException.getMessage(), (Throwable)invalidKeyException);
            throw new CapiException("Invalid key format", 3000);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Invalid signature", 3010);
        }
        if (!bl) {
            throw new CapiException("Invalid signature", 3010);
        }
    }

    public byte[] hash(byte[] byArray, String string) throws CapiException {
        a.debug("hash (byte[])");
        if (byArray == null || string == null) {
            throw new CapiException("null params", 1001);
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string.toUpperCase(), ProvUtils.bcProvider);
            a.debug("hash getInstance OK for " + string + ProvUtils.bcProvider);
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("Invalid algorithm", 3011);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
    }

    public byte[] hash(InputStream inputStream, String string) throws CapiException {
        return this.hash(inputStream, string, 512);
    }

    public byte[] hash(InputStream inputStream, String object, int n) throws CapiException {
        a.debug("hash (inputstream block= " + n + ")");
        if (inputStream == null || object == null) {
            throw new CapiException("null params", 1001);
        }
        try {
            int n2;
            MessageDigest messageDigest = MessageDigest.getInstance(((String)object).toUpperCase(), ProvUtils.bcProvider);
            a.debug("hash getInstance OK for " + (String)object + ProvUtils.bcProvider);
            object = new byte[n];
            while ((n2 = inputStream.read((byte[])object)) != -1) {
                if (n2 == 0) continue;
                if (n2 == n) {
                    messageDigest.update((byte[])object);
                    continue;
                }
                a.debug("Crypto: hash last block read;len =" + n2);
                byte[] byArray = new byte[n2];
                System.arraycopy(object, 0, byArray, 0, n2);
                messageDigest.update(byArray);
            }
            inputStream.close();
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("Invalid algorithm", 3011);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 1003);
        }
    }

    private static byte[] a(byte[] byArray, PrivateKey privateKey) throws CapiException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", "Actalis");
            cipher.init(1, privateKey);
            return cipher.doFinal(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("Internal error", 1003);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            a.debug(noSuchPaddingException.getMessage(), (Throwable)noSuchPaddingException);
            throw new CapiException("Internal error", 1003);
        }
        catch (BadPaddingException badPaddingException) {
            a.debug(badPaddingException.getMessage(), (Throwable)badPaddingException);
            throw new CapiException("Invalid signature", 3010);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            a.debug(illegalBlockSizeException.getMessage(), (Throwable)illegalBlockSizeException);
            throw new CapiException("Invalid signature", 3010);
        }
        catch (InvalidKeyException invalidKeyException) {
            a.debug(invalidKeyException.getMessage(), (Throwable)invalidKeyException);
            throw new CapiException("Invalid key format", 3000);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Invalid signature", 3010);
        }
        catch (CapiError capiError) {
            a.debug(capiError.getMessage(), (Throwable)capiError);
            throw capiError.getCapiException();
        }
    }
}

