/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.crl;

import com.google.gson.Gson;
import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.CrlBean;
import esecurity.validator.x509status.RevocationBean;
import esecurity.validator.x509status.crl.CRLCacheManager;
import esecurity.validator.x509status.crl.CRLUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.ConfigFile;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509CRLEntry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.sqlite.SQLiteConfig;
import secretstoreutils.PassPharseUtils;

public class DefaultCrlCacheManager
implements CRLCacheManager {
    private boolean a;
    private Logger b;
    private static final ConcurrentHashMap<String, CRL> c = new ConcurrentHashMap();
    private static final LinkedBlockingQueue<String> d = new LinkedBlockingQueue();
    private Thread e;
    private a f;
    private String g;
    private static DefaultCrlCacheManager h = null;
    private Connection i;
    private RandomAccessFile j;
    private FileChannel k;
    private File l;
    private FileLock m;

    private DefaultCrlCacheManager(ValidatorConfig object, Logger object2) throws CapiException, SQLException, IOException {
        block10: {
            this.a = true;
            this.b = null;
            this.e = null;
            this.f = null;
            new Gson();
            this.g = null;
            this.i = null;
            this.j = null;
            this.k = null;
            this.b = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
            if (object2 != null) {
                this.b = object2;
            }
            boolean bl = this.a = (object = ((ConfigFile)object).getElement("crl.dir")) == null;
            if (this.a || object == null) break block10;
            if (!((File)(object = new File((String)object))).exists()) {
                ((File)object).mkdirs();
            }
            this.g = ((File)object).getAbsolutePath() + File.separatorChar + "crlV1.db";
            this.l = new File(this.g + ".lck");
            try {
                this.c();
                this.i = this.a(false);
                object = this;
                object2 = "CREATE TABLE IF NOT EXISTS crl_infos (\n\tcrl_id TEXT,\n\tissuer_dn TEXT,\n\tthis_update TEXT,\n\tnext_update TEXT,\n\tserial TEXT,\n\tsign_alg_name TEXT,\n\tcrl_status_explained TEXT,\n\texpired_certs_on_crl TEXT,\n\tissuing_distribution_point_name TEXT,\n\tdownloaded_url TEXT,\n\tversion TEXT,\n\tcrl_valid INTEGER,\n\tCONSTRAINT crl_infos_pk PRIMARY KEY (crl_id)\n);";
                String string = "CREATE TABLE IF NOT EXISTS crl_entries (\n\tcrl_id TEXT,\n\tserial_number TEXT,\n\trevocation_code INTEGER,\n\trevocation_date NUMERIC,\n\tCONSTRAINT crl_entries_pk PRIMARY KEY (crl_id,serial_number),\n\tCONSTRAINT crl_entries_fk FOREIGN KEY (crl_id) REFERENCES crl_infos(crl_id) ON DELETE CASCADE ON UPDATE CASCADE\n);";
                Statement statement = null;
                try {
                    statement = ((DefaultCrlCacheManager)object).i.createStatement();
                    statement.execute((String)object2);
                    statement.execute(string);
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(statement);
                    throw throwable;
                }
                Util.closeQuietly(statement);
                this.f = new a(this, 0);
                this.e = new Thread(this.f);
                this.e.setDaemon(true);
                this.e.start();
                Runtime.getRuntime().addShutdownHook(new Thread(new esecurity.validator.x509status.crl.a(this)));
                return;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException(noSuchAlgorithmException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new RuntimeException(invalidKeyException);
            }
            finally {
                this.d();
            }
        }
    }

    private void c() throws IOException {
        if (this.m != null) {
            return;
        }
        if (!this.l.exists()) {
            this.l.createNewFile();
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.l, "rw");
            this.k = randomAccessFile.getChannel();
        }
        catch (Throwable throwable) {}
        while (this.m == null) {
            try {
                this.m = this.k.tryLock();
            }
            catch (Throwable throwable) {}
            if (this.m == null) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    private void d() throws IOException {
        Util.closeQuietly(this.m);
        Util.closeQuietly(this.k);
        Util.closeQuietly(null);
        this.m = null;
        this.k = null;
        this.j = null;
    }

    private Connection a(boolean bl) throws SQLException, UnknownHostException, NoSuchAlgorithmException, InvalidKeyException {
        Connection connection;
        Object object = "iaofmvciermvoiaenvrepsrngvn";
        object = PassPharseUtils.deriveKey((byte[])InetAddress.getLocalHost().getHostName().getBytes(), (byte[])((String)object).getBytes(), (int)1024, (int)16);
        object = "jdbc:sqlite:file:" + new File(this.g).getAbsolutePath() + "?cipher=aes128cbc&kdf_iter=1&key=" + Hex.toHexString((byte[])object);
        SQLiteConfig sQLiteConfig = new SQLiteConfig();
        sQLiteConfig.setReadOnly(false);
        sQLiteConfig.setPageSize(8192);
        try {
            connection = sQLiteConfig.createConnection((String)object);
            connection.setReadOnly(false);
        }
        catch (Throwable throwable) {
            new File(this.g).delete();
            connection = sQLiteConfig.createConnection((String)object);
            connection.setReadOnly(false);
        }
        return connection;
    }

    public static DefaultCrlCacheManager getInstance(ValidatorConfig validatorConfig) throws CapiException {
        return DefaultCrlCacheManager.getInstance(validatorConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultCrlCacheManager getInstance(ValidatorConfig validatorConfig, Logger object) throws CapiException {
        EllipsLogger ellipsLogger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        if (object != null) {
            ellipsLogger = object;
        }
        if (h == null) {
            object = validatorConfig;
            synchronized (object) {
                if (h == null) {
                    try {
                        h = new DefaultCrlCacheManager(validatorConfig, (Logger)ellipsLogger);
                    }
                    catch (IOException | SQLException exception) {
                        throw new CapiException("Unable to create Cache Manager", 1003, exception);
                    }
                }
            }
        }
        return h;
    }

    @Override
    public RevocationBean checkRevocation(Certificate object, ValidationDate object2) {
        String string = CRLUtils.generateCrlId((Certificate)object);
        RevocationBean revocationBean = null;
        Object object3 = c.get(string);
        if (object3 != null) {
            revocationBean = CRLUtils.a((CRL)object3, ((Certificate)object).getInternalCert().getSerialNumber(), (ValidationDate)object2);
        }
        if (revocationBean != null) {
            return revocationBean;
        }
        object3 = this.a(string);
        if (object3 == null) {
            this.b.debug("Crl not in cache...");
            return null;
        }
        Date date = new Date();
        if (!((CrlBean)object3).isCrlValid()) {
            this.b.debug("Crl not valid");
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            if (date.before(simpleDateFormat.parse(((CrlBean)object3).getNextUpdate()))) {
                revocationBean = new RevocationBean();
                revocationBean.setCrlBean((CrlBean)object3);
                revocationBean.setCrlStatus(((CrlBean)object3).getCrlStatusExplained());
                object = this.a(string, ((Certificate)object).getInternalCert().getSerialNumber().toString(16));
                if (object == null) {
                    revocationBean.setCertRevoked(false);
                } else if (((Date)(object2 = ((ValidationDate)object2).getDate())).compareTo(((b)object).c()) >= 0) {
                    revocationBean.setCertRevoked(true);
                    revocationBean.setRevocationDate(((b)object).c());
                    revocationBean.setRevocationReason(Integer.toString(((b)object).b()));
                    object = CRLUtils.a(((b)object).b());
                    if (!revocationBean.getInvalidityReason().equalsIgnoreCase("")) {
                        object = revocationBean.getInvalidityReason() + " - " + (String)object;
                    }
                    revocationBean.setInvalidityReason((String)object);
                }
            }
        }
        catch (ParseException parseException) {
            this.b.error("unable to parse crl nextUpdate.", (Throwable)parseException);
        }
        return revocationBean;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CrlBean a(String object) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block7: {
            block6: {
                Object object2 = "select * from  crl_infos where crl_id = ?";
                preparedStatement = null;
                resultSet = null;
                try {
                    preparedStatement = this.i.prepareStatement((String)object2);
                    preparedStatement.setString(1, (String)object);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        object = resultSet;
                        object2 = new CrlBean();
                        ((CrlBean)object2).setCrlId(object.getString("crl_id"));
                        ((CrlBean)object2).setIssuerDN(object.getString("issuer_dn"));
                        ((CrlBean)object2).setThisUpdate(object.getString("this_update"));
                        ((CrlBean)object2).setNextUpdate(object.getString("next_update"));
                        ((CrlBean)object2).setSerial(object.getString("serial"));
                        ((CrlBean)object2).setSigAlgName(object.getString("sign_alg_name"));
                        ((CrlBean)object2).setCrlStatusExplained(object.getString("crl_status_explained"));
                        ((CrlBean)object2).setExpiredCertsOnCRL(object.getString("expired_certs_on_crl"));
                        ((CrlBean)object2).setIssuingDistributionPointName(object.getString("issuing_distribution_point_name"));
                        ((CrlBean)object2).setDownloadedUrl(object.getString("downloaded_url"));
                        ((CrlBean)object2).setVersion(object.getString("version"));
                        ((CrlBean)object2).setCrlValid(object.getBoolean("crl_valid"));
                        object = object2;
                        Util.closeQuietly(resultSet);
                        break block6;
                    }
                    Util.closeQuietly(resultSet);
                    break block7;
                }
                catch (SQLException sQLException) {
                    this.b.error("Errore nella query lettura crlBean ", (Throwable)sQLException);
                    return null;
                }
            }
            Util.closeQuietly(preparedStatement);
            return object;
        }
        Util.closeQuietly(preparedStatement);
        return null;
        finally {
            Util.closeQuietly(resultSet);
            Util.closeQuietly(preparedStatement);
        }
    }

    private b a(String string, String string2) {
        String string3 = "select * from  crl_entries where crl_id = ? and serial_number = ?";
        b b2 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.i.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                b2 = new b(this, new BigInteger(string2, 16), resultSet.getInt("revocation_code"), new Date(resultSet.getLong("revocation_date")));
            }
            Util.closeQuietly(resultSet);
        }
        catch (SQLException sQLException) {
            this.b.error("Errore nella query lettura crlBean ", (Throwable)sQLException);
            return null;
        }
        finally {
            Util.closeQuietly(resultSet);
            Util.closeQuietly(preparedStatement);
        }
        Util.closeQuietly(preparedStatement);
        return b2;
    }

    @Override
    public boolean isCrlInCache(String string) {
        if (this.a) {
            return false;
        }
        CrlBean crlBean = this.a(string);
        if (crlBean == null) {
            this.b.debug("Crl's info for id:" + string + " is null");
            return c.get(string) != null;
        }
        if (!crlBean.isCrlValid()) {
            this.b.debug("Crl not valid");
            return c.get(string) != null;
        }
        boolean bl = false;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            Date date = new Date();
            if (date.after(simpleDateFormat.parse(crlBean.getNextUpdate()))) {
                bl = true;
            }
        }
        catch (ParseException parseException) {
            bl = true;
        }
        if (bl) {
            this.b.debug("Crl not valid");
            return c.get(string) != null;
        }
        return true;
    }

    @Override
    public void addCrlToCache(String string, CRL cRL) throws CapiException {
        if (!this.a && c.size() < 10) {
            c.put(string, cRL);
            d.add(string);
        }
    }

    private void e() {
        try {
            if (this.f == null) {
                return;
            }
            this.f.a(false);
            this.e.join();
            this.f = null;
            this.e = null;
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    public void finalize() throws Throwable {
        this.e();
        super.finalize();
    }

    static /* synthetic */ void a(DefaultCrlCacheManager defaultCrlCacheManager) {
        defaultCrlCacheManager.e();
        Util.closeQuietly(defaultCrlCacheManager.i);
    }

    static /* synthetic */ void a(DefaultCrlCacheManager defaultCrlCacheManager, String string) throws SQLException {
        String string2 = "delete from crl_infos where crl_id = ?";
        String string3 = "delete from crl_entries where crl_id = ?";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = defaultCrlCacheManager.i.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            Util.closeQuietly(preparedStatement);
            preparedStatement = defaultCrlCacheManager.i.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeQuietly(preparedStatement);
            throw throwable;
        }
        Util.closeQuietly(preparedStatement);
    }

    static /* synthetic */ void a(DefaultCrlCacheManager defaultCrlCacheManager, CrlBean crlBean) throws SQLException {
        String string = "INSERT INTO crl_infos\n(crl_id, \"issuer_dn\", \"this_update\", \"next_update\",serial,sign_alg_name,crl_status_explained,expired_certs_on_crl,issuing_distribution_point_name,downloaded_url,version,crl_valid)\nVALUES(?, ?,?,?,?,?,?,?,?,?,?,?);";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = defaultCrlCacheManager.i.prepareStatement(string);
            preparedStatement.setString(1, crlBean.getCrlId());
            preparedStatement.setString(2, crlBean.getIssuerDN());
            preparedStatement.setString(3, crlBean.getThisUpdate());
            preparedStatement.setString(4, crlBean.getNextUpdate());
            preparedStatement.setString(5, crlBean.getSerial());
            preparedStatement.setString(6, crlBean.getSigAlgName());
            preparedStatement.setString(7, crlBean.getCrlStatusExplained());
            preparedStatement.setString(8, crlBean.getExpiredCertsOnCRL());
            preparedStatement.setString(9, crlBean.getIssuingDistributionPointName());
            preparedStatement.setString(10, crlBean.getDownloadedUrl());
            preparedStatement.setString(11, crlBean.getVersion());
            preparedStatement.setBoolean(12, crlBean.isCrlValid());
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeQuietly(preparedStatement);
            throw throwable;
        }
        Util.closeQuietly(preparedStatement);
    }

    static /* synthetic */ void a(DefaultCrlCacheManager defaultCrlCacheManager, String string, b b2) throws SQLException {
        String string2 = "INSERT INTO crl_entries\n(crl_id, serial_number, \"revocation_code\", \"revocation_date\")\nVALUES(?, ?,?,?);";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = defaultCrlCacheManager.i.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, b2.a().toString(16));
            preparedStatement.setInt(3, b2.b());
            preparedStatement.setLong(4, b2.c().getTime());
            preparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            Util.closeQuietly(preparedStatement);
            throw throwable;
        }
        Util.closeQuietly(preparedStatement);
    }

    final class b
    implements Serializable {
        private BigInteger a;
        private int b;
        private Date c;

        public b(DefaultCrlCacheManager defaultCrlCacheManager, BigInteger bigInteger, int n, Date date) {
            this.a = bigInteger;
            this.b = n;
            this.c = date;
        }

        public final BigInteger a() {
            return this.a;
        }

        public final int b() {
            return this.b;
        }

        public final Date c() {
            return this.c;
        }
    }

    final class a
    implements Runnable {
        private boolean a = true;
        private /* synthetic */ DefaultCrlCacheManager b;

        private a(DefaultCrlCacheManager defaultCrlCacheManager) {
            this.b = defaultCrlCacheManager;
        }

        @Override
        public final void run() {
            try {
                while (this.a) {
                    CRL cRL;
                    String string = (String)d.poll(1L, TimeUnit.SECONDS);
                    if (string == null || (cRL = (CRL)c.get(string)) == null) continue;
                    try {
                        this.b.c();
                        this.b.i.setAutoCommit(false);
                        DefaultCrlCacheManager.a(this.b, string);
                        CrlBean crlBean = CRLUtils.a(cRL, new Date());
                        crlBean.setCrlId(string);
                        DefaultCrlCacheManager.a(this.b, crlBean);
                        if (cRL.getInternalCRL() != null && cRL.getInternalCRL().getRevokedCertificates() != null) {
                            for (X509CRLEntry x509CRLEntry : cRL.getInternalCRL().getRevokedCertificates()) {
                                int n = 0;
                                try {
                                    n = cRL.getReasonCode(x509CRLEntry.getSerialNumber());
                                }
                                catch (CapiException capiException) {}
                                b object = new b(this.b, x509CRLEntry.getSerialNumber(), n, x509CRLEntry.getRevocationDate());
                                DefaultCrlCacheManager.a(this.b, string, object);
                            }
                        }
                        c.remove(string);
                        this.b.i.commit();
                    }
                    catch (Exception exception) {
                        this.b.b.error("unable to parse crl.", (Throwable)exception);
                        exception.printStackTrace();
                    }
                    finally {
                        this.b.i.setAutoCommit(true);
                        this.b.d();
                    }
                }
                return;
            }
            catch (IOException | InterruptedException | SQLException exception) {
                this.b.b.error("Worker Interrotto", (Throwable)exception);
                exception.printStackTrace();
                return;
            }
        }

        public final void a(boolean bl) {
            this.a = false;
        }

        /* synthetic */ a(DefaultCrlCacheManager defaultCrlCacheManager, byte by) {
            this(defaultCrlCacheManager);
        }
    }
}

