/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepOrder;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

@StepOrder(order=1)
public class StepFormat
extends SingleValidationSubStepImpl {
    public StepFormat() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> object, ValidationContextParameters validationContextParameters) {
        object = validationContextParameters.getSignature().getFormat().name();
        if (((String)object).startsWith("TST")) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0002_MARK_FORMAT, object);
        }
        if (validationContextParameters.getLevelValidation() == null) {
            if (validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getPadesSpecific() != null) {
                String string = validationContextParameters.getSignature().getPadesSpecific().getSubFilter();
                if (string.equalsIgnoreCase("adbe.pkcs7.detached") || string.equalsIgnoreCase("adbe.pkcs7.sha1")) {
                    object = (String)object + "-basic";
                } else if (string.equalsIgnoreCase("ETSI.CAdES.detached")) {
                    object = (String)object + "-BES";
                }
            } else {
                object = (String)object + "-BES";
            }
        } else {
            object = (String)object + "-" + validationContextParameters.getLevelValidation().getLevel().toString();
        }
        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0001_SIGNATURE_FORMAT, object);
    }
}

