/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.edec;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.Utils;
import org.bouncycastle.util.Arrays;

public class BCXDHPrivateKey
implements XDHKey,
PrivateKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricKeyParameter xdhPrivateKey;
    private final boolean hasPublicKey;
    private final byte[] attributes;

    BCXDHPrivateKey(AsymmetricKeyParameter privKey) {
        this.hasPublicKey = true;
        this.attributes = null;
        this.xdhPrivateKey = privKey;
    }

    BCXDHPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.hasPublicKey = keyInfo.hasPublicKey();
        this.attributes = keyInfo.getAttributes() != null ? keyInfo.getAttributes().getEncoded() : null;
        this.populateFromPrivateKeyInfo(keyInfo);
    }

    private void populateFromPrivateKeyInfo(PrivateKeyInfo keyInfo) throws IOException {
        ASN1Encodable keyOcts = keyInfo.parsePrivateKey();
        this.xdhPrivateKey = EdECObjectIdentifiers.id_X448.equals((ASN1Primitive)keyInfo.getPrivateKeyAlgorithm().getAlgorithm()) ? new X448PrivateKeyParameters(ASN1OctetString.getInstance((Object)keyOcts).getOctets(), 0) : new X25519PrivateKeyParameters(ASN1OctetString.getInstance((Object)keyOcts).getOctets(), 0);
    }

    @Override
    public String getAlgorithm() {
        return this.xdhPrivateKey instanceof X448PrivateKeyParameters ? "X448" : "X25519";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            ASN1Set attrSet = ASN1Set.getInstance((Object)this.attributes);
            PrivateKeyInfo privInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)this.xdhPrivateKey, (ASN1Set)attrSet);
            if (this.hasPublicKey) {
                return privInfo.getEncoded();
            }
            return new PrivateKeyInfo(privInfo.getPrivateKeyAlgorithm(), privInfo.parsePrivateKey(), attrSet).getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    AsymmetricKeyParameter engineGetKeyParameters() {
        return this.xdhPrivateKey;
    }

    public String toString() {
        Object pubKey = this.xdhPrivateKey instanceof X448PrivateKeyParameters ? ((X448PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey() : ((X25519PrivateKeyParameters)this.xdhPrivateKey).generatePublicKey();
        return Utils.keyToString("Private Key", this.getAlgorithm(), (AsymmetricKeyParameter)pubKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BCXDHPrivateKey)) {
            return false;
        }
        BCXDHPrivateKey other = (BCXDHPrivateKey)o;
        return Arrays.areEqual((byte[])other.getEncoded(), (byte[])this.getEncoded());
    }

    public int hashCode() {
        return Arrays.hashCode((byte[])this.getEncoded());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.populateFromPrivateKeyInfo(PrivateKeyInfo.getInstance((Object)enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

