var windowHeight;
var fixedTop = 116;
var loaded = false;
var updateDragDrop = false;

var resizable = "#ver_documentContainer";

function updateResize() {
    try {
        if (loaded === true) {
            var verMainContainerRect = document.getElementById('ver_mainContainer').getBoundingClientRect();
            var maxHeight = window.innerHeight - getFixesTop() - 200;
            $(resizable).resizable("option", "maxHeight", maxHeight);
            if ($(resizable).outerHeight(false) > maxHeight) {
                $(resizable).css("height", maxHeight);
            }
            setsignaturesTreeDummyContainerHeight();
        }
    } catch (exception) {
        error(exception.stack);
    }
}

function getFixesTop() {
    if(window.innerHeight > 690 && window.innerWidth > 1005) {
        return fixedTop + 10;
    } else {
        return fixedTop - 50;
    }
}

function updateDragAndDropHandler(val) {
    updateDragDrop = val;
}

function updateDragAndDrop() {
    try {
        var height = $("#ver_documentTableContainer").height();
        $("#ver_mainContainer_dnd_draggable-section-full").height(height - 20);
    } catch (exception) {
        error(exception.stack);
    }
}

function forceSignatureSectionHeightIncrease() {
    fixedTop = 116;
    updateResize();
}

function forceSignatureSectionHeightReduction() {
    fixedTop = 168;
    updateResize();
}

function resize() {
    try {
        updateResize();
    } catch (exception) {
        error(exception.stack);
    }
    try {
        if (updateDragDrop) {
            updateDragAndDrop();
        }
    } catch (exception) {
        error(exception.stack);
    }
}

function setDragResize() {
    try {
        $(resizable).resizable({
            handles: 's',
            minHeight: getMinHeight(),
            maxHeight: window.innerHeight - getFixesTop() - 200,
            resize: function (event, ui) {
                updateDragAndDrop();
                setsignaturesTreeDummyContainerHeight();
            }
        });
        var verMainContainerRect = document.getElementById('ver_mainContainer').getBoundingClientRect();
        $(resizable).css("height", (window.innerHeight - getFixesTop() - 160) / 2);
        $("#ver_documentTreeContainer").css("height", "100%");
        window.onresize = resize;
    } catch (exception) {
        error(exception.stack);
    }
    loaded = true;
}

function getMinHeight() {
    if(window.innerHeight > 690 && window.innerWidth > 1005) {
        return 150;
    } else {
        return 80;
    }
}

function setsignaturesTreeDummyContainerHeight() {
    var signatureTableRect = document.getElementById('ver_signaturesTableContainer').getBoundingClientRect();
    $("#signaturesTreeDummyContainer").css("height", (signatureTableRect.bottom - signatureTableRect.top - 20));
}

function scrollToLastCert() {
    //NB: manternere il parametro di scrollIntoView a false per evitare bug visivi della modale
    //(if false, the bottom of the element will be aligned to the bottom of the visible area of the scrollable ancestor)
    document.getElementsByClassName('cd_treeItemSelected')[0].scrollIntoView(false);
}

//--------------------------------------DocumentTable------------------------------------------

var documentArea;
var observableDocuments = [];

function startDocumentAreaObservation(documentAreaId) {
    documentArea = document.getElementById(documentAreaId);
    window.addEventListener('resize', function (e) {
        resizeDocuments();
    });
}

function resizeDocuments() {
    if (observableDocuments.length !== 0 && documentArea !== undefined && documentArea !== null) {
        var width = documentArea.clientWidth - 20;
        for (var doc in observableDocuments) {
            observableDocuments[doc].style.width = width + 'px';
        }
    }
}

function observeDocument(documentId) {
    var width = documentArea.clientWidth;
    var iconsArea = document.getElementById(documentId);
    iconsArea.style.width = (width - 20) + 'px';
    observableDocuments.push(iconsArea);
}

function removeObservableDocument(documentId) {
    var id = observableDocuments.indexOf(documentId);
    if (id > -1) {
        observableDocuments.splice(id, 1);
    }
}
