/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.core.http.providers.okhttp;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import esecurity.dsd.core.Log;
import esecurity.dsd.core.Utils;
import esecurity.dsd.core.http.ProxyConfiguration;
import esecurity.dsd.core.http.RESTClient;
import esecurity.dsd.core.http.providers.HTTPUrl;
import esecurity.dsd.core.http.providers.RESTClientProvider;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.Parameters;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.EnumMap;

public class RESTClient
implements RESTClientProvider {
    private UrlClient client = null;

    @Override
    public void initialize(HTTPUrl baseURL, EnumMap<RESTClient.Timeouts, Long> timeouts, KeyStore truststore, ProxyConfiguration proxy) {
        NetworkConfig conf = new NetworkConfig(Log.logger(), false);
        if (proxy != null && proxy.getAddr() != null && !proxy.getAddr().isEmpty() && proxy.getPort() > -1) {
            conf.setProxy(proxy.getAddr());
            conf.setProxyPort(String.valueOf(proxy.getPort()));
            if (proxy.getUser() != null && !proxy.getUser().isEmpty() && proxy.getPwd() != null && !proxy.getPwd().isEmpty()) {
                conf.setUserProxy(proxy.getUser());
                conf.setPasswordProxy(proxy.getPwd());
            }
        }
        if (timeouts != null) {
            if (timeouts.containsKey((Object)RESTClient.Timeouts.CONNECTION)) {
                conf.setConnectionTimeOut(String.valueOf(timeouts.get((Object)RESTClient.Timeouts.CONNECTION)));
            }
            if (timeouts.containsKey((Object)RESTClient.Timeouts.READ)) {
                conf.setReadTimeOut(String.valueOf(timeouts.get((Object)RESTClient.Timeouts.READ)));
            }
        }
        this.client = new UrlClient(conf, Log.logger());
        this.client.setTrustStore(truststore);
    }

    @Override
    public RESTClient.HTTPResponse call(RESTClient.HTTPMethod method, HTTPUrl url, RESTClient.HTTPHeader header, String username, String password, JsonElement body) throws RESTClient.HTTPException {
        UrlReturn response = null;
        RequestData rdate = new RequestData();
        ArrayList<Parameters> params = new ArrayList<Parameters>();
        if (header != null && !header.keyset().isEmpty()) {
            for (String k : header.keyset()) {
                Parameters param = new Parameters(k, header.get(k));
                params.add(param);
            }
        }
        rdate.setParam(params);
        URLCredentials creds = null;
        if (username != null && password != null && !username.isEmpty() && !password.isEmpty()) {
            creds = new URLCredentials(username, password, null, null);
        }
        if (method != RESTClient.HTTPMethod.GET) {
            rdate.setPostdata(new Gson().toJson(body).getBytes());
            rdate.setContentType("application/json");
        }
        String urlString = "";
        try {
            urlString = url.toURL().toString();
        }
        catch (MalformedURLException ex) {
            urlString = "";
            Log.logger().error(ex.getMessage(), (Throwable)ex);
        }
        Log.logger().debug(urlString);
        response = this.client.urlRequest(urlString, method.name(), rdate, creds);
        JsonObject jsonResponse = new JsonObject();
        if (response.getStatus() != null && response.getStatus().equals("OK")) {
            try {
                jsonResponse = (JsonElement)Utils.Gson().fromJson(new String(response.getData()), JsonElement.class);
                response.setStatus_code(200);
            }
            catch (JsonSyntaxException e) {
                Log.logger().error("Error during okHttp response body parsing into json. ", (Throwable)e);
                e.printStackTrace();
                throw new RESTClient.HTTPException(204, e.getMessage(), (Exception)((Object)e));
            }
        }
        return new RESTClient.HTTPResponse.Builder().code(response.getStatus_code()).message(response.getStatusMessage()).body((JsonElement)jsonResponse).build();
    }
}

