/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.core.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import esecurity.dsd.core.Domain;
import esecurity.dsd.core.DomainProvider;
import esecurity.dsd.core.LocalConfigurationProvider;
import esecurity.dsd.core.Log;
import esecurity.dsd.core.PropertyContainer;
import esecurity.dsd.core.http.RESTClient;
import esecurity.dsd.core.http.Token;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DomainHTTPProvider
implements DomainProvider {
    private LocalConfigurationProvider configurator;
    private Token token = Token.invalidToken();
    private RESTClient restClient = null;

    public DomainHTTPProvider(LocalConfigurationProvider configProvider) {
        this.configurator = configProvider;
    }

    private RESTClient rest() {
        if (this.restClient == null) {
            this.restClient = RESTClient.getInstance(this.configurator.getProvidedConfiguration());
        }
        return this.restClient;
    }

    @Override
    public Set<String> availableDomains() throws Exception {
        Log.logger().debug("Get available domains: ");
        TreeSet<String> result = new TreeSet<String>();
        this.checkTokenAuthentication();
        try {
            JsonElement list = this.rest().getDomainList(this.token);
            if (list.isJsonArray()) {
                list.getAsJsonArray().forEach(e -> {
                    result.add(e.getAsString());
                    Log.logger().debug("\t\t".concat(e.getAsString()));
                });
            }
        }
        catch (RESTClient.UnhautorizedException ex) {
            Log.logger().warn("Domain list not returned " + ex.getMessage());
        }
        return result;
    }

    private void checkTokenAuthentication() throws Exception {
        if (!this.token.isValid()) {
            PropertyContainer properties = this.configurator.getProvidedConfiguration();
            String username = properties.getValue("user", String.class).orElseThrow(() -> new IllegalArgumentException("Username missed"));
            String pwd = properties.getValue("pwd", String.class).orElseThrow(() -> new IllegalArgumentException("Password missed"));
            try {
                this.token = this.rest().getToken(username, pwd, true);
            }
            catch (Exception e) {
                this.token = Token.invalidToken();
                Log.logger().error("Error on check authentication. ", (Throwable)e);
                e.printStackTrace();
                throw e;
            }
        }
    }

    @Override
    public PropertyContainer getDomainProperties(String domainName) throws Exception {
        Domain result = null;
        Log.logger().debug("Get properties of domain [".concat(domainName).concat("] "));
        this.checkTokenAuthentication();
        JsonElement domainPub = this.rest().getDomain(this.token, domainName);
        try {
            JsonElement domainRes = this.rest().getDomainRestricted(this.token, domainName);
            for (Map.Entry entry : domainRes.getAsJsonObject().entrySet()) {
                domainPub.getAsJsonObject().add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        catch (RESTClient.UnhautorizedException ex) {
            Log.logger().warn("Unautorize exception getting private key for domain " + domainName);
        }
        result = new Domain(domainName, domainPub.getAsJsonObject());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Log.logger().debug(gson.toJson(domainPub));
        return result;
    }

    public PropertyContainer getDomainPublicProperties(String domainName) throws Exception {
        Domain result = null;
        Log.logger().debug("Get properties of domain [".concat(domainName).concat("] "));
        this.checkTokenAuthentication();
        JsonElement domain = this.rest().getDomain(this.token, domainName);
        result = new Domain(domainName, domain.getAsJsonObject());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Log.logger().debug(gson.toJson(domain));
        return result;
    }

    public PropertyContainer getDomainRestrictedProperties(String domainName) throws Exception {
        Domain result = null;
        Log.logger().debug("Get properties of domain [".concat(domainName).concat("] "));
        this.checkTokenAuthentication();
        JsonElement domain = this.rest().getDomainRestricted(this.token, domainName);
        result = new Domain(domainName, domain.getAsJsonObject());
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Log.logger().debug(gson.toJson(domain));
        return result;
    }
}

