/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dts.util;

import esecurity.dts.util.Connection;
import esecurity.dts.util.DTMPException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import org.slf4j.Logger;

public class DTMProtocol {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private byte b;
    private byte[] c;

    public DTMProtocol() {
    }

    public DTMProtocol(byte[] byArray, byte by) throws DTMPException {
        this.b = by;
        if (byArray == null) {
            throw new DTMPException("Expected a value");
        }
        this.c = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.c, 0, byArray.length);
    }

    public void read(Connection connection) throws IOException, DTMPException, CapiException {
        this.a(false, connection, 0, 0, 0);
    }

    public void readPDUZero(Connection connection, int n, int n2, int n3) throws IOException, DTMPException, CapiException {
        this.a(true, connection, n, n2, n3);
    }

    public byte[] getData() {
        return this.c;
    }

    public void setFlag(byte by) {
        this.b = by;
    }

    public byte getFlag() {
        return this.b;
    }

    public void setData(byte[] byArray) {
        System.arraycopy(byArray, 0, this.c, 0, byArray.length);
    }

    public byte[] toByteArray() {
        if (this.c == null) {
            return null;
        }
        int n = this.c.length + 1;
        byte[] byArray = new byte[4];
        for (int i = 3; i >= 0; --i) {
            byArray[i] = (byte)n;
            n >>>= 8;
        }
        byte[] byArray2 = byArray;
        byArray = new byte[5 + this.c.length];
        System.arraycopy(byArray2, 0, byArray, 0, 4);
        byArray[4] = this.b;
        System.arraycopy(this.c, 0, byArray, 5, this.c.length);
        return byArray;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    private static int a(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n |= (byArray[i] & 0xFF) << (3 - i << 3);
        }
        return n;
    }

    private void a(boolean n, Connection object, int n2, int n3, int n4) throws IOException, DTMPException, CapiException {
        int n5;
        byte[] byArray = new byte[4];
        for (n5 = 0; n5 < 4; ++n5) {
            byArray[n5] = ((Connection)object).read();
        }
        n5 = DTMProtocol.a(byArray);
        a.debug("toRead= " + n5);
        if (n != 0) {
            if (n5 < n2) {
                throw new DTMPException("PKI length:" + n5 + " less than " + n2);
            }
            if (n5 > n3) {
                throw new DTMPException("PKI length:" + n5 + " greater than " + n3);
            }
        }
        this.b = ((Connection)object).read();
        a.debug("flag=" + this.b + " toRead= " + --n5);
        if (n != 0 && this.b != 0 && this.b != (byte)n4) {
            throw new DTMPException("PKI flag invalid:" + this.b);
        }
        this.c = new byte[n5];
        for (n = 0; n < n5; ++n) {
            this.c[n] = ((Connection)object).read();
        }
        if (a.isDebugEnabled()) {
            String string = "./readpdudata.der";
            a.debug("saving to file " + string);
            Util.saveToFile(this.c, string);
            string = "./alldata.der";
            a.debug("saving to file " + string);
            object = new byte[this.c.length + 4 + 1];
            System.arraycopy(byArray, 0, object, 0, 4);
            object[4] = this.b;
            System.arraycopy(this.c, 0, object, 5, this.c.length);
            Util.saveToFile((byte[])object, string);
        }
    }
}

