/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util.m7m;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsa.TSDUtils;
import it.actalis.ellips.capi.util.m7m.SimpleMimeReader;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.InputStream;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import org.slf4j.Logger;

public class M7MUtils {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static void M7MToTSD(InputHandler object, OutputHandler outputHandler) throws CapiException {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart(object.getInputAsNewStream());
            mimeBodyPart = new MimePartDataSource((MimePart)mimeBodyPart);
            mimeBodyPart = new MimeMultipart((DataSource)mimeBodyPart);
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < mimeBodyPart.getCount(); ++i) {
                if (mimeBodyPart.getBodyPart(i).getContentType().startsWith("application/pkcs7-mime")) {
                    n = i;
                }
                if (!mimeBodyPart.getBodyPart(i).getContentType().startsWith("application/timestamp")) continue;
                n2 = i;
            }
            InputHandler inputHandler = null;
            InputHandler inputHandler2 = null;
            if (n2 == -1 && n != -1 || n == -1 && n2 != -1) {
                object = new SimpleMimeReader(object.getInputAsNewStream());
                while (((SimpleMimeReader)object).nextPart()) {
                    if (((SimpleMimeReader)object).getDescription() != null && ((SimpleMimeReader)object).getDescription().toLowerCase().contains("time-stamp response")) {
                        inputHandler = DataHandlerBuilder.get().setBytes(((SimpleMimeReader)object).getPartDataAsBytes()).buildInput();
                    } else if (((SimpleMimeReader)object).getPartType() != null && ((SimpleMimeReader)object).getPartType().startsWith("application/timestamp")) {
                        inputHandler = DataHandlerBuilder.get().setBytes(((SimpleMimeReader)object).getPartDataAsBytes()).buildInput();
                    } else {
                        if (((SimpleMimeReader)object).getPartType() != null) {
                            ((SimpleMimeReader)object).getPartType().startsWith("application/pkcs7-mime");
                        }
                        inputHandler2 = DataHandlerBuilder.get().setBytes(((SimpleMimeReader)object).getPartDataAsBytes()).buildInput();
                    }
                    if (inputHandler == null || inputHandler2 == null) continue;
                    break;
                }
            } else {
                inputHandler = DataHandlerBuilder.get().setInputStream(mimeBodyPart.getBodyPart(n2).getInputStream()).buildInput();
                inputHandler2 = DataHandlerBuilder.get().setInputStream(mimeBodyPart.getBodyPart(n).getInputStream()).buildInput();
            }
            if (inputHandler == null || inputHandler2 == null) {
                throw new ParsingException("La busta M7M e' corrotta o illeggibile", (Throwable)new Exception("Possibile Boundary non corretto"));
            }
            object = new TimeStampToken(Util.getBytesFromInputStream((InputStream)inputHandler.getInputAsNewStream()));
            if (object.getInternalTst() == null) {
                throw new CapiException("Could not transform M7M to TSD", 50040);
            }
            TSDUtils.createTsd((InputHandler)inputHandler2, (OutputHandler)outputHandler, (byte[])object.toByteArray(false, true), null, null, null, null, null, (boolean)false);
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Could not transform M7M to TSD", 50040, (Throwable)exception);
        }
    }
}

