/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;

public class OsCheck {
    protected static OSType detectedOS;
    protected static OSInfo osInfo;

    public static OSType getOperatingSystemType() {
        if (detectedOS == null) {
            String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            detectedOS = OS.contains("mac") || OS.contains("darwin") ? OSType.MacOS : (OS.contains("win") ? OSType.Windows : (OS.contains("nux") ? OSType.Linux : OSType.Other));
        }
        return detectedOS;
    }

    public static OSInfo getOperatingSistemInfo() {
        if (osInfo != null) {
            return osInfo;
        }
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String arch = System.getProperty("os.arch");
        if (name == null || name.contains("Windows") || name.contains("Mac") || name.contains("Darwin")) {
            osInfo = new OSInfo(name, arch, version, name);
            return osInfo;
        }
        osInfo = OsCheck.getLinuxInfo(name, version, arch);
        return osInfo;
    }

    private static OSInfo getLinuxInfo(String name, String version, String arch) {
        File fileVersion;
        OSInfo info = OsCheck.getPlatformNameFromLsbRelease(name, version, arch);
        if (info != null) {
            return info;
        }
        info = OsCheck.getPlatformNameFromOsRelease(name, version, arch);
        if (info != null) {
            return info;
        }
        info = OsCheck.getPlatformNameFromFile(name, version, arch, "/etc/system-release");
        if (info != null) {
            return info;
        }
        File dir = new File("/etc/");
        if (dir.exists()) {
            info = OsCheck.getPlatformNameFromFile(name, version, arch, OsCheck.getFileEndingWith(dir, "-release"));
            if (info != null) {
                return info;
            }
            info = OsCheck.getPlatformNameFromFile(name, version, arch, OsCheck.getFileEndingWith(dir, "_version"));
            if (info != null) {
                return info;
            }
            info = OsCheck.getPlatformNameFromFile(name, version, arch, "/etc/issue");
            if (info != null) {
                return info;
            }
        }
        if ((fileVersion = new File("/proc/version")).exists() && (info = OsCheck.getPlatformNameFromFile(name, version, arch, fileVersion.getAbsolutePath())) != null) {
            return info;
        }
        info = new OSInfo(name, arch, version, name);
        return info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OSInfo getPlatformNameFromLsbRelease(String name, String version, String arch) {
        String fileName = "/etc/lsb-release";
        File f = new File(fileName);
        if (!f.exists()) {
            return null;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(fileName));){
            OSInfo oSInfo = OsCheck.readPlatformNameFromLsb(name, version, arch, br);
            return oSInfo;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static OSInfo readPlatformNameFromLsb(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String distribDescription = null;
        String distribCodename = null;
        while ((line = br.readLine()) != null && distribDescription == null && distribCodename == null) {
            if (line.startsWith("DISTRIB_DESCRIPTION")) {
                distribDescription = line.replace("DISTRIB_DESCRIPTION=", "").replace("\"", "");
            }
            if (!line.startsWith("DISTRIB_CODENAME")) continue;
            distribCodename = line.replace("DISTRIB_CODENAME=", "");
        }
        if (distribDescription != null && distribCodename != null) {
            return new OSInfo(name, arch, version, distribDescription + " (" + distribCodename + ")");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OSInfo getPlatformNameFromOsRelease(String name, String version, String arch) {
        String fileName = "/etc/os-release";
        File f = new File(fileName);
        if (!f.exists()) {
            return null;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(fileName));){
            OSInfo oSInfo = OsCheck.readPlatformNameFromOsRelease(name, version, arch, br);
            return oSInfo;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static OSInfo readPlatformNameFromOsRelease(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String distribName = "Linux";
        String distribVersion = "";
        String distribId = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("NAME=")) {
                distribName = line.replace("NAME=", "").replace("\"", "");
            }
            if (line.startsWith("VERSION=")) {
                distribVersion = line.replace("VERSION=", "").replace("\"", "") + " ";
            }
            if (!line.startsWith("ID=")) continue;
            distribId = line.replace("ID=", "").replace("\"", "");
        }
        if (distribName != null && distribId != null) {
            return new OSInfo(name, arch, distribVersion != null ? distribVersion : version, distribName + "(" + distribId + ")");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static OSInfo getPlatformNameFromFile(String name, String version, String arch, String filename) {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(filename));){
            OSInfo oSInfo = OsCheck.readPlatformName(name, version, arch, br);
            return oSInfo;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static OSInfo readPlatformName(String name, String version, String arch, BufferedReader br) throws IOException {
        String line;
        String lineToReturn = null;
        int lineNb = 0;
        while ((line = br.readLine()) != null) {
            if (lineNb++ == 0) {
                lineToReturn = line;
            }
            if (!line.startsWith("PRETTY_NAME")) continue;
            return new OSInfo(name, arch, version, line.substring(13, line.length() - 1));
        }
        return new OSInfo(name, arch, version, lineToReturn);
    }

    private static String getFileEndingWith(File dir, String fileEndingWith) {
        File[] fileList = dir.listFiles((dir1, filename) -> filename.endsWith(fileEndingWith));
        if (fileList.length > 0) {
            return fileList[0].getAbsolutePath();
        }
        return null;
    }

    public static class OSInfo {
        private String name;
        private String architecture;
        private String version;
        private String platformName;

        public OSInfo(String name, String architecture, String version, String platformName) {
            this.name = name;
            this.architecture = architecture;
            this.version = version;
            this.platformName = platformName;
        }

        public String getName() {
            return this.name;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public String getVersion() {
            return this.version;
        }

        public String getPlatformName() {
            return this.platformName;
        }
    }

    public static enum OSType {
        Windows,
        MacOS,
        Linux,
        Other;

    }
}

