/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.jetty;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import esecurity.desktop.BaseController;
import esecurity.desktop.ResUtils;
import esecurity.desktop.jetty.JettyView;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JettyResource
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String controllerId = request.getParameter("controllerId");
        if (controllerId != null) {
            BaseController controller = JettyView.controllerMap.get(controllerId);
            String html = ResUtils.composeHtml(controller, false, new ArrayList<String>()).outerHtml();
            String jsMethods = this.composeJs(controller, controllerId);
            String js = request.getParameter("js");
            String css = request.getParameter("css");
            String img = request.getParameter("img");
            if (js == null && css == null && img == null) {
                html = html.replace("</body>", "<script>" + jsMethods + "\n\nwindow.onbeforeunload = function () {\n   var xhr = new XMLHttpRequest();\nvar url = \"index\";\nxhr.open(\"POST\", url, true);\nxhr.setRequestHeader(\"Content-Type\", \"application/json\");\nxhr.onreadystatechange = function () {\n    if (xhr.readyState === 4 && xhr.status === 200) {\n        var json = JSON.parse(xhr.responseText);\n        console.log(\" status -->, \" + json.status);\n    }\n};\nvar json = {method:\"close\"};\nvar data = JSON.stringify(json);\nxhr.send(data);\n};\n\nvar evaluate_service = new WebSocket('ws://localhost:8888/ws');\nevaluate_service.onopen = function(event){\nvar initBean = \"" + controller.getId() + "\";\nevaluate_service.send(initBean);\n\ncontroller_" + controller.getId() + "_viewOnLoad();\n}\nevaluate_service.onmessage = function(event){\n   var json = JSON.parse(event.data);\n   var strEval = json.evaluate;\n   var ret = eval(strEval);\n   var objRet = {ThreadId:json.ThreadId,return:ret};\n   var json2 = JSON.stringify(objRet);\n   evaluate_service.send(json2);\n};\n</script> </body>");
                ServletOutputStream out = response.getOutputStream();
                out.write(html.getBytes());
                out.flush();
                out.close();
            } else {
                ServletOutputStream out;
                if (js != null) {
                    InputStream jsResource = ((Object)((Object)this)).getClass().getResourceAsStream(js);
                    if (jsResource != null) {
                        response.setContentType("application/javascript");
                        String jsValue = ResUtils.toString(jsResource, true);
                        jsValue = jsValue.replace("$controller$.", "controller_" + controller.getId() + "_");
                        out = response.getOutputStream();
                        out.write(jsValue.getBytes());
                        out.flush();
                        out.close();
                    } else {
                        response.setStatus(404);
                    }
                }
                if (css != null) {
                    InputStream cssResource = ((Object)((Object)this)).getClass().getResourceAsStream(css);
                    if (cssResource != null) {
                        response.setContentType("text/css");
                        String cssValue = ResUtils.toString(cssResource, true);
                        cssValue = cssValue.replace("$controller$.", "controller_" + controller.getId() + "_");
                        out = response.getOutputStream();
                        out.write(cssValue.getBytes());
                        out.flush();
                        out.close();
                    } else {
                        response.setStatus(404);
                    }
                }
                if (img != null) {
                    URL res = ResUtils.class.getResource(img);
                    if (res != null) {
                        URLConnection uc = res.openConnection();
                        response.setContentType(uc.getContentType());
                        byte[] bValue = ResUtils.toByteArray(uc.getInputStream(), true);
                        ServletOutputStream out2 = response.getOutputStream();
                        out2.write(bValue);
                        out2.flush();
                        out2.close();
                    } else {
                        response.setStatus(404);
                    }
                }
            }
        } else {
            response.setStatus(404);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String controllerId = request.getParameter("controllerId");
        if (controllerId != null) {
            InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream());
            Gson gson = new Gson();
            JsonElement element = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            String page = this.getInitParameter("view");
            BaseController controller = JettyView.controllerMap.get(controllerId);
            String method = element.getAsJsonObject().get("method").getAsString();
            JsonElement arg = element.getAsJsonObject().get("arg");
            if (method.equals("close")) {
                // empty if block
            }
            Object obj = null;
            String jsonObj = "{\"status\":\"OK\"}";
            try {
                if (arg != null) {
                    int size = arg.getAsJsonObject().entrySet().size();
                    Object[] args = new Object[size];
                    int i = 0;
                    for (Map.Entry entry : arg.getAsJsonObject().entrySet()) {
                        args[i] = ((JsonElement)entry.getValue()).getAsString();
                        ++i;
                    }
                    obj = size == 0 ? controller.getJsMethod(method).invoke((Object)controller, null) : controller.getJsMethod(method).invoke((Object)controller, args);
                    if (obj != null) {
                        jsonObj = gson.toJson(obj);
                    }
                }
            }
            catch (Exception e) {
                jsonObj = "{\"status\":\"KO\"}";
                e.printStackTrace();
            }
            response.setContentType("application/json");
            ServletOutputStream out = response.getOutputStream();
            out.write(jsonObj.getBytes());
            out.flush();
            out.close();
        } else {
            response.setStatus(404);
        }
    }

    private String composeJs(BaseController controller, String controllerId) {
        String js = "";
        String name = "controller_" + controller.getId() + "_viewOnLoad";
        Method mtd = controller.getJsMethod(name);
        String parameters = "";
        String parametersJson = "";
        int i = 0;
        for (Class<?> par : mtd.getParameterTypes()) {
            if (parameters.equals("")) {
                parameters = parameters + "par" + i;
                parametersJson = parametersJson + "\"par" + i + "\":par" + i;
            } else {
                parameters = parameters + ",par" + i;
                parametersJson = parametersJson + ",\"par" + i + "\":par" + i;
            }
            ++i;
        }
        js = js + "\nfunction " + name + "(" + parameters + "){\nvar xhr = new XMLHttpRequest();\nvar url = \"index?controllerId=" + controllerId + "\";\nxhr.open(\"POST\", url, true);\nxhr.setRequestHeader(\"Content-Type\", \"application/json\");\nxhr.onreadystatechange = function () {\n    if (xhr.readyState === 4 && xhr.status === 200) {\n        var json = JSON.parse(xhr.responseText);\n        console.log(\" status -->, \" + json.status);\n    }\n};\nvar arguments = {" + parametersJson + "};\nvar json = {method:\"" + name + "\",arg:arguments};\nvar data = JSON.stringify(json);\nxhr.send(data);\n}\n";
        return js;
    }
}

