/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.JsUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.DivContainer;
import esecurity.desktop.dom.HTMLBlock;
import esecurity.desktop.dom.TreeNodeIter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TreeNode<T extends HTMLBlock>
extends DOMElement
implements Iterable<TreeNode<T>> {
    public T data;
    public TreeNode<T> parent;
    public List<TreeNode<T>> children;
    private boolean expanded;
    private Runnable onExpand;
    private Runnable onCollapse;
    private String childListId;
    private String contentId;
    private List<TreeNode<T>> elementsIndex;

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public TreeNode(String id, View view, String parentId, T data) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.data = data;
        this.children = new ArrayList<TreeNode<T>>();
        this.elementsIndex = new ArrayList<TreeNode<T>>();
        this.elementsIndex.add(this);
        this.expanded = true;
        this.createElementWithIDAndAppendIt("li", id, parentId);
        this.setInnerHTML(data.getHtml());
        this.childListId = id + "_childList";
        this.createElementWithIDAndAppendIt("ul", this.childListId, id);
    }

    public TreeNode(String id, View view, DOMElement parent, T data) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.data = data;
        this.children = new ArrayList<TreeNode<T>>();
        this.elementsIndex = new ArrayList<TreeNode<T>>();
        this.elementsIndex.add(this);
        this.expanded = true;
        this.createElementWithIDAndAppendIt("li", id, parent.getId());
        this.setInnerHTML(data.getHtml());
        this.createElementWithIDAndAppendIt("ul", id + "_childList", id);
    }

    public TreeNode(String id, View view, String parentId) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.children = new ArrayList<TreeNode<T>>();
        this.elementsIndex = new ArrayList<TreeNode<T>>();
        this.elementsIndex.add(this);
        this.expanded = true;
        this.createElementWithIDAndAppendIt("li", id, parentId);
        this.contentId = id + "_content";
        this.createElementWithIDAndAppendIt("div", this.contentId, id);
        this.childListId = id + "_childList";
        this.createElementWithIDAndAppendIt("ul", this.childListId, id);
    }

    public TreeNode(String id, View view, String parentId, String contentClassName) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.children = new ArrayList<TreeNode<T>>();
        this.elementsIndex = new ArrayList<TreeNode<T>>();
        this.elementsIndex.add(this);
        this.expanded = true;
        this.createElementWithIDAndAppendIt("li", id, parentId);
        this.contentId = id + "_content";
        DivContainer content = new DivContainer(this.contentId, id, view);
        content.addClass(contentClassName);
        this.childListId = id + "_childList";
        this.createElementWithIDAndAppendIt("ul", this.childListId, id);
    }

    public String getChildListId() {
        return this.childListId;
    }

    public String getContentID() {
        return this.contentId;
    }

    public TreeNode<T> addChild(String id, View view, T child) {
        TreeNode<T> childNode = new TreeNode<T>(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")").toString(), view, this.childListId, child);
        childNode.parent = this;
        this.children.add(childNode);
        this.registerChildForSearch(childNode);
        return childNode;
    }

    public TreeNode<T> addChild(TreeNode child) {
        child.parent = this;
        this.children.add(child);
        this.registerChildForSearch(child);
        return child;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isParentOf(TreeNode node) {
        Iterator<TreeNode<T>> it = this.iterator();
        boolean found = false;
        while (!found && it.hasNext()) {
            if (!node.equals(it.next())) continue;
            found = true;
        }
        return found;
    }

    public int getLevel() {
        if (this.isRoot()) {
            return 0;
        }
        return this.parent.getLevel() + 1;
    }

    private void registerChildForSearch(TreeNode<T> node) {
        this.elementsIndex.add(node);
        if (this.parent != null) {
            super.registerChildForSearch(node);
        }
    }

    public TreeNode<T> findTreeNode(Comparable<T> cmp) {
        for (TreeNode<T> element : this.elementsIndex) {
            T elData = element.data;
            if (cmp.compareTo(elData) != 0) continue;
            return element;
        }
        return null;
    }

    public String toString() {
        return this.data != null ? this.data.getHtml() : "[data null]";
    }

    @Override
    public Iterator<TreeNode<T>> iterator() {
        TreeNodeIter iterator = new TreeNodeIter(this);
        return iterator;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void collapse() {
        if (this.isLeaf()) {
            return;
        }
        for (TreeNode<T> child : this.children) {
            child.collapse();
            child.hide();
        }
        if (this.onCollapse != null) {
            new Thread(this.onCollapse).start();
        }
        this.expanded = false;
    }

    public void expand() {
        if (this.isLeaf()) {
            return;
        }
        for (TreeNode<T> child : this.children) {
            child.expand();
            child.show();
        }
        if (this.onExpand != null) {
            new Thread(this.onExpand).start();
        }
        this.expanded = true;
    }

    @Override
    public void show() {
        this.setVisible(true);
    }

    @Override
    public void hide() {
        this.setVisible(false);
    }

    public void onCollapse(Runnable callback) {
        this.onCollapse = callback;
    }

    public void onExpand(Runnable callback) {
        this.onExpand = callback;
    }

    public void delete() {
        this.remove();
    }
}

