/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop;

import esecurity.desktop.Event;
import esecurity.desktop.Listener;
import esecurity.desktop.ResUtils;
import esecurity.desktop.View;
import esecurity.desktop.annotation.JSFunction;
import esecurity.desktop.jetty.JettyView;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseController {
    public static final Logger logger = LoggerFactory.getLogger(BaseController.class);
    public static final AtomicInteger CONTROLLER_ID_SINGLETON = new AtomicInteger();
    protected View view = null;
    private String mainResource;
    private Document htmlDocument;
    private String id = "";
    private String bodyId = "";
    private Runnable onDragEnter = null;
    private Runnable onDragError = null;
    private Runnable onDragLeave = null;
    private Listener onDropEvent = null;
    private boolean loaded = false;
    protected BaseController parent;
    HashMap<String, Method> lstJsFunction = new HashMap();

    public BaseController() {
    }

    public BaseController(String mainResource, BaseController parentController) {
        this.initialize(mainResource, new ArrayList<String>(0), parentController);
    }

    public BaseController(String mainResource, List<String> javascript, BaseController parentController) {
        this.initialize(mainResource, javascript, parentController);
    }

    private void initialize(String mainResource, List<String> javascript, BaseController parentController) {
        Method[] methods;
        this.id = "" + CONTROLLER_ID_SINGLETON.getAndIncrement();
        this.mainResource = mainResource;
        this.parent = parentController;
        InputStream mainIs = this.getClass().getResourceAsStream(mainResource);
        String html = ResUtils.toString(mainIs, true);
        this.htmlDocument = Jsoup.parse((String)html);
        Element baseCss = this.htmlDocument.createElement("link");
        baseCss.attr("rel", "stylesheet");
        baseCss.attr("type", "text/css");
        baseCss.attr("href", "/esecurity/desktop/basecss/base.css");
        Element head = this.htmlDocument.head();
        baseCss.appendTo(head);
        if (this.parent == null) {
            Element jQuery = this.htmlDocument.createElement("script");
            jQuery.attr("src", "/esecurity/desktop/jquery/jquery-3.3.1.js");
            jQuery.appendTo(head);
            Element script = this.htmlDocument.createElement("script");
            script.attr("src", "/esecurity/desktop/basejs/base.js");
            script.appendTo(head);
        }
        for (String js : javascript) {
            Element scr = this.htmlDocument.createElement("script");
            scr.attr("src", js);
            scr.appendTo(head);
        }
        Element bodyElem = this.htmlDocument.body();
        if (bodyElem != null) {
            this.bodyId = bodyElem.id();
        }
        this.htmlDocument.html();
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.isAnnotationPresent(JSFunction.class)) continue;
            this.lstJsFunction.put("controller_" + this.id + "_" + method.getName(), method);
        }
    }

    @JSFunction
    public final void eventDispacher(String jsonEvent) {
        this.view.fireEvent(jsonEvent);
    }

    @JSFunction
    public final void info(String info) {
        logger.info("JS: " + info);
    }

    @JSFunction
    public final void error(String info) {
        logger.error("JS: " + info);
    }

    @JSFunction
    public final synchronized void viewOnLoad() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        logger.debug("viewOnLoad controller: " + this.id);
        if (this.view instanceof JettyView) {
            try {
                ((JettyView)this.view).waitViewReady();
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        for (String name : this.lstJsFunction.keySet()) {
            this.view.registerJsMethod(name, this);
        }
        String develop = System.getProperty("esecurity.desktop.develop", "false");
        if (!develop.equals("true")) {
            this.view.getDocument().addJavascriptEventListener("contextmenu", "preventDef");
        }
        this.view.enableDropEvent();
        this.documentOnLoad();
    }

    @JSFunction
    public final void onJSDragEnter() {
        this.view.onDragEnter();
    }

    @JSFunction
    public final void onJSDragEnd() {
        this.view.onDragEnd();
    }

    public void setDropListener(Listener<Event> listener) {
        this.onDropEvent = listener;
    }

    public Listener<Event> getDropListener() {
        return this.onDropEvent;
    }

    public void setOnDragEnter(Runnable onDragEnter) {
        this.onDragEnter = onDragEnter;
    }

    public Runnable getOnDragEnter() {
        return this.onDragEnter;
    }

    public void setOnDragError(Runnable onDragError) {
        this.onDragError = onDragError;
    }

    public void setOnDragLeave(Runnable onDragLeave) {
        this.onDragLeave = onDragLeave;
    }

    public Runnable getOnDragLeave() {
        return this.onDragLeave;
    }

    public void onDropEvent(Event event) {
        if (this.onDropEvent != null) {
            this.onDropEvent.notify(event);
        }
    }

    public void onDragError() {
        if (this.onDragError != null) {
            this.onDragError.run();
        }
    }

    public void onDragEnter() {
        if (this.onDragEnter != null) {
            this.onDragEnter.run();
        }
    }

    public void onDragLeave() {
        if (this.onDragLeave != null) {
            this.onDragLeave.run();
        }
    }

    protected void documentOnLoad() {
    }

    public String getMainResource() {
        return this.mainResource;
    }

    public Document getHtmlDocument() {
        return this.htmlDocument;
    }

    public void setView(View view) {
        this.view = view;
    }

    public View getView() {
        return this.view;
    }

    public void addJsMethod(Method method) {
        String name = "controller_" + this.id + "_" + method.getName();
        this.lstJsFunction.put(name, method);
        this.view.registerJsMethod(name, this);
    }

    public Method getJsMethod(String name) {
        return this.lstJsFunction.get(name);
    }

    public Set<String> getJsMethodNames() {
        return this.lstJsFunction.keySet();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBodyId(boolean recursively) {
        if (recursively && this.parent != null) {
            return this.parent.getBodyId(recursively);
        }
        return this.bodyId;
    }

    public void setTitle(String title) {
        if (this.parent != null) {
            this.parent.setTitle(title);
        } else if (this.view != null) {
            this.view.setTitle(title);
        }
    }

    public String getTitle() {
        if (this.parent != null) {
            return this.parent.getTitle();
        }
        if (this.view != null) {
            return this.view.getTitle();
        }
        return "";
    }

    static {
        CONTROLLER_ID_SINGLETON.set(1);
    }
}

