/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xades;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.bc.Base64;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.LTResourceResolver;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.ellips.capi.signature.TimeStampGenerator;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.util.SignUtils;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import it.actalis.ellips.capi.xades.XadesTransformation;
import it.actalis.ellips.capi.xades.a;
import it.actalis.ellips.capi.xades.b;
import it.actalis.ellips.capi.xades.c;
import it.actalis.ellips.capi.xades.d;
import it.actalis.ellips.capi.xades.e;
import it.actalis.ellips.capi.xades.enums.XadesSignatureProfile;
import it.actalis.ellips.capi.xades.exception.XadesModeException;
import it.actalis.ellips.capi.xml.DOMSubTreeData;
import it.actalis.ellips.capi.xml.InternalKeySelector;
import it.actalis.ellips.capi.xml.InternalUriDereferencer;
import it.actalis.ellips.capi.xml.utils.XMLUtils;
import it.actalis.vol.utils.Constants;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.crypto.dsig.spec.XSLTTransformParameterSpec;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XadesDocument {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private Document b = null;
    private DocumentBuilder c;
    private String d = null;
    private ProcessingInstruction e = null;
    private String f = "";
    private boolean g = false;
    private DOMSignContext h = null;
    private XMLSignature i = null;
    private NodeList j = null;
    private SimpleDateFormat k = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private String l = "";

    XadesDocument(InputHandler object) throws CapiException {
        try {
            object = object.getInputAsNewStream();
            Object object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            ((DocumentBuilderFactory)object2).setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            ((DocumentBuilderFactory)object2).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            ((DocumentBuilderFactory)object2).setFeature("http://xml.org/sax/features/external-general-entities", false);
            ((DocumentBuilderFactory)object2).setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.c = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            try {
                this.b = this.c.parse((InputStream)object);
                XadesDocument xadesDocument = this;
                object2 = xadesDocument.b;
                object = xadesDocument;
                xadesDocument.a((Node)object2);
                XadesDocument.b(this.b);
                this.g = true;
                object = this.b.getElementsByTagName("soapenv:Body");
                if (object != null && object.getLength() > 0) {
                    if ((object = (Element)object.item(0)) != null && object.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) {
                        this.l = object.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                    } else if (object != null && object.hasAttribute("Id")) {
                        this.l = object.getAttribute("Id");
                    }
                }
            }
            catch (SAXException sAXException) {
                a.error(sAXException.getMessage(), (Throwable)sAXException);
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
            }
            this.k.setTimeZone(TimeZone.getTimeZone("GMT"));
            return;
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Envelope format unknown or not implemented", 50023);
        }
    }

    final Document a(XadesSignatureOptions object, X509Certificate x509Certificate, PrivateKey privateKey, Provider provider) throws CapiException, CertificateEncodingException {
        a.debug("[addSigner] generating SOAP ENVELOPED Signature...");
        long l = System.currentTimeMillis();
        new StringBuilder("Signer-T-").append(l);
        if (object.getSignerId() != null) {
            object.getSignerId();
        }
        LinkedList linkedList = new LinkedList();
        LinkedList<Reference> linkedList2 = new LinkedList<Reference>();
        XadesDocument xadesDocument = this;
        xadesDocument.a(xadesDocument.b, object.getSignatureMode());
        XMLSignatureFactory xMLSignatureFactory = XMLUtils.getXMLSignatureFactoryInstance();
        Object object2 = this.b.getElementsByTagName("wsu:Timestamp");
        if (object2 != null && object2.getLength() > 0) {
            object2 = (Element)object2.item(0);
            object2.setAttribute("Id", "Timestamp");
            object2.setIdAttribute("Id", true);
            object2.setAttribute("xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            LinkedList<it.actalis.ellips.capi.core.Certificate> linkedList3 = new Date();
            Object object3 = new Date(((Date)((Object)linkedList3)).getTime() + 3600000L);
            Object object4 = this.b.createElement("wsu:Created");
            object4.setTextContent(this.k.format((Date)((Object)linkedList3)));
            linkedList3 = this.b.createElement("wsu:Expires");
            linkedList3.setTextContent(this.k.format((Date)object3));
            object2.appendChild((Node)object4);
            object2.appendChild((Node)((Object)linkedList3));
            this.b.getElementsByTagName("wsse:Security").item(0).appendChild((Node)object2);
            linkedList3 = this.b.createElement("wsse:BinarySecurityToken");
            linkedList3.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
            linkedList3.setAttribute("ValueType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            linkedList3.setAttribute("Id", "X509Token");
            linkedList3.setIdAttribute("Id", true);
            linkedList3.setTextContent(new String(Base64.encode((byte[])x509Certificate.getEncoded())));
            this.b.getElementsByTagName("wsse:Security").item(0).appendChild((Node)((Object)linkedList3));
            if (this.b == null) {
                throw new CapiException("Mimetype: " + object.getXmlMimetype() + " Enveloped Signature requires text/xml", 50025);
            }
            try {
                this.h = new DOMSignContext(privateKey, this.b.getElementsByTagName("wsse:Security").item(0));
                this.h.setURIDereferencer((URIDereferencer)new InternalUriDereferencer(null, null, null));
                linkedList3 = this.b.getElementsByTagName("soapenv:Body");
                object3 = null;
                if (linkedList3 != null && linkedList3.getLength() > 0) {
                    object3 = (Element)linkedList3.item(0);
                    if (object3 != null && object3.hasAttributeNS(this.f, this.f)) {
                        object3.setIdAttribute("wsu:Id", true);
                    } else if (object3 != null && object3.hasAttribute("Id")) {
                        object3.setIdAttribute("Id", true);
                    } else {
                        throw new CapiException("Attribute Id not found inside soap:body element!", 50025);
                    }
                }
                if (object3 == null) {
                    throw new CapiException("Element soap:body not found in document!", 50025);
                }
                ((Element)this.b.getElementsByTagName("wsu:Timestamp").item(0)).setIdAttribute("Id", true);
                object4 = this.b.createElement("wsse:SecurityTokenReference");
                linkedList3 = this.b.createElement("wsse:Reference");
                object4.appendChild((Node)((Object)linkedList3));
                linkedList3.setAttribute("URI", "#X509Token");
                linkedList3 = xMLSignatureFactory.getKeyInfoFactory();
                linkedList3 = ((KeyInfoFactory)((Object)linkedList3)).newKeyInfo(Collections.singletonList(new DOMStructure((Node)object4)), null);
                linkedList2.add(xMLSignatureFactory.newReference("#" + object2.getAttribute("Id"), xMLSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(xMLSignatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null)), null, null));
                linkedList2.add(xMLSignatureFactory.newReference("#" + object3.getAttribute("Id"), xMLSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null)));
                object2 = xMLSignatureFactory.newCanonicalizationMethod(object.getCanonicalizerOfSignedInfo(), (C14NMethodParameterSpec)null);
                object = SignUtils.algoByKeyAndDigest((PrivateKey)privateKey, (DigestAlgorithm)object.getDigestAlgorithm()).getXadesName();
                object = xMLSignatureFactory.newSignedInfo((CanonicalizationMethod)object2, xMLSignatureFactory.newSignatureMethod((String)object, null), linkedList2);
                this.i = xMLSignatureFactory.newXMLSignature((SignedInfo)object, (KeyInfo)((Object)linkedList3), linkedList, null, null);
            }
            catch (Exception exception) {
                if (a.isDebugEnabled()) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
                if (exception instanceof CapiException) {
                    throw (CapiException)exception;
                }
                throw new CapiException("An encoding or IO error during envelope operation occurred", 50025);
            }
            linkedList3 = new LinkedList<it.actalis.ellips.capi.core.Certificate>();
            object3 = new LinkedList<OCSPResp>();
            object4 = new LinkedList();
            this.h.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            this.h.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", provider);
            this.a(x509Certificate);
            XadesDocument xadesDocument2 = this;
            xadesDocument2.a(xadesDocument2.i, this.b, linkedList3);
            XadesDocument xadesDocument3 = this;
            xadesDocument3.c(xadesDocument3.i, this.b, (List<OCSPResp>)object3);
            XadesDocument xadesDocument4 = this;
            xadesDocument4.b(xadesDocument4.i, this.b, (List<CRL>)object4);
            return this.b;
        }
        throw new CapiException("Timestamp Element not found!", 1003);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Document b(XadesSignatureOptions xadesSignatureOptions4, X509Certificate x509Certificate, PrivateKey object, Provider object2) throws CapiException {
        LinkedList<OCSPResp> linkedList;
        void var5_9;
        Element element;
        Object var5_7 = null;
        if (xadesSignatureOptions4.getSignaturePath() != null && !xadesSignatureOptions4.getSignaturePath().isEmpty() && (element = this.a(xadesSignatureOptions4.getSignaturePath())) == null) {
            throw new CapiException("Invalid Signature Path", 1003);
        }
        if (var5_9 == null) {
            XadesDocument xadesDocument = this;
            xadesDocument.a(xadesDocument.b, xadesSignatureOptions4.getSignatureMode());
            try {
                Element element2;
                int n;
                XPath xPath = XPathFactory.newInstance().newXPath();
                linkedList = (NodeList)xPath.evaluate("//*[@id]", this.b, XPathConstants.NODESET);
                for (n = 0; n < linkedList.getLength(); ++n) {
                    element2 = (Element)linkedList.item(n);
                    element2.setIdAttribute("id", true);
                }
                linkedList = (NodeList)xPath.evaluate("//*[@Id]", this.b, XPathConstants.NODESET);
                for (n = 0; n < linkedList.getLength(); ++n) {
                    element2 = (Element)linkedList.item(n);
                    element2.setIdAttribute("Id", true);
                }
                linkedList = (NodeList)xPath.evaluate("//*[@ID]", this.b, XPathConstants.NODESET);
                for (n = 0; n < linkedList.getLength(); ++n) {
                    element2 = (Element)linkedList.item(n);
                    element2.setIdAttribute("ID", true);
                }
            }
            catch (XPathExpressionException xPathExpressionException) {
                a.error(xPathExpressionException.getMessage(), (Throwable)xPathExpressionException);
            }
            if (xadesSignatureOptions4.getSignatureMode() == SignatureMode.DETACHED) {
                this.b(xadesSignatureOptions4, x509Certificate, (PrivateKey)object);
            } else if (xadesSignatureOptions4.getSignatureMode() == SignatureMode.ENVELOPED) {
                boolean bl = false;
                Object object3 = object;
                linkedList = x509Certificate;
                XadesSignatureOptions xadesSignatureOptions2 = xadesSignatureOptions4;
                object = this;
                ((XadesDocument)object).a(xadesSignatureOptions2, (X509Certificate)((Object)linkedList), (PrivateKey)object3, null, null, false);
            } else if (xadesSignatureOptions4.getSignatureMode() == SignatureMode.ENVELOPING) {
                this.c(xadesSignatureOptions4, x509Certificate, (PrivateKey)object);
            } else {
                if (xadesSignatureOptions4.getSignatureMode() != SignatureMode.DETACHED_INTERNAL) throw new CapiException("Invalid Xades Mode", 50026);
                this.a(xadesSignatureOptions4, x509Certificate, (PrivateKey)object);
            }
        } else {
            Object object4 = object;
            void var7_21 = var5_9;
            linkedList = x509Certificate;
            object = this;
            XadesSignatureOptions xadesSignatureOptions3 = xadesSignatureOptions4;
            Object object5 = ((XadesDocument)object).a(xadesSignatureOptions3, ((XadesDocument)object).b, (Element)var7_21);
            if (object5 == null) {
                throw new CapiException("Unable to find signature to countersign", 50025);
            }
            try {
                super.a(xadesSignatureOptions3, (X509Certificate)((Object)linkedList), (PrivateKey)object4, (Element)object5, var7_21.getAttribute("Id"), true);
            }
            catch (Exception exception) {
                if (!a.isDebugEnabled()) throw new CapiException("CounterSignature encoding error", 50025);
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("CounterSignature encoding error", 50025);
            }
        }
        this.h.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
        this.h.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", object2);
        try {
            this.a(x509Certificate);
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        LinkedList<it.actalis.ellips.capi.core.Certificate> linkedList2 = new LinkedList<it.actalis.ellips.capi.core.Certificate>();
        linkedList = new LinkedList<OCSPResp>();
        LinkedList<CRL> linkedList3 = new LinkedList<CRL>();
        if (xadesSignatureOptions4.getSignatureLevel() != SignatureLevel.BES && xadesSignatureOptions4.getTimeStampOptions() != null) {
            XadesDocument xadesDocument = this;
            TimeStampToken timeStampToken = xadesDocument.a(xadesDocument.i, this.b, xadesSignatureOptions4);
            object = timeStampToken.getTSACert();
            if (!linkedList2.contains(object)) {
                linkedList2.add((it.actalis.ellips.capi.core.Certificate)object);
            }
            if (xadesSignatureOptions4.getSignatureLevel().compareTo((Enum)SignatureLevel.T) > 0) {
                try {
                    xadesSignatureOptions4 = new LTResourceResolver(xadesSignatureOptions4.getNetworkConfig(), a, xadesSignatureOptions4.getCertdb());
                    x509Certificate = xadesSignatureOptions4.resolve(new it.actalis.ellips.capi.core.Certificate(x509Certificate), timeStampToken.getDate());
                    for (Object object5 : x509Certificate.getCerts()) {
                        if (linkedList2.contains(object5)) continue;
                        linkedList2.add((it.actalis.ellips.capi.core.Certificate)object5);
                    }
                    for (Object object5 : x509Certificate.getCrls()) {
                        if (linkedList3.contains(object5)) continue;
                        linkedList3.add((CRL)object5);
                    }
                    for (Object object5 : x509Certificate.getOcsps()) {
                        if (linkedList.contains(object5)) continue;
                        linkedList.add(object5.getFullOcspResponse());
                    }
                    object2 = xadesSignatureOptions4.resolve((it.actalis.ellips.capi.core.Certificate)object, timeStampToken.getDate());
                    for (XadesSignatureOptions xadesSignatureOptions4 : object2.getCerts()) {
                        if (linkedList2.contains((Object)xadesSignatureOptions4)) continue;
                        linkedList2.add((it.actalis.ellips.capi.core.Certificate)xadesSignatureOptions4);
                    }
                    for (XadesSignatureOptions xadesSignatureOptions4 : object2.getCrls()) {
                        if (linkedList3.contains((Object)xadesSignatureOptions4)) continue;
                        linkedList3.add((CRL)xadesSignatureOptions4);
                    }
                    for (XadesSignatureOptions xadesSignatureOptions4 : object2.getOcsps()) {
                        if (linkedList.contains((Object)xadesSignatureOptions4)) continue;
                        linkedList.add(xadesSignatureOptions4.getFullOcspResponse());
                    }
                }
                catch (IOException | CertificateException exception) {
                    a.error(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Unable to resolve resources for certificate", 50040, (Throwable)exception);
                }
            }
        }
        XadesDocument xadesDocument = this;
        xadesDocument.a(xadesDocument.i, this.b, linkedList2);
        XadesDocument xadesDocument2 = this;
        xadesDocument2.c(xadesDocument2.i, this.b, linkedList);
        XadesDocument xadesDocument3 = this;
        xadesDocument3.b(xadesDocument3.i, this.b, linkedList3);
        return this.b;
    }

    final Document a(XadesSignatureOptions object) throws CapiException {
        block12: {
            try {
                Object object2;
                NodeList nodeList;
                boolean bl;
                Object object3;
                Object object4 = this.a(object.getSignaturePath());
                Element element = object4;
                Object object5 = object4.getElementsByTagName("xades:UnsignedProperties");
                if ((object5 == null || object5.getLength() == 0 ? false : ((object3 = element.getElementsByTagName("xades:UnsignedSignatureProperties")) == null || object3.getLength() == 0 ? false : (bl = (nodeList = element.getElementsByTagName("xades:SignatureTimeStamp")) != null && nodeList.getLength() != 0))) && SignatureLevel.T.equals((Object)object.getSignatureLevel())) {
                    return this.b;
                }
                if (!bl) {
                    object5 = object;
                    XadesDocument xadesDocument = this;
                    object2 = object4;
                    object3 = xadesDocument.b((Element)object2);
                    if (object3 != null) {
                        xadesDocument.a((Element)object2, (Node)object3, (XadesSignatureOptions)((Object)object5));
                    } else {
                        object3 = xadesDocument.b.createElement("xades:UnsignedProperties");
                        xadesDocument.a((Element)object2, (Node)object3, (XadesSignatureOptions)((Object)object5));
                        nodeList = object2.getElementsByTagName("xades:QualifyingProperties");
                        nodeList.item(0).appendChild((Node)object3);
                    }
                }
                if (!SignatureLevel.LT.equals((Object)object.getSignatureLevel())) break block12;
                object5 = object;
                XadesDocument xadesDocument = this;
                object2 = object4;
                object3 = xadesDocument.c((Element)object2);
                if (object3 == null) {
                    throw new CapiException("xades:UnsignedSignatureProperties element not present", 3003);
                }
                nodeList = xadesDocument.a((Element)object2);
                object = new LinkedList();
                object4 = new LinkedList();
                LinkedList<CRL> linkedList = new LinkedList<CRL>();
                XadesDocument.a((Element)object2, (List<it.actalis.ellips.capi.core.Certificate>)object);
                Object object6 = object2;
                object6 = object6.getElementsByTagName("xades:EncapsulatedTimeStamp");
                if (object6 == null || object6.getLength() == 0) {
                    throw new CapiException("", 3003);
                }
                object6 = object6.item(0);
                object6 = object6.getFirstChild().getNodeValue();
                it.actalis.ellips.capi.core.Certificate certificate = (object6 = new TimeStampToken(Base64.decode((String)object6))).getTSACert();
                if (!object.contains(certificate)) {
                    object.add(certificate);
                }
                try {
                    object5 = new LTResourceResolver(object5.getNetworkConfig(), a, object5.getCertdb());
                    XadesDocument.a((it.actalis.ellips.capi.core.Certificate)nodeList, object6.getDate(), (List<it.actalis.ellips.capi.core.Certificate>)object, (List<OCSPResp>)object4, linkedList, (LTResourceResolver)object5);
                    XadesDocument.a(certificate, object6.getDate(), (List<it.actalis.ellips.capi.core.Certificate>)object, (List<OCSPResp>)object4, linkedList, (LTResourceResolver)object5);
                }
                catch (IOException | CertificateException exception) {
                    a.error(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Unable to resolve resources for certificate", 50040, (Throwable)exception);
                }
                xadesDocument.a((Node)object3, xadesDocument.b, (List<it.actalis.ellips.capi.core.Certificate>)object);
                object5 = object2.getElementsByTagName("xades:RevocationValues");
                object = object5 == null || object5.getLength() == 0 ? xadesDocument.b.createElement("xades:RevocationValues") : object5.item(0);
                XadesDocument.c((Node)object, xadesDocument.b, (List<OCSPResp>)object4);
                XadesDocument.b((Node)object, xadesDocument.b, linkedList);
                object3.appendChild((Node)object);
            }
            catch (Exception exception) {
                if (a.isDebugEnabled()) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
                throw new CapiException("CounterSignature encoding error", 50025);
            }
        }
        return this.b;
    }

    private void a(Element element, Node node, XadesSignatureOptions xadesSignatureOptions) throws CapiException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, TransformException {
        Element element2 = this.c(element);
        if (element2 != null) {
            this.b(element, element2, xadesSignatureOptions);
            return;
        }
        element2 = this.b.createElement("xades:UnsignedSignatureProperties");
        this.b(element, element2, xadesSignatureOptions);
        node.appendChild(element2);
    }

    private void b(Element element, Node node, XadesSignatureOptions xadesSignatureOptions) throws CapiException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, TransformException {
        Object object = element.getElementsByTagName("xades:SignatureTimeStamp");
        if (object != null && object.getLength() != 0) {
            return;
        }
        object = this.b.createElement("xades:SignatureTimeStamp");
        this.c(element, (Node)object, xadesSignatureOptions);
        node.appendChild((Node)object);
    }

    private void c(Element object, Node node, XadesSignatureOptions xadesSignatureOptions) throws CapiException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, TransformException {
        Element element = this.b.createElement("ds:CanonicalizationMethod");
        Element element2 = this.b.createElement("xades:EncapsulatedTimeStamp");
        element.setAttribute("Algorithm", "http://www.w3.org/2006/12/xml-c14n11#WithComments");
        object = this.a((Element)object, xadesSignatureOptions);
        element2.appendChild(this.b.createTextNode(Base64.toBase64String((byte[])object)));
        element2.setAttribute("Encoding", "http://uri.etsi.org/01903/v1.2.2#DER");
        node.appendChild(element);
        node.appendChild(element2);
    }

    private byte[] a(Element object, XadesSignatureOptions xadesSignatureOptions) throws CapiException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, TransformException {
        object = object.getElementsByTagName("ds:SignatureValue");
        object = object.item(0);
        TransformService transformService = TransformService.getInstance("http://www.w3.org/2006/12/xml-c14n11#WithComments", "DOM");
        DOMValidateContext dOMValidateContext = new DOMValidateContext((KeySelector)new InternalKeySelector(null), (Node)object);
        transformService.init(new DOMStructure((Node)object), null);
        object = transformService.transform((Data)new DOMSubTreeData((Node)object, false), dOMValidateContext);
        object = ((OctetStreamData)object).getOctetStream();
        byte[] byArray = IOUtils.toByteArray((InputStream)object);
        object = byArray;
        return XadesDocument.a(byArray, xadesSignatureOptions);
    }

    private static void a(Element object, List<it.actalis.ellips.capi.core.Certificate> list) throws CapiException {
        String string = "xades:CertificateValues";
        if ((object = object.getElementsByTagName(string)) == null || object.getLength() == 0) {
            return;
        }
        object = object.item(0);
        if ((object = object.getChildNodes()) == null || object.getLength() == 0) {
            return;
        }
        for (int i = 0; i < object.getLength(); ++i) {
            Object object2 = object.item(i);
            object2 = object2.getFirstChild().getNodeValue();
            list.add(new it.actalis.ellips.capi.core.Certificate(Base64.decode((String)object2)));
        }
    }

    private it.actalis.ellips.capi.core.Certificate a(Element element) throws MarshalException {
        Object object3;
        Object object2;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        NodeList nodeList = element.getElementsByTagName("ds:KeyInfo");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object2 = nodeList.item(i);
            DOMStructure dOMStructure = new DOMStructure((Node)object2);
            object2 = KeyInfoFactory.getInstance().unmarshalKeyInfo(dOMStructure).getContent();
            for (int j = 0; j < object2.size(); ++j) {
                object3 = (XMLStructure)object2.get(j);
                if (!(object3 instanceof X509Data)) continue;
                for (Object object3 : ((X509Data)object3).getContent()) {
                    if (!(object3 instanceof X509Certificate)) continue;
                    object3 = (X509Certificate)object3;
                    arrayList.add((X509Certificate)object3);
                }
            }
        }
        String string = null;
        object2 = null;
        Object object4 = element.getElementsByTagName("xades:SigningCertificate");
        if (object4.getLength() == 0) {
            object4 = element.getElementsByTagName("xades:SigningCertificateV2");
        }
        if (object4.getLength() != 0) {
            object2 = object4.item(0);
            object4 = XadesDocument.a((Node)object2, "xades:Cert");
            object3 = XadesDocument.a((Node)object4, "xades:CertDigest");
            Node node = XadesDocument.a((Node)object3, "ds:DigestMethod");
            object3 = XadesDocument.a((Node)object3, "ds:DigestValue");
            object2 = node.getAttributes().getNamedItem("Algorithm").getNodeValue();
            string = object3.getFirstChild().getNodeValue();
        }
        return XadesDocument.a(arrayList, string, (String)object2);
    }

    private static void a(it.actalis.ellips.capi.core.Certificate certificate, Date iterator, List<it.actalis.ellips.capi.core.Certificate> list, List<OCSPResp> list2, List<CRL> list3, LTResourceResolver lTResourceResolver2) throws CapiException, IOException, CertificateException {
        certificate = lTResourceResolver2.resolve(certificate, (Date)((Object)iterator));
        for (LTResourceResolver lTResourceResolver2 : certificate.getCerts()) {
            if (list.contains(lTResourceResolver2)) continue;
            list.add((it.actalis.ellips.capi.core.Certificate)lTResourceResolver2);
        }
        for (LTResourceResolver lTResourceResolver2 : certificate.getCrls()) {
            if (list3.contains(lTResourceResolver2)) continue;
            list3.add((CRL)lTResourceResolver2);
        }
        for (LTResourceResolver lTResourceResolver2 : certificate.getOcsps()) {
            if (list2.contains(lTResourceResolver2.getFullOcspResponse())) continue;
            list2.add(lTResourceResolver2.getFullOcspResponse());
        }
    }

    private static it.actalis.ellips.capi.core.Certificate a(List<X509Certificate> object, String string, String object2) {
        try {
            object2 = MessageDigest.getInstance(DigestAlgorithm.valueFromXadesId((String)object2).getId(), ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.error(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            return null;
        }
        object = object.iterator();
        while (object.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)object.next();
            try {
                if (!MessageDigest.isEqual(Base64.decode((String)string), ((MessageDigest)object2).digest(x509Certificate.getEncoded()))) continue;
                return new it.actalis.ellips.capi.core.Certificate(x509Certificate);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            }
        }
        return null;
    }

    private void a(X509Certificate x509Certificate) throws CapiException {
        try {
            x509Certificate = new it.actalis.ellips.capi.core.Certificate(x509Certificate.getEncoded());
            if (x509Certificate.isRsVerified()) {
                throw new UnsupportedOperationException("to be ported from XMLSEC");
            }
            this.i.sign(this.h);
        }
        catch (MarshalException marshalException) {
            if (a.isDebugEnabled()) {
                a.debug(marshalException.getMessage(), (Throwable)marshalException);
            }
            throw new CapiException("MarshalException error occurred: " + marshalException.getMessage(), 50025, (Throwable)marshalException);
        }
        catch (XMLSignatureException xMLSignatureException) {
            if (a.isDebugEnabled()) {
                a.debug(xMLSignatureException.getMessage(), (Throwable)xMLSignatureException);
            }
            throw new CapiException("XMLSignatureException error occurred: " + xMLSignatureException.getMessage(), 50025, (Throwable)xMLSignatureException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            if (a.isDebugEnabled()) {
                a.debug(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            }
            throw new CapiException("CertificateEncodingException error occurred: " + certificateEncodingException.getMessage(), 50025, (Throwable)certificateEncodingException);
        }
    }

    private void a(XadesSignatureOptions object, X509Certificate object2, PrivateKey privateKey) throws CapiException {
        Document document;
        block32: {
            a.debug("[addSigner] generating XML DETACHED internal Signature...");
            InputStream inputStream = null;
            document = this.c.newDocument();
            long l = System.currentTimeMillis();
            String string = "Signer-T-" + l;
            if (object.getSignerId() != null) {
                string = object.getSignerId();
            }
            LinkedList<XMLObject> linkedList = new LinkedList<XMLObject>();
            LinkedList<Transform> linkedList2 = new LinkedList<Transform>();
            LinkedList<Reference> linkedList3 = new LinkedList<Reference>();
            XMLSignatureFactory xMLSignatureFactory = XMLUtils.getXMLSignatureFactoryInstance();
            try {
                inputStream = object.getInput().getInputAsNewStream();
                if (this.b != null) {
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    if (this.j != null && this.j.getLength() > 0) {
                        document = this.b;
                        object8 = this.b.getDocumentElement().getTagName();
                        if (((String)object8).endsWith(":Signature") || ((String)object8).compareToIgnoreCase("Signature") == 0) {
                            Element element = this.b.getDocumentElement();
                            object7 = this.b.getDocumentElement().cloneNode(true);
                            object6 = this.b.createElement("Envelope");
                            object6.appendChild((Node)object7);
                            this.b.replaceChild((Node)object6, element);
                            XadesDocument.b(this.b);
                        } else {
                            object6 = this.b.getDocumentElement();
                        }
                        this.h = new DOMSignContext(privateKey, (Node)object6);
                        this.h.setURIDereferencer((URIDereferencer)new InternalUriDereferencer(null, null, null));
                        if (!XadesDocument.a(document, linkedList2, object.getXmlTransforms(), xMLSignatureFactory)) {
                            linkedList2 = null;
                        }
                        if (object.getXmlTargetID() != null) {
                            object5 = object.getXmlTargetID();
                        } else {
                            object7 = "";
                            object4 = XadesDocument.a((Node)this.b.getDocumentElement(), "Object");
                            if (object4 != null && object4.hasAttributes() && object4.getAttributes().getNamedItem("Id") != null) {
                                object7 = object4.getAttributes().getNamedItem("Id").getTextContent();
                            } else {
                                object3 = XadesDocument.a((Node)this.b.getDocumentElement(), "Signature");
                                if (object3 != null && (object4 = XadesDocument.a((Node)object3, "Object")) != null && object4.hasAttributes() && object4.getAttributes().getNamedItem("Id") != null) {
                                    object7 = "xpointer(id('" + object4.getAttributes().getNamedItem("Id").getTextContent() + "'))";
                                }
                            }
                            object5 = object7;
                        }
                        linkedList3.add(xMLSignatureFactory.newReference("#" + (String)object5, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), linkedList2, null, "r-doc-" + string));
                    } else {
                        object6 = document.createElement("Envelope");
                        document.appendChild((Node)object6);
                        this.h = new DOMSignContext(privateKey, (Node)object6);
                        this.h.setURIDereferencer((URIDereferencer)new InternalUriDereferencer(null, null, null));
                        object8 = document.createElement("ds:Object");
                        object5 = "ToBeSigned" + l;
                        object8.setAttribute("Id", (String)object5);
                        object8.setAttribute("Encoding", "UTF-8");
                        object8.setAttribute("MimeTYpe", "text/xml");
                        object8.setIdAttribute("Id", true);
                        object8.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
                        object6.appendChild((Node)object8);
                        if (this.b != null) {
                            if (this.e != null) {
                                object8.appendChild(document.createProcessingInstruction(this.e.getTarget(), this.e.getData()));
                            }
                            object7 = document.importNode(this.b.getDocumentElement(), true);
                            object8.appendChild((Node)object7);
                        } else {
                            object7 = new BufferedReader(new InputStreamReader(inputStream));
                            object4 = new StringBuilder();
                            while ((object3 = ((BufferedReader)object7).readLine()) != null) {
                                ((StringBuilder)object4).append(((String)object3).concat("\n"));
                            }
                            inputStream.close();
                            object8.appendChild(document.createTextNode(((StringBuilder)object4).toString()));
                        }
                        if (!XadesDocument.a(document, linkedList2, object.getXmlTransforms(), xMLSignatureFactory)) {
                            linkedList2 = null;
                        }
                        linkedList3.add(xMLSignatureFactory.newReference("#" + (String)object5, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), linkedList2, null, "r-doc-" + string));
                    }
                    object6 = object.getSigningTime();
                    if (object6 == null) {
                        object6 = new Date();
                    }
                    if (this.d != null) {
                        object8 = xMLSignatureFactory.newReference(this.d, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, null, "r-stylesheet-" + string);
                        try {
                            this.h.getURIDereferencer().dereference(new a(this), this.h);
                            linkedList3.add((Reference)object8);
                        }
                        catch (NullPointerException | URIReferenceException exception) {
                            a.warn("Can't add {} to referenced signature", (Object)object8.getURI());
                        }
                    }
                    linkedList3.add(xMLSignatureFactory.newReference("#SignedProperties-" + string, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, "http://uri.etsi.org/01903#SignedProperties", null));
                    object8 = new LinkedList<X509Certificate>();
                    ((LinkedList)object8).add(object2);
                    object5 = xMLSignatureFactory.getKeyInfoFactory();
                    object7 = ((KeyInfoFactory)object5).newX509Data((List<?>)object8);
                    object4 = "KeyInfo-" + string;
                    object3 = ((KeyInfoFactory)object5).newKeyInfo(Collections.singletonList(object7), (String)object4);
                    linkedList3.add(xMLSignatureFactory.newReference("#" + (String)object4, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, null, "r-keyinfo-" + string));
                    linkedList.add(this.a((XadesSignatureOptions)((Object)object), (Date)object6, xMLSignatureFactory, document, (X509Certificate)object2, string, (List<Reference>)linkedList3));
                    object2 = xMLSignatureFactory.newCanonicalizationMethod(object.getCanonicalizerOfSignedInfo(), (C14NMethodParameterSpec)null);
                    object = SignUtils.algoByKeyAndDigest((PrivateKey)privateKey, (DigestAlgorithm)object.getDigestAlgorithm()).getXadesName();
                    object = xMLSignatureFactory.newSignedInfo((CanonicalizationMethod)object2, xMLSignatureFactory.newSignatureMethod((String)object, null), linkedList3);
                    this.i = xMLSignatureFactory.newXMLSignature((SignedInfo)object, (KeyInfo)object3, linkedList, string, "SignatureValue-" + string);
                    break block32;
                }
                throw new CapiException("Unable make Dethaced Interna if XML file", 50050);
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2 = runtimeException;
                if (runtimeException.getMessage().equals("Interrupted by user")) {
                    throw new CapiException("Interrupted by user", 50052);
                }
                if (a.isDebugEnabled()) {
                    a.debug(runtimeException2.getMessage(), (Throwable)runtimeException2);
                }
                throw new CapiException("RuntimeException" + runtimeException2.getMessage(), 50025);
            }
            catch (CapiException capiException) {
                if (a.isDebugEnabled()) {
                    a.debug(capiException.getMessage(), (Throwable)capiException);
                }
                throw capiException;
            }
            catch (Exception exception) {
                if (a.isDebugEnabled()) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
                throw new CapiException("An encoding or IO error during envelope operation occurred", 50025);
            }
            finally {
                Util.closeQuietly((Closeable)inputStream);
            }
        }
        this.b = document;
    }

    private void b(XadesSignatureOptions object, X509Certificate object2, PrivateKey privateKey) throws CapiException {
        a.debug("[addSigner] generating XML DETACHED Signature...");
        XMLSignatureFactory xMLSignatureFactory = XMLUtils.getXMLSignatureFactoryInstance();
        long l = System.currentTimeMillis();
        String string = "Signer-T-" + l;
        if (object.getSignerId() != null) {
            string = object.getSignerId();
        }
        LinkedList<XMLObject> linkedList = new LinkedList<XMLObject>();
        Object object3 = new LinkedList<Transform>();
        LinkedList<Reference> linkedList2 = new LinkedList<Reference>();
        InputStream inputStream = null;
        try {
            inputStream = object.getInput().getInputAsNewStream();
            this.b = this.c.newDocument();
            this.h = new DOMSignContext(privateKey, (Node)this.b);
            Object object4 = new InternalUriDereferencer(null, null, null);
            this.h.setURIDereferencer((URIDereferencer)object4);
            object4.addDocument(object.getInput());
            if (object.getSignerId() != null) {
                string = object.getSignerId();
            }
            if ((object4 = object.getSigningTime()) == null) {
                object4 = new Date();
            }
            if (!XadesDocument.a(this.b, object3, object.getXmlTransforms(), xMLSignatureFactory)) {
                object3 = null;
            }
            for (int i = 0; i < object.getDetachedURI().size(); ++i) {
                linkedList2.add(xMLSignatureFactory.newReference((String)object.getDetachedURI().get(i), xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), (List<? extends Transform>)object3, null, "r-id-1"));
            }
            linkedList2.add(xMLSignatureFactory.newReference(object.getInput().getName(), xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), (List<? extends Transform>)object3, null, "r-doc-" + string));
            if (this.d != null) {
                Reference reference = xMLSignatureFactory.newReference(this.d, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, null, "r-stylesheet-" + string);
                try {
                    this.h.getURIDereferencer().dereference(new b(this), this.h);
                    linkedList2.add(reference);
                }
                catch (NullPointerException | URIReferenceException exception) {
                    a.warn("Can't add {} to referenced signature", (Object)reference.getURI());
                }
            }
            linkedList2.add(xMLSignatureFactory.newReference("#SignedProperties-" + string, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, "http://uri.etsi.org/01903#SignedProperties", null));
            Object object5 = new LinkedList<X509Certificate>();
            ((LinkedList)object5).add(object2);
            object3 = xMLSignatureFactory.getKeyInfoFactory();
            object5 = ((KeyInfoFactory)object3).newX509Data((List<?>)object5);
            String string2 = "KeyInfo-" + string;
            object3 = ((KeyInfoFactory)object3).newKeyInfo(Collections.singletonList(object5), string2);
            linkedList2.add(xMLSignatureFactory.newReference("#" + string2, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, null, "r-keyinfo-" + string));
            linkedList.add(this.a((XadesSignatureOptions)((Object)object), (Date)object4, xMLSignatureFactory, this.b, (X509Certificate)object2, string, (List<Reference>)linkedList2));
            object2 = xMLSignatureFactory.newCanonicalizationMethod(object.getCanonicalizerOfSignedInfo(), (C14NMethodParameterSpec)null);
            object = SignUtils.algoByKeyAndDigest((PrivateKey)privateKey, (DigestAlgorithm)object.getDigestAlgorithm()).getXadesName();
            object = xMLSignatureFactory.newSignedInfo((CanonicalizationMethod)object2, xMLSignatureFactory.newSignatureMethod((String)object, null), linkedList2);
            this.i = xMLSignatureFactory.newXMLSignature((SignedInfo)object, (KeyInfo)object3, linkedList, string, "SignatureValue-" + string);
            return;
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            if (runtimeException.getMessage().equals("Interrupted by user")) {
                throw new CapiException("Interrupted by user", 50052);
            }
            if (a.isDebugEnabled()) {
                a.debug(runtimeException2.getMessage(), (Throwable)runtimeException2);
            }
            throw new CapiException("RuntimeException" + runtimeException2.getMessage(), 50025);
        }
        catch (CapiException capiException) {
            if (a.isDebugEnabled()) {
                a.debug(capiException.getMessage(), (Throwable)capiException);
            }
            throw capiException;
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("An encoding or IO error during envelope operation occurred", 50025);
        }
        finally {
            Util.closeQuietly((Closeable)inputStream);
        }
    }

    private static Node a(Node object, String string) {
        if (!object.hasChildNodes()) {
            return null;
        }
        object = object.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            short s = object.item(i).getNodeType();
            if (s != 1 || !object.item(i).getNodeName().endsWith(string)) continue;
            return object.item(i);
        }
        return null;
    }

    private void a(XMLSignature object, Document document, List<it.actalis.ellips.capi.core.Certificate> list) throws CapiException {
        if (list.size() > 0) {
            if (a.isDebugEnabled()) {
                a.debug("[addCertificateValues] Add Additional  X509Certificate Values...");
            }
            object = this.b((XMLSignature)object, document);
            this.a((Node)object, document, list);
        }
    }

    private void a(Node node, Document document, List<it.actalis.ellips.capi.core.Certificate> object) throws CapiException {
        node = XadesDocument.a(node, document);
        try {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (it.actalis.ellips.capi.core.Certificate)object.next();
                Element element = document.createElement("xades:EncapsulatedX509Certificate");
                object2 = Util.base64EncodeStr((byte[])object2.getDerEncoded());
                object2 = document.createTextNode((String)object2);
                element.appendChild((Node)object2);
                node.appendChild(element);
            }
            return;
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw new CapiException("Unable To Encode Cert", 50050);
        }
    }

    private static Node a(Node node, Document node2) {
        NodeList nodeList = node.getChildNodes();
        String string = "xades:CertificateValues";
        if (nodeList != null && nodeList.getLength() != 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (!string.equals(node3.getNodeName())) continue;
                return node3;
            }
        }
        node2 = node2.createElement(string);
        node.appendChild(node2);
        return node2;
    }

    private void b(XMLSignature object, Document document, List<CRL> list) throws CapiException {
        if (list.isEmpty()) {
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("[addCertificateValues] Add Additional  X509Certificate Values...");
        }
        object = (Element)this.a((XMLSignature)object, document);
        XadesDocument.b((Node)object, document, list);
    }

    private static void b(Node object, Document document, List<CRL> object22) throws CapiException {
        if (object22 == null || object22.isEmpty()) {
            return;
        }
        Element element = document.createElement("xades:CRLValues");
        object.appendChild(element);
        try {
            for (Object object22 : object22) {
                Element element2 = document.createElement("xades:EncapsulatedCRLValue");
                object22 = Util.base64EncodeStr((byte[])object22.getInternalCRL().getEncoded());
                object22 = document.createTextNode((String)object22);
                element2.appendChild((Node)object22);
                element.appendChild(element2);
            }
            return;
        }
        catch (CRLException cRLException) {
            a.error(cRLException.getMessage(), (Throwable)cRLException);
            throw new CapiException("Unable To Encode Cert", 50050);
        }
    }

    private void c(XMLSignature object, Document document, List<OCSPResp> list) throws CapiException {
        if (list.isEmpty()) {
            return;
        }
        if (a.isDebugEnabled()) {
            a.debug("[addCertificateValues] Add Additional  X509Certificate Values...");
        }
        object = (Element)this.a((XMLSignature)object, document);
        XadesDocument.c((Node)object, document, list);
    }

    private static void c(Node object, Document document, List<OCSPResp> object22) throws CapiException {
        if (object22 == null || object22.isEmpty()) {
            return;
        }
        Element element = document.createElement("xades:OCSPValues");
        object.appendChild(element);
        try {
            for (Object object22 : object22) {
                Element element2 = document.createElement("xades:EncapsulatedOCSPValue");
                object22 = Util.base64EncodeStr((byte[])object22.getEncoded());
                element2.appendChild(document.createTextNode((String)object22));
                element.appendChild(element2);
            }
            return;
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            throw new CapiException("Unable To Encode Cert", 50050);
        }
    }

    private Node a(XMLSignature object, Document object2) throws CapiException {
        try {
            object = this.b((XMLSignature)object, (Document)object2);
            Document document = object2;
            object2 = object;
            object = this;
            object = (Element)XadesDocument.a((Node)object2, "RevocationValues");
            if (object == null) {
                object = document.createElement("xades:RevocationValues");
                object2.appendChild((Node)object);
            }
            return object;
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("An error occurred adding retrieveXadesRevocationValues", 50025);
        }
    }

    private TimeStampToken a(XMLSignature object, Document document, XadesSignatureOptions object2) throws CapiException {
        Object object3;
        Node node;
        Object object4;
        if (a.isDebugEnabled()) {
            a.debug("[addSignatureTimeStamp] getting Time Stamp Token from TSA ...");
        }
        try {
            object4 = object.getId();
            node = document.getElementById((String)object4);
            node = (Element)XadesDocument.a(node, "SignatureValue");
            object3 = node.getAttribute("Id");
            if (object3 == null || ((String)object3).equals("")) {
                object3 = "SignatureValue-" + (String)object4;
                node.setAttributeNS(null, "Id", (String)object3);
                node.setIdAttribute("Id", true);
                a.info("[addSigner] Signature Value Id setted to: " + (String)object3);
            } else {
                a.info("[addSigner] Signature Value Id is: " + (String)object3);
            }
            object4 = TransformService.getInstance("http://www.w3.org/2006/12/xml-c14n11#WithComments", "DOM");
            object3 = new DOMValidateContext((KeySelector)new InternalKeySelector(null), node);
            ((TransformService)object4).init(new DOMStructure(node), null);
            object4 = object4.transform((Data)new DOMSubTreeData(node, false), (XMLCryptoContext)object3);
            object4 = ((OctetStreamData)object4).getOctetStream();
            byte[] byArray = IOUtils.toByteArray((InputStream)object4);
            object4 = byArray;
            object2 = XadesDocument.a(byArray, object2);
        }
        catch (CapiException capiException) {
            CapiException capiException2 = capiException;
            if (capiException instanceof TSAException) {
                throw capiException2;
            }
            throw new CapiException(capiException2.getMessage(), 50053);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | TransformException exception) {
            throw new CapiException("Invalid Canonicalizer Exception generating Time Stamp Token", 50053);
        }
        catch (IOException iOException) {
            throw new CapiException("Invalid Exception generating Time Stamp Token", 50053);
        }
        if (object2 == null) {
            throw new CapiException("An error occurred getting Time Stamp Token from TSA", 50053);
        }
        if (a.isDebugEnabled()) {
            a.debug("[addSignatureTimeStamp] Time Stamp Token received from TSA.");
        }
        object4 = Util.base64EncodeStr((byte[])object2);
        if (a.isDebugEnabled()) {
            a.debug("[addSignatureTimeStamp] Time Stamp Token has been base64 encoded.");
        }
        if (a.isDebugEnabled()) {
            a.debug("[addSignatureTimeStamp] SignatureTimeStamp node preparing ...");
        }
        node = this.b((XMLSignature)object, document);
        object = document.createElement("xades:SignatureTimeStamp");
        node.appendChild((Node)object);
        try {
            if (a.isDebugEnabled()) {
                a.debug("[addSignatureTimeStamp] setting CanonicalizationMethod...");
            }
            node = document.createElement("ds:CanonicalizationMethod");
            node.setAttributeNS(null, "Algorithm", "http://www.w3.org/2006/12/xml-c14n11#WithComments");
            object.appendChild(node);
            if (a.isDebugEnabled()) {
                a.debug("[addSignatureTimeStamp] setting EncapsulatedTimeStamp...");
            }
            object3 = document.createElement("xades:EncapsulatedTimeStamp");
            object3.setAttributeNS(null, "Encoding", "http://uri.etsi.org/01903/v1.2.2#DER");
            object.appendChild((Node)object3);
            if (a.isDebugEnabled()) {
                a.debug("[addSignatureTimeStamp] setting Base64TimeStamp...to: " + (String)object4);
            }
            object4 = document.createTextNode((String)object4);
            object3.appendChild((Node)object4);
            if (a.isDebugEnabled()) {
                a.debug("[addSignatureTimeStamp] SignatureTimeStamp generated.");
            }
            return new TimeStampToken((byte[])object2);
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug("[addSignatureTimeStamp] Error generating SignatureTimeStamp" + exception.getMessage());
            }
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error generating SignatureTimeStamp", 50023);
        }
    }

    private Node b(XMLSignature xMLSignature, Document document) throws CapiException {
        Node node = null;
        try {
            String string = xMLSignature.getId();
            if (string == null || string.equals("")) {
                long l = System.currentTimeMillis();
                new StringBuilder("Signer-T-").append(l);
            }
            int n = xMLSignature.getObjects().size();
            Node node2 = null;
            for (int i = 0; i < n; ++i) {
                Object object = xMLSignature.getObjects().get(i).getContent();
                object = object.iterator();
                while (object.hasNext()) {
                    Object e2 = object.next();
                    if (!(e2 instanceof DOMStructure) || !((DOMStructure)e2).getNode().getNodeName().endsWith("QualifyingProperties")) continue;
                    node2 = (Element)((DOMStructure)e2).getNode();
                    break;
                }
                if (node2 != null) break;
            }
            if (node2 != null) {
                Node node3 = XadesDocument.a(node2, "UnsignedProperties");
                if (node3 == null) {
                    node3 = document.createElement("xades:UnsignedProperties");
                    node2.appendChild(node3);
                    node = document.createElement("xades:UnsignedSignatureProperties");
                    node3.appendChild(node);
                } else {
                    node = XadesDocument.a(node3, "UnsignedSignatureProperties");
                }
            }
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("An error occurred adding signature time stamp", 50025);
        }
        return node;
    }

    private static byte[] a(byte[] byArray, XadesSignatureOptions xadesSignatureOptions) throws CapiException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            byArray = TimeStampGenerator.timestamp((TimeStampOptions)xadesSignatureOptions.getTimeStampOptions(), (InputStream)byteArrayInputStream);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(byteArrayInputStream);
            throw throwable;
        }
        Util.closeQuietly((Closeable)byteArrayInputStream);
        return byArray;
    }

    private Element b(Element element) {
        Node node = null;
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            node = element.getChildNodes().item(i);
            if ((node = (Element)XadesDocument.a(node, "QualifyingProperties")) != null) break;
        }
        if (node == null) {
            return null;
        }
        return (Element)XadesDocument.a(node, "UnsignedProperties");
    }

    private Element c(Element element) {
        if ((element = this.b(element)) == null) {
            return null;
        }
        return (Element)XadesDocument.a((Node)element, "UnsignedSignatureProperties");
    }

    private Element a(XadesSignatureOptions object, Document document, Element node) throws CapiException {
        Element element;
        Object object2;
        Element element2 = null;
        for (int i = 0; i < node.getChildNodes().getLength() && (element2 = (Element)XadesDocument.a((Node)(object2 = node.getChildNodes().item(i)), "QualifyingProperties")) == null; ++i) {
        }
        if (element2 == null) {
            element2 = document.createElement("xades:QualifyingProperties");
            element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xades", "http://uri.etsi.org/01903/v1.3.2#");
            element2.setAttributeNS(null, "Target", "#" + ((XadesSignatureOptions)((Object)object)).getSignerId());
            object2 = document.createElement("xades:UnsignedProperties");
            element2.appendChild((Node)object2);
            object = document.createElement("xades:UnsignedSignatureProperties");
            object2.appendChild((Node)object);
            element = document.createElement("xades:CounterSignature");
            object.appendChild(element);
            node.appendChild(element2);
        } else {
            object = element2.getAttribute("xmlns");
            object2 = object != null && ((String)object).compareToIgnoreCase("http://uri.etsi.org/01903/v1.3.2#") == 0 ? "" : ((object2 = element2.getPrefix()) == null || ((String)object2).isEmpty() ? "" : (String)object2 + ":");
            object = XadesDocument.a((Node)element2, "UnsignedProperties");
            if (object == null) {
                object = document.createElement((String)object2 + "UnsignedProperties");
                element2.appendChild((Node)object);
                node = document.createElement((String)object2 + "UnsignedSignatureProperties");
                object.appendChild(node);
                element = document.createElement((String)object2 + "CounterSignature");
                node.appendChild(element);
            } else {
                node = XadesDocument.a((Node)object, "UnsignedSignatureProperties");
                if (node == null) {
                    node = document.createElement((String)object2 + "UnsignedSignatureProperties");
                    object.appendChild(node);
                    element = document.createElement((String)object2 + "CounterSignature");
                    node.appendChild(element);
                } else {
                    element = document.createElement((String)object2 + "CounterSignature");
                    node.appendChild(element);
                }
            }
        }
        return element;
    }

    private void a(XadesSignatureOptions object, X509Certificate x509Certificate, PrivateKey object2, Element object3, String object4, boolean bl) throws CapiException {
        a.debug("[addSigner] generating XML ENVELOPED Signature...");
        if (this.b == null) {
            throw new CapiException("Mimetype: " + object.getXmlMimetype() + " Enveloped Signature requires text/xml", 50025);
        }
        XMLSignatureFactory xMLSignatureFactory = XMLUtils.getXMLSignatureFactoryInstance();
        long l = System.currentTimeMillis();
        String string = "Signer-T-" + l;
        if (object.getSignerId() != null) {
            string = object.getSignerId();
        } else if (object4 != null && !((String)object4).isEmpty()) {
            string = "Countersignature-" + l + "-" + (String)object4;
        }
        LinkedList<XMLObject> linkedList = new LinkedList<XMLObject>();
        LinkedList<Transform> linkedList2 = new LinkedList<Transform>();
        LinkedList<Reference> linkedList3 = new LinkedList<Reference>();
        try {
            Object object5;
            Object object6;
            if (object3 == null) {
                object3 = this.b.getElementsByTagName("Revision");
                for (int i = 0; i < object3.getLength(); ++i) {
                    object6 = ((Element)object3.item(i)).getAttribute("ID");
                    if (object6 == null || ((String)object6).equals("")) continue;
                    ((Element)object3.item(i)).setIdAttribute("ID", true);
                }
                object5 = (Element)this.b.getElementsByTagName("Atto").item(0);
                if (object5 != null && (object6 = object5.getAttribute("ID")) != null && !((String)object6).equals("")) {
                    object5.setIdAttribute("ID", true);
                }
                object3 = object.getXmlSignatureLocation() == null ? this.b.getDocumentElement() : (Element)this.b.getElementsByTagName(object.getXmlSignatureLocation()).item(0);
            }
            this.h = new DOMSignContext((Key)object2, (Node)object3);
            this.h.setURIDereferencer((URIDereferencer)new InternalUriDereferencer(null, null, null));
            object3 = object.getSigningTime();
            if (object3 == null) {
                object3 = new Date();
            }
            if (!bl) {
                object5 = new HashMap<String, String>();
                ((HashMap)object5).put("ds", "http://www.w3.org/2000/09/xmldsig#");
                object6 = new XPathFilter2ParameterSpec(Collections.singletonList(new XPathType("/descendant::ds:Signature", XPathType.Filter.SUBTRACT, (Map<String, String>)object5)));
                linkedList2.add(xMLSignatureFactory.newTransform("http://www.w3.org/2002/06/xmldsig-filter2", (TransformParameterSpec)object6));
            }
            XadesDocument.a(this.b, linkedList2, object.getXmlTransforms(), xMLSignatureFactory);
            object5 = "";
            if (object4 != null && !((String)object4).isEmpty()) {
                object5 = "#SignatureValue-" + (String)object4;
            } else if (object.getXmlTargetID() != null) {
                object5 = "#" + object.getXmlTargetID();
            }
            object6 = null;
            if (bl) {
                object6 = "http://uri.etsi.org/01903#CountersignedSignature";
            }
            object2 = xMLSignatureFactory.newReference((String)object5, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), linkedList2, (String)object6, "r-doc-" + string);
            linkedList3.add((Reference)object2);
            if (this.d != null) {
                object2 = xMLSignatureFactory.newReference(this.d, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, null, "r-stylesheet-" + string);
                try {
                    this.h.getURIDereferencer().dereference(new c(this), this.h);
                    linkedList3.add((Reference)object2);
                }
                catch (NullPointerException | URIReferenceException exception) {
                    a.warn("Can't add {} to referenced signature", (Object)object2.getURI());
                }
            }
            linkedList3.add(xMLSignatureFactory.newReference("#SignedProperties-" + string, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, "http://uri.etsi.org/01903#SignedProperties", null));
            object2 = new LinkedList<X509Certificate>();
            ((LinkedList)object2).add(x509Certificate);
            object4 = xMLSignatureFactory.getKeyInfoFactory();
            object2 = ((KeyInfoFactory)object4).newX509Data((List<?>)object2);
            String string2 = "KeyInfo-" + string;
            object2 = ((KeyInfoFactory)object4).newKeyInfo(Collections.singletonList(object2), string2);
            linkedList3.add(xMLSignatureFactory.newReference("#" + string2, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, null, "r-keyinfo-" + string));
            linkedList.add(this.a((XadesSignatureOptions)((Object)object), (Date)object3, xMLSignatureFactory, this.b, x509Certificate, string, (List<Reference>)linkedList3));
            object = xMLSignatureFactory.newCanonicalizationMethod(object.getCanonicalizerOfSignedInfo(), (C14NMethodParameterSpec)null);
            object = xMLSignatureFactory.newSignedInfo((CanonicalizationMethod)object, xMLSignatureFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null), linkedList3);
            this.i = xMLSignatureFactory.newXMLSignature((SignedInfo)object, (KeyInfo)object2, linkedList, string, "SignatureValue-" + string);
            return;
        }
        catch (CapiException capiException) {
            if (a.isDebugEnabled()) {
                a.debug(capiException.getMessage(), (Throwable)capiException);
            }
            throw capiException;
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("An encoding or IO error during envelope operation occurred", 50025);
        }
    }

    private Element a(String stringArray) throws CapiException {
        NodeList nodeList;
        if (this.b == null) {
            return null;
        }
        stringArray = stringArray.split(":");
        try {
            XadesDocument xadesDocument = this;
            nodeList = xadesDocument.a(xadesDocument.b);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new CapiException("TransformerException getting Signature Nodes", 50001, (Throwable)xPathExpressionException);
        }
        if (nodeList.getLength() == 0) {
            return null;
        }
        int n = Integer.parseInt(stringArray[0]);
        if (nodeList.item(n) == null) {
            return null;
        }
        if (1 == stringArray.length) {
            return (Element)nodeList.item(n);
        }
        return this.a((Element)nodeList.item(n), stringArray, 2);
    }

    private NodeList a(Document document) throws XPathExpressionException {
        Object object = new d(this);
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext((NamespaceContext)object);
        object = xPath.compile("//ds:Signature[not(ancestor::ds:Signature)]");
        return (NodeList)object.evaluate(document, XPathConstants.NODESET);
    }

    private Element a(Element element, String[] stringArray, int n) throws CapiException {
        while (element != null) {
            LinkedList<Node> linkedList = null;
            if ((element = this.c(element)) != null) {
                linkedList = XadesDocument.a(element, "CounterSignature");
            }
            if (linkedList == null || linkedList.isEmpty()) {
                return null;
            }
            int n2 = Integer.parseInt(stringArray[n - 1]);
            if (linkedList.get(n2) == null) {
                return null;
            }
            if (n == stringArray.length) {
                return (Element)linkedList.get(n2).getFirstChild();
            }
            element = (Element)linkedList.get(n2).getFirstChild();
        }
        return null;
    }

    private static LinkedList<Node> a(Element object, String string) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        if (object.hasChildNodes()) {
            object = object.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                short s = object.item(i).getNodeType();
                if (s != 1 || !object.item(i).getNodeName().endsWith(string)) continue;
                linkedList.add(object.item(i));
            }
        }
        return linkedList;
    }

    private void c(XadesSignatureOptions object, X509Certificate object2, PrivateKey privateKey) throws CapiException {
        a.debug("[addSigner] generating XML ENVELOPING Signature");
        Document document = this.c.newDocument();
        XMLSignatureFactory xMLSignatureFactory = XMLUtils.getXMLSignatureFactoryInstance();
        this.h = new DOMSignContext(privateKey, (Node)document);
        this.h.setURIDereferencer((URIDereferencer)new InternalUriDereferencer(null, null, null));
        try {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Serializable serializable;
            long l = System.currentTimeMillis();
            Object object7 = "SignedObject-" + l;
            if (this.b != null) {
                a.debug("[addSigner] XML ENVELOPING Object is XML text");
                serializable = new LinkedList();
                if (this.e != null) {
                    serializable.add(new DOMStructure(document.createProcessingInstruction(this.e.getTarget(), this.e.getData())));
                }
                object6 = document.importNode(this.b.getDocumentElement(), true);
                serializable.add(new DOMStructure((Node)object6));
                object6 = xMLSignatureFactory.newXMLObject((List<? extends XMLStructure>)((Object)serializable), (String)object7, object.getXmlMimetype(), object.getXmlEncoding());
            } else {
                a.debug("[addSigner] XML ENVELOPING Object is Base64 encoded");
                serializable = new StringBuilder();
                object6 = object.getInput().getInputAsNewStream();
                try {
                    object5 = new BufferedReader(new InputStreamReader((InputStream)object6));
                    while ((object4 = ((BufferedReader)object5).readLine()) != null) {
                        ((StringBuilder)serializable).append(((String)object4).concat("\n"));
                    }
                }
                finally {
                    Util.closeQuietly((Closeable)object6);
                }
                object6 = xMLSignatureFactory.newXMLObject(Collections.singletonList(new DOMStructure(document.createTextNode(((StringBuilder)serializable).toString()))), (String)object7, object.getXmlMimetype(), object.getXmlEncoding());
            }
            serializable = new LinkedList<LinkedList<Transform>>();
            serializable.add(object6);
            object6 = new LinkedList<Transform>();
            if (!XadesDocument.a(document, object6, object.getXmlTransforms(), xMLSignatureFactory)) {
                object6 = null;
            }
            object5 = "Signer-T-" + l;
            if (object.getSignerId() != null) {
                object5 = object.getSignerId();
            }
            object4 = new LinkedList<Reference>();
            object4.add(xMLSignatureFactory.newReference("#xpointer(id('" + (String)object7 + "'))", xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), (List<? extends Transform>)object6, null, "r-doc-" + (String)object5));
            Date date = object.getSigningTime();
            if (date == null) {
                date = new Date();
            }
            object4.add(xMLSignatureFactory.newReference("#SignedProperties-" + (String)object5, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, "http://uri.etsi.org/01903#SignedProperties", null));
            if (this.d != null) {
                object3 = xMLSignatureFactory.newReference(this.d, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, null, "r-stylesheet-" + (String)object5);
                try {
                    this.h.getURIDereferencer().dereference(new e(this), this.h);
                    object4.add(object3);
                }
                catch (NullPointerException | URIReferenceException exception) {
                    a.warn("Can't add {} to referenced signature", (Object)object3.getURI());
                }
            }
            object3 = new LinkedList<X509Certificate>();
            ((LinkedList)object3).add(object2);
            object7 = xMLSignatureFactory.getKeyInfoFactory();
            object3 = ((KeyInfoFactory)object7).newX509Data((List<?>)object3);
            object6 = "KeyInfo-" + (String)object5;
            object3 = ((KeyInfoFactory)object7).newKeyInfo(Collections.singletonList(object3), (String)object6);
            object4.add(xMLSignatureFactory.newReference("#" + (String)object6, xMLSignatureFactory.newDigestMethod(object.getDigestAlgorithm().getXadesID(), null), null, null, "r-keyinfo-" + (String)object5));
            serializable.add(this.a((XadesSignatureOptions)((Object)object), date, xMLSignatureFactory, document, (X509Certificate)object2, (String)object5, (List<Reference>)object4));
            object2 = xMLSignatureFactory.newCanonicalizationMethod(object.getCanonicalizerOfSignedInfo(), (C14NMethodParameterSpec)null);
            object = SignUtils.algoByKeyAndDigest((PrivateKey)privateKey, (DigestAlgorithm)object.getDigestAlgorithm()).getXadesName();
            object = xMLSignatureFactory.newSignedInfo((CanonicalizationMethod)object2, xMLSignatureFactory.newSignatureMethod((String)object, null), (List<? extends Reference>)object4);
            this.i = xMLSignatureFactory.newXMLSignature((SignedInfo)object, (KeyInfo)object3, (List<? extends XMLObject>)((Object)serializable), (String)object5, "SignatureValue-" + (String)object5);
        }
        catch (CapiException capiException) {
            if (a.isDebugEnabled()) {
                a.debug(capiException.getMessage(), (Throwable)capiException);
            }
            throw capiException;
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("An encoding or IO error during envelope operation occurred", 50025);
        }
        this.b = document;
    }

    private void a(Node object) throws CapiException {
        switch (object.getNodeType()) {
            case 7: {
                this.a((ProcessingInstruction)object);
            }
        }
        object = object.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            this.a(object.item(i));
        }
    }

    private void a(ProcessingInstruction object) throws CapiException {
        if (a.isDebugEnabled()) {
            a.debug("[dumpProcesssInstruction] PI: target=" + object.getTarget());
        }
        if (a.isDebugEnabled()) {
            a.debug("[dumpProcesssInstruction] PI: data=" + object.getData());
        }
        if (object.getTarget().startsWith("xml-stylesheet")) {
            int n;
            Node node = object.getParentNode();
            if (node != null && node.getNodeType() == 9) {
                this.e = object;
            }
            if ((n = object.getData().indexOf("href=")) < 0) {
                if (a.isDebugEnabled()) {
                    a.debug("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            n = ((String)(object = object.getData().substring(n + 5))).indexOf("\"");
            if (n < 0) {
                if (a.isDebugEnabled()) {
                    a.debug("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            int n2 = ((String)object).indexOf("\"", n + 1);
            if (n2 <= n + 1) {
                if (a.isDebugEnabled()) {
                    a.debug("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            this.d = ((String)object).substring(n + 1, n2);
            if (this.d != null && !"".equals(this.d)) {
                try {
                    object = new URL(this.d);
                    ((URL)object).toURI();
                }
                catch (Exception exception) {
                    object = XadesDocument.b(this.d);
                    try {
                        URL uRL = new URL((String)object);
                        uRL.toURI();
                        this.d = object;
                    }
                    catch (Exception exception2) {
                        throw new CapiException("Malformed stilesheet href", 50025);
                    }
                }
            }
            if (a.isDebugEnabled()) {
                a.debug("[dumpProcesssInstruction] stylesheet href setted to: " + this.d);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private XMLObject a(XadesSignatureOptions object, Date date, XMLSignatureFactory xMLSignatureFactory, Document document, X509Certificate object2, String object3, List<Reference> list) throws CapiException, NoSuchAlgorithmException {
        try {
            void var3_11;
            void var7_15;
            Element element;
            Object object4;
            Object object5;
            Object object6;
            void var2_5;
            Object object7;
            void var4_12;
            Element element2 = var4_12;
            Element element3 = object7;
            Element element4 = element2.createElement("xades:QualifyingProperties");
            element4.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xades", "http://uri.etsi.org/01903/v1.3.2#");
            element4.setAttributeNS(null, "Target", "#" + (String)((Object)element3));
            void v0 = object7;
            object7 = var4_12;
            element2 = v0;
            element3 = element4;
            Object object8 = object7.createElement("xades:SignedProperties");
            object8.setAttributeNS(null, "Id", "SignedProperties-" + (String)((Object)element2));
            object8.setIdAttributeNS(null, "Id", true);
            XadesDocument.a(element3, (Node)object8, 2, true, (Document)object7);
            object7 = object8;
            element3 = var4_12.createElement("xades:SignedSignatureProperties");
            element2 = var4_12.createElement("xades:SigningTime");
            Date n = date;
            if (n == null) {
                Date object102 = new Date();
            }
            object8 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            object8 = ((DateFormat)object8).format((Date)var2_5);
            try {
                if (a.isDebugEnabled()) {
                    a.debug("[addSignTime]doing Z format..");
                }
                object6 = new SimpleDateFormat("Z");
                object6 = ((DateFormat)object6).format((Date)var2_5);
                object6 = ((String)object6).substring(0, 3) + ":" + ((String)object6).substring(3, 5);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (a.isDebugEnabled()) {
                    a.debug("[addSignTime] catched Exception ..");
                }
                object5 = new GregorianCalendar();
                ((Calendar)object5).setTime((Date)var2_5);
                int n2 = ((Calendar)object5).get(15) / 3600000;
                object4 = new DecimalFormat("00");
                object6 = n2 >= 0 ? "+" + ((NumberFormat)object4).format(n2) + ":00" : "-" + ((NumberFormat)object4).format(n2) + ":00";
            }
            if (a.isDebugEnabled()) {
                a.debug("[addSignTime] SigningTime is: " + (String)object8 + (String)object6);
            }
            element2.appendChild(var4_12.createTextNode((String)object8 + (String)object6));
            object6 = object.getSignatureProfile() != null && object.getSignatureProfile().equals((Object)XadesSignatureProfile.ETSI_EN_319_132_1_v1_1_1) ? var4_12.createElement("xades:SigningCertificateV2") : var4_12.createElement("xades:SigningCertificate");
            object5 = var4_12.createElement("xades:Cert");
            Element element5 = var4_12.createElement("xades:CertDigest");
            object4 = var4_12.createElement("ds:DigestMethod");
            object4.setAttributeNS(null, "Algorithm", object.getDigestAlgorithm().getXadesID());
            object8 = var4_12.createElement("ds:DigestValue");
            Object object9 = MessageDigest.getInstance(object.getDigestAlgorithm().getId(), ProvUtils.bcProvider);
            ((MessageDigest)object9).update(((Certificate)((Object)element)).getEncoded());
            object9 = ((MessageDigest)object9).digest();
            object8.appendChild(var4_12.createTextNode(new String(Util.base64Encode((byte[])object9))));
            if (object.getSignatureProfile() != null && object.getSignatureProfile().equals((Object)XadesSignatureProfile.ETSI_EN_319_132_1_v1_1_1)) {
                object = var4_12.createElement("xades:IssuerSerialV2");
                object.appendChild(var4_12.createTextNode(new String(Util.base64Encode((byte[])((X509Certificate)((Object)element)).getIssuerX500Principal().getEncoded()))));
            } else {
                object = var4_12.createElement("xades:IssuerSerial");
                object9 = var4_12.createElement("ds:X509IssuerName");
                object9.appendChild(var4_12.createTextNode(((X509Certificate)((Object)element)).getIssuerX500Principal().getName()));
                object.appendChild((Node)object9);
                object9 = var4_12.createElement("ds:X509SerialNumber");
                object9.appendChild(var4_12.createTextNode(((X509Certificate)((Object)element)).getSerialNumber().toString()));
                object.appendChild((Node)object9);
            }
            XadesDocument.a((Node)object7, element3, 3, true, (Document)var4_12);
            XadesDocument.a(element3, element2, 4, false, (Document)var4_12);
            XadesDocument.a(element3, (Node)object6, 4, true, (Document)var4_12);
            XadesDocument.a((Node)object6, (Node)object5, 5, true, (Document)var4_12);
            XadesDocument.a((Node)object5, element5, 6, false, (Document)var4_12);
            XadesDocument.a(element5, (Node)object4, 7, false, (Document)var4_12);
            XadesDocument.a(element5, (Node)object8, 7, true, (Document)var4_12);
            XadesDocument.a((Node)object5, (Node)object, 6, true, (Document)var4_12);
            object9 = var4_12.createElement("xades:SignedDataObjectProperties");
            XadesDocument.a((Node)object7, (Node)object9, 3, true, (Document)var4_12);
            for (Reference reference : var7_15) {
                if (reference.getType() != null && reference.getType().equals("http://uri.etsi.org/01903#SignedProperties")) continue;
                element = var4_12.createElement("xades:DataObjectFormat");
                element.setAttribute("ObjectReference", "#" + reference.getId());
                object7 = "text/xml";
                if (reference.getId().startsWith("r-doc-") && !this.g) {
                    object7 = "application/octet-stream";
                }
                Element element6 = var4_12.createElement("xades:MimeType");
                element6.appendChild(var4_12.createTextNode((String)object7));
                XadesDocument.a((Node)object9, element, 4, true, (Document)var4_12);
                XadesDocument.a(element, element6, 5, true, (Document)var4_12);
            }
            object = new DOMStructure(element4);
            return var3_11.newXMLObject(Collections.singletonList(object), null, null, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (a.isDebugEnabled()) {
                a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            }
            throw new CapiException("NoSuchAlgorithmException occurred: " + noSuchAlgorithmException.getMessage(), 50025);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            if (a.isDebugEnabled()) {
                a.debug(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            }
            throw new CapiException("CertificateEncodingException occurred: " + certificateEncodingException.getMessage(), 50025);
        }
    }

    private static void a(Node node, Node node2, int n, boolean bl, Document document) {
        Node[] nodeArray = XadesDocument.a(n, bl, document);
        node.appendChild(nodeArray[0]);
        node.appendChild(node2);
        if (bl) {
            node.appendChild(nodeArray[1]);
        }
    }

    private static Node[] a(int n, boolean n2, Document document) {
        Object object;
        String string = "\n";
        for (int i = 0; i < n; ++i) {
            string = string.concat("\t");
        }
        Text text = document.createTextNode(string);
        Text text2 = null;
        if (n2 != 0) {
            object = "\n";
            if (n2 != 0) {
                for (n2 = 0; n2 < n - 1; ++n2) {
                    object = object.concat("\t");
                }
            } else {
                object = string;
            }
            text2 = document.createTextNode((String)object);
        }
        Node[] nodeArray = new Node[2];
        object = nodeArray;
        nodeArray[0] = text;
        object[1] = text2;
        return object;
    }

    private static boolean a(Document document, List<Transform> list, List<XadesTransformation> object, XMLSignatureFactory xMLSignatureFactory) throws Exception {
        if (object == null || object.isEmpty()) {
            return false;
        }
        object = object.iterator();
        block15: while (object.hasNext()) {
            Object object2 = (XadesTransformation)object.next();
            if (object2 == null || ((XadesTransformation)object2).getAlgorithm() == null) continue;
            switch (((XadesTransformation)object2).getAlgorithm()) {
                case "http://www.w3.org/TR/1999/REC-xpath-19991116": {
                    object2 = new XPathFilterParameterSpec("samlp:AuthnRequest/UserID", Collections.singletonMap("ds", "http://www.w3.org/2000/09/xmldsig#"));
                    list.add(xMLSignatureFactory.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", (TransformParameterSpec)object2));
                    continue block15;
                }
                case "http://www.w3.org/2002/06/xmldsig-filter2": {
                    if (((XadesTransformation)object2).getFilter() == null) continue block15;
                    Object object3 = new HashMap<String, String>();
                    ((HashMap)object3).put("ds", "http://www.w3.org/2000/09/xmldsig#");
                    ((HashMap)object3).put(((XadesTransformation)object2).getNsPrefix(), ((XadesTransformation)object2).getNsUri());
                    XPathType.Filter filter = XPathType.Filter.SUBTRACT;
                    if (((XadesTransformation)object2).getFilter().compareToIgnoreCase("intersect") == 0) {
                        filter = XPathType.Filter.INTERSECT;
                    } else if (((XadesTransformation)object2).getFilter().compareToIgnoreCase("union") == 0) {
                        filter = XPathType.Filter.UNION;
                    }
                    object2 = new XPathFilter2ParameterSpec(Collections.singletonList(new XPathType(((XadesTransformation)object2).getValue(), filter, (Map<String, String>)object3)));
                    list.add(xMLSignatureFactory.newTransform("http://www.w3.org/2002/06/xmldsig-filter2", (TransformParameterSpec)object2));
                    continue block15;
                }
                case "http://www.w3.org/TR/1999/REC-xslt-19991116": {
                    Object object3 = null;
                    try {
                        object3 = new FileInputStream(((XadesTransformation)object2).getValue());
                        object2 = DocumentBuilderFactory.newInstance();
                        ((DocumentBuilderFactory)object2).setNamespaceAware(true);
                        object2 = ((DocumentBuilderFactory)object2).newDocumentBuilder();
                        object2 = ((DocumentBuilder)object2).parse((InputStream)object3);
                        object2 = object2.getDocumentElement();
                        object2 = document.importNode((Node)object2, true);
                        object2 = new XSLTTransformParameterSpec(new DOMStructure((Node)object2));
                        list.add(xMLSignatureFactory.newTransform("http://www.w3.org/TR/1999/REC-xslt-19991116", (TransformParameterSpec)object2));
                        continue block15;
                    }
                    catch (Exception exception) {
                        object2 = exception;
                        throw exception;
                    }
                    finally {
                        Util.closeQuietly((Closeable)object3);
                        continue block15;
                    }
                }
            }
            list.add(xMLSignatureFactory.newTransform(((XadesTransformation)object2).getAlgorithm(), new DOMStructure(document.getDocumentElement())));
        }
        return true;
    }

    private void a(Document object, SignatureMode signatureMode) throws CapiException {
        if (object == null) {
            return;
        }
        try {
            this.j = this.a((Document)object);
            if (this.j.getLength() == 0) {
                return;
            }
            if ((((String)(object = object.getDocumentElement().getTagName())).endsWith(":Signature") || ((String)object).compareToIgnoreCase("Signature") == 0) && signatureMode == SignatureMode.ENVELOPED) {
                object = new XadesModeException(signatureMode, SignatureMode.DETACHED_INTERNAL);
                throw object;
            }
            int n = 0;
            for (int i = 0; i < this.j.getLength(); ++i) {
                Iterator iterator = this.j.item(i);
                iterator = XadesDocument.a((Node)((Element)((Object)iterator)), "SignedInfo");
                iterator = XadesDocument.a((Element)((Object)iterator), "Reference");
                boolean bl = false;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Object object2 = (Node)iterator.next();
                    Object object3 = ((Element)object2).getAttribute("URI");
                    if (object3 == null || !((String)object3).isEmpty() || (object2 = XadesDocument.a((Node)((Element)object2), "Transforms")) == null || (object2 = XadesDocument.a((Element)object2, "Transform")).isEmpty()) continue;
                    bl = false;
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        object3 = (Node)object2.next();
                        String string = ((Element)object3).getAttribute("Algorithm");
                        if (string.equals("http://www.w3.org/2002/06/xmldsig-filter2")) {
                            string = ((Element)(object3 = XadesDocument.a((Node)((Element)object3), "XPath"))).getAttribute("Filter");
                            if (!string.equals("subtract") || !((Element)object3).getTextContent().equals("/descendant::ds:Signature")) continue;
                            bl = true;
                            continue;
                        }
                        if (!string.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") || !"not(ancestor-or-self::ds:Signature)".equals(string = (object3 = XadesDocument.a((Node)((Element)object3), "XPath")).getTextContent())) continue;
                        bl = true;
                    }
                    if (signatureMode == SignatureMode.ENVELOPED && !bl) {
                        throw new XadesModeException(signatureMode, null);
                    }
                    if (signatureMode != SignatureMode.ENVELOPED && bl) {
                        throw new XadesModeException(signatureMode, SignatureMode.ENVELOPED);
                    }
                    bl = true;
                }
                if (!bl) continue;
                ++n;
            }
            if (n < this.j.getLength() && signatureMode == SignatureMode.ENVELOPED) {
                throw new XadesModeException(signatureMode, SignatureMode.DETACHED_INTERNAL);
            }
            return;
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new CapiException("TransformerException getting Signature Nodes", 50001, (Throwable)xPathExpressionException);
        }
    }

    private static void b(Document object) throws XPathExpressionException {
        Object object2 = XPathFactory.newInstance();
        object2 = ((XPathFactory)object2).newXPath();
        object2 = object2.compile("descendant-or-self::*/@Id");
        object = (NodeList)object2.evaluate(object, XPathConstants.NODESET);
        for (int i = 0; i < object.getLength(); ++i) {
            Attr attr = (Attr)object.item(i);
            attr.getOwnerElement().setIdAttributeNode(attr, true);
        }
    }

    public String getBodyId() {
        return this.l;
    }

    private static String b(String string) {
        string = string.replaceAll("\\\\", "/").replaceAll("\\s+", "");
        return "file://" + string;
    }

    static /* synthetic */ ProcessingInstruction a(XadesDocument xadesDocument) {
        return xadesDocument.e;
    }

    static /* synthetic */ String b(XadesDocument xadesDocument) {
        return xadesDocument.d;
    }
}

