/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.parser;

import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.RefCRL;
import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.ParserUtils;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.asic.envelope.ASiCContainer;
import it.actalis.ellips.capi.asic.envelope.ASiCEContainer;
import it.actalis.ellips.capi.asic.envelope.ASiCSContainer;
import it.actalis.ellips.capi.asic.parser.ASiCInternalParser;
import it.actalis.ellips.capi.asic.parser.b;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.naming.OperationNotSupportedException;
import org.slf4j.Logger;

public class ASiCParser
extends SignatureParser {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private DateFormat b = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
    private ASiCContainer c;

    public ASiCParser(SignatureParserBuilder signatureParserBuilder) {
        super(signatureParserBuilder);
        this.b.setTimeZone(Constants.DEFAULT_TIMEZONE);
        this.c = null;
    }

    public ParsedTransientDocument parse(InputHandler object, EventHandlerSelector eventHandlerSelector, NetworkConfig object2, TimeZone timeZone, File file) throws ParsingException {
        Object object3 = new ASiCInternalParser((NetworkConfig)object2, timeZone);
        ParsedTransientDocument parsedTransientDocument = new ParsedTransientDocument((InputHandler)object);
        if (timeZone != null) {
            this.b.setTimeZone(timeZone);
        }
        try {
            this.c = object3.parse((InputHandler)object);
        }
        catch (CapiException capiException) {
            parsedTransientDocument.setSigned(false);
        }
        if (this.c != null) {
            block2 : switch (this.c.getOpts().getFormat()) {
                case SIMPLE: {
                    object3 = file;
                    object = timeZone;
                    file = object2;
                    timeZone = eventHandlerSelector;
                    object2 = (ASiCSContainer)this.c;
                    eventHandlerSelector = parsedTransientDocument;
                    object = this;
                    ASiCSignatureType aSiCSignatureType = ((ASiCContainer)object2).getOpts().getSignatureType();
                    try {
                        switch (aSiCSignatureType) {
                            case CADES: {
                                super.a((ParsedTransientDocument)eventHandlerSelector, ((ASiCSContainer)object2).getFilename(), ((ASiCSContainer)object2).getCadesTransientDocument(), ((ASiCSContainer)object2).getContentStream(), (EventHandlerSelector)timeZone, (NetworkConfig)file, (File)object3);
                                break block2;
                            }
                            case TIMESTAMP: {
                                super.b((ParsedTransientDocument)eventHandlerSelector, ((ASiCSContainer)object2).getFilename(), ((ASiCSContainer)object2).getTimestampTransientDocument(), ((ASiCSContainer)object2).getContentStream(), (EventHandlerSelector)timeZone, (NetworkConfig)file, (File)object3);
                                break block2;
                            }
                            case XADES: {
                                super.c((ParsedTransientDocument)eventHandlerSelector, ((ASiCSContainer)object2).getFilename(), ((ASiCSContainer)object2).getXadesTransientDocument(), ((ASiCSContainer)object2).getContentStream(), (EventHandlerSelector)timeZone, (NetworkConfig)file, (File)object3);
                                break block2;
                            }
                        }
                        a.error("Unrecognized sign type: [" + (Object)((Object)aSiCSignatureType) + "]");
                        eventHandlerSelector.setSigned(false);
                    }
                    catch (OperationNotSupportedException operationNotSupportedException) {
                        eventHandlerSelector.setSigned(false);
                    }
                    catch (IOException iOException) {
                        eventHandlerSelector.setSigned(false);
                    }
                    break;
                }
                case EXTENDED: {
                    this.a(parsedTransientDocument, (ASiCEContainer)this.c, eventHandlerSelector, (NetworkConfig)object2, timeZone, file);
                    break;
                }
                default: {
                    parsedTransientDocument.setSigned(false);
                }
            }
        }
        for (int i = 0; i < parsedTransientDocument.getSignerInfo().size(); ++i) {
            ((SignatureInformation)parsedTransientDocument.getSignerInfo().get(i)).setContainerFormat(ContainerFormat.ASIC);
        }
        return parsedTransientDocument;
    }

    private void a(ParsedTransientDocument parsedTransientDocument, ASiCEContainer aSiCEContainer, EventHandlerSelector eventHandlerSelector, NetworkConfig networkConfig, TimeZone object, File file) {
        object = aSiCEContainer.getOpts().getSignatureType();
        try {
            switch (it.actalis.ellips.capi.asic.parser.b.b[((Enum)object).ordinal()]) {
                case 1: {
                    for (String string : aSiCEContainer.getCadesTransientDocuments().keySet()) {
                        InputStream inputStream = aSiCEContainer.getContentStream(string);
                        aSiCEContainer.getHashVerified(string);
                        this.a(parsedTransientDocument, string, aSiCEContainer.getCadesTransientDocuments().get(string), inputStream, eventHandlerSelector, networkConfig, file);
                    }
                    break;
                }
                case 2: {
                    for (String string : aSiCEContainer.getTimestampTransientDocuments().keySet()) {
                        InputStream inputStream = aSiCEContainer.getContentStream(string);
                        aSiCEContainer.getHashVerified(string);
                        this.b(parsedTransientDocument, string, aSiCEContainer.getTimestampTransientDocuments().get(string), inputStream, eventHandlerSelector, networkConfig, file);
                    }
                    break;
                }
                case 3: {
                    for (String string : aSiCEContainer.getXadesTransientDocuments().keySet()) {
                        InputStream inputStream = aSiCEContainer.getContentStream(string);
                        aSiCEContainer.getHashVerified(string);
                        this.c(parsedTransientDocument, string, aSiCEContainer.getXadesTransientDocuments().get(string), inputStream, eventHandlerSelector, networkConfig, file);
                    }
                    break;
                }
                default: {
                    a.error("Unrecognized sign type: [" + object + "]");
                    parsedTransientDocument.setSigned(false);
                }
            }
            for (String string : aSiCEContainer.getUnsignedDocs()) {
                this.a(parsedTransientDocument, string, aSiCEContainer.getContentStream(string), eventHandlerSelector, networkConfig, file);
            }
            for (String string : aSiCEContainer.getSignedDocs()) {
                this.a(parsedTransientDocument, string, aSiCEContainer.getContentStream(string), eventHandlerSelector, networkConfig, file);
            }
            return;
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            parsedTransientDocument.setSigned(false);
            return;
        }
        catch (IOException iOException) {
            parsedTransientDocument.setSigned(false);
            return;
        }
    }

    private void a(ParsedTransientDocument parsedTransientDocument, String iterator, ParsedTransientDocument parsedTransientDocument2, InputStream inputStream2, EventHandlerSelector eventHandlerSelector, NetworkConfig networkConfig, File file) {
        if (this.c.getOpts().getFormat() == ASiCFormat.SIMPLE) {
            this.a(parsedTransientDocument, (String)((Object)iterator), inputStream2, eventHandlerSelector, networkConfig, file);
        }
        try {
            for (InputStream inputStream2 : parsedTransientDocument2.getCerts()) {
                parsedTransientDocument.addCert((RefCertificate)inputStream2);
            }
            if (parsedTransientDocument2.isSigned()) {
                parsedTransientDocument.setSigned(true);
                for (InputStream inputStream2 : parsedTransientDocument2.getSignerInfo()) {
                    parsedTransientDocument.addSignerInfo((SignatureInformation)inputStream2);
                }
                for (InputStream inputStream2 : parsedTransientDocument2.getCrls()) {
                    parsedTransientDocument.addCrl((RefCRL)inputStream2);
                }
                for (InputStream inputStream2 : parsedTransientDocument2.getOcspresps()) {
                    parsedTransientDocument.addOcspresp((RefOcsp)inputStream2);
                }
            }
            return;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    private void b(ParsedTransientDocument parsedTransientDocument, String iterator, ParsedTransientDocument parsedTransientDocument2, InputStream inputStream2, EventHandlerSelector eventHandlerSelector, NetworkConfig networkConfig, File file) {
        if (this.c.getOpts().getFormat() == ASiCFormat.SIMPLE) {
            this.a(parsedTransientDocument, (String)((Object)iterator), inputStream2, eventHandlerSelector, networkConfig, file);
        }
        try {
            for (InputStream inputStream2 : parsedTransientDocument2.getCerts()) {
                parsedTransientDocument.addCert((RefCertificate)inputStream2);
            }
            if (parsedTransientDocument2.isSigned()) {
                parsedTransientDocument.setSigned(true);
                for (InputStream inputStream2 : parsedTransientDocument2.getSignerInfo()) {
                    parsedTransientDocument.addSignerInfo((SignatureInformation)inputStream2);
                }
                for (InputStream inputStream2 : parsedTransientDocument2.getCrls()) {
                    parsedTransientDocument.addCrl((RefCRL)inputStream2);
                }
                for (InputStream inputStream2 : parsedTransientDocument2.getOcspresps()) {
                    parsedTransientDocument.addOcspresp((RefOcsp)inputStream2);
                }
            }
            return;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    private TransientDocument c(ParsedTransientDocument parsedTransientDocument, String string, ParsedTransientDocument parsedTransientDocument2, InputStream iterator, EventHandlerSelector eventHandlerSelector2, NetworkConfig networkConfig, File object) {
        string = this.a(parsedTransientDocument, string, (InputStream)((Object)iterator), eventHandlerSelector2, networkConfig, (File)object);
        try {
            if (parsedTransientDocument2.isSigned()) {
                parsedTransientDocument.setSigned(true);
                for (EventHandlerSelector eventHandlerSelector2 : parsedTransientDocument2.getRefsDocs()) {
                    boolean bl = false;
                    for (TransientDocument transientDocument : parsedTransientDocument.getRefsDocs()) {
                        if (!transientDocument.getId().equals(eventHandlerSelector2.getId())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    parsedTransientDocument.addRefDoc((TransientDocument)eventHandlerSelector2);
                }
                for (EventHandlerSelector eventHandlerSelector2 : parsedTransientDocument2.getCerts()) {
                    parsedTransientDocument.addCert((RefCertificate)eventHandlerSelector2);
                }
                for (EventHandlerSelector eventHandlerSelector2 : parsedTransientDocument2.getSignerInfo()) {
                    parsedTransientDocument.addSignerInfo((SignatureInformation)eventHandlerSelector2);
                }
                for (EventHandlerSelector eventHandlerSelector2 : parsedTransientDocument2.getCrls()) {
                    parsedTransientDocument.addCrl((RefCRL)eventHandlerSelector2);
                }
                for (EventHandlerSelector eventHandlerSelector2 : parsedTransientDocument2.getOcspresps()) {
                    parsedTransientDocument.addOcspresp((RefOcsp)eventHandlerSelector2);
                }
            }
            return string;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private TransientDocument a(ParsedTransientDocument parsedTransientDocument, String string, InputStream inputStream, EventHandlerSelector eventHandlerSelector, NetworkConfig object, File file2) {
        try {
            inputStream = DataHandlerBuilder.get().setInputStream(inputStream).setName(string).buildInput();
            inputStream = ParserUtils.parseDoc((InputHandler)inputStream, (EventHandlerSelector)eventHandlerSelector, (NetworkConfig)object, (TimeZone)this.b.getTimeZone(), (File)file2);
            boolean bl = false;
            for (File file2 : parsedTransientDocument.getRefsDocs()) {
                if (!file2.getId().equals(inputStream.getId())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                parsedTransientDocument.addRefDoc((TransientDocument)inputStream);
            }
        }
        catch (Exception exception) {
            a.error("Errore parsing entry {}", (Object)string);
            inputStream = new TransientDocument();
            inputStream.setShortName(string);
            inputStream.setId(string);
            parsedTransientDocument.addRefDoc((TransientDocument)inputStream);
        }
        return inputStream;
    }

    public ASiCContainer getASiCContainer() {
        return this.c;
    }
}

