/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.envelope;

import esecurity.validator.bean.ParsedTransientDocument;
import it.actalis.ellips.capi.asic.ASiCOptions;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.asic.envelope.ASiCContainer;
import it.actalis.ellips.capi.asic.envelope.ASiCContainerFactory;
import it.actalis.ellips.capi.asic.parser.util.ASiCContentData;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.naming.OperationNotSupportedException;

public class ASiCEContainer
extends ASiCContainer {
    protected Map<String, ParsedTransientDocument> cadesTransientDocuments;
    protected Map<String, ParsedTransientDocument> timestampTransientDocuments;
    protected Map<String, ParsedTransientDocument> xadesTransientDocuments;
    protected List<String> signedDocs;
    protected List<String> unsignedDocs;

    public Map<String, ParsedTransientDocument> getCadesTransientDocuments() throws OperationNotSupportedException {
        this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.CADES);
        return this.cadesTransientDocuments;
    }

    public Map<String, ParsedTransientDocument> getTimestampTransientDocuments() throws OperationNotSupportedException {
        this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.TIMESTAMP);
        return this.timestampTransientDocuments;
    }

    public Map<String, ParsedTransientDocument> getXadesTransientDocuments() throws OperationNotSupportedException {
        this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.XADES);
        return this.xadesTransientDocuments;
    }

    ASiCEContainer(ASiCOptions aSiCOptions, ASiCContainerFactory.a a2) throws OperationNotSupportedException {
        super(aSiCOptions, a2);
        switch (aSiCOptions.getSignatureType()) {
            case CADES: {
                this.cadesTransientDocuments = a2.b();
                break;
            }
            case TIMESTAMP: {
                this.timestampTransientDocuments = a2.d();
                break;
            }
            case XADES: {
                this.xadesTransientDocuments = a2.c();
                break;
            }
            default: {
                throw new OperationNotSupportedException("XADES not supported yet.");
            }
        }
        this.unsignedDocs = a2.g();
        this.signedDocs = a2.h();
    }

    public InputStream getContentStream(String object) throws IOException {
        if (this.data.containsKey(object)) {
            object = ((ASiCContentData)this.data.get(object)).getContentData();
            return object;
        }
        return null;
    }

    public boolean getHashVerified(String string) throws IOException {
        if (this.data.containsKey(string)) {
            return ((ASiCContentData)this.data.get(string)).isHashValid();
        }
        return false;
    }

    public List<String> getUnsignedDocs() {
        return this.unsignedDocs;
    }

    public List<String> getSignedDocs() {
        return this.signedDocs;
    }
}

