/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import esecurity.tsl.CertChain;
import esecurity.tsl.CertDb;
import esecurity.tsl.ChainEntry;
import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.tsl.TslServiceDbItem;
import esecurity.tsl.X509ServiceDbItem;
import esecurity.tsl.sqllite.ManifestSigner;
import esecurity.tsl.sqllite.SqlLiteCdb;
import esecurity.tsl.v5.AnyType;
import esecurity.tsl.v5.OtherTSLPointerType;
import esecurity.tsl.v5.TrustStatusListType;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.tsl.TSL;
import it.actalis.ellips.capi.tsl.rootupdater.RootUpdater;
import it.actalis.ellips.capi.tsl.rootupdater.TSLCache;
import it.actalis.ellips.capi.tsl.rootupdater.TSLDownloader;
import it.actalis.ellips.capi.tsl.rootupdater.TSLUtils;
import it.actalis.ellips.capi.tsl.rootupdater.UpdateReportFileWriter;
import it.actalis.ellips.capi.tsl.rootupdater.UpdaterProgress;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.BackingStoreException;
import javax.xml.bind.JAXBElement;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.w3c.dom.Element;

final class TSLUpdater {
    private final UpdateReportFileWriter a;
    private final TSLDownloader b;
    private final CertDb c;
    private final ManifestSigner d;
    private final CertDB e;
    private final TSLCache f;
    private final List<String> g;
    private final List<String> h;
    private final UpdaterProgress i;
    private final File j;
    private final List<Certificate> k = new ArrayList<Certificate>();

    private TSLUpdater(UpdateReportFileWriter updateReportFileWriter, TSLDownloader tSLDownloader, CertDb certDb, ManifestSigner manifestSigner, CertDB certDB, TSLCache tSLCache, List<String> list, List<String> list2, UpdaterProgress updaterProgress, File file) {
        this.a = updateReportFileWriter;
        this.b = tSLDownloader;
        this.c = certDb;
        this.d = manifestSigner;
        this.e = certDB;
        this.f = tSLCache;
        this.g = list;
        this.h = list2;
        this.i = updaterProgress;
        this.j = file;
    }

    public final boolean a() throws IOException {
        this.a.write("\nEUROPEAN TSL");
        this.a.write("---------------");
        this.i.update(0.0, "check european TSL...", "");
        TSLUpdater tSLUpdater = this;
        if (tSLUpdater.a(tSLUpdater.c)) {
            this.a.write("european TSL updated: " + TSL.URL_ListOfList.getUrl());
            return true;
        }
        this.a.write("european TSL NOT updated: " + TSL.URL_ListOfList.getUrl());
        return false;
    }

    private boolean a(CertDb certDb) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        InputHandler inputHandler = null;
        try {
            inputHandler = this.b.downloadTsl(TSL.URL_ListOfList.getUrl());
            Iterator iterator = this.b.parseTSL(inputHandler, null);
            this.a(TSL.URL_ListOfList.getUrl(), new Date());
            int n4 = 0;
            iterator = ((TrustStatusListType)((Object)iterator)).getSchemeInformation().getPointersToOtherTSL().getOtherTSLPointer();
            int n5 = iterator.size();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                OtherTSLPointerType otherTSLPointerType = (OtherTSLPointerType)iterator.next();
                String string = TSLUpdater.a("ns3:MimeType", otherTSLPointerType.getAdditionalInformation().getTextualInformationOrOtherInformation()).toString();
                if (!string.equals("application/vnd.etsi.tsl+xml")) continue;
                string = TSLUpdater.a("{http://uri.etsi.org/02231/v2#}SchemeTerritory", otherTSLPointerType.getAdditionalInformation().getTextualInformationOrOtherInformation()).toString();
                String string2 = otherTSLPointerType.getTSLLocation();
                RootUpdater.logger.info("===================================================================");
                String string3 = "";
                if (this.g.contains(TSLUpdater.a(string2))) {
                    string3 = " (ignored)";
                }
                String string4 = "";
                if (this.h.contains(TSLUpdater.a(string2.toLowerCase()))) {
                    string4 = " (no signature verification)";
                }
                RootUpdater.logger.info("{}) {}{}{}", new Object[]{n4 + 1, string2, string3, string4});
                RootUpdater.logger.info("===================================================================");
                this.i.update((double)n4 / (double)n5, "Downloading TSL", string);
                this.a.writeLines("", n4 + 1 + ") " + TSLUtils.extendedNationId(string) + " - " + string2);
                if (string.equals("EU")) continue;
                ++n3;
                if (this.a(otherTSLPointerType, string2, string, certDb)) {
                    ++n;
                } else {
                    ++n2;
                }
                ++n4;
            }
            this.c(certDb);
            ((SqlLiteCdb)certDb).signManifest(this.d);
            this.b(certDb);
        }
        catch (Exception exception) {
            RootUpdater.logger.error("error processing EU TSL " + exception.getMessage(), (Throwable)exception);
            this.a.write("!!! GENERAL ERROR (see log) !!!");
            return false;
        }
        finally {
            Util.closeQuietly(null);
            Util.closeQuietly(inputHandler);
        }
        RootUpdater.logger.debug("{}/{} TSL processed", (Object)n, (Object)n3);
        RootUpdater.logger.debug("{}/{} TSL NOT processed", (Object)n2, (Object)n3);
        RootUpdater.logger.debug("{}/{} TSL skipped", (Object)0, (Object)n3);
        this.a.writeLines("", "- - - - -", ">> " + n + " TSL processed", ">> " + n2 + " TSL NOT processed", ">> " + 0 + " TSL skipped or ignored");
        return true;
    }

    private void b(CertDb certDb) throws CapiException {
        if (this.e == null) {
            return;
        }
        for (CertDBItem certDBItem : this.e.list(127)) {
            if (certDBItem.getSource() != 2) continue;
            X509ServiceDbItem x509ServiceDbItem = new X509ServiceDbItem(certDBItem.getCertificate(), TSLServiceTypeIdentifiers.Fea);
            certDb.importService(x509ServiceDbItem);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean a(OtherTSLPointerType var1_1, String var2_4, String var3_5, CertDb var4_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void c(CertDb certDb) throws CapiException {
        RootUpdater.logger.info("{} intermediate roots found", (Object)this.k.size());
        RootUpdater.logger.info("-- start parsing caIssuer --");
        int n = 0;
        for (Certificate certificate : this.k) {
            CertChain certChain = certDb.retrieveCertificateChain(certificate);
            if (certChain.getStartEntry().getParent() == null) continue;
            Iterator<ChainEntry> iterator = certChain.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                block4: {
                    Object object = iterator.next();
                    ChainEntry chainEntry = object;
                    object = certDb;
                    for (ServiceDbItem serviceDbItem : chainEntry.getCertDbItem()) {
                        if (!(serviceDbItem instanceof TslServiceDbItem)) {
                            continue;
                        }
                        break block4;
                    }
                    X509ServiceDbItem x509ServiceDbItem = new X509ServiceDbItem(chainEntry.getCert(), TSLServiceTypeIdentifiers.CaIssuer);
                    ((CertDb)object).importService(x509ServiceDbItem);
                }
                ++n;
            }
        }
        RootUpdater.logger.info(String.format("%d caIssuer added", n));
        RootUpdater.logger.info("-- end parsing caIssuer --");
    }

    private static Object a(String string, List<Object> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if (!(object2 instanceof AnyType)) continue;
            for (Object e : ((AnyType)object2).getContent()) {
                if (e instanceof JAXBElement && ((JAXBElement)e).getName().toString().equals(string)) {
                    return ((JAXBElement)e).getValue();
                }
                if (!(e instanceof Element) || !((Element)e).getTagName().equals(string)) continue;
                return ((Element)e).getTextContent();
            }
        }
        return null;
    }

    private static String a(String string) {
        return string.replace("http://", "").replace("https://", "");
    }

    private boolean a(String string, Date date) {
        if (Util.isNullOrEmpty(string)) {
            return false;
        }
        Object object = TSLUpdater.a(string);
        if (((String[])(object = object.split("/"))).length <= 0) {
            return false;
        }
        object = object[0];
        try {
            if (!this.j.exists()) {
                this.j.createNewFile();
            }
            Ini ini = new Ini(this.j);
            IniPreferences iniPreferences = new IniPreferences(ini);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            iniPreferences.node("TSL").put((String)object, simpleDateFormat.format(date));
            try {
                iniPreferences.sync();
                ini.store();
            }
            catch (BackingStoreException backingStoreException) {
                RootUpdater.logger.error("unable to update local date file " + backingStoreException.getMessage(), (Throwable)backingStoreException);
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            RootUpdater.logger.error("unable to get local date for " + string + " " + exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    /* synthetic */ TSLUpdater(UpdateReportFileWriter updateReportFileWriter, TSLDownloader tSLDownloader, CertDb certDb, ManifestSigner manifestSigner, CertDB certDB, TSLCache tSLCache, List list, List list2, UpdaterProgress updaterProgress, File file, byte by) {
        this(updateReportFileWriter, tSLDownloader, certDb, manifestSigner, certDB, tSLCache, list, list2, updaterProgress, file);
    }

    public static class TSLUpdaterBuilder {
        private UpdateReportFileWriter a;
        private TSLDownloader b;
        private CertDb c;
        private ManifestSigner d;
        private CertDB e;
        private TSLCache f;
        private List<String> g;
        private List<String> h;
        private UpdaterProgress i;
        private File j;

        private TSLUpdaterBuilder() {
        }

        public TSLUpdaterBuilder setReportWriter(UpdateReportFileWriter updateReportFileWriter) {
            this.a = updateReportFileWriter;
            return this;
        }

        public TSLUpdaterBuilder setTslDownloader(TSLDownloader tSLDownloader) {
            this.b = tSLDownloader;
            return this;
        }

        public TSLUpdaterBuilder setCdb(CertDb certDb) {
            this.c = certDb;
            return this;
        }

        public TSLUpdaterBuilder setManifestSigner(ManifestSigner manifestSigner) {
            this.d = manifestSigner;
            return this;
        }

        public TSLUpdaterBuilder setOldFormatCdb(CertDB certDB) {
            this.e = certDB;
            return this;
        }

        public TSLUpdaterBuilder setTslCache(TSLCache tSLCache) {
            this.f = tSLCache;
            return this;
        }

        public TSLUpdaterBuilder setIgnoreTSL(List<String> list) {
            this.g = list;
            return this;
        }

        public TSLUpdaterBuilder setIgnoreVerificationTSL(List<String> list) {
            this.h = list;
            return this;
        }

        public TSLUpdaterBuilder setProgress(UpdaterProgress updaterProgress) {
            this.i = updaterProgress;
            return this;
        }

        public TSLUpdaterBuilder setIndexLastUpdFile(File file) {
            this.j = file;
            return this;
        }

        public TSLUpdater build() {
            return new TSLUpdater(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, 0);
        }

        /* synthetic */ TSLUpdaterBuilder(byte by) {
            this();
        }
    }
}

