/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.utils;

import esecurity.crypto.gui.beans.CardCertificateListHandler;
import esecurity.crypto.gui.functionality.ValidationFacade;
import esecurity.crypto.gui.model.CardHandler;
import esecurity.crypto.gui.model.signer.CardSigner;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.ValidationProfile;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.TokenHelper;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.pkcs11.CapiPKCS11Exception;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pkcs11.card.Card;
import it.arubapec.ca.pkcs11.card.CardService;
import it.arubapec.ca.pkcs11.card.ReaderEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CardMonitor {
    private static final EllipsLogger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final List<Runnable> b = new ArrayList<Runnable>();
    private static final List<Runnable> c = new ArrayList<Runnable>();
    private static final Object d = new Object();
    private static final CardService e = CardService.getInstance();
    private static boolean f = false;

    public static boolean isIsLoading() {
        return f;
    }

    public static void setIsLoading(boolean bl) {
        f = bl;
    }

    public static void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOnStartReloadingListener(Runnable runnable) {
        List<Runnable> list = c;
        synchronized (list) {
            c.add(runnable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeOnStartReloadingListener(Runnable runnable) {
        List<Runnable> list = c;
        synchronized (list) {
            c.remove(runnable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOnEndReloadingListener(Runnable runnable) {
        List<Runnable> list = b;
        synchronized (list) {
            b.add(runnable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeOnEndReloadingListener(Runnable runnable) {
        List<Runnable> list = b;
        synchronized (list) {
            b.remove(runnable);
            return;
        }
    }

    private static List<CardHandler> a(CardService object) throws IOException {
        ArrayList<CardHandler> arrayList = new ArrayList<CardHandler>();
        try {
            for (Card card : object.retrieveCardList()) {
                TokenSpi tokenSpi = null;
                try {
                    a.info("Loading card " + card.getSerial());
                    a.debug("Inizializzazione Token PKCS11");
                    tokenSpi = card.getToken();
                    a.debug("Token Inizializzato");
                    TokenHelper.openPublicSession((TokenSpi)tokenSpi);
                    String[] stringArray = TokenHelper.listObjects((TokenSpi)tokenSpi, null, (byte)18);
                    ArrayList<CardSigner> arrayList2 = new ArrayList<CardSigner>();
                    for (String string : stringArray) {
                        try {
                            String string2 = TokenHelper.getCertificate((TokenSpi)tokenSpi, (String)string);
                            string2 = new Certificate(string2.getBytes());
                            a.debug("Start pkcs11 cert validation");
                            string2 = ValidationFacade.verifyCertificate((Certificate)string2, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, null);
                            a.debug("Certificate validated");
                            arrayList2.add(new CardSigner(card, string, (ValidatedCertificate)string2));
                        }
                        catch (CapiException capiException) {
                            a.info(capiException.getMessage());
                        }
                    }
                    arrayList.add(new CardHandler(card, arrayList2));
                    if (tokenSpi == null) continue;
                }
                catch (Throwable throwable) {
                    try {
                        a.error(throwable.getMessage(), throwable);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        if (tokenSpi == null) continue;
                        TokenHelper.destroy(tokenSpi);
                        continue;
                    }
                }
                TokenHelper.destroy((TokenSpi)tokenSpi);
            }
        }
        catch (CapiException | CapiPKCS11Exception throwable) {
            a.error(throwable.getMessage(), throwable);
        }
        return arrayList;
    }

    static {
        e.addListener(object -> {
            if (ReaderEvent.ReaderEventType.onChange.equals((Object)object.getType())) {
                try {
                    object = d;
                    synchronized (object) {
                        List<Runnable> object32 = c;
                        synchronized (object32) {
                            for (Runnable runnable : c) {
                                new Thread(runnable, "CardMonitorStartReloading").start();
                            }
                        }
                        System.setProperty("esecurity.pkcs11.dsPinIsCnsPinSys", "true");
                        CardMonitor.setIsLoading(true);
                        List<CardHandler> list = CardCertificateListHandler.getInstance().getCardCerts();
                        Iterator<Runnable> iterator = CardMonitor.a(e);
                        CardCertificateListHandler.getInstance().replaceAll(list, iterator);
                        List<Runnable> list2 = b;
                        synchronized (list2) {
                            for (Runnable runnable : b) {
                                new Thread(runnable, "CardMonitorEndReloading").start();
                            }
                        }
                    }
                    return;
                }
                catch (IOException iOException) {
                    a.error(iOException.getMessage(), (Throwable)iOException);
                    return;
                }
                finally {
                    CardMonitor.setIsLoading(false);
                }
            }
        });
    }
}

