/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider.pkcs11;

import esecurity.enroll.CSRUtils;
import esecurity.enroll.bean.CertificateFields;
import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.capi.provider.pkcs11.Bit4IDConfigPkcs11Params;
import it.actalis.ellips.capi.provider.pkcs11.DsPinCallBack;
import it.actalis.ellips.capi.provider.pkcs11.a;
import it.actalis.ellips.capi.util.ECUtils;
import it.actalis.ellips.capi.util.KeyUtils;
import it.actalis.pkcs11.CapiPKCS11Exception;
import it.actalis.pkcs11.PKCS11;
import it.actalis.pkcs11.PKCS11Info;
import it.actalis.pkcs11.PKCS11MechanismInfo;
import it.actalis.pkcs11.PKCS11Object;
import it.actalis.pkcs11.PKCS11Session;
import it.actalis.pkcs11.PKCS11Slot;
import it.actalis.pkcs11.PKCS11SlotInfo;
import it.actalis.pkcs11.PKCS11TokenInfo;
import it.actalis.pkcs11.Pkcs11ExceptionUtils;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.pkcs11.nat.NativePKCS11Session;
import it.actalis.pkcs11.nat.NativePKCS11Slot;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pkcs11.card.CNSStrategy;
import it.arubapec.ca.pkcs11.card.Card;
import it.arubapec.ca.pkcs11.card.CardFamily;
import it.arubapec.ca.pkcs11.card.DSStrategy;
import it.arubapec.ca.pkcs11.card.FSStrategy;
import it.arubapec.ca.pkcs11.card.FSStrategyParameters;
import it.arubapec.ca.pkcs11.card.athena.AthenaDsFsGenerator;
import it.arubapec.ca.pkcs11.card.athena.AthenaFsStrategyParameters;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class PKCS11Token
extends TokenSpi {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private CardFamily b = null;
    private DsPinCallBack c = null;
    public static boolean mcccompatibilitymode = true;
    private PKCS11 d = null;
    private PKCS11Slot e = null;
    private PKCS11SlotInfo f = null;
    private PKCS11TokenInfo g = null;
    private long h = 0L;
    private PKCS11Session i = null;
    private String[] j = null;
    private String k = null;
    private int l = -1;
    private int m = 0;
    private byte[] n = new byte[]{122, 123, 124, 125, 126, 127};
    private int o = 0;
    private static boolean p = false;
    private HashMap<String, a> q = null;
    private HashMap<String, a> r = null;
    private boolean s = false;
    private Bit4IDConfigPkcs11Params t = Bit4IDConfigPkcs11Params.DEFAULT;
    private Bit4IDConfigPkcs11Params u = Bit4IDConfigPkcs11Params.DEFAULT;
    private boolean v = false;

    public PKCS11Token() {
        a.debug("build new PKCS11Token");
    }

    public boolean exist(String string) throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        return this.q.containsKey(string);
    }

    public String generateID(String[] stringArray) {
        this.k = stringArray[0];
        this.l = -1;
        if (stringArray.length > 1 && stringArray[1] != null) {
            this.l = Integer.parseInt(stringArray[1]);
        }
        return this.k + "(slot=" + this.l + ")";
    }

    @Deprecated
    public void initializeLib(String[] stringArray, boolean bl) throws CapiException {
        a.debug("[PKCS11TokenConstants.initializeLib] con parametro tokenSoftSia");
        this.initializeLib(stringArray);
    }

    public void initializeLib(String[] object) throws CapiException {
        PKCS11Token pKCS11Token = this;
        pKCS11Token.initProviders(pKCS11Token);
        a.debug("parsing pkcs11 args");
        if (object == null || ((String[])object).length <= 0 || object[0] == null) {
            throw new CapiException("Null parameters", 1001);
        }
        this.k = object[0];
        this.l = -1;
        this.m = 0;
        p = false;
        try {
            if (((String[])object).length > 1 && object[1] != null) {
                this.l = Integer.parseInt(object[1]);
            }
            if (((String[])object).length > 2 && object[2] != null) {
                this.m = Integer.parseInt(object[2]);
            }
            if (((String[])object).length > 3 && object[3] != null) {
                Long.parseLong(object[3]);
            }
            if (((String[])object).length > 5 && object[5] != null && object[5].toLowerCase().startsWith("y")) {
                p = true;
            }
            a.debug("using ckaprivate attribute set to " + p);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Invalid parameters", 1002);
        }
        try {
            a.debug("loading actalisjpkcs11 library, then loading p11library: " + object[0]);
            this.d = NativePKCS11.getInstance(object[0], true);
            a.debug("loaded  actalisjpkcs11 library");
            object = this.d.getInfo();
            a.debug("library info:\n" + object);
            this.j = new String[9];
            this.j[0] = "Cryptoki " + ((PKCS11Info)object).cryptokiVersion() + " (java bridge v" + this.d.getBridgeVersion() + ")";
            this.j[1] = this.k + " (slot=" + this.l + " flags=" + this.m + ")";
            this.j[2] = ((PKCS11Info)object).libraryDescription();
            this.j[3] = ((PKCS11Info)object).libraryVersion().toString();
            this.j[4] = ((PKCS11Info)object).manufacturerID();
            this.j[5] = "N/A";
            this.j[6] = "N/A";
            this.j[7] = "N/A";
            this.j[8] = "N/A";
            return;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        catch (Error | Exception throwable) {
            a.debug(throwable.getMessage());
            throw new CapiException("Cannot link Library", 11000);
        }
    }

    public void initializeLib(TokenParameters tokenParameters) throws CapiException {
        if (!(tokenParameters instanceof Card)) {
            throw new UnsupportedOperationException("Not supported TokenParameters.");
        }
        tokenParameters = (Card)tokenParameters;
        this.b = tokenParameters.getCardFamily();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.b.getSelected_lib().getDrive());
        linkedList.add(String.format("%d", ((NativePKCS11Slot)tokenParameters.getSlot()).getNativeID()));
        if (this.b.getName().equalsIgnoreCase("GEMALTO")) {
            linkedList.add("4");
        }
        this.initializeLib(linkedList.toArray(new String[0]));
    }

    public void setCardFamily(CardFamily cardFamily) {
        this.b = cardFamily;
    }

    public void finalizeLib() {
        try {
            this.i.logout();
            this.v = false;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
        }
        try {
            this.i.close();
        }
        catch (Exception exception) {
            a.info(exception.getMessage());
        }
        try {
            a.debug("unloadLibrary ?");
            ((NativePKCS11)this.d).unloadLibrary();
        }
        catch (Error | Exception throwable) {
            a.debug(throwable.getMessage());
        }
        this.d = null;
        this.i = null;
        this.e = null;
        this.f = null;
        this.k = null;
        this.l = -1;
        this.m = 0;
        this.j = null;
        PKCS11Token.removeProvider((String)"Actalis");
        a.debug("closed Actalis security provider");
    }

    public String[] getLibInfo() {
        try {
            if (!this.isTokenInserted()) {
                return this.j;
            }
            String[] stringArray = new String[9];
            for (int i = 0; i < 5; ++i) {
                stringArray[i] = this.j[i];
            }
            if ((this.m & 0x80) != 0) {
                stringArray[5] = this.f.description();
                stringArray[6] = this.f.manufacturer();
                PKCS11TokenInfo pKCS11TokenInfo = this.c();
                a.debug("get info from token");
                stringArray[7] = pKCS11TokenInfo.model();
                stringArray[8] = pKCS11TokenInfo.manufacturer();
                return stringArray;
            }
            a.debug("getting info ... ");
            Object object = this.e.getInfo();
            a.debug("get info from tokenslot.");
            stringArray[5] = ((PKCS11SlotInfo)object).description();
            stringArray[6] = ((PKCS11SlotInfo)object).manufacturer();
            object = this.e.getTokenInfo();
            a.debug("get info from token.");
            stringArray[7] = ((PKCS11TokenInfo)object).model();
            stringArray[8] = ((PKCS11TokenInfo)object).manufacturer();
            return stringArray;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            return this.j;
        }
    }

    public boolean isTokenInserted() throws CapiException {
        a.debug("isTokenInserted?");
        if (this.e != null) {
            try {
                if ((this.m & 0x80) != 0) {
                    this.f = this.e.getInfo();
                    a.debug("get info from tokenslot");
                    if (this.f.tokenPresent()) {
                        return true;
                    }
                } else if (this.e.getInfo().tokenPresent()) {
                    a.debug("tokenPresent into tokenslot");
                    return true;
                }
            }
            catch (Exception exception) {
                a.debug(exception.getMessage());
                a.debug("...but the exception is ignored");
            }
        }
        try {
            this.a();
            if ((this.m & 0x80) != 0) {
                this.f = this.e.getInfo();
                a.debug("get info after gettokenslot");
                if (this.f.tokenPresent()) {
                    a.debug("token present");
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (CapiException capiException) {
            CapiException capiException2 = capiException;
            if (capiException.getErrorCode() == 10014) {
                throw capiException2;
            }
            if (capiException2.getErrorCode() == 11004) {
                throw capiException2;
            }
            a.debug(capiException2.getMessage());
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            a.debug("exception is ignored");
        }
        return false;
    }

    public String getLibName() {
        return this.k;
    }

    public String getLabel() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            if ((this.m & 0x80) != 0) {
                PKCS11TokenInfo pKCS11TokenInfo = this.c();
                a.debug("get info from token");
                return pKCS11TokenInfo.label();
            }
            return this.e.getTokenInfo().label();
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
    }

    public String getSerialNumber() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            if ((this.m & 0x40) != 0) {
                if ((this.m & 0x80) != 0) {
                    PKCS11TokenInfo pKCS11TokenInfo = this.c();
                    a.debug("get info from token");
                    return pKCS11TokenInfo.label();
                }
                return this.e.getTokenInfo().label();
            }
            return this.e.getTokenInfo().serialNumber();
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
    }

    public long getFreeSpace() throws CapiException {
        try {
            if (!this.isTokenInserted()) {
                throw new CapiException("Token not inserted", 10011);
            }
            if ((this.m & 0x80) != 0) {
                PKCS11TokenInfo pKCS11TokenInfo = this.c();
                a.debug("get info from token");
                return pKCS11TokenInfo.freePrivateMemory();
            }
            return this.e.getTokenInfo().freePrivateMemory();
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changePIN(String string, String string2) throws CapiException {
        block9: {
            if (!this.isTokenInserted()) {
                throw new CapiException("Token not inserted", 10011);
            }
            boolean bl = !this.isSessionOpen() || this.isSessionOpen() && !this.v;
            if (bl) {
                if (this.isSessionOpen()) {
                    this.closeSession();
                }
                this.openSession(false, string);
            }
            try {
                this.i.setPIN(string, string2);
                if (bl) break block9;
            }
            catch (CapiPKCS11Exception capiPKCS11Exception) {
                try {
                    a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
                    throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
                    catch (Exception exception) {
                        a.debug(exception.getMessage());
                        throw new CapiException("Internal error", 10040);
                    }
                }
                catch (Throwable throwable) {
                    if (!bl) {
                        this.closeSession();
                    }
                    throw throwable;
                }
            }
            this.closeSession();
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changePUK(String string, String string2) throws CapiException {
        block9: {
            if (!this.isTokenInserted()) {
                throw new CapiException("Token not inserted", 10011);
            }
            boolean bl = !this.isSessionOpen() || this.isSessionOpen() && this.v;
            if (bl) {
                if (this.isSessionOpen()) {
                    this.closeSession();
                }
                this.openSession(true, string);
            }
            try {
                this.i.setPIN(string, string2);
                if (!bl) break block9;
            }
            catch (CapiPKCS11Exception capiPKCS11Exception) {
                try {
                    a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
                    throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
                    catch (Exception exception) {
                        a.debug(exception.getMessage());
                        throw new CapiException("Internal error", 10040);
                    }
                }
                catch (Throwable throwable) {
                    if (bl) {
                        this.closeSession();
                    }
                    throw throwable;
                }
            }
            this.closeSession();
            return;
        }
    }

    public void unblockPIN(String string, String string2) throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        if (this.isSessionOpen()) {
            this.closeSession();
        }
        if ((this.m & 0x40) != 0) {
            byte[] byArray = Hex.encode((byte[])string.getBytes());
            this.openSessionEllips(string);
            try {
                a.debug("setPIN ... ");
                this.i.setPINellips(byArray, byArray);
                try {
                    this.i.logout();
                    this.v = false;
                }
                catch (Exception exception) {}
            }
            catch (CapiPKCS11Exception capiPKCS11Exception) {
                a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
                throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
            }
            catch (Exception exception) {
                a.debug(exception.getMessage());
                throw new CapiException("Internal error", 10040);
            }
            a.debug("unblocking to default Ellips PIN done");
            this.changePIN("12345", string2);
            a.debug("unblocking PIN done");
            this.closeSession();
            return;
        }
        this.openSession(true, string);
        a.debug("unblocking PIN ... ");
        try {
            this.i.initPIN(string2);
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
            if (capiPKCS11Exception.getErrorCode() == 160L || "CKR_PIN_INCORRECT".equals(capiPKCS11Exception.getMessage())) {
                throw new CapiException("PIN not blocked or operation invalid", 2011);
            }
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Internal error", 10040);
        }
        a.debug("unblocking PIN done");
        this.closeSession();
    }

    public void openSession(boolean bl, String string, int n) throws CapiException {
        try {
            if (this.l != n) {
                this.l = n;
                this.a();
            }
            a.debug("before openSession");
            this.i = this.e.openSession(6L, null, null);
            PKCS11Token pKCS11Token = this;
            pKCS11Token.a((NativePKCS11Session)pKCS11Token.i);
            a.debug(this.i.getInfo().toString());
            a.debug("before login");
            if ((this.m & 0x20) == 0) {
                this.i.login(bl, string);
            }
            a.debug(this.i.getInfo().toString());
            a.debug("after openSession loading objects");
            if (!bl) {
                this.b();
            }
            a.debug("after openSession loaded objects");
            return;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            this.i = null;
            a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception, bl);
        }
    }

    public void openSession(boolean bl, String string) throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            a.debug("before closeAllSessions");
            if (this.i != null) {
                this.i.close();
            }
            a.debug("before openSession");
            this.i = this.e.openSession(6L, null, null);
            PKCS11Token pKCS11Token = this;
            pKCS11Token.a((NativePKCS11Session)pKCS11Token.i);
            a.debug(this.i.getInfo().toString());
            a.debug("before login");
            if ((this.m & 0x20) == 0) {
                this.i.login(bl, string);
                this.v = !bl;
            }
            a.debug(this.i.getInfo().toString());
            a.debug("after openSession loading objects");
            if (!bl) {
                this.b();
            }
            a.debug("after openSession loaded objects");
            return;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            this.i = null;
            a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception, bl);
        }
    }

    public void openPublicSession() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        a.debug("openPublicSession loading public objects");
        try {
            a.debug("before closeAllSessions");
            if (this.i != null) {
                this.i.close();
            }
            a.debug("before openSession");
            this.i = this.e.openSession(6L, null, null);
            PKCS11Token pKCS11Token = this;
            pKCS11Token.a((NativePKCS11Session)pKCS11Token.i);
            a.debug(this.i.getInfo().toString());
            this.b();
            return;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            this.i = null;
            a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception, false);
        }
    }

    public void openSessionAuthPath(boolean bl) throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            long l;
            if ((this.m & 0x80) != 0) {
                PKCS11TokenInfo pKCS11TokenInfo = this.c();
                a.debug("get info from token");
                l = pKCS11TokenInfo.flags();
                a.debug("Flags: " + pKCS11TokenInfo.flagsToString(" | "));
            } else {
                l = this.e.getTokenInfo().flags();
                a.debug("Flags: " + this.e.getTokenInfo().flagsToString(" | "));
            }
            if ((l & 0x100L) == 0L) {
                throw new CapiPKCS11Exception(84L);
            }
            a.debug("before closeAllSessions");
            if (this.i != null) {
                this.i.close();
            }
            this.i = this.e.openSession(6L, null, null);
            PKCS11Token pKCS11Token = this;
            pKCS11Token.a((NativePKCS11Session)pKCS11Token.i);
            a.debug("before login");
            this.i.loginAuthPath(bl);
            if (!bl) {
                a.debug(this.i.getInfo().toString());
                a.debug("after openSession loading objects");
                this.b();
                a.debug("after openSession loaded objects");
            }
            return;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            this.i = null;
            a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception, bl);
        }
    }

    public void closeSession() throws CapiException {
        try {
            this.i.logout();
            this.v = false;
        }
        catch (Exception exception) {}
        try {
            this.i.close();
        }
        catch (Exception exception) {}
        this.i = null;
        this.q = null;
    }

    public boolean isSessionOpen() throws CapiException {
        a.debug("isSessionOpen ?");
        if (this.i == null) {
            return false;
        }
        try {
            a.debug("isSessionOpen: session.getInfo().state() ? ");
            long l = this.i.getInfo().state();
            a.debug("isSessionOpen: session.getInfo().state() = " + l);
            if ((this.m & 0x20) != 0 && l == 2L) {
                return true;
            }
            if (l == 3L) {
                return true;
            }
            if (l == 2L) {
                return true;
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
        }
        return false;
    }

    public String[] listObjects(String string, byte by) throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            String[] stringArray = new String[this.q.size()];
            if (this.q.isEmpty()) {
                return stringArray;
            }
            int n = 0;
            for (String string2 : this.q.keySet()) {
                if ((this.getObjectType(string2) & by) == 0 || string != null && !string2.contains(string)) continue;
                stringArray[n] = string2;
                ++n;
            }
            if (n == 0) {
                return new String[0];
            }
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = stringArray[i];
            }
            return stringArray2;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Internal error: " + exception.getMessage(), 10040);
        }
    }

    public byte getObjectType(String object) throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            object = this.q.get(object);
            if (object == null) {
                throw new CapiException("Object not found", 10023);
            }
            return ((a)object).a();
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage());
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Object not found", 10023);
        }
    }

    public String getObjectID(String object) throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            object = this.q.get(object);
            if (object == null) {
                throw new CapiException("Object not found", 10023);
            }
            return ((a)object).c();
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage());
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Object not found", 10023);
        }
    }

    public void deleteObject(String string) throws CapiException {
        this.a(string, 1);
    }

    public void renameObject(String string, String string2, int n) throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            a a2 = this.q.get(string);
            if (a2 == null) {
                throw new CapiException("Object not found", 10023);
            }
            this.a(string2, n);
            Object[] objectArray = a2.i();
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = string2;
                PKCS11Object pKCS11Object = (PKCS11Object)objectArray[i];
                try {
                    a.debug("renaming " + string3);
                    pKCS11Object.setAttributeValue(3L, string3);
                    a.debug("renamed  " + string3);
                    continue;
                }
                catch (CapiPKCS11Exception capiPKCS11Exception) {
                    a.debug(capiPKCS11Exception.getMessage());
                    throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
                }
                catch (Exception exception) {
                    a.debug(exception.getMessage());
                    throw new CapiException("Internal error", 1003);
                }
            }
            a2.a(string2);
            this.q.remove(string);
            this.a(string2, a2);
            return;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage());
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Internal error", 10040);
        }
    }

    public int getObjectSize(String objectArray) throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (this.q.containsKey(objectArray)) {
            try {
                objectArray = this.q.get(objectArray);
                objectArray = objectArray.i();
                int n = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    n = (int)((long)n + ((PKCS11Object)objectArray[i]).size());
                }
                if (n < 0) {
                    n = -1;
                }
                return n;
            }
            catch (CapiPKCS11Exception capiPKCS11Exception) {
                a.debug(capiPKCS11Exception.getMessage());
                if (capiPKCS11Exception.getErrorCode() == 84L || "CKR_FUNCTION_NOT_SUPPORTED".equals(capiPKCS11Exception.getMessage())) {
                    return -1;
                }
                if (capiPKCS11Exception.getErrorCode() == 368L || "CKR_INFORMATION_SENSITIVE".equals(capiPKCS11Exception.getMessage())) {
                    return -1;
                }
                if ((capiPKCS11Exception.getErrorCode() == 130L || "CKR_OBJECT_HANDLE_INVALID".equals(capiPKCS11Exception.getMessage())) && this.k.startsWith("etpk")) {
                    a.debug("object handle invalid for etoken");
                    return -1;
                }
                throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
            }
            catch (Exception exception) {
                a.debug(exception.getMessage());
                throw new CapiException("Internal error", 10040);
            }
        }
        throw new CapiException("Object not found", 10023);
    }

    public int getKeyUsage(String string, boolean bl) throws CapiException {
        a.debug("getting key usage alias=" + string);
        PKCS11Object pKCS11Object = this.b(string, 3);
        if (pKCS11Object == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            a.debug("getting BOOL attribute SIGN ");
            boolean bl2 = pKCS11Object.getBoolAttributeValue(264L);
            a.debug("get BOOL attribute SIGN ");
            boolean bl3 = pKCS11Object.getBoolAttributeValue(261L);
            a.debug("get BOOL attribute DECRYPT ");
            if (bl2 && !bl3) {
                return 1;
            }
            if (!bl2 && bl3) {
                return 2;
            }
            if (!bl) {
                return 3;
            }
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        try {
            String string2 = this.getCert(string);
            Certificate certificate = new Certificate(Util.getBytes((String)string2));
            byte by = (byte)(certificate.getKeyUsageBits() % 256);
            bl = (by & 0x63) > 0;
            byte by2 = by = (by & 0xC) > 0 ? (byte)1 : 0;
            if (bl && by == 0) {
                return 1;
            }
            if (!bl && by != 0) {
                return 2;
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            a.debug("exception ignored");
        }
        return 3;
    }

    public byte[] getData(String object) throws CapiException {
        if ((object = this.b((String)object, 0)) == null) {
            throw new CapiException("Object not found", 10020);
        }
        try {
            a.debug("getting DATA attribute value");
            object = ((PKCS11Object)object).getByteArrayAttributeValue(17L);
            a.debug("get DATA attribute value");
            return object;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
    }

    public void setData(String string, byte[] object, int n) throws CapiException {
        try {
            this.a(string, n);
            Object object2 = new long[]{0L, 1L, 2L, 16L, 3L, 17L};
            object = new Object[]{PKCS11Object.DATA, Boolean.TRUE, Boolean.TRUE, "Ellips", string, object};
            a.debug("creating DATA object");
            object = this.i.createObject((long[])object2, (Object[])object);
            a.debug("created  DATA object");
            boolean bl = false;
            object2 = string;
            PKCS11Token pKCS11Token = this;
            pKCS11Token.a((PKCS11Object)object, (String)object2, 0, null);
            return;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage());
            throw capiException;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
    }

    public String getCert(String string) throws CapiException {
        Object object = this.b(string, 1);
        if (object == null) {
            throw new CapiException("Object not found", 10022);
        }
        try {
            a.debug("getting Cert alias=" + string);
            if ((this.m & 0x80) != 0) {
                Object object2;
                String string2 = string;
                Object object3 = this;
                if (object3.q == null) {
                    throw new CapiException("Session not opened", 10013);
                }
                if (object3.q.containsKey(string2)) {
                    object3 = object3.q.get(string2);
                    object2 = ((a)object3).k();
                } else {
                    object2 = object3 = null;
                }
                if (object2 == null) {
                    object = ((PKCS11Object)object).getByteArrayAttributeValue(17L);
                    a.debug("getCert Attribute alias=" + string);
                    if (object != null) {
                        object3 = Util.base64EncodeStr((byte[])object);
                        this.a(string, (String)object3);
                        a.debug("getCert alias=" + string);
                        return object3;
                    }
                    a.debug("getCert null alias=" + string);
                    return null;
                }
                if (!string.equals(object = ((PKCS11Object)object).getStringAttributeValue(3L))) {
                    throw new CapiException("alias not found", 10023);
                }
                a.debug("getCert b64 alias=" + string);
                return object3;
            }
            byte[] byArray = ((PKCS11Object)object).getByteArrayAttributeValue(17L);
            a.debug("getCert alias=" + string);
            if (byArray != null) {
                return Util.base64EncodeStr((byte[])byArray);
            }
            return null;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage());
            throw capiException;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Internal error", 1003);
        }
    }

    public String installCertificate(Certificate certificate) throws CapiException {
        Object object;
        a.debug("installCertificate find alias ...");
        PublicKey publicKey = null;
        String object2 = null;
        for (String object3 : this.q.keySet()) {
            if ((this.getObjectType(object3) & 0xC) <= 0) continue;
            PublicKey publicKey2 = this.getPublicKey(object3);
            if (!certificate.getPublicKey().equals(publicKey2)) continue;
            PKCS11Token pKCS11Token = this;
            if (!pKCS11Token.checkKeyUsage(pKCS11Token.getKeyUsage(object3, true), certificate.getKeyUsageBits())) continue;
            publicKey = publicKey2;
            object2 = object3;
            break;
        }
        if (publicKey == null) {
            throw new CapiException("Public key not corresponding", 10033);
        }
        a.debug("Public key Found {}", object2);
        try {
            PKCS11Object capiPKCS11Exception = this.b(object2, 3);
            a.debug("instCert getting prvkey ID");
            object = capiPKCS11Exception.getByteArrayAttributeValue(258L);
            a.debug("instCert get prvkey ID");
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        this.setCert(object2, certificate, 9, (byte[])object, false);
        return object2;
    }

    public void setCert(String string, byte[] object, int n, boolean bl) throws CapiException {
        object = new Certificate(object);
        PKCS11Token pKCS11Token = this;
        byte[] byArray = pKCS11Token.a(pKCS11Token.hash(((RSAKey)((Object)object.getPublicKey())).getModulus().toByteArray()));
        this.setCert(string, (Certificate)object, n, byArray, bl);
    }

    public void setCert(String string, Certificate certificate, int n, byte[] byArray, boolean bl) throws CapiException {
        a.debug("setCert alias=" + string);
        a.debug("setCert ckapriv=" + bl);
        try {
            this.a(string, n);
            Object object = new ArrayList<Long>();
            ((ArrayList)object).add(0L);
            ((ArrayList)object).add(1L);
            ((ArrayList)object).add(128L);
            ((ArrayList)object).add(2L);
            ((ArrayList)object).add(258L);
            ((ArrayList)object).add(3L);
            ((ArrayList)object).add(257L);
            ((ArrayList)object).add(129L);
            ((ArrayList)object).add(130L);
            ((ArrayList)object).add(17L);
            if (this.s) {
                ((ArrayList)object).add(370L);
            }
            object = Util.longArrayFromList(object);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(PKCS11Object.CERTIFICATE);
            arrayList.add(Boolean.TRUE);
            arrayList.add(PKCS11Object.X_509);
            arrayList.add(bl ? Boolean.TRUE : Boolean.FALSE);
            arrayList.add(byArray);
            arrayList.add(string.toCharArray());
            arrayList.add(certificate.getSubjectName().getEncoded());
            arrayList.add(certificate.getIssuerName().getEncoded());
            arrayList.add(certificate.getInternalCert().getSerialNumber().toByteArray());
            arrayList.add(Util.base64DecodeStr((String)certificate.getEncoded()));
            if (this.s) {
                arrayList.add(Boolean.FALSE);
            }
            ArrayList<Object> arrayList2 = arrayList;
            Object[] objectArray = arrayList2.toArray(new Object[arrayList2.size()]);
            a.debug("creating cert object");
            object = this.i.createObject((long[])object, objectArray);
            a.debug("set cert object");
            string = this.a((PKCS11Object)object, string, 1, byArray);
            a.debug("setCert addobj done");
            if ((this.m & 0x80) != 0) {
                this.a(string, certificate.getEncoded());
            }
            return;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
    }

    public void setCkaId(String string, String string2, byte[] byArray) throws CapiException {
        PKCS11Object pKCS11Object = null;
        boolean bl = false;
        try {
            this.i.findObjectsInit(null, null);
            for (PKCS11Object pKCS11Object2 : this.i.findObject()) {
                int n = pKCS11Object2.getIntAttributeValue(0L);
                String string3 = pKCS11Object2.getStringAttributeValue(3L);
                if ((long)n == PKCS11Object.PRIVATE_KEY) {
                    string3.equals(string);
                }
                if ((long)n == PKCS11Object.PUBLIC_KEY) {
                    string3.equals(string);
                }
                if ((long)n != PKCS11Object.CERTIFICATE || !string3.equals(string)) continue;
                pKCS11Object = pKCS11Object2;
                bl = true;
                a.debug("trovato certificato " + string);
            }
            this.i.findObjectsFinal();
            a.debug("OBJECT LIST END\n");
            if (!bl || pKCS11Object == null) {
                a.debug("Non trovato certificato " + string);
                return;
            }
            pKCS11Object.setAttributeValue(258L, byArray);
            pKCS11Object.setAttributeValue(3L, string2);
            a.debug("ckaId e label changed.");
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            a.debug(" --> change ID and/or label " + string + " non performed: " + exception2.getMessage());
            return;
        }
    }

    public boolean canImport() {
        return (this.m & 1) <= 0;
    }

    public boolean canExport(String object) {
        a.debug("canExport: alias=" + (String)object);
        if ((this.m & 2) > 0) {
            return false;
        }
        a.debug("canExport: alias null=" + (String)object);
        if (object == null) {
            return true;
        }
        a.debug("canExport: findObj =" + (String)object);
        try {
            object = this.b((String)object, 3);
            if (object == null) {
                return false;
            }
            a.debug("canExport: getbool ");
            boolean bl = ((PKCS11Object)object).getBoolAttributeValue(259L);
            a.debug("canExport: sensitive= " + bl);
            if (bl) {
                return false;
            }
            a.debug("canExport: return true ");
            return true;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            return false;
        }
    }

    public int canUnblock() {
        if ((this.m & 8) > 0) {
            return 0;
        }
        if ((this.m & 0x10) > 0) {
            return 1;
        }
        return 2;
    }

    public void genKeyPair(String string, int n, int n2, int n3) throws CapiException {
        this.genKeyPair(string, KeyAlgo.RSA, n, n2, n3);
    }

    public void genKeyPair(String string, KeyAlgo object, int n, int n2, int n3) throws CapiException {
        this.a(string, n3);
        try {
            boolean bl;
            Object object2;
            boolean bl2;
            n3 = n != 2 ? 1 : 0;
            boolean bl3 = bl2 = n != 1;
            if (n == 3) {
                n3 = 1;
                bl2 = true;
            }
            Object object3 = object2 = bl2 ? Boolean.FALSE : Boolean.TRUE;
            if ((this.m & 4) > 0) {
                object2 = Boolean.TRUE;
            }
            if ((this.m & 0x200) > 0) {
                p = true;
            }
            Object[] objectArray = new ArrayList();
            PKCS11Object[] pKCS11ObjectArray = new ArrayList();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            objectArray.add(1L);
            objectArray.add(289L);
            objectArray.add(262L);
            objectArray.add(266L);
            objectArray.add(260L);
            objectArray.add(258L);
            objectArray.add(3L);
            if (this.s) {
                objectArray.add(370L);
            }
            pKCS11ObjectArray.add(Boolean.TRUE);
            pKCS11ObjectArray.add(n2);
            pKCS11ObjectArray.add(bl2 ? Boolean.TRUE : Boolean.FALSE);
            pKCS11ObjectArray.add(n3 != 0 ? Boolean.TRUE : Boolean.FALSE);
            pKCS11ObjectArray.add(bl2 ? Boolean.TRUE : Boolean.FALSE);
            pKCS11ObjectArray.add(Util.getBytes((String)string));
            pKCS11ObjectArray.add(string);
            if (this.s) {
                pKCS11ObjectArray.add(Boolean.FALSE);
            }
            arrayList.add(1L);
            arrayList.add(2L);
            arrayList.add(259L);
            arrayList.add(263L);
            arrayList.add(264L);
            arrayList.add(261L);
            arrayList.add(258L);
            arrayList.add(3L);
            if (this.s) {
                arrayList.add(370L);
            }
            arrayList2.add(Boolean.TRUE);
            arrayList2.add(Boolean.TRUE);
            arrayList2.add(object2);
            arrayList2.add(bl2 ? Boolean.TRUE : Boolean.FALSE);
            arrayList2.add(n3 != 0 ? Boolean.TRUE : Boolean.FALSE);
            arrayList2.add(bl2 ? Boolean.TRUE : Boolean.FALSE);
            arrayList2.add(Util.getBytes((String)string));
            arrayList2.add(string);
            if (this.s) {
                arrayList2.add(Boolean.FALSE);
            }
            if (object == KeyAlgo.RSA) {
                objectArray.add(2L);
                objectArray.add(267L);
                objectArray.add(290L);
                pKCS11ObjectArray.add(p ? Boolean.TRUE : Boolean.FALSE);
                pKCS11ObjectArray.add(n3 != 0 ? Boolean.TRUE : Boolean.FALSE);
                pKCS11ObjectArray.add(new BigInteger("65537").toByteArray());
                arrayList.add(265L);
                arrayList2.add(n3 != 0 ? Boolean.TRUE : Boolean.FALSE);
            } else {
                if (n2 == 521) {
                    object2 = SECObjectIdentifiers.secp521r1;
                } else if (n2 == 384) {
                    object2 = SECObjectIdentifiers.secp384r1;
                } else if (n2 == 256) {
                    object2 = SECObjectIdentifiers.secp256r1;
                } else {
                    throw new CapiException("Unsupported Curve Bits", 10031);
                }
                objectArray.add(384L);
                objectArray.add(268L);
                pKCS11ObjectArray.add(object2.getEncoded());
                pKCS11ObjectArray.add(Boolean.FALSE);
                arrayList.add(384L);
                arrayList.add(268L);
                arrayList2.add(object2.getEncoded());
                arrayList2.add(Boolean.FALSE);
            }
            object2 = Util.longArrayFromList(objectArray);
            Object[] objectArray2 = pKCS11ObjectArray.toArray(new Object[pKCS11ObjectArray.size()]);
            long[] lArray = Util.longArrayFromList(arrayList);
            ArrayList<Object> arrayList3 = arrayList2;
            objectArray = arrayList3.toArray(new Object[arrayList3.size()]);
            a.debug("generating keypair");
            int n4 = 0;
            int n5 = 0;
            do {
                if (object == KeyAlgo.RSA) {
                    pKCS11ObjectArray = this.i.generateKeyPair(0L, null, (long[])object2, objectArray2, lArray, objectArray);
                    n4 = pKCS11ObjectArray[0].getBigIntegerAttributeValue(288L).bitLength();
                    if (n4 == n2) {
                        bl = false;
                        a.debug("keypair length ok: " + n4 + " bit");
                    } else {
                        bl = true;
                        a.debug("keypair length ko: " + n4 + " bit");
                        PKCS11Token.a(this.i, string, PKCS11Object.PRIVATE_KEY);
                        a.debug("private key deleted");
                        PKCS11Token.a(this.i, string, PKCS11Object.PUBLIC_KEY);
                        a.debug("public key deleted");
                    }
                    ++n5;
                    continue;
                }
                pKCS11ObjectArray = this.i.generateKeyPair(4160L, null, (long[])object2, objectArray2, lArray, objectArray);
                bl = false;
            } while (bl && n5 < 5);
            if (bl) {
                throw new CapiException("keypair length error (" + n4 + " <> " + n2 + ")", 10031);
            }
            a.debug("generated keypair");
            object = null;
            try {
                object2 = pKCS11ObjectArray[0].getBigIntegerAttributeValue(288L);
                a.debug("get modulus key pair");
                PKCS11Token pKCS11Token = this;
                byte[] byArray = pKCS11Token.a(pKCS11Token.hash(((BigInteger)object2).toByteArray()));
                object2 = byArray;
                object = byArray;
                pKCS11ObjectArray[0].setAttributeValue(258L, object2);
                pKCS11ObjectArray[1].setAttributeValue(258L, object2);
                a.debug("set ID key pair");
            }
            catch (Exception exception) {
                a.error(exception.getMessage());
                a.debug("Unable to change the ID - go on anyway");
            }
            this.a(pKCS11ObjectArray[0], string, 2, (byte[])object);
            object2 = this.a(pKCS11ObjectArray[1], string, 3, (byte[])object);
            if ((this.m & 0x80) != 0) {
                this.a((String)object2, this.getPublicKey((String)object2));
            }
            return;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage());
            throw capiException;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        catch (IOException iOException) {
            throw new CapiException("Unable to generate Key", 1003, (Throwable)iOException);
        }
    }

    private static void a(PKCS11Session pKCS11Session, String objectArray, Object object) {
        try {
            long[] lArray = new long[]{0L, 258L, 3L};
            objectArray = new Object[]{object, Util.getBytes((String)objectArray), objectArray};
            pKCS11Session.findObjectsInit(lArray, objectArray);
            objectArray = pKCS11Session.findObject().length > 0 ? pKCS11Session.findObject()[0] : null;
            objectArray.destroy();
            pKCS11Session.findObjectsFinal();
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            exception.printStackTrace();
            return;
        }
    }

    public String impCred(String string, PrivateKey privateKey, int n, int n2) throws CapiException {
        Boolean bl;
        if (!this.canImport()) {
            throw new CapiException("Cannot import", 11002);
        }
        a.debug("impcred " + string);
        this.a(string, n2);
        n2 = n != 2 ? 1 : 0;
        n = n != 1 ? 1 : 0;
        a.debug("impcred sign " + (n2 != 0) + " ciph " + (n != 0));
        Boolean bl2 = bl = n != 0 ? Boolean.FALSE : Boolean.TRUE;
        if ((this.m & 4) > 0) {
            bl = Boolean.TRUE;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        try {
            byte[] byArray;
            if (privateKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                PKCS11Token pKCS11Token = this;
                byArray = pKCS11Token.a(pKCS11Token.hash(((RSAPrivateKey)privateKey).getModulus().toByteArray()));
                a.debug("impcred getUniqueID ");
                arrayList.add(0L);
                arrayList.add(256L);
                arrayList.add(1L);
                arrayList.add(2L);
                arrayList.add(259L);
                arrayList.add(258L);
                arrayList.add(3L);
                arrayList.add(261L);
                arrayList.add(264L);
                arrayList.add(265L);
                arrayList.add(263L);
                arrayList.add(288L);
                arrayList.add(290L);
                arrayList.add(291L);
                arrayList.add(292L);
                arrayList.add(293L);
                arrayList.add(294L);
                arrayList.add(295L);
                arrayList.add(296L);
                arrayList2.add(PKCS11Object.PRIVATE_KEY);
                arrayList2.add(PKCS11Object.RSA);
                arrayList2.add(Boolean.TRUE);
                arrayList2.add(Boolean.TRUE);
                arrayList2.add(bl);
                arrayList2.add(byArray);
                arrayList2.add(string.toCharArray());
                arrayList2.add(n != 0 ? Boolean.TRUE : Boolean.FALSE);
                arrayList2.add(n2 != 0 ? Boolean.TRUE : Boolean.FALSE);
                arrayList2.add(n2 != 0 ? Boolean.TRUE : Boolean.FALSE);
                arrayList2.add(n != 0 ? Boolean.TRUE : Boolean.FALSE);
                arrayList2.add(((RSAPrivateCrtKey)privateKey).getModulus().toByteArray());
                arrayList2.add(((RSAPrivateCrtKey)privateKey).getPublicExponent().toByteArray());
                arrayList2.add(((RSAPrivateCrtKey)privateKey).getPrivateExponent().toByteArray());
                arrayList2.add(((RSAPrivateCrtKey)privateKey).getPrimeP().toByteArray());
                arrayList2.add(((RSAPrivateCrtKey)privateKey).getPrimeQ().toByteArray());
                arrayList2.add(((RSAPrivateCrtKey)privateKey).getPrimeExponentP().toByteArray());
                arrayList2.add(((RSAPrivateCrtKey)privateKey).getPrimeExponentQ().toByteArray());
                arrayList2.add(((RSAPrivateCrtKey)privateKey).getCrtCoefficient().toByteArray());
            } else {
                PKCS11Token pKCS11Token = this;
                byArray = pKCS11Token.a(pKCS11Token.hash(privateKey.getEncoded()));
                arrayList.add(258L);
                arrayList.add(3L);
                arrayList.add(0L);
                arrayList.add(256L);
                arrayList.add(1L);
                arrayList.add(2L);
                arrayList.add(259L);
                arrayList.add(261L);
                arrayList.add(264L);
                arrayList.add(17L);
                arrayList.add(384L);
                arrayList2.add(byArray);
                arrayList2.add(string.toCharArray());
                arrayList2.add(PKCS11Object.PRIVATE_KEY);
                arrayList2.add(PKCS11Object.ECDSA);
                arrayList2.add(Boolean.TRUE);
                arrayList2.add(Boolean.TRUE);
                arrayList2.add(bl);
                arrayList2.add(n != 0 ? Boolean.TRUE : Boolean.FALSE);
                arrayList2.add(n2 != 0 ? Boolean.TRUE : Boolean.FALSE);
                PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])privateKey.getEncoded()));
                arrayList2.add(((DEROctetString)((DLSequence)privateKeyInfo.parsePrivateKey().toASN1Primitive()).getObjectAt(1).toASN1Primitive()).getOctets());
                arrayList2.add(privateKeyInfo.getPrivateKeyAlgorithm().getParameters().toASN1Primitive().getEncoded());
            }
            if (this.s) {
                arrayList.add(370L);
                arrayList2.add(Boolean.FALSE);
            }
            a.debug("impcred creating object");
            Object object = Util.longArrayFromList(arrayList);
            ArrayList<Object> arrayList3 = arrayList2;
            Object[] objectArray = arrayList3.toArray(new Object[arrayList3.size()]);
            object = this.i.createObject((long[])object, objectArray);
            a.debug("impcred created object");
            string = this.a((PKCS11Object)object, string, 3, byArray);
            a.debug("impcred addobj done ");
            if ((this.m & 0x80) != 0) {
                this.a(string, KeyUtils.rebuildPublicKeyFromPrivate((PrivateKey)privateKey));
            }
            return string;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage());
            throw capiException;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        catch (Exception exception) {
            a.debug("Generic Erron on Credential Imports");
            throw new CapiException("Generic Erron on Credential Imports", 1003, (Throwable)exception);
        }
    }

    public PublicKey getPublicKey(String string) throws CapiException {
        try {
            return this.a(string, false);
        }
        catch (Exception exception) {
            return this.a(string, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey a(String string, boolean bl) throws CapiException {
        Object object;
        a.debug("getting public key...");
        Object object2 = this.b(string, 2);
        if (object2 == null || bl) {
            a.debug("public key not present, trying with private key");
            object2 = this.b(string, 3);
        }
        if (object2 == null) {
            a.debug("private key not present");
            throw new CapiException("public key not present", 10021);
        }
        try {
            a.debug("getting BigInteger Modulus key...");
            PKCS11Object pKCS11Object = object2;
            synchronized (pKCS11Object) {
                if (((PKCS11Object)object2).getIntAttributeValue(256L) == PKCS11Object.ECDSA.intValue()) {
                    object = ((PKCS11Object)object2).getByteArrayAttributeValue(385L);
                    byte[] byArray = ((PKCS11Object)object2).getByteArrayAttributeValue(384L);
                    object = ECUtils.rebuildPublicKeyFromRawCard((byte[])byArray, (byte[])object);
                } else {
                    BigInteger bigInteger = ((PKCS11Object)object2).getBigIntegerAttributeValue(288L);
                    a.debug("get BigInteger Modulus key");
                    try {
                        object = (this.m & 0x40) != 0 ? (Object)new BigInteger("65537") : (Object)((PKCS11Object)object2).getBigIntegerAttributeValue(290L);
                        a.debug("get BigInteger PublicExponent key " + object);
                    }
                    catch (Exception exception) {
                        a.debug("KO retrieving public exponent attribute");
                        a.debug(exception.getMessage());
                        throw exception;
                    }
                    object = new RSAPublicKeySpec(bigInteger, (BigInteger)object);
                    object2 = KeyFactory.getInstance("RSA");
                    object = ((KeyFactory)object2).generatePublic((KeySpec)object);
                }
            }
            if ((this.m & 0x80) != 0) {
                this.a(string, (PublicKey)object);
            }
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Internal error", 1003);
        }
        a.debug("getPubKey OK");
        return object;
    }

    public PrivateKey getPrivateKey(String string) throws CapiException {
        PKCS11Object pKCS11Object = this.b(string, 3);
        if (pKCS11Object == null) {
            throw new CapiException("Object not found", 10021);
        }
        pKCS11Object = new Actalis_PrivateKey(string);
        pKCS11Object.setCryptoDev(this);
        pKCS11Object.setPublicInfo(this.a(string, true));
        return pKCS11Object;
    }

    public PrivateKey expCred(String object) throws CapiException {
        if ((object = this.b((String)object, 3)) == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            a.debug("getting modulus");
            Object object2 = ((PKCS11Object)object).getBigIntegerAttributeValue(288L);
            a.debug("get modulus");
            object = ((PKCS11Object)object).getBigIntegerAttributeValue(291L);
            a.debug("get private exponent");
            object = new RSAPrivateKeySpec((BigInteger)object2, (BigInteger)object);
            object2 = KeyFactory.getInstance("RSA");
            object = (RSAPrivateKey)((KeyFactory)object2).generatePrivate((KeySpec)object);
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Internal error", 1003);
        }
        a.debug("expCred OK");
        return object;
    }

    public int getKeyLength(String object) throws CapiException {
        if ((object = this.getPrivateKey((String)object)) instanceof Actalis_PrivateKey) {
            if ((object = ((Actalis_PrivateKey)object).getPublicInfo()) instanceof RSAPublicKey) {
                int n = ((RSAPublicKey)object).getModulus().bitLength();
                int n2 = (n + 255) / 256 << 8;
                a.debug("getKeyLength value=" + n + " ->" + n2);
                return n2;
            }
            return -1;
        }
        return 0;
    }

    public long getMaxRSAKeyLength() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            PKCS11MechanismInfo pKCS11MechanismInfo = this.e.getMechanismInfo(0L);
            if (pKCS11MechanismInfo != null) {
                return pKCS11MechanismInfo.maxKeySize();
            }
            pKCS11MechanismInfo = this.e.getMechanismInfo(1L);
            if (pKCS11MechanismInfo != null) {
                return pKCS11MechanismInfo.maxKeySize();
            }
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        throw new CapiException("RSA not supported", 11013);
    }

    public long getMinRSAKeyLength() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            PKCS11MechanismInfo pKCS11MechanismInfo = this.e.getMechanismInfo(0L);
            if (pKCS11MechanismInfo != null) {
                return pKCS11MechanismInfo.minKeySize();
            }
            pKCS11MechanismInfo = this.e.getMechanismInfo(1L);
            if (pKCS11MechanismInfo != null) {
                return pKCS11MechanismInfo.minKeySize();
            }
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        throw new CapiException("RSA not supported", 11013);
    }

    public void instCert(String string, Certificate certificate, boolean bl, boolean bl2) throws CapiException {
        Object object;
        a.debug("instCert alias=" + string);
        if ((this.getObjectType(string) & 0xC) <= 0) {
            throw new CapiException("Object not found", 10021);
        }
        PublicKey publicKey = this.getPublicKey(string);
        a.debug("instCert pk=" + publicKey);
        if (!certificate.getPublicKey().equals(publicKey)) {
            throw new CapiException("Public key not corresponding", 10033);
        }
        a.debug("instCert check keyusage");
        if (bl) {
            PKCS11Token pKCS11Token = this;
            if (!pKCS11Token.checkKeyUsage(pKCS11Token.getKeyUsage(string, true), certificate.getKeyUsageBits())) {
                throw new CapiException("Key usage not corresponding", 10037);
            }
        }
        try {
            object = this.b(string, 3);
            a.debug("instCert getting prvkey ID");
            object = ((PKCS11Object)object).getByteArrayAttributeValue(258L);
            a.debug("instCert get prvkey ID");
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        this.setCert(string, certificate, 9, (byte[])object, bl2);
    }

    public byte[] doSign(byte[] byArray, String object, int n) throws CapiException {
        a.debug("doSign alias=" + (String)object);
        Object object2 = this.b((String)object, 3);
        if (object2 == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            PublicKey publicKey = this.a((String)object, true);
            if (publicKey.getAlgorithm().equalsIgnoreCase("ec")) {
                this.i.signInit(4161L, null, (PKCS11Object)object2);
                object = new byte[256];
                int n2 = this.i.sign(byArray, 0, byArray.length, (byte[])object, 0);
                return Arrays.copyOfRange((byte[])object, 0, n2);
            }
            int n3 = this.getKeyLength((String)object) / 8;
            a.debug("signing RSA LENGTH: in=" + byArray.length + " out=" + n3);
            byte[] byArray2 = new byte[n3];
            if (n == 3) {
                this.i.signInit(3L, null, (PKCS11Object)object2);
            } else {
                this.i.signInit(1L, null, (PKCS11Object)object2);
            }
            try {
                this.i.sign(byArray, 0, byArray.length, byArray2, 0);
                a.debug("sign OK");
            }
            catch (CapiPKCS11Exception capiPKCS11Exception) {
                Object object3;
                block21: {
                    if (this.c == null) {
                        throw capiPKCS11Exception;
                    }
                    if (capiPKCS11Exception.getErrorCode() == 160L && this.isSessionDsPinIsCnsPin() && this.v) {
                        ((NativePKCS11Session)this.i).setTokenParam("dspiniscnspin", "false");
                        try {
                            this.i.sign(byArray, 0, byArray.length, byArray2, 0);
                            a.debug("sign OK");
                        }
                        catch (CapiPKCS11Exception capiPKCS11Exception2) {
                            object2 = capiPKCS11Exception2;
                            if (capiPKCS11Exception2.getErrorCode() != 257L && !"CKR_USER_NOT_LOGGED_IN".equals(((Throwable)object2).getMessage())) break block21;
                            object3 = object2;
                        }
                    }
                }
                if (((CapiPKCS11Exception)object3).getErrorCode() != 257L && !"CKR_USER_NOT_LOGGED_IN".equals(((Throwable)object3).getMessage())) {
                    throw object3;
                }
                if (!this.e()) {
                    throw object3;
                }
                object2 = this.c.getPin();
                if (object2 != null) {
                    ((NativePKCS11Session)this.i).loginContextSpecific((String)object2);
                    this.i.sign(byArray, 0, byArray.length, byArray2, 0);
                    a.debug("sign OK");
                }
                throw object3;
            }
            if (n == 3) {
                return byArray2;
            }
            try {
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding", ProvUtils.bcProvider);
                cipher.init(2, publicKey);
                byte[] byArray3 = cipher.doFinal(byArray2);
                object2 = byArray3;
                if (!Util.equalsBlock((byte[])byArray3, (byte[])byArray)) {
                    a.debug("hash  : " + new String(Hex.encode((byte[])byArray)));
                    a.debug("result: " + new String(Hex.encode((byte[])object2)));
                    throw new Exception("Invalid signature");
                }
            }
            catch (Exception exception) {
                a.debug(exception.getMessage());
                throw new CapiException("Invalid signature", 3010);
            }
            return byArray2;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage() + " code: " + capiPKCS11Exception.getErrorCode());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        catch (CapiException capiException) {
            CapiException capiException2 = capiException;
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Internal error", 50050);
        }
    }

    public byte[] doDecrypt(byte[] byArray, String string, int n) throws CapiException {
        a.debug("doDecrypt alias=" + string);
        PKCS11Object pKCS11Object = this.b(string, 3);
        if (pKCS11Object == null) {
            throw new CapiException("Object not found", 10021);
        }
        try {
            int n2 = this.getKeyLength(string) / 8;
            a.debug("LENGTH: in=" + byArray.length + " out=" + n2);
            byte[] byArray2 = new byte[n2];
            a.debug("mode=" + n);
            if (n == 4) {
                this.i.decryptInit(3L, null, pKCS11Object);
            } else {
                this.i.decryptInit(1L, null, pKCS11Object);
            }
            int n3 = this.i.decrypt(byArray, 0, byArray.length, byArray2, 0, n2);
            a.debug("decrypted len=" + n3 + " message: " + PKCS11Object.bytesToString(byArray2, 0));
            a.debug("decrypt OK");
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            return byArray3;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Internal error", 50050);
        }
    }

    public long getMinPINLen() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            if ((this.m & 0x80) != 0) {
                PKCS11TokenInfo pKCS11TokenInfo = this.c();
                a.debug("get info from token");
                return pKCS11TokenInfo.minPinLen();
            }
            return this.e.getTokenInfo().minPinLen();
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
    }

    public long getMaxPINLen() throws CapiException {
        if (!this.isTokenInserted()) {
            throw new CapiException("Token not inserted", 10011);
        }
        try {
            if ((this.m & 0x80) != 0) {
                PKCS11TokenInfo pKCS11TokenInfo = this.c();
                a.debug("get info from token");
                return pKCS11TokenInfo.maxPinLen();
            }
            return this.e.getTokenInfo().maxPinLen();
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
    }

    private void a() throws CapiException {
        try {
            if (this.l < 0) {
                a.debug("getting token in first available slot");
                this.e = this.d.getFirstTokenSlot();
            } else {
                a.debug("getting token in slot " + this.l);
                PKCS11Slot[] pKCS11SlotArray = this.d.getSlotList(false);
                try {
                    a.debug(pKCS11SlotArray.length + " slots found");
                }
                catch (Exception exception) {}
                boolean bl = false;
                for (PKCS11Slot pKCS11Slot : pKCS11SlotArray) {
                    if (!(pKCS11Slot instanceof NativePKCS11Slot)) {
                        a.error("Invalid slot object");
                        throw new CapiException("Invalid slot object", 10015);
                    }
                    pKCS11Slot = (NativePKCS11Slot)pKCS11Slot;
                    try {
                        a.debug(" - slotId: " + ((NativePKCS11Slot)pKCS11Slot).getNativeID());
                    }
                    catch (Exception exception) {}
                    if (((NativePKCS11Slot)pKCS11Slot).getNativeID() != (long)this.l) continue;
                    this.e = pKCS11Slot;
                    bl = true;
                    break;
                }
                if (!bl) {
                    a.error("Invalid slot number");
                    throw new CapiException("Invalid slot number", 10014);
                }
            }
            if (this.e != null) {
                if ((this.m & 0x80) != 0) {
                    a.debug("opt_get_info");
                } else {
                    if (a.isDebugEnabled()) {
                        a.debug(this.e.getInfo().toString());
                    } else {
                        this.e.getInfo();
                    }
                    if (a.isDebugEnabled()) {
                        a.debug(this.e.getTokenInfo().toString());
                    } else {
                        this.e.getTokenInfo();
                    }
                }
            }
            a.debug("end get token slot");
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            this.e = null;
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        catch (CapiException capiException) {
            CapiException capiException2 = capiException;
            throw capiException;
        }
        catch (Exception exception) {
            this.e = null;
            a.debug(exception.getMessage());
            throw new CapiException("Internal error", 10040);
        }
        if (this.e == null) {
            throw new CapiException("Token not inserted", 10011);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() throws CapiException {
        PKCS11 pKCS11 = this.d;
        synchronized (pKCS11) {
            this.q = new HashMap();
            this.r = new HashMap();
            Vector<long> vector = new Vector<long>();
            this.o = 0;
            try {
                Object object;
                Object object2;
                a.debug("before findobjectsInit");
                Object object3 = new long[]{};
                Object[] objectArray = new Object[]{};
                this.i.findObjectsInit((long[])object3, objectArray);
                a.debug("after  findobjectsInit");
                PKCS11Object[] pKCS11ObjectArray = this.i.findObject();
                object3 = pKCS11ObjectArray;
                int n = pKCS11ObjectArray.length;
                for (int i = 0; i < n; ++i) {
                    a a2;
                    Object object4;
                    object2 = object3[i];
                    a.debug("after obj=session.findobject");
                    int n2 = ((PKCS11Object)object2).getIntAttributeValue(0L);
                    a.debug("after obj.getAttrVal CLASS=" + n2);
                    if (n2 != 1 && n2 != 0 && n2 != 3 && n2 != 2 && n2 != 4) continue;
                    if (n2 == 4 && (this.m & 0x100) != 0) {
                        a.debug("skip SECRET_KEY CLASS " + n2);
                        continue;
                    }
                    if (n2 == 1) {
                        vector.addElement((long)object2);
                        a.debug("end   PKCS11_CERT    CLASS=" + n2);
                        continue;
                    }
                    object = null;
                    if ((this.m & 0x100) == 0) {
                        object = ((PKCS11Object)object2).getStringAttributeValue(3L);
                        a.debug("after obj.getAttrVal LABEL=" + (String)object);
                    }
                    if (n2 == 0 || n2 == 4) {
                        if ((this.m & 0x100) != 0) {
                            object = ((PKCS11Object)object2).getStringAttributeValue(3L);
                            a.debug("after obj.getAttrVal DATA-SECK LABEL=" + (String)object);
                        }
                        object4 = new a(n2, object2, null, (String)object);
                        this.a((String)object, (a)object4);
                        a.debug("end   PKCS11_DATA || SECK CLASS =" + n2);
                        continue;
                    }
                    object4 = new String(Hex.encode((byte[])((PKCS11Object)object2).getByteArrayAttributeValue(258L)));
                    a.debug("after obj.getAttrVal ID   =" + (String)object4);
                    if (this.r.containsKey(object4)) {
                        a2 = this.r.get(object4);
                        if ((this.m & 0x100) != 0) {
                            object = a2.b();
                            a.debug("after objsID.getLABEL=" + (String)object);
                        }
                        a2.a(n2, object2, (String)object);
                        continue;
                    }
                    if ((this.m & 0x100) != 0) {
                        ++this.o;
                        object = Util.newString((byte[])this.n) + "_" + this.o;
                        a.debug("after dummy PUBK-PRVK LABEL=" + (String)object);
                    }
                    a2 = new a(n2, object2, (String)object4, (String)object);
                    this.r.put((String)object4, a2);
                }
                this.i.findObjectsFinal();
                a.debug("after obj=session.findobjectsfinal");
                object3 = vector.elements();
                while (object3.hasMoreElements()) {
                    a a3;
                    String string;
                    PKCS11Object pKCS11Object = (PKCS11Object)object3.nextElement();
                    if ((this.m & 0x100) != 0) {
                        string = pKCS11Object.getStringAttributeValue(3L);
                        a.debug("after CERT.getAttrVal LABEL=" + string);
                    } else {
                        string = pKCS11Object.getStringAttributeValue(3L);
                        a.debug("after CERT.getAttrVal LABEL=" + string);
                    }
                    object2 = new String(Hex.encode((byte[])pKCS11Object.getByteArrayAttributeValue(258L)));
                    a.debug("after CERT.getAttrVal ID   =" + (String)object2);
                    if (this.r.containsKey(object2)) {
                        a3 = this.r.get(object2);
                        if ((this.m & 0x100) != 0) {
                            a3.a(string);
                            a.debug("after objsID.getLABEL=" + string);
                        }
                        a3.a(1, pKCS11Object, string);
                        a.debug("end CERT ID credential =" + (String)object2);
                        continue;
                    }
                    a3 = new a(1, pKCS11Object, (String)object2, string);
                    this.a(string, a3);
                    a.debug("end CERT ID alone =" + (String)object2);
                }
                for (Map.Entry entry : this.r.entrySet()) {
                    a a4 = (a)entry.getValue();
                    if ((this.m & 0x100) != 0) {
                        object2 = a4.b();
                        a.debug("objectsID LABEL=" + (String)object2);
                        if (((String)object2).startsWith(Util.newString((byte[])this.n))) {
                            Object[] objectArray2 = a4.i();
                            a.debug("objectsID n.=" + objectArray2.length);
                            object = (PKCS11Object)objectArray2[0];
                            object2 = ((PKCS11Object)object).getStringAttributeValue(3L);
                            a.debug("after obj.getAttrVal PUBK-PRVK LABEL=" + (String)object2);
                            a4.a((String)object2);
                        }
                        this.a((String)object2, a4);
                        continue;
                    }
                    this.a(a4.b(), a4);
                }
                a.debug("after enumeration objectsid       ");
            }
            catch (CapiPKCS11Exception capiPKCS11Exception) {
                a.debug(capiPKCS11Exception.getMessage());
                throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
            }
            catch (Exception exception) {
                a.debug(exception.getMessage());
                throw new CapiException("Internal error", 1003);
            }
            return;
        }
    }

    private String a(PKCS11Object pKCS11Object, String string, int n, byte[] object) throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            a.debug("adding object ");
            if ((this.m & 0x80) == 0) {
                string = pKCS11Object.getStringAttributeValue(3L);
            }
            a.debug("added  object LABEL ");
            if ((this.m & 0x80) == 0) {
                n = pKCS11Object.getIntAttributeValue(0L);
            }
            a.debug("added  object CLASS ");
            if (n == 0) {
                object = new a(n, pKCS11Object, null, string);
                return this.a(string, (a)object);
            }
            object = (this.m & 0x80) != 0 ? (Object)new String(Hex.encode((byte[])object)) : (Object)new String(Hex.encode((byte[])pKCS11Object.getByteArrayAttributeValue(258L)));
            a.debug("added  object ID ");
            if (this.r.containsKey(object)) {
                a a2 = this.r.get(object);
                a2.a(n, pKCS11Object, string);
                return string;
            }
            a a3 = new a(n, pKCS11Object, (String)object, string);
            this.r.put((String)object, a3);
            return this.a(string, a3);
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Internal error", 1003);
        }
    }

    private String a(String string, a a2) throws CapiException {
        if (!this.q.containsKey(string)) {
            this.q.put(string, a2);
            return string;
        }
        int n = 1;
        while (true) {
            String string2;
            if (!this.q.containsKey(string2 = string + "___" + n)) {
                this.q.put(string2, a2);
                return string2;
            }
            ++n;
        }
    }

    private void a(String string, int n) throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (n == 2) {
            return;
        }
        if (this.q.containsKey(string)) {
            if (n == 0) {
                throw new CapiException("Object already exist", 10024);
            }
            try {
                a a2 = this.q.get(string);
                byte by = a2.a();
                if ((by & 0xC) > 0) {
                    if (n == 9) {
                        PKCS11Object pKCS11Object = (PKCS11Object)a2.j();
                        if (pKCS11Object != null) {
                            a.debug("deleting installed cert. " + string);
                            pKCS11Object.destroy();
                            a.debug("deleted already installed.");
                        }
                        return;
                    }
                    this.r.remove(a2.c());
                }
                if ((by & 2) > 0) {
                    this.r.remove(a2.c());
                }
                Object[] objectArray = a2.i();
                a.debug("deleting " + string);
                for (int i = 0; i < objectArray.length; ++i) {
                    ((PKCS11Object)objectArray[i]).destroy();
                }
                a.debug("deleted " + string);
                this.q.remove(string);
                return;
            }
            catch (CapiPKCS11Exception capiPKCS11Exception) {
                a.debug(capiPKCS11Exception.getMessage());
                throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
            }
            catch (Exception exception) {
                a.debug(exception.getMessage());
                throw new CapiException("Internal error", 1003);
            }
        }
    }

    private PKCS11Object b(String object, int n) throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (this.q.containsKey(object)) {
            object = this.q.get(object);
            switch (n) {
                case 3: {
                    return (PKCS11Object)((a)object).h();
                }
                case 2: {
                    return (PKCS11Object)((a)object).g();
                }
                case 1: {
                    return (PKCS11Object)((a)object).e();
                }
                case 0: {
                    return (PKCS11Object)((a)object).d();
                }
                case 4: {
                    return (PKCS11Object)((a)object).f();
                }
            }
            return null;
        }
        return null;
    }

    private byte[] a(byte[] byArray) {
        String string;
        if (byArray == null) {
            Util.secureRandom.nextBytes(byArray);
        }
        String string2 = string = mcccompatibilitymode ? Util.base64EncodeStr((byte[])byArray).substring(0, 8) : new String(Hex.encode((byte[])byArray));
        while (this.r.containsKey(string)) {
            a.debug("getUniqueID: generating random");
            Util.secureRandom.nextBytes(byArray);
            string = mcccompatibilitymode ? Util.base64EncodeStr((byte[])byArray).substring(0, 8) : new String(Hex.encode((byte[])byArray));
        }
        if (mcccompatibilitymode) {
            return string.getBytes();
        }
        return byArray;
    }

    public String versionString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n >> 8;
        stringBuffer.append(n2);
        stringBuffer.append(".");
        stringBuffer.append((n &= 0xFF) / 10);
        if (n % 10 != 0) {
            stringBuffer.append(n % 10);
        }
        return stringBuffer.toString();
    }

    private PKCS11TokenInfo c() throws CapiPKCS11Exception {
        a.debug("getting info from token");
        if ((this.m & 0x80) != 0) {
            long l = System.currentTimeMillis() - this.h;
            if (this.g == null || l > 4500L) {
                this.g = this.e.getTokenInfo();
                this.h = System.currentTimeMillis();
                return this.g;
            }
            a.debug("getting info from token buffer");
            return this.g;
        }
        return this.e.getTokenInfo();
    }

    private void a(String object, PublicKey publicKey) throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (this.q.containsKey(object)) {
            object = this.q.get(object);
            ((a)object).a(publicKey);
        }
    }

    private void a(String object, String string) throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        if (this.q.containsKey(object)) {
            object = this.q.get(object);
            ((a)object).b(string);
        }
    }

    public void openSessionEllips(String string) throws CapiException {
        try {
            a.debug("before closeAllSessions");
            if (this.i != null) {
                this.i.close();
            }
            this.i = this.e.openSession(6L, null, null);
            PKCS11Token pKCS11Token = this;
            pKCS11Token.a((NativePKCS11Session)pKCS11Token.i);
            a.debug("before login");
            this.i.login(true, string);
            return;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            this.i = null;
            a.debug(capiPKCS11Exception.getMessage());
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception, true);
        }
    }

    public CertificationRequest generatePKCS10CertificationRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) throws Exception {
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        if (x500Name == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        try {
            subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), publicKey.getEncoded());
            publicKey = new CertificationRequestInfo(x500Name, subjectPublicKeyInfo, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't encode public key");
        }
        Signature signature = Signature.getInstance("SHA1withRSA", (Provider)ActalisSingleton.getActalisProvider());
        signature.initSign(privateKey);
        try {
            signature.update(publicKey.getEncoded("DER"));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("exception encoding TBS cert request - " + exception);
        }
        x500Name = new CertificationRequestInfo(x500Name, subjectPublicKeyInfo, null);
        x500Name = new CertificationRequest((CertificationRequestInfo)x500Name, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE), new DERBitString(signature.sign()));
        return x500Name;
    }

    public String certReq(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, String string) throws CapiException {
        return this.certReq(x500Name, publicKey, privateKey, Security.getProvider(string));
    }

    @Deprecated
    public String certReq(String string, X500Name x500Name) throws CapiException {
        return this.certReq(x500Name, this.getPublicKey(string), this.getPrivateKey(string), ProvUtils.actalisProvider);
    }

    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int n, String string, List<GeneralNames> list, String string2) throws CapiException {
        GeneralNames[] generalNamesArray = null;
        if (list != null && !list.isEmpty()) {
            generalNamesArray = list.toArray(new GeneralNames[0]);
        }
        return this.generateCertificateRequest(keyType, keyAlgo, n, string, generalNamesArray, string2);
    }

    public byte[] generateCertificateRequest(KeyType object, KeyAlgo keyAlgo, int n, String string, GeneralNames[] generalNamesArray, String string2) throws CapiException {
        String string3;
        CertificateFields certificateFields;
        int n2 = 3;
        try {
            certificateFields = new CertificateFields(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            a.error(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            throw new CapiException("Invalid CN: " + string, 1003);
        }
        if (object == KeyType.DS) {
            n2 = 1;
            if (this.b == null) {
                throw new CapiException("No strategy to generate qualified signature key (1)", 3011);
            }
            if (this.b.getDsStrategy() == DSStrategy.NONE) {
                throw new CapiException("No strategy to generate qualified signature key (2)", 3011);
            }
            if (keyAlgo == KeyAlgo.RSA) {
                if (n < 2048) {
                    throw new CapiException(String.format("Invalid Key Size %d for qualified signature key (1)", n), 3011);
                }
            } else if (n < 256) {
                throw new CapiException(String.format("Invalid Key Size %d for qualified signature key (2)", n), 3011);
            }
        } else if (object == KeyType.CNS) {
            if (this.b == null) {
                throw new CapiException("No strategy to generate cns key (1)", 3011);
            }
            if (this.b.getCnsStrategy() == CNSStrategy.NONE) {
                throw new CapiException("No strategy to generate cns key (2)", 3011);
            }
        }
        int n3 = 0;
        string = "GenericKey%d";
        if (object == KeyType.DS) {
            if (this.b.getDsStrategy() == DSStrategy.LABEL) {
                n3 = 3;
                string = "DS%d";
            }
            if (this.b.getDsStrategy() == DSStrategy.LABEL2) {
                string = "Firma%d";
            }
            if (this.b.getDsStrategy() == DSStrategy.PORTAL) {
                string3 = new SimpleDateFormat("MM-yyyy").format(new Date());
                string = "Firma Digitale Qualificata " + (string3.startsWith("0") ? string3.substring(1) : string3);
            }
        } else if (object == KeyType.CNS) {
            if (this.b.getCnsStrategy() == CNSStrategy.LABEL) {
                string = "CNS0";
            }
            if (this.b.getCnsStrategy() == CNSStrategy.LABEL2) {
                string = "CNS1";
            }
            if (this.b.getCnsStrategy() == CNSStrategy.PORTAL) {
                string3 = new SimpleDateFormat("MM-yyyy").format(new Date());
                string = "Alias Authentication/CNS " + (string3.startsWith("0") ? string3.substring(1) : string3);
            }
        }
        string3 = "";
        KeyPair keyPair = null;
        for (int i = n3; i < n3 + 3; ++i) {
            block31: {
                try {
                    string3 = String.format(string, i);
                    a.debug("Tentativo Creazione Chiave {}", (Object)string3);
                    this.genKeyPair(string3, keyAlgo, n2, n, 0);
                    keyPair = new KeyPair(this.getPublicKey(string3), this.getPrivateKey(string3));
                }
                catch (CapiException capiException) {
                    CapiException capiException2 = capiException;
                    if (capiException.getErrorCode() == 11002) {
                        throw capiException2;
                    }
                    a.error("Errore tentativo {}: {} (1)", (Object)string3, (Object)capiException2.getMessage());
                    if (object == KeyType.CNS) {
                        throw new CapiException("Unable To Generate Key", 10032, (Throwable)capiException2);
                    }
                }
                catch (Exception exception) {
                    a.error("Errore tentativo {}: {} (2)", (Object)string3, (Object)exception.getMessage());
                    if (object != KeyType.CNS) break block31;
                    throw new CapiException("Unable To Generate Key", 10032, (Throwable)exception);
                }
            }
            if (keyPair != null) break;
        }
        if (keyPair == null) {
            throw new CapiException("Unable To Generate Key", 10032);
        }
        try {
            PKCS10CertificationRequest pKCS10CertificationRequest = CSRUtils.generateCertificateRequest((Provider)ProvUtils.actalisProvider, keyPair, (CertificateFields)certificateFields, (GeneralNames[])generalNamesArray);
            object = pKCS10CertificationRequest.getEncoded();
        }
        catch (IOException | NoSuchAlgorithmException | OperatorCreationException throwable) {
            this.deleteObject(string3);
            throw new CapiException("Unable To Generate Csr", 1003, throwable);
        }
        return object;
    }

    public boolean requiredExtendedAuth() {
        return false;
    }

    public RecoverySessionCredential openSessionWithExtendedAuth(boolean bl, String string, ExtendedCredentials extendedCredentials) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(X500Name object, PublicKey object2, PrivateKey privateKey, Provider provider) throws CapiException {
        try {
            a.debug("creating and signing certreq...");
            a.debug("subject: " + object.toString());
            try {
                object = new JcaPKCS10CertificationRequestBuilder(object, (PublicKey)object2);
                object = object.build(new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider(provider).build(privateKey));
            }
            catch (Exception exception) {
                object = exception;
                throw exception;
            }
            a.debug("certRequest ok");
        }
        catch (IllegalStateException illegalStateException) {
            a.debug(illegalStateException.getMessage());
            throw new CapiException("IllegalStateException", 1003);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("NoSuchProviderException", 1003);
        }
        try {
            object2 = new StringWriter();
            privateKey = new PEMWriter((Writer)object2);
            privateKey.writeObject(object);
            privateKey.close();
            object = new String(((StringWriter)object2).getBuffer());
            return object;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage());
            throw new CapiException("Exception saving PEM certificate Requet", 1003);
        }
    }

    public boolean isOpenCns() {
        byte[] byArray;
        block7: {
            if (this.b == null) {
                return false;
            }
            if (this.b.getCnsStrategy() == CNSStrategy.NONE) {
                return false;
            }
            byArray = null;
            try {
                byArray = this.getData("PDATA");
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                if (exception instanceof CapiException || ((CapiException)((Object)exception2)).getErrorCode() != 10020) break block7;
                a.error(exception2.getMessage(), (Throwable)exception2);
            }
        }
        try {
            if (byArray == null) {
                this.setData("PDATA", "ciao                                                                                                                                                                                                                                                                                                                                                                                                           ".getBytes(), 1);
                this.deleteObject("PDATA");
                return true;
            }
            this.setData("PDATA", byArray, 1);
            return true;
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public void cleanCard() throws CapiException {
        if (this.q == null) {
            throw new CapiException("Session not opened", 10013);
        }
        a.debug("cleanCard...");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.q.keySet()) {
            if ((this.getObjectType(string) & 0xC) <= 0) continue;
            PublicKey publicKey = this.getPublicKey(string);
            boolean bl = false;
            for (String string2 : this.q.keySet()) {
                if (this.b(string2, 1) == null || !(string2 = new Certificate(this.getCert(string2).getBytes())).getPublicKey().equals(publicKey)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(string);
        }
        for (String string : arrayList) {
            this.deleteObject(string);
        }
    }

    public void resetToken(String iterator) throws CapiException {
        try {
            if (this.b == null || this.b.getDefaultPUK() == null) {
                throw new CapiException("Unable to reset unknown cards", 11002);
            }
            a.debug("resetCard...");
            this.changePUK((String)((Object)iterator), this.b.getDefaultPUK());
            PKCS11Token pKCS11Token = this;
            pKCS11Token.unblockPIN(pKCS11Token.b.getDefaultPUK(), this.b.getDefaultPIN());
            this.openSession(false, this.b.getDefaultPIN());
            if (this.q.size() > 0) {
                iterator = new ArrayList<String>();
                iterator.addAll(this.q.keySet());
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.deleteObject(string);
                }
            }
            return;
        }
        finally {
            this.closeSession();
        }
    }

    public void finalize() throws Throwable {
        if (this.d != null) {
            a.info("Token pkcs11 non chiuso");
            this.finalizeLib();
        }
        super.finalize();
    }

    public void createDsFs(FSStrategyParameters object) throws CapiException {
        try {
            if (this.b.getFsStrategy() == FSStrategy.NONE) {
                throw new UnsupportedOperationException("Not supported TokenParameters.");
            }
            if (!this.isTokenInserted()) {
                throw new CapiException("Token not inserted", 10011);
            }
            if (this.isSessionOpen()) {
                this.closeSession();
            }
            if (this.b.getFsStrategy() == FSStrategy.ATHENA) {
                if (!(object instanceof AthenaFsStrategyParameters)) {
                    throw new CapiException("Invalid Parameters", 1002);
                }
            } else {
                return;
            }
            object = new AthenaDsFsGenerator((NativePKCS11)this.d, (NativePKCS11Slot)this.e, (AthenaFsStrategyParameters)object);
            ((AthenaDsFsGenerator)object).generateDsFs();
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            object = capiPKCS11Exception;
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
    }

    public DsPinCallBack getDsPinCallBack() {
        return this.c;
    }

    public void setDsPinCallBack(DsPinCallBack dsPinCallBack) {
        this.c = dsPinCallBack;
    }

    private boolean d() throws CapiException {
        if (this.i == null) {
            throw new CapiException("session object not found", 10040);
        }
        try {
            ((NativePKCS11Session)this.i).getTokenParam("dspinusegui");
            return true;
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            return false;
        }
    }

    private boolean e() throws CapiException {
        try {
            if (this.d()) {
                return ((NativePKCS11Session)this.i).getTokenParam("dspinusegui").equals("false");
            }
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            CapiPKCS11Exception capiPKCS11Exception2 = capiPKCS11Exception;
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        return false;
    }

    private Bit4IDConfigPkcs11Params f() {
        if (this.t == Bit4IDConfigPkcs11Params.DEFAULT && System.getProperty("esecurity.pkcs11.dsPinUseGuiSys") != null) {
            if (System.getProperty("esecurity.pkcs11.dsPinUseGuiSys").equals("true")) {
                return Bit4IDConfigPkcs11Params.ENABLE;
            }
            if (System.getProperty("esecurity.pkcs11.dsPinUseGuiSys").equals("false")) {
                return Bit4IDConfigPkcs11Params.DISABLE;
            }
        }
        return this.t;
    }

    public void setEnableSessionGui(Bit4IDConfigPkcs11Params bit4IDConfigPkcs11Params) {
        this.t = bit4IDConfigPkcs11Params;
    }

    private Bit4IDConfigPkcs11Params g() {
        if (this.u == Bit4IDConfigPkcs11Params.DEFAULT && System.getProperty("esecurity.pkcs11.dsPinIsCnsPinSys") != null) {
            if (System.getProperty("esecurity.pkcs11.dsPinIsCnsPinSys").equals("true")) {
                return Bit4IDConfigPkcs11Params.ENABLE;
            }
            if (System.getProperty("esecurity.pkcs11.dsPinIsCnsPinSys").equals("false")) {
                return Bit4IDConfigPkcs11Params.DISABLE;
            }
        }
        return this.u;
    }

    public void setEnableDSPinIsCnsPin(Bit4IDConfigPkcs11Params bit4IDConfigPkcs11Params) {
        this.u = bit4IDConfigPkcs11Params;
    }

    public boolean isSessionDsPinIsCnsPin() throws CapiException {
        try {
            if (this.d()) {
                return ((NativePKCS11Session)this.i).getTokenParam("dspiniscnspin").equals("true");
            }
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            CapiPKCS11Exception capiPKCS11Exception2 = capiPKCS11Exception;
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        return false;
    }

    public boolean isSessionDsPinGuiEnable() throws CapiException {
        try {
            if (this.d()) {
                return ((NativePKCS11Session)this.i).getTokenParam("dspinusegui").equals("true");
            }
        }
        catch (CapiPKCS11Exception capiPKCS11Exception) {
            CapiPKCS11Exception capiPKCS11Exception2 = capiPKCS11Exception;
            throw Pkcs11ExceptionUtils.toCapiException(capiPKCS11Exception);
        }
        return false;
    }

    public boolean isLockGeneratedTokenObject() {
        return this.s;
    }

    public void setLockGeneratedTokenObject(boolean bl) {
        this.s = bl;
    }

    private void a(NativePKCS11Session nativePKCS11Session) throws CapiException, CapiPKCS11Exception {
        if (this.d()) {
            if (this.f() != Bit4IDConfigPkcs11Params.DEFAULT) {
                if (this.f() == Bit4IDConfigPkcs11Params.ENABLE) {
                    nativePKCS11Session.setTokenParam("dspinusegui", "true");
                } else {
                    nativePKCS11Session.setTokenParam("dspinusegui", "false");
                }
            }
            if (this.g() != Bit4IDConfigPkcs11Params.DEFAULT) {
                if (this.g() == Bit4IDConfigPkcs11Params.ENABLE) {
                    nativePKCS11Session.setTokenParam("dspiniscnspin", "true");
                    return;
                }
                nativePKCS11Session.setTokenParam("dspiniscnspin", "false");
            }
        }
    }
}

