/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils.provider;

import it.actalis.ellips.capi.http.arubautils.HttpAdditionalInfoUtils;
import it.actalis.ellips.capi.http.arubautils.HttpStatusException;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.Parameters;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.http.arubautils.provider.DownloadProgressNotifier;
import it.actalis.ellips.capi.http.arubautils.provider.HTTPProvider;
import it.actalis.ellips.capi.http.arubautils.provider.HttpURLConnectionMultipartWrapper;
import it.actalis.ellips.capi.http.arubautils.provider.MultipartWrapper;
import it.actalis.ellips.capi.http.bc.Base64;
import it.actalis.ellips.capi.http.util.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;

public class HTTPUrlConnectionProvider
extends HTTPProvider {
    int connectionTimeOut = 3000;
    int readTimeOut = 5000;

    public HTTPUrlConnectionProvider(NetworkConfig conf, Logger logger) {
        super(conf, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream retrieveInputStream(HttpURLConnection httpConn, String method, RequestData rdate, URLCredentials credentials) throws IOException {
        OutputStream outputStream;
        HashMap<String, String> headers;
        HashMap<String, String> lstProperty = new HashMap<String, String>();
        if (credentials != null) {
            if (credentials.getUser() != null && credentials.getPassword() != null) {
                lstProperty.put("Authorization", "Basic " + new String(Base64.encode((credentials.getUser() + ":" + credentials.getPassword()).getBytes())));
            } else if (credentials.getToken() != null && credentials.getToken().isEmpty()) {
                lstProperty.put("Authorization", "Bearer " + credentials.getToken());
            }
        }
        if (rdate != null && rdate.getType() != null) {
            if (rdate.getType().equals("TSA")) {
                lstProperty.put("Content-Type", "application/timestamp-query");
                if (rdate.getAcceptHeader() == null) {
                    rdate.setAcceptHeader("application/timestamp-reply");
                }
            } else if (rdate.getType().equals("SOAP")) {
                lstProperty.put("Content-Type", "text/xml;charset=UTF-8");
            } else if (rdate.getType().equals("JSON")) {
                lstProperty.put("Content-Type", "application/json");
            } else if (rdate.getType().equals("OCSP")) {
                lstProperty.put("Content-Type", "application/ocsp-request");
            }
            if (rdate.getSoapAction() != null && !rdate.getSoapAction().equals("")) {
                if (rdate.getSoapAction().equals("empty")) {
                    lstProperty.put("SOAPAction", "");
                } else {
                    lstProperty.put("SOAPAction", rdate.getSoapAction());
                }
            }
        }
        if (rdate != null && rdate.getAcceptHeader() != null) {
            lstProperty.put("Accept", rdate.getAcceptHeader());
        }
        if (rdate != null && rdate.getContentType() != null) {
            lstProperty.put("Content-Type", rdate.getContentType());
        }
        for (String string : lstProperty.keySet()) {
            httpConn.setRequestProperty(string, (String)lstProperty.get(string));
        }
        if (rdate != null) {
            for (Parameters parameters : rdate.getParam()) {
                httpConn.setRequestProperty(parameters.getName(), parameters.getValue());
            }
        }
        if ((headers = HttpAdditionalInfoUtils.listAdditionalHeaders()) != null) {
            for (String key : headers.keySet()) {
                httpConn.setRequestProperty(key, headers.get(key));
            }
        }
        if (method != null) {
            httpConn.setRequestMethod(method.toUpperCase());
        }
        if (rdate == null || rdate.getPostdata() == null) {
            if (rdate == null) return httpConn.getInputStream();
            if (rdate.getPostStream() == null) return httpConn.getInputStream();
        }
        if (method == null) {
            httpConn.setRequestMethod("POST");
        }
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        try (OutputStream outputStream2 = null;){
            outputStream = httpConn.getOutputStream();
            if (rdate.getPostdata() != null) {
                outputStream.write(rdate.getPostdata());
            } else {
                StreamUtils.copyStream(rdate.getPostStream(), outputStream);
            }
            if (outputStream == null) return httpConn.getInputStream();
        }
        outputStream.close();
        return httpConn.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UrlReturn urlRequest(URL url, String method, RequestData rdate, URLCredentials credentials, OutputStream os, DownloadProgressNotifier notifier) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        UrlReturn ret;
        block25: {
            ret = new UrlReturn();
            ret.setStatus("KO");
            HttpURLConnection httpConn = this.initProvider(this.connectionTimeOut, this.readTimeOut, url, credentials, rdate == null ? null : rdate.getType(), true);
            try {
                InputStream objIn = this.retrieveInputStream(httpConn, method, rdate, credentials);
                long size = httpConn.getContentLengthLong();
                long currentSize = 0L;
                if (notifier != null) {
                    notifier.notify(size, currentSize);
                }
                if (objIn == null) break block25;
                try {
                    byte[] buffer = new byte[64000];
                    int letti = objIn.read(buffer);
                    while (letti != -1) {
                        if (notifier != null) {
                            notifier.notify(size, currentSize += (long)letti);
                        }
                        os.write(buffer, 0, letti);
                        letti = objIn.read(buffer);
                    }
                    objIn.close();
                    ret.setStatus("OK");
                    ret.setStatusMessage("OK");
                    ArrayList<String> cookieList = new ArrayList<String>();
                    Map<String, List<String>> headerFields = httpConn.getHeaderFields();
                    for (Map.Entry<String, List<String>> headerFieldEntry : headerFields.entrySet()) {
                        if (!"Set-Cookie".equalsIgnoreCase(headerFieldEntry.getKey())) continue;
                        for (String headerValue : headerFieldEntry.getValue()) {
                            logger.debug("Cookie found: " + headerValue);
                            cookieList.add(headerValue);
                        }
                    }
                    ret.setCookieList(cookieList);
                    String urlpath = url.getHost() + url.getPort() + url.getDefaultPort() + url.getProtocol();
                    this.conf.getAuth().getOldCredential().remove(urlpath);
                }
                finally {
                    objIn.close();
                }
            }
            catch (IOException ex) {
                if (httpConn.getResponseCode() != 200 && httpConn.getResponseCode() != -1) {
                    InputStream inerr = null;
                    try {
                        inerr = httpConn.getErrorStream();
                        if (inerr != null) {
                            byte[] buffererr = new byte[64000];
                            int letti = inerr.read(buffererr);
                            ByteArrayOutputStream objOuterr = new ByteArrayOutputStream();
                            while (letti != -1) {
                                objOuterr.write(buffererr, 0, letti);
                                letti = inerr.read(buffererr);
                            }
                            ret.setErrordata(objOuterr.toByteArray());
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (inerr != null) {
                            try {
                                inerr.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    throw new HttpStatusException(httpConn.getResponseCode(), ret.getErrordata(), ex);
                }
                throw ex;
            }
        }
        return ret;
    }

    @Override
    public Date getLastModifiedDate(URL url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        HttpURLConnection httpConn = this.initProvider(this.connectionTimeOut, this.readTimeOut, url, credentials, null, false);
        httpConn.setRequestMethod("HEAD");
        Date lastModified = new Date(httpConn.getLastModified());
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection initProvider(int connectionTimeOut, int readTimeOut, URL url, URLCredentials credentials, String type, boolean useCache) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, IOException {
        logger.debug("Init Provider [START]");
        HttpURLConnection httpConn = null;
        SSLSocketFactory sf = null;
        Proxy proxy = null;
        if (this.conf.getConnectionTimeOut() != null && this.conf.getReadTimeOut() != null) {
            int val2;
            if (this.conf.getConnectionTimeOut().equals("0")) {
                connectionTimeOut = 0;
            }
            if (this.conf.getReadTimeOut().equals("0")) {
                readTimeOut = 0;
            }
            try {
                val2 = Integer.parseInt(this.conf.getConnectionTimeOut());
                if (val2 >= 3000) {
                    connectionTimeOut = val2;
                }
            }
            catch (Exception val2) {
                // empty catch block
            }
            try {
                val2 = Integer.parseInt(this.conf.getReadTimeOut());
                if (val2 >= 2000) {
                    readTimeOut = val2;
                }
            }
            catch (Exception val3) {
                // empty catch block
            }
        }
        if (url.getProtocol().equals("https")) {
            Object kmf;
            KeyManager[] km = null;
            if (credentials != null && credentials.getKeystore() != null) {
                kmf = null;
                try {
                    kmf = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
                    ((KeyManagerFactory)kmf).init(credentials.getKeystore(), credentials.getKeystorepwd().toCharArray());
                    km = ((KeyManagerFactory)kmf).getKeyManagers();
                }
                catch (Exception ex) {
                    logger.debug("Impossibile istanziare il provider ORACLE provo a instaziare il provider IBM");
                    kmf = KeyManagerFactory.getInstance("IbmX509");
                    ((KeyManagerFactory)kmf).init(credentials.getKeystore(), credentials.getKeystorepwd().toCharArray());
                    km = ((KeyManagerFactory)kmf).getKeyManagers();
                    logger.debug("provider IbmX509 impostato");
                }
            }
            if (this.sslTrustAllRoot) {
                this.tm = nullTrustManager;
            }
            if (km == null && useCache) {
                sf = this.getSocketFactory(this.tm);
            }
            if (sf == null) {
                kmf = HTTPProvider.sfactorymap;
                synchronized (kmf) {
                    if (km == null && useCache) {
                        sf = this.getSocketFactory(this.tm);
                    }
                    if (sf == null) {
                        SSLContext sc = null;
                        sc = System.getProperty("java.vm.vendor").contains("IBM") ? SSLContext.getInstance("TLSv1") : SSLContext.getInstance("SSL");
                        sc.init(km, this.tm, null);
                        sf = sc.getSocketFactory();
                        if (km == null && useCache) {
                            this.setSocketFactory(this.tm, sf);
                        }
                    }
                }
            }
        }
        if (!url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1") && this.conf.isProxyHost(url.toString())) {
            if (this.conf.isAutomaticProxyDiscovery()) {
                logger.debug("Tentativo selezione automatica proxy");
                Object http = null;
                ProxySelector sel = this.conf.getDefaultproxyselector();
                proxy = null;
                if (sel != null) {
                    URI uri = null;
                    try {
                        uri = url.toURI();
                    }
                    catch (URISyntaxException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                    Iterator<Proxy> it = sel.select(uri).iterator();
                    while (it.hasNext()) {
                        proxy = it.next();
                        try {
                            if (proxy == Proxy.NO_PROXY) {
                                proxy = null;
                                continue;
                            }
                            proxy = new Proxy(proxy.type(), proxy.address());
                            logger.debug("Utilizzo il proxy : " + (Object)((Object)proxy.type()) + " - " + proxy.address());
                            break;
                        }
                        catch (Exception ioex) {
                            logger.error("Errore connessione proxy:" + proxy.address(), (Throwable)ioex);
                            if (proxy != Proxy.NO_PROXY) {
                                sel.connectFailed(uri, proxy.address(), new IOException(ioex));
                                if (it.hasNext()) continue;
                                proxy = null;
                                break;
                            }
                            proxy = null;
                        }
                    }
                }
            } else if (this.conf.getProxy() != null && !this.conf.getProxy().equals("")) {
                if (this.conf.getProxyPort() != null && !this.conf.getProxyPort().equals("")) {
                    logger.debug("Richiesta proxy non automatica:" + this.conf.getProxyType() + "://" + this.conf.getProxy() + ":" + this.conf.getProxyPort());
                    proxy = this.conf.getProxyType().equals("socks") ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.conf.getProxy(), Integer.parseInt(this.conf.getProxyPort()))) : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.conf.getProxy(), Integer.parseInt(this.conf.getProxyPort())));
                } else if (this.conf.getProxyType().equals("socks")) {
                    logger.debug("Richiesta proxy non automatica:socks://" + this.conf.getProxy() + ":1080");
                    proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.conf.getProxy(), 1080));
                } else {
                    logger.debug("Richiesta proxy non automatica:http://" + this.conf.getProxy() + ":8080");
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.conf.getProxy(), 8080));
                }
            }
            if (proxy != null) {
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                if (url.getProtocol().startsWith("http")) {
                    logger.debug("Configurato Proxy http :" + (addr.getAddress() != null ? addr.getAddress().getHostAddress() : addr.getHostName()) + " " + String.valueOf(addr.getPort()) + " " + proxy.type().name().toLowerCase());
                    this.setProxyConfiguration("http", addr.getAddress() != null ? addr.getAddress().getHostAddress() : addr.getHostName(), String.valueOf(addr.getPort()), proxy.type().name().toLowerCase());
                } else if (url.getProtocol().startsWith("ldap")) {
                    logger.debug("Configurato Proxy ldap :" + (addr.getAddress() != null ? addr.getAddress().getHostAddress() : addr.getHostName()) + " " + String.valueOf(addr.getPort()) + " " + proxy.type().name().toLowerCase());
                    this.setProxyConfiguration("ldap", addr.getAddress() != null ? addr.getAddress().getHostAddress() : addr.getHostName(), String.valueOf(addr.getPort()), proxy.type().name().toLowerCase());
                } else {
                    logger.debug("Proxy non configurato vengono usati i parametri di default");
                }
                this.conf.getAuth().setProxyConfig(addr.getAddress() != null ? addr.getAddress().getHostAddress() : addr.getHostName(), this.conf);
            } else if (url.getProtocol().startsWith("http")) {
                this.setProxyConfiguration("http", "", "", "direct");
            } else if (url.getProtocol().startsWith("ldap")) {
                this.setProxyConfiguration("ldap", "", "", "direct");
            }
        }
        URL objDownload = url;
        URLConnection objConn = null;
        if (proxy == null) {
            logger.debug("Connessione diretta.");
            objConn = objDownload.openConnection();
        } else {
            logger.debug("Connessione con proxy");
            objConn = objDownload.openConnection(proxy);
        }
        httpConn = (HttpURLConnection)objConn;
        httpConn.setInstanceFollowRedirects(true);
        httpConn.setConnectTimeout(connectionTimeOut);
        httpConn.setReadTimeout(readTimeOut);
        if (sf != null && httpConn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpConn).setSSLSocketFactory(sf);
            if (this.sslHallHostVerified) {
                HostnameVerifier allHostsValid = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                ((HttpsURLConnection)httpConn).setHostnameVerifier(allHostsValid);
            }
        }
        logger.debug("Init Provider [END]");
        return httpConn;
    }

    @Override
    public Long getContentLengthLong(URL url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        HttpURLConnection httpConn = this.initProvider(this.connectionTimeOut, this.readTimeOut, url, credentials, null, false);
        httpConn.setRequestMethod("HEAD");
        long content = httpConn.getContentLengthLong();
        return content;
    }

    @Override
    public Proxy fech_proxy(URL url) {
        int connectionTimeOut = 3000;
        int readTimeOut = 5000;
        logger.debug("Tenattivo selezione proxy automatica");
        Object http = null;
        ProxySelector sel = this.conf.getDefaultproxyselector();
        Proxy proxy = null;
        if (sel != null) {
            URI uri = null;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            Iterator<Proxy> it = sel.select(uri).iterator();
            while (it.hasNext()) {
                proxy = it.next();
                try {
                    if (proxy != Proxy.NO_PROXY) {
                        proxy = null;
                        continue;
                    }
                    proxy = new Proxy(proxy.type(), proxy.address());
                    logger.debug("Utilizzo il proxy : " + (Object)((Object)proxy.type()) + " - " + proxy.address().toString());
                    break;
                }
                catch (Exception ioex) {
                    logger.error("Errore connessione proxy:" + proxy.address(), (Throwable)ioex);
                    if (proxy != Proxy.NO_PROXY) {
                        sel.connectFailed(uri, proxy.address(), new IOException(ioex));
                        if (it.hasNext()) continue;
                        proxy = null;
                        break;
                    }
                    proxy = null;
                }
            }
        }
        return proxy;
    }

    @Override
    public Date getLastModifiedDate(String url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        return this.getLastModifiedDate(new URL(url), credentials);
    }

    @Override
    public InputStream getInputStream(URL url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        HttpURLConnection httpConn = this.initProvider(this.connectionTimeOut, this.readTimeOut, url, credentials, null, true);
        InputStream objIn = this.retrieveInputStream(httpConn, null, null, credentials);
        return objIn;
    }

    @Override
    public MultipartWrapper getMultipartWrapper(URL url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        HttpURLConnection httpConn = this.initProvider(this.connectionTimeOut, this.readTimeOut, url, credentials, null, true);
        HttpURLConnectionMultipartWrapper msw = new HttpURLConnectionMultipartWrapper(httpConn);
        return msw;
    }

    @Override
    public Long getContentLengthLong(String url, URLCredentials credentials) throws MalformedURLException, IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, URISyntaxException {
        return this.getContentLengthLong(new URL(url), credentials);
    }

    @Override
    public HttpURLConnection getHttpURLConnection(URL url, URLCredentials credentials) throws IOException, KeyManagementException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, URISyntaxException {
        return this.initProvider(this.connectionTimeOut, this.readTimeOut, url, credentials, "\r\n", true);
    }
}

