/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.core.x509.StepX509DPCM45DigestAlgorithmCompliance;
import esecurity.validator.steps.core.x509.StepX509DPCM45Issuer;
import esecurity.validator.steps.core.x509.StepX509DPCM45SubjectDN;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class StepX509DPCM45Compliance
extends SingleValidationSubStepImpl {
    public StepX509DPCM45Compliance() {
        super(ValidationType.CERTIFICATE);
        this.subSteps.add(new StepX509DPCM45DigestAlgorithmCompliance());
        this.subSteps.add(new StepX509DPCM45SubjectDN());
        this.subSteps.add(new StepX509DPCM45Issuer());
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> object, ValidationContextParameters validationContextParameters) {
        object = StepsUtils.retrieveWorstLevel(object);
        boolean bl = false;
        try {
            Object object2 = validationContextParameters.getSignerCertificate().getCert();
            object2 = validationContextParameters.getCertDB().contains(((Certificate)object2).getDerEncoded());
            bl = ((CertDBItem)object2).getSource() == 1 || ((CertDBItem)object2).getSource() == 5;
        }
        catch (Exception exception) {}
        if (object != MessageLevel.INFO && !bl) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), (MessageLevel)((Object)object), (EsecurityMessage)ValidatorMessageEnum.EC0010_NOCNIPA45, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
        }
        return null;
    }
}

