/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf.report;

import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.bean.ValidatedSigner;
import esecurity.validator.constants.SignatureFormat;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.core.Version;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageFactory;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ReportMessageEnum;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.core.qc.PdsLocation;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.pdf.report.CertificateDetailsInfo;
import it.actalis.ellips.capi.pdf.report.PDFReportPage;
import it.actalis.ellips.capi.pdf.report.PDFReportParams;
import it.actalis.ellips.capi.pdf.report.PageLink;
import it.actalis.ellips.capi.pdf.report.SummaryPageLink;
import it.actalis.ellips.capi.pdf.report.SummaryTableRow;
import it.actalis.ellips.capi.pdf.report.ValidatedSignerReport;
import it.actalis.vol.exception.VolException;
import it.actalis.vol.utils.Constants;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.slf4j.Logger;

public class PDFReport {
    private static final Color a = new Color(42, 134, 59);
    private static final Color b = new Color(239, 249, 236);
    private static final Color c = new Color(213, 29, 45);
    private static final Color d = new Color(253, 238, 242);
    private static final Color e = new Color(244, 154, 33);
    private static final Color f = new Color(254, 246, 232);
    private static final Color g = new Color(41, 113, 174);
    private static final Color h = new Color(206, 232, 255);
    private static final Color i = new Color(210, 212, 209);
    private static final Color j = new Color(57, 59, 60);
    private static final Color k = new Color(57, 117, 194);
    private static final Color l = new Color(255, 255, 255);
    private static final Color m = new Color(231, 230, 230);
    private static final PDColor n = new PDColor(new float[]{(float)k.getRed() / 255.0f, (float)k.getGreen() / 255.0f, (float)k.getBlue() / 255.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
    private final PDRectangle o = PDRectangle.A4;
    private PDFont p;
    private PDFont q;
    private final float r = this.o.getHeight() - 60.0f;
    private float s = 0.0f;
    private float t = 0.0f;
    private ValidatedDocument u = null;
    private PDDocument v = null;
    private String w = "";
    private boolean x = false;
    private boolean y = false;
    private InputStream z;
    private String A = "";
    private MessageFactory B = null;
    private Logger C = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private SimpleDateFormat D = null;
    private LinkedList<ValidatedSignerReport> E = null;
    private LinkedList<ValidatedSignerReport> F = null;
    private int G = 0;
    private static final int[] H = new int[]{50, 50, 175, 175, 85, 30, 0, 0};
    private final HashMap<String, PDFReportPage> I = new HashMap();
    private final Map<String, SummaryPageLink> J = new HashMap<String, SummaryPageLink>();
    private int K = 0;

    public PDFReport(PDFReportParams object) {
        this.w = ((PDFReportParams)object).appName;
        if (!Util.isNullOrEmpty((String)((PDFReportParams)object).validatedDocName)) {
            if (((PDFReportParams)object).validatedDocName.contains(File.separator)) {
                if (((PDFReportParams)object).validatedDocName.endsWith(File.separator)) {
                    ((PDFReportParams)object).validatedDocName = ((PDFReportParams)object).validatedDocName.substring(0, ((PDFReportParams)object).validatedDocName.length() - 1);
                }
                if (((PDFReportParams)object).validatedDocName.contains(File.separator)) {
                    ((PDFReportParams)object).validatedDocName = ((PDFReportParams)object).validatedDocName.substring(((PDFReportParams)object).validatedDocName.lastIndexOf(File.separator) + 1);
                }
            }
            this.A = ((PDFReportParams)object).validatedDocName;
        }
        this.C = ((PDFReportParams)object).logger;
        this.x = ((PDFReportParams)object).showCapiVer;
        this.y = ((PDFReportParams)object).isFEAActivated;
        this.z = ((PDFReportParams)object).reportLogo;
        try {
            this.B = new MessageFactory(((PDFReportParams)object).language, "reportDictionary");
        }
        catch (VolException volException) {
            this.C.error("unable to setup the language for message factory: " + volException.getMessage());
        }
        this.D = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        this.D.setTimeZone(Constants.DEFAULT_TIMEZONE);
        try {
            this.u = ((PDFReportParams)object).validatedDoc;
            this.E = this.a(this.u, 1, ((PDFReportParams)object).currentDocumentOnly);
            this.F = this.b(this.u, 1, ((PDFReportParams)object).currentDocumentOnly);
            this.v = new PDDocument();
            InputStream inputStream = this.getClass().getResourceAsStream("/font/Lato-Regular.ttf");
            object = this.getClass().getResourceAsStream("/font/Lato-Bold.ttf");
            if (inputStream != null && object != null) {
                this.p = PDType0Font.load((PDDocument)this.v, (InputStream)inputStream);
                this.q = PDType0Font.load((PDDocument)this.v, (InputStream)object);
            }
            return;
        }
        catch (Exception exception) {
            this.C.error(exception.getMessage());
            return;
        }
    }

    private LinkedList<ValidatedSignerReport> a(ValidatedDocument validatedDocument, int n, boolean bl) {
        LinkedList<ValidatedSignerReport> linkedList = new LinkedList<ValidatedSignerReport>();
        for (Object object : validatedDocument.getSignersOnly()) {
            object = new ValidatedSignerReport((ValidatedSigner)object, n);
            linkedList.add((ValidatedSignerReport)object);
        }
        if (bl) {
            return linkedList;
        }
        for (Object object : validatedDocument.getSubResults()) {
            linkedList.addAll(this.a((ValidatedDocument)object, ++n, bl));
        }
        return linkedList;
    }

    private LinkedList<ValidatedSignerReport> b(ValidatedDocument validatedDocument, int n, boolean bl) {
        LinkedList<ValidatedSignerReport> linkedList = new LinkedList<ValidatedSignerReport>();
        for (Object object : validatedDocument.getTimeStampsOnly()) {
            object = new ValidatedSignerReport((ValidatedSigner)object, n);
            linkedList.add((ValidatedSignerReport)object);
        }
        if (bl) {
            return linkedList;
        }
        for (Object object : validatedDocument.getSubResults()) {
            linkedList.addAll(this.b((ValidatedDocument)object, n++, bl));
        }
        return linkedList;
    }

    private float a() {
        this.s = 20.0f;
        return this.s;
    }

    private float a(float f) {
        if (this.s - f >= 20.0f) {
            this.s -= f;
        }
        return this.s;
    }

    private float b(float f) {
        if (this.s + f <= this.o.getWidth() - 20.0f) {
            this.s += f;
        }
        return this.s;
    }

    private float c(float f) {
        if (this.t - f >= 40.0f) {
            this.t -= f;
        }
        return this.t;
    }

    public boolean createPdfReportFull() {
        this.a();
        this.t = this.r - 7.5f - this.p.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * 12.0f / 4.0f;
        return this.b();
    }

    private boolean b() {
        try {
            boolean bl = this.c();
            PDFReport pDFReport = this;
            boolean bl2 = true;
            for (ValidatedSignerReport object : pDFReport.F) {
                bl2 &= pDFReport.a(object.getSigner());
            }
            for (ValidatedSignerReport validatedSignerReport : pDFReport.E) {
                bl2 &= pDFReport.a(validatedSignerReport.getSigner());
            }
            boolean bl3 = bl2;
            boolean bl4 = this.e();
            pDFReport = this;
            PDBorderStyleDictionary pDBorderStyleDictionary = new PDBorderStyleDictionary();
            pDBorderStyleDictionary.setStyle("U");
            pDBorderStyleDictionary.setWidth(2.0f);
            for (SummaryPageLink summaryPageLink : pDFReport.J.values()) {
                PageLink pageLink = summaryPageLink.getLink();
                try {
                    summaryPageLink.getPage().getContentStream().setNonStrokingColor(k);
                }
                catch (IOException iOException) {
                    pDFReport.C.error(iOException.getMessage(), (Throwable)iOException);
                }
                pDFReport.a(summaryPageLink.getPage(), pageLink.getDestinationPage(), pDFReport.q, 9.0f, summaryPageLink.getxPos(), summaryPageLink.getyPos());
                PDAnnotationLink pDAnnotationLink = new PDAnnotationLink();
                pDAnnotationLink.setBorderStyle(pDBorderStyleDictionary);
                pDAnnotationLink.setRectangle(pageLink.getRectangle());
                pDAnnotationLink.setColor(n);
                PDActionGoTo pDActionGoTo = new PDActionGoTo();
                PDPageXYZDestination pDPageXYZDestination = new PDPageXYZDestination();
                pDPageXYZDestination.setPage(pDFReport.I.get(pageLink.getDestinationPage()).getPDPage());
                pDActionGoTo.setDestination((PDDestination)pDPageXYZDestination);
                pDAnnotationLink.setAction((PDAction)pDActionGoTo);
                try {
                    pageLink.getSourcePage().getPDPage().getAnnotations().add(pDAnnotationLink);
                    pDAnnotationLink.constructAppearances();
                }
                catch (IOException iOException) {
                    pDFReport.C.error(iOException.getMessage(), (Throwable)iOException);
                }
            }
            for (SummaryPageLink summaryPageLink : pDFReport.J.values()) {
                try {
                    summaryPageLink.getPage().close();
                }
                catch (IOException iOException) {
                    pDFReport.C.error(iOException.getMessage(), (Throwable)iOException);
                }
            }
            return bl && bl3 && bl4;
        }
        catch (Exception exception) {
            this.C.error(exception.getMessage());
            return false;
        }
    }

    private boolean c() {
        try {
            PDFReportPage pDFReportPage = this.f();
            if (this.z != null) {
                PDFReport pDFReport = this;
                pDFReportPage.getContentStream().drawForm(pDFReport.a(pDFReport.z, this.s, this.t - 30.0f, 1.5, 1.5));
            }
            this.t = pDFReportPage.getPDPage().getMediaBox().getHeight() - 70.0f;
            ArrayList<SummaryTableRow> arrayList = new ArrayList<SummaryTableRow>();
            this.G = 1;
            for (ValidatedSignerReport validatedSignerReport : this.F) {
                ++this.G;
                this.a(validatedSignerReport.getSigner(), arrayList, String.format("%d", validatedSignerReport.getTreeLevel()));
            }
            for (ValidatedSignerReport validatedSignerReport : this.E) {
                ++this.G;
                this.a(validatedSignerReport.getSigner(), arrayList, String.format("%d", validatedSignerReport.getTreeLevel()));
            }
            this.b(arrayList, pDFReportPage);
        }
        catch (IOException iOException) {
            this.C.error(iOException.getMessage());
            return false;
        }
        return true;
    }

    private void a(ValidatedSigner validatedSigner, List<SummaryTableRow> list, String string) {
        int n = this.G;
        Object object = validatedSigner.getSignerName();
        if (object != null) {
            if (((String)object).equals("NO_CERT_FOUND_INSIDE_SIGNATURE")) {
                object = "";
            }
            if (((String)object).length() > 35) {
                object = ((String)object).substring(0, 35) + "...";
            }
        }
        Object object22 = null;
        try {
            if (validatedSigner.getCert() != null) {
                object22 = validatedSigner.getCert().getCert().getIssuerDNAttribute("commonname");
            }
        }
        catch (CapiException capiException) {
            this.C.error(capiException.getMessage(), (Throwable)capiException);
        }
        String string2 = "";
        if (object22 != null && ((String[])object22).length > 0 && (string2 = object22[0]).length() > 40) {
            string2 = string2.substring(0, 40) + "...";
        }
        list.add(new SummaryTableRow(validatedSigner, string, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0069_SIGNATURE, new Object[0]), (String)object, string2, PDFReport.b(validatedSigner).name(), n++, 0, "SIGN"));
        for (Object object22 : validatedSigner.getTimeStamps()) {
            string2 = object22.getSignerName();
            if (string2 != null && string2.equals("NO_CERT_FOUND_INSIDE_SIGNATURE")) {
                string2 = "";
            }
            if (string2.length() > 35) {
                string2 = string2.substring(0, 35) + "...";
            }
            String string3 = "";
            if (validatedSigner.getCert() != null && validatedSigner.getCert().getIssuer() != null && validatedSigner.getCert().getIssuer().getCert() != null && (string3 = validatedSigner.getCert().getIssuer().getCert().getName()).length() > 40) {
                string3 = string3.substring(0, 40) + "...";
            }
            ++this.G;
            list.add(new SummaryTableRow((ValidatedSigner)object22, string, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0070_TIMESTAMP, new Object[0]), string2, string3, PDFReport.b(object22).name(), n++, 1, "TST"));
        }
        for (int i = 0; i < validatedSigner.getCounterSigners().size(); ++i) {
            object22 = String.format("%s.%d", string, i + 1);
            ++this.G;
            this.a((ValidatedSigner)validatedSigner.getCounterSigners().get(i), list, (String)object22);
        }
    }

    private void a(String object) throws IOException {
        object = this.J.get(object);
        String string = Integer.toString(this.v.getNumberOfPages());
        ((SummaryPageLink)object).getLink().setDestinationPage(string);
        float f = this.q.getStringWidth(string) / 1000.0f * 9.0f;
        Object object2 = object;
        ((SummaryPageLink)object2).setxPos(((SummaryPageLink)object2).getxPos() - f);
        ((SummaryPageLink)object).getLink().getRectangle().setLowerLeftX(((SummaryPageLink)object).getLink().getRectangle().getLowerLeftX() - f);
    }

    private boolean a(ValidatedSigner validatedSigner) {
        try {
            PDFReportPage pDFReportPage = this.f();
            Throwable throwable = null;
            try {
                this.a(Integer.toString(validatedSigner.hashCode()));
                Object object = validatedSigner.getSignerName();
                if (object != null && ((String)object).equals("NO_CERT_FOUND_INSIDE_SIGNATURE")) {
                    object = "";
                }
                this.t = pDFReportPage.getPDPage().getMediaBox().getHeight() - 50.0f;
                this.a(pDFReportPage, (String)object, this.p, 16.0f, this.a(), this.t);
                object = this;
                ((PDFReport)object).c(15.0f);
                object = this;
                ((PDFReport)object).c(15.0f);
                object = validatedSigner.getFormat().equals((Object)SignatureFormat.TST) ? this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0062_RESULT_MARK, new Object[0]) : this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0063_RESULT_SIGNATURE, new Object[0]);
                float f = PDFReport.a((String)object, this.p, 14.0f);
                this.a(pDFReportPage, (String)object, this.p, 14.0f, this.s, this.t);
                this.a(PDFReport.b(validatedSigner).name(), pDFReportPage, this.s + f + 20.0f, this.t - 2.0f);
                pDFReportPage.getContentStream().setNonStrokingColor(j);
                object = this;
                ((PDFReport)object).c(15.0f);
                if (this.y) {
                    this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0061_FEA_ACTIVE, new Object[0]), this.q, 9.0f, this.s, this.t - 12.0f);
                }
                this.a(validatedSigner.getMessages(), pDFReportPage);
                if (validatedSigner.getCert() != null) {
                    this.a(validatedSigner.getCert().getMessages(), pDFReportPage);
                }
                if (validatedSigner.getFormat().equals((Object)SignatureFormat.TST)) {
                    boolean bl = false;
                    for (ValidatorMessage validatorMessage : validatedSigner.getMessages()) {
                        if (!ValidatorMessageEnum.IS0013_MARK_DETAILS.getCode().equals(validatorMessage.getMessageCode())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.a();
                        Object object2 = validatedSigner.getSignerName();
                        if (object2 != null && ((String)object2).equals("NO_CERT_FOUND_INSIDE_SIGNATURE")) {
                            object2 = "";
                        }
                        PDFReport pDFReport = this;
                        this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0026_TIMESTAMP_DETAILS, new Object[0]), this.q, 9.0f, this.s, pDFReport.c(15.0f));
                        pDFReport = this;
                        pDFReport.b(5.0f);
                        pDFReport = this;
                        this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0027_TIMESTAMP_ISSUING_DATE, new Object[0]) + ": " + this.D.format(validatedSigner.getSignatureDate()), this.p, 9.0f, this.s, pDFReport.c(15.0f));
                        pDFReport = this;
                        this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0028_TSA, new Object[0]) + ": " + (String)object2, this.p, 9.0f, this.s, pDFReport.c(15.0f));
                        if (validatedSigner.getCert() != null) {
                            pDFReport = this;
                            this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0029_HASH_ALGORTHM, new Object[0]) + ": " + validatedSigner.getCert().getCert().getInternalCert().getSigAlgName(), this.p, 9.0f, this.s, pDFReport.c(15.0f));
                            pDFReport = this;
                            this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0030_EIDAS_COMPLIANT, new Object[0]) + ": " + (validatedSigner.getCert().getCert().isCompliant() ? "YES" : "NO"), this.p, 9.0f, this.s, pDFReport.c(15.0f));
                        }
                        pDFReport = this;
                        this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0031_ACCURACY, new Object[0]) + ": " + this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0032_MILLISECONDS, new Object[0]), this.p, 9.0f, this.s, pDFReport.c(15.0f));
                        pDFReport = this;
                        pDFReport.c(15.0f);
                    }
                }
                this.a();
                Object object3 = this;
                this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0012_CERTIFICATE_DETAILS, new Object[0]), this.q, 12.0f, this.s, ((PDFReport)object3).c(15.0f));
                object3 = this;
                ((PDFReport)object3).c(15.0f);
                if (validatedSigner.getCert() != null) {
                    this.a(pDFReportPage, validatedSigner);
                } else {
                    object3 = this;
                    ((PDFReport)object3).b(5.0f);
                    if (validatedSigner.getFormat().equals((Object)SignatureFormat.TST)) {
                        object3 = this;
                        this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0048_TIMESTAMP_WITHOUT_CERTIFICATE, new Object[0]), this.p, 12.0f, this.s, ((PDFReport)object3).c(15.0f));
                    }
                }
                for (ValidatedSigner validatedSigner2 : validatedSigner.getTimeStamps()) {
                    this.a(validatedSigner2);
                }
                for (ValidatedSigner validatedSigner3 : validatedSigner.getCounterSigners()) {
                    this.a(validatedSigner3);
                }
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            pDFReportPage.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        pDFReportPage.close();
                    }
                    throw throwable4;
                }
            }
            pDFReportPage.close();
        }
        catch (IOException iOException) {
            this.C.error(iOException.getMessage());
            return false;
        }
        catch (Exception exception) {
            this.C.error(exception.getMessage());
            return false;
        }
        return true;
    }

    private void a(PDFReportPage pDFReportPage, ValidatedSigner validatedSigner) throws CapiException, IOException {
        PDFReportPage pDFReportPage2 = pDFReportPage;
        Object object = this;
        ((PDFReport)object).c(15.0f);
        object = new ArrayList<CertificateDetailsInfo>();
        object.add(new CertificateDetailsInfo(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0013_CN, new Object[0]) + ": ", validatedSigner.getCert().getCert().getSubjectCommonName()));
        object.add(new CertificateDetailsInfo(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0014_SERIAL, new Object[0]) + ": ", validatedSigner.getCert().getCertSerial()));
        if (validatedSigner.getCert().getCert().getSubjectOrganization() != null && validatedSigner.getCert().getCert().getSubjectOrganization().length > 0) {
            object.add(new CertificateDetailsInfo(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0015_ORGANIZATION, new Object[0]) + ": ", validatedSigner.getCert().getCert().getSubjectOrganization()[0]));
        }
        if (validatedSigner.getCert().getCert().getSubjectCountry() != null && validatedSigner.getCert().getCert().getSubjectCountry().length > 0) {
            object.add(new CertificateDetailsInfo(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0016_NATION, new Object[0]) + ": ", validatedSigner.getCert().getCert().getSubjectCountry()[0]));
        }
        if (validatedSigner.getCert().getCert().getSubjectSerialNumber() != null && validatedSigner.getCert().getCert().getSubjectSerialNumber().length > 0) {
            object.add(new CertificateDetailsInfo(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0017_NATIONALID, new Object[0]) + ": ", validatedSigner.getCert().getCert().getSubjectSerialNumber()[0]));
        }
        object.add(new CertificateDetailsInfo(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0008_ISSUER, new Object[0]) + ": ", validatedSigner.getCert().getCertIssuer()));
        object.add(new CertificateDetailsInfo(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0019_KEYUSAGE, new Object[0]) + ": ", validatedSigner.getCert().getCert().keyUsageToString(validatedSigner.getCert().getCert().getKeyUsage())));
        List<String> list = this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0020_POLICIES, new Object[0]) + ": ";
        Object object2 = validatedSigner.getCert().getCert().getPolicies(',');
        CharSequence charSequence = new StringBuilder();
        for (String string : object2) {
            charSequence.append(string);
        }
        object.add(new CertificateDetailsInfo((String)((Object)list), charSequence.toString()));
        object.add(new CertificateDetailsInfo(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0021_VALIDITY, new Object[0]) + ": ", String.format("%s %s %s %s", this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0022_FROM, new Object[0]), validatedSigner.getCert().getCert().getValidityNotBefore("dd/MM/yyyy HH:mm:ss zzz", "UTC"), this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0023_TO, new Object[0]), validatedSigner.getCert().getCert().getValidityNotAfter("dd/MM/yyyy HH:mm:ss zzz", "UTC"))));
        if (validatedSigner.getCert().getCert().isSSCD()) {
            object.add(new CertificateDetailsInfo("", this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0037_QC_SSCD, new Object[0])));
        }
        if (validatedSigner.getCert().getCert().getQcStatementLimitValue() != null) {
            object.add(new CertificateDetailsInfo(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0035_QC_LIMIT, new Object[0]) + ": ", validatedSigner.getCert().getCert().getQcStatementLimitValue()));
        }
        if (validatedSigner.getCert().getCert().getQcStatementRetention() != null) {
            object.add(new CertificateDetailsInfo(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0036_QC_RETENTION, new Object[0]) + ": ", validatedSigner.getCert().getCert().getQcStatementRetention() + " " + this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0034_YEARS, new Object[0])));
        }
        if (validatedSigner.getCert().getCert().getQcStatementType() != null) {
            for (String string : validatedSigner.getCert().getCert().getQcStatementType()) {
                if (string.endsWith("0.4.0.1862.1.6.1")) {
                    object.add(new CertificateDetailsInfo("", this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0039_QC_TYPE_0_4_0_1862_1_6_1, new Object[0])));
                    continue;
                }
                if (string.endsWith("0.4.0.1862.1.6.2")) {
                    object.add(new CertificateDetailsInfo("", this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0040_QC_TYPE_0_4_0_1862_1_6_2, new Object[0])));
                    continue;
                }
                if (!string.endsWith("0.4.0.1862.1.6.3")) continue;
                object.add(new CertificateDetailsInfo("", this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0041_QC_TYPE_0_4_0_1862_1_6_3, new Object[0])));
            }
        }
        object2 = new ArrayList();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            float f;
            String string;
            CertificateDetailsInfo certificateDetailsInfo = (CertificateDetailsInfo)iterator.next();
            string = certificateDetailsInfo.getValue();
            charSequence = certificateDetailsInfo.getKey();
            list = pDFReportPage;
            object = this;
            float f2 = PDFReport.a((String)charSequence, ((PDFReport)object).q, 12.0f);
            list = PDFReport.a(string, ((PDFReport)object).p, 12.0f, ((PDFReportPage)((Object)list)).getPDPage().getMediaBox().getWidth() - ((PDFReport)object).s - f2 - 20.0f);
            float f3 = ((PDFReport)object).t - 15.0f * (float)list.size();
            if (!(f >= 40.0f)) {
                pDFReportPage2 = this.d();
                object2.add(pDFReportPage2);
            }
            this.a(certificateDetailsInfo.getKey(), certificateDetailsInfo.getValue(), pDFReportPage2);
        }
        if (validatedSigner.getCert().getCert().getQcPdsLocation() != null) {
            if (this.t - 15.0f * (float)(validatedSigner.getCert().getCert().getQcPdsLocation().size() + 1) < 40.0f) {
                pDFReportPage2 = this.d();
                object2.add(pDFReportPage2);
            }
            this.a(pDFReportPage2, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0038_QC_PKI, new Object[0]) + ": ", this.q, 12.0f, this.s, this.t);
            object = this;
            ((PDFReport)object).c(15.0f);
            object = this;
            ((PDFReport)object).b(5.0f);
            for (PdsLocation pdsLocation : validatedSigner.getCert().getCert().getQcPdsLocation()) {
                this.a(pDFReportPage2, "- (" + pdsLocation.getLanguage() + ") " + pdsLocation.getUrl(), this.p, 12.0f, this.s, this.t);
                object = this;
                ((PDFReport)object).c(15.0f);
            }
            object = this;
            ((PDFReport)object).a(5.0f);
        }
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            PDFReportPage pDFReportPage3 = (PDFReportPage)iterator.next();
            pDFReportPage3.close();
        }
    }

    private PDFReportPage d() throws IOException {
        PDFReportPage pDFReportPage = this.f();
        this.t = pDFReportPage.getPDPage().getMediaBox().getHeight() - 70.0f;
        return pDFReportPage;
    }

    private void a(String string, String string2, PDFReportPage pDFReportPage) throws IOException {
        float f = PDFReport.a(string, this.q, 12.0f);
        this.a(pDFReportPage, string, this.q, 12.0f, this.s, this.t);
        int n = this.a(pDFReportPage, string2, this.p, 12.0f, this.s + f, this.t, pDFReportPage.getPDPage().getMediaBox().getWidth() - this.s - f - 20.0f, 15.0f);
        this.c(15.0f * (float)n);
    }

    private void a(List<ValidatorMessage> object, PDFReportPage pDFReportPage) throws IOException {
        object = object.iterator();
        while (object.hasNext()) {
            ValidatorMessage validatorMessage = (ValidatorMessage)object.next();
            this.c(45.0f);
            this.a();
            this.b(validatorMessage, pDFReportPage);
            this.b(20.0f);
            int n = this.a(pDFReportPage, validatorMessage.getMessage(), this.q, 12.0f, this.s, this.t, this.o.getWidth() - this.s - 20.0f, 15.0f);
            this.c(15.0f * (float)n);
            this.c(10.0f);
            for (ValidatorMessage validatorMessage2 : validatorMessage.getNotes()) {
                this.a(validatorMessage2, pDFReportPage);
            }
        }
    }

    private void a(ValidatorMessage object, PDFReportPage pDFReportPage) {
        int n = this.a(pDFReportPage, object.getMessage(), this.p, 12.0f, this.s, this.t, this.o.getWidth() - this.s - 20.0f, 15.0f);
        this.b(20.0f);
        this.c(15.0f * (float)n);
        for (ValidatorMessage validatorMessage : object.getNotes()) {
            this.a(validatorMessage, pDFReportPage);
        }
        this.a(20.0f);
    }

    private void b(ValidatorMessage validatorMessage, PDFReportPage pDFReportPage) throws IOException {
        switch (validatorMessage.getLevel()) {
            case INFO: {
                if (this.y) {
                    pDFReportPage.getContentStream().drawForm(this.a("/report/successBlue.pdf", this.s, this.t - 5.0f, 0.05, 0.05));
                    return;
                }
                pDFReportPage.getContentStream().drawForm(this.a("/report/success.pdf", this.s, this.t - 5.0f, 0.05, 0.05));
                return;
            }
            case ERROR: {
                pDFReportPage.getContentStream().drawForm(this.a("/report/error.pdf", this.s, this.t - 5.0f, 0.35, 0.35));
                return;
            }
            case WARNING: {
                pDFReportPage.getContentStream().drawForm(this.a("/report/warning.pdf", this.s, this.t - 5.0f, 0.05, 0.05));
            }
        }
    }

    private PDFormXObject a(String object, float f, float f2, double d, double d2) throws IOException {
        object = this.getClass().getResourceAsStream((String)object);
        return this.a((InputStream)object, f, f2, d, d2);
    }

    private PDFormXObject a(InputStream object, float f, float f2, double d, double d2) throws IOException {
        Object object2 = new ScratchFile(MemoryUsageSetting.setupMixed((long)10000000L));
        object = object2.createBuffer((InputStream)object);
        object = new PDFParser((RandomAccessRead)object, object2);
        object = object.parse().getPage(0);
        object2 = object.getContents();
        PDFormXObject pDFormXObject = new PDFormXObject(this.v);
        OutputStream outputStream = pDFormXObject.getStream().createOutputStream();
        try {
            IOUtils.copy((InputStream)object2, (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((Closeable)outputStream);
            IOUtils.closeQuietly((Closeable)object2);
        }
        pDFormXObject.setResources(object.getResources());
        pDFormXObject.setBBox(object.getBBox());
        object = AffineTransform.getTranslateInstance(f, f2);
        ((AffineTransform)object).scale(d, d2);
        pDFormXObject.setMatrix((AffineTransform)object);
        return pDFormXObject;
    }

    private boolean e() {
        try {
            PDFReportPage pDFReportPage = this.f();
            Throwable throwable = null;
            try {
                this.a();
                Object object = this;
                this.t = ((PDFReport)object).r;
                float cfr_ignored_0 = ((PDFReport)object).t;
                this.a("appendix");
                this.c(50.0f);
                this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0004_APPENDIX_A, new Object[0]), this.p, 16.0f, this.s, this.t);
                object = this;
                ((PDFReport)object).c(15.0f);
                pDFReportPage.getContentStream().setNonStrokingColor(m);
                pDFReportPage.getContentStream().moveTo(this.s, this.t);
                pDFReportPage.getContentStream().lineTo(this.o.getWidth() - 20.0f, this.t);
                pDFReportPage.getContentStream().fill();
                pDFReportPage.getContentStream().setNonStrokingColor(j);
                object = this;
                ((PDFReport)object).c(15.0f);
                object = this;
                ((PDFReport)object).c(15.0f);
                this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0042_ROOT_AUTHORITIES_CERTIFICATES, new Object[0]), this.p, 16.0f, this.s, this.t);
                object = this;
                ((PDFReport)object).c(15.0f);
                object = new HashMap();
                for (ValidatedSignerReport validatedSignerReport : this.E) {
                    this.a(validatedSignerReport.getSigner(), (HashMap<String, ValidatedCertificate>)object);
                }
                for (ValidatedSignerReport validatedSignerReport : ((HashMap)object).values()) {
                    this.c(42.0f);
                    this.a(pDFReportPage, validatedSignerReport.getCertName(), this.q, 13.0f, this.s, this.t);
                    this.c(28.0f);
                    this.a(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0014_SERIAL, new Object[0]) + ": ", validatedSignerReport.getCertSerial(), pDFReportPage);
                    if (validatedSignerReport.getCert().getSubjectOrganization() != null && validatedSignerReport.getCert().getSubjectOrganization().length > 0) {
                        this.a(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0015_ORGANIZATION, new Object[0]) + ": ", validatedSignerReport.getCert().getSubjectOrganization()[0], pDFReportPage);
                    }
                    if (validatedSignerReport.getCert().getSubjectCountry() != null && validatedSignerReport.getCert().getSubjectCountry().length > 0) {
                        this.a(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0016_NATION, new Object[0]) + ": ", validatedSignerReport.getCert().getSubjectCountry()[0], pDFReportPage);
                    }
                    if (validatedSignerReport.getCert().getSubjectSerialNumber() != null && validatedSignerReport.getCert().getSubjectSerialNumber().length > 0) {
                        this.a(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0017_NATIONALID, new Object[0]) + ": ", validatedSignerReport.getCert().getSubjectSerialNumber()[0], pDFReportPage);
                    }
                    this.a(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0019_KEYUSAGE, new Object[0]) + ": ", validatedSignerReport.getCert().keyUsageToString(validatedSignerReport.getCert().getKeyUsage()), pDFReportPage);
                    this.a(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0008_ISSUER, new Object[0]) + ": ", validatedSignerReport.getCert().getIssuerDN(), pDFReportPage);
                    object = String.format("%s %s %s %s", this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0022_FROM, new Object[0]), validatedSignerReport.getCert().getValidityNotBefore("dd/MM/yyyy HH:mm:ss zzz", "UTC"), this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0023_TO, new Object[0]), validatedSignerReport.getCert().getValidityNotAfter("dd/MM/yyyy HH:mm:ss zzz", "UTC"));
                    this.a(this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0021_VALIDITY, new Object[0]) + ": ", (String)object, pDFReportPage);
                    object = this;
                    ((PDFReport)object).c(15.0f);
                }
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            pDFReportPage.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        pDFReportPage.close();
                    }
                    throw throwable4;
                }
            }
            pDFReportPage.close();
        }
        catch (IOException iOException) {
            this.C.error(iOException.getMessage());
            return false;
        }
        catch (Exception exception) {
            this.C.error(exception.getMessage());
            return false;
        }
        return true;
    }

    private void a(ValidatedSigner validatedSigner, HashMap<String, ValidatedCertificate> hashMap) {
        Object object = validatedSigner.getCert();
        if (object != null) {
            while (object.getIssuer() != null) {
                object = object.getIssuer();
                hashMap.put(object.getCertSerial(), (ValidatedCertificate)object);
            }
        }
        for (ValidatedSigner validatedSigner2 : validatedSigner.getCounterSigners()) {
            this.a(validatedSigner2, hashMap);
        }
        for (ValidatedSigner validatedSigner2 : validatedSigner.getTimeStamps()) {
            this.a(validatedSigner2, hashMap);
        }
    }

    private void b(List<SummaryTableRow> list, PDFReportPage pDFReportPage) throws IOException {
        float f;
        PDFReportPage pDFReportPage2;
        float f2;
        float f3;
        PDFReport pDFReport;
        pDFReportPage.getContentStream().setFont(this.p, 9.0f);
        float f4 = this.t;
        this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0001_FILENAME, new Object[0]), this.q, 9.0f, 25.0f, f4);
        int n = this.a(pDFReportPage, !Util.isNullOrEmpty((String)this.A) ? this.A : this.u.getShortName(), this.p, 9.0f, 120.0f, f4, this.o.getWidth() - 120.0f);
        for (int i = 0; i < n; ++i) {
            f4 -= 20.0f;
        }
        this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0002_VERIFICATION_DATE, new Object[0]), this.q, 9.0f, 25.0f, f4);
        this.a(pDFReportPage, this.D.format(((ValidatedSigner)this.u.getSigners().get(0)).getVerificationDate().getDate()), this.p, 9.0f, 120.0f, f4);
        if (this.x) {
            String string = this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0060_VERIFIER_VER, new Object[0]);
            this.a(pDFReportPage, string, this.q, 9.0f, 357.0f, f4);
            float f5 = this.q.getStringWidth(string) / 1000.0f * 9.0f;
            this.a(pDFReportPage, String.format("%s", Version.getVersion()), this.p, 9.0f, f5 + 377.0f, f4);
        }
        f4 -= 20.0f;
        if (this.y) {
            this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0061_FEA_ACTIVE, new Object[0]), this.q, 9.0f, 25.0f, f4);
            f4 -= 40.0f;
        } else {
            f4 -= 20.0f;
        }
        Object object = list;
        float f6 = 40.0f;
        f6 = 25.0f;
        PDFReport pDFReport2 = this;
        String[] stringArray = new String[]{pDFReport2.B.getMessage((EsecurityMessage)ReportMessageEnum.R0006_SIGNATURE_TREE_LEVEL, new Object[0]), pDFReport2.B.getMessage((EsecurityMessage)ReportMessageEnum.R0068_TYPE, new Object[0]), pDFReport2.B.getMessage((EsecurityMessage)ReportMessageEnum.R0007_SIGNER, new Object[0]), pDFReport2.B.getMessage((EsecurityMessage)ReportMessageEnum.R0008_ISSUER, new Object[0]), pDFReport2.B.getMessage((EsecurityMessage)ReportMessageEnum.R0010_RESULT, new Object[0]), pDFReport2.B.getMessage((EsecurityMessage)ReportMessageEnum.R0009_PAGE, new Object[0]), "0", ""};
        pDFReport2.a(pDFReportPage, stringArray, 25.0f, f4);
        f4 -= 25.0f;
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            SummaryTableRow summaryTableRow = (SummaryTableRow)object.next();
            int n3 = n2;
            pDFReport = pDFReport2;
            if (n3 != 0 && (pDFReport.K == 1 && n3 % 16 == 0 || pDFReport.K > 1 && (float)n3 % 18.0f == 0.0f)) {
                n2 = 0;
                pDFReportPage = pDFReport2.f();
                f4 = pDFReportPage.getPDPage().getMediaBox().getHeight() - 70.0f;
                pDFReport2.a(pDFReportPage, stringArray, 25.0f, f4);
                f4 -= 25.0f;
            }
            f3 = f4;
            f2 = 25.0f;
            pDFReportPage2 = pDFReportPage;
            pDFReport = pDFReport2;
            String string = "";
            for (int i = 0; i < summaryTableRow.getIndentationLevel(); ++i) {
                string = string + " >";
            }
            pDFReport.a(pDFReportPage2, string + " " + summaryTableRow.getLevel(), pDFReport.p, 7.0f, f2, f3);
            pDFReport.a(pDFReportPage2, summaryTableRow.getTypeName(), pDFReport.p, 7.0f, f2 += (float)H[0], f3);
            f2 += (float)H[1];
            if ("TST".equals(summaryTableRow.getType())) {
                pDFReportPage2.getContentStream().drawForm(pDFReport.a("/report/mark.pdf", f2, f3 - 7.0f, 1.25, 1.25));
            } else {
                pDFReportPage2.getContentStream().drawForm(pDFReport.a("/report/sign.pdf", f2, f3 - 7.0f, 1.25, 1.25));
            }
            pDFReport.a(pDFReportPage2, summaryTableRow.getSigner(), pDFReport.p, 7.0f, f2 + 25.0f, f3, H[2] - 20);
            pDFReport.a(pDFReportPage2, summaryTableRow.getCa(), pDFReport.p, 7.0f, f2 += (float)H[2], f3);
            pDFReport.a(summaryTableRow.getResult(), pDFReportPage2, f2 += (float)H[3], f3 - 3.0f);
            f2 += (float)H[4];
            float f7 = pDFReport.q.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * 9.0f;
            pDFReport.J.put(Integer.toString(summaryTableRow.getValidatedSigner().hashCode()), new SummaryPageLink(pDFReportPage2, new PageLink(new PDRectangle(f2 += (float)H[5], f3 - 2.0f, 0.0f, f7), pDFReportPage2, ""), f2, f3));
            pDFReportPage2.getContentStream().setNonStrokingColor(j);
            f = f4 -= 15.0f;
            pDFReportPage2 = pDFReportPage;
            pDFReport = pDFReport2;
            pDFReportPage2.getContentStream().setNonStrokingColor(m);
            pDFReportPage2.getContentStream().moveTo(20.0f, f);
            pDFReportPage2.getContentStream().lineTo(pDFReport.o.getWidth(), f);
            pDFReportPage2.getContentStream().fill();
            pDFReportPage2.getContentStream().setNonStrokingColor(j);
            f4 -= 20.0f;
            ++n2;
        }
        f2 = f4;
        f = 25.0f;
        pDFReportPage2 = pDFReportPage;
        pDFReport = pDFReport2;
        pDFReport.a(pDFReportPage2, pDFReport.B.getMessage((EsecurityMessage)ReportMessageEnum.R0004_APPENDIX_A, new Object[0]), pDFReport.q, 9.0f, f += (float)H[0], f2);
        f += (float)H[1];
        f += (float)H[2];
        f += (float)H[3];
        f += (float)H[4];
        f3 = pDFReport.q.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * 9.0f;
        pDFReport.J.put("appendix", new SummaryPageLink(pDFReportPage2, new PageLink(new PDRectangle(f += (float)H[5], f2 - 2.0f, 0.0f, f3), pDFReportPage2, ""), f, f2));
    }

    private void a(PDFReportPage pDFReportPage, String[] stringArray, float f, float f2) throws IOException {
        this.a(f, f2, pDFReportPage);
        this.a(pDFReportPage, stringArray[0], this.q, 9.0f, f, f2 + 2.0f);
        this.a(pDFReportPage, stringArray[1], this.q, 9.0f, f += (float)H[0], f2 + 2.0f);
        this.a(pDFReportPage, stringArray[2], this.q, 9.0f, f += (float)H[1], f2 + 2.0f);
        this.a(pDFReportPage, stringArray[3], this.q, 9.0f, f += (float)H[2], f2 + 2.0f);
        this.a(pDFReportPage, stringArray[4], this.q, 9.0f, f += (float)H[3], f2 + 2.0f);
        this.a(pDFReportPage, stringArray[5], this.q, 9.0f, f += (float)H[4], f2 + 2.0f);
    }

    private void a(String string, PDFReportPage pDFReportPage, float f, float f2) throws IOException {
        if (MessageLevel.INFO.name().equals(string)) {
            if (this.y) {
                PDFReport.a(f, f2, 40.0f, 12.0f, h, g, pDFReportPage);
                pDFReportPage.getContentStream().setNonStrokingColor(g);
            } else {
                PDFReport.a(f, f2, 40.0f, 12.0f, b, a, pDFReportPage);
                pDFReportPage.getContentStream().setNonStrokingColor(a);
            }
            this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0064_RESULT_VALID, new Object[0]), this.p, 7.0f, f + 7.0f, f2 + 3.0f);
            return;
        }
        if (MessageLevel.ERROR.name().equals(string)) {
            PDFReport.a(f, f2, 55.0f, 12.0f, d, c, pDFReportPage);
            pDFReportPage.getContentStream().setNonStrokingColor(c);
            this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0065_RESULT_INVALID, new Object[0]), this.p, 7.0f, f + 7.0f, f2 + 3.0f);
            return;
        }
        if (MessageLevel.WARNING.name().equals(string)) {
            PDFReport.a(f, f2, 58.0f, 12.0f, PDFReport.f, e, pDFReportPage);
            pDFReportPage.getContentStream().setNonStrokingColor(e);
            this.a(pDFReportPage, this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0066_RESULT_WARNING, new Object[0]), this.p, 7.0f, f + 7.0f, f2 + 3.0f);
        }
    }

    private void a(float f, float f2, PDFReportPage pDFReportPage) throws IOException {
        pDFReportPage = pDFReportPage.getContentStream();
        pDFReportPage.setNonStrokingColor(i);
        pDFReportPage.addRect(f - 5.0f, f2 - 5.0f, this.o.getWidth() - 20.0f, 20.0f);
        pDFReportPage.fill();
        float f3 = f;
        pDFReportPage.setNonStrokingColor(l);
        pDFReportPage.moveTo(f3 - 5.0f, f2 += 10.0f);
        pDFReportPage.curveTo(f3 - 5.0f, f2 + 2.7614238f, f3 - 2.7614238f, f2 + 5.0f, f3, f2 + 5.0f);
        pDFReportPage.lineTo(f3, f2 + 5.0f + 5.0f);
        pDFReportPage.lineTo(f3 - 5.0f - 5.0f, f2 + 5.0f + 5.0f);
        pDFReportPage.lineTo(f3 - 5.0f - 5.0f, f2);
        pDFReportPage.lineTo(f3 - 5.0f, f2);
        pDFReportPage.fill();
        f3 = f - 10.0f + (this.o.getWidth() - 20.0f);
        pDFReportPage.moveTo(f3, f2 + 5.0f);
        pDFReportPage.curveTo(f3 + 2.7614238f, f2 + 5.0f, f3 + 5.0f, f2 + 2.7614238f, f3 + 5.0f, f2);
        pDFReportPage.lineTo(f3 + 5.0f + 5.0f, f2);
        pDFReportPage.lineTo(f3 + 5.0f + 5.0f, f2 + 5.0f + 5.0f);
        pDFReportPage.lineTo(f3, f2 + 5.0f + 5.0f);
        pDFReportPage.lineTo(f3, f2 + 5.0f);
        pDFReportPage.fill();
        pDFReportPage.setNonStrokingColor(j);
    }

    private static void a(float f, float f2, float f3, float f4, Color color, Color color2, PDFReportPage pDFReportPage) throws IOException {
        f4 = Math.min(f3, 12.0f) / 2.0f;
        float f5 = f + f4;
        float f6 = f2 + f4;
        f = f + f3 - f4;
        PDPageContentStream pDPageContentStream = pDFReportPage.getContentStream();
        pDPageContentStream.setStrokingColor(color2);
        pDPageContentStream.setNonStrokingColor(color);
        pDPageContentStream.moveTo(f5, f2);
        pDPageContentStream.curveTo(f5 - 0.5522848f * f4, f6 - f4, f5 - f4, f6 - 0.5522848f * f4, f5 - f4, f6);
        pDPageContentStream.curveTo(f5 - f4, f6 + 0.5522848f * f4, f5 - 0.5522848f * f4, f6 + f4, f5, f6 + f4);
        pDPageContentStream.lineTo(f, f6 + f4);
        pDPageContentStream.curveTo(f + 0.5522848f * f4, f6 + f4, f + f4, f6 + 0.5522848f * f4, f + f4, f6);
        pDPageContentStream.curveTo(f + f4, f6 - 0.5522848f * f4, f + 0.5522848f * f4, f6 - f4, f, f6 - f4);
        pDPageContentStream.closeAndFillAndStroke();
        pDPageContentStream.setNonStrokingColor(j);
    }

    private void a(PDFReportPage pDFReportPage, String string, PDFont object, float f, float f2, float f3) {
        if ((string = PDFReport.b(string)).isEmpty()) {
            return;
        }
        if (string.length() > 90) {
            float f4 = this.o.getWidth() - 20.0f;
            int n = this.a(pDFReportPage, string, (PDFont)object, f, f2, f3, f4);
            for (int i = 0; i < n - 1; ++i) {
                object = this;
                object.c(15.0f);
            }
            return;
        }
        try {
            PDPageContentStream pDPageContentStream = pDFReportPage.getContentStream();
            pDPageContentStream.beginText();
            pDPageContentStream.moveTextPositionByAmount(f2, f3);
            pDPageContentStream.setFont(object, f);
            pDPageContentStream.drawString(string);
            pDPageContentStream.endText();
            return;
        }
        catch (IOException iOException) {
            this.C.error(iOException.getMessage());
            return;
        }
    }

    private static String b(String string) {
        string = string.replace("<br>", "");
        string = string.replace("<BR>", "");
        string = string.replace("<link>", "");
        string = string.replace("<LINK>", "");
        string = string.replace("</link>", "");
        string = string.replace("</LINK>", "");
        return string;
    }

    private int a(PDFReportPage pDFReportPage, String string, PDFont pDFont, float f, float f2, float f3, float f4) {
        return this.a(pDFReportPage, string, pDFont, f, f2, f3, f4, 1.5f * f);
    }

    private int a(PDFReportPage pDFReportPage, String object, PDFont object2, float f, float f2, float f3, float f4, float f5) {
        try {
            object = PDFReport.a((String)object, (PDFont)object2, f, f4);
            f4 = f3;
            f3 = f2;
            f2 = f;
            Object object3 = object2;
            object2 = object;
            pDFReportPage = pDFReportPage.getContentStream();
            pDFReportPage.beginText();
            pDFReportPage.setFont((PDFont)object3, f2);
            pDFReportPage.moveTextPositionByAmount(f3, f4);
            object2 = object2.iterator();
            while (object2.hasNext()) {
                object3 = (String)object2.next();
                pDFReportPage.drawString((String)object3);
                pDFReportPage.moveTextPositionByAmount(0.0f, -f5);
            }
            pDFReportPage.endText();
            return object.size();
        }
        catch (IOException iOException) {
            this.C.error(iOException.getMessage());
            return 0;
        }
    }

    private static List<String> a(String string, PDFont pDFont, float f, float f2) throws IOException {
        string = PDFReport.b(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        while (string.length() > 0) {
            float f3;
            int n2 = string.indexOf(32, n + 1);
            if (n2 < 0 && (n2 = string.indexOf(46, n + 1)) < 0) {
                n2 = string.length();
            }
            String string2 = string.substring(0, n2);
            float f4 = f * pDFont.getStringWidth(string2) / 1000.0f;
            if (f3 > f2) {
                if (n < 0) {
                    n = n2;
                }
                while (f * pDFont.getStringWidth(string.substring(0, n)) / 1000.0f > f2) {
                    --n;
                }
                String string3 = string.substring(0, n);
                arrayList.add(string3);
                string = string.substring(n).trim();
                n = -1;
                continue;
            }
            if (n2 == string.length()) {
                arrayList.add(string);
                string = "";
                continue;
            }
            n = n2;
        }
        return arrayList;
    }

    public PDDocument getPDFDoc() {
        return this.v;
    }

    private static MessageLevel b(ValidatedSigner validatedSigner) {
        if (!validatedSigner.isValid()) {
            return MessageLevel.ERROR;
        }
        if (validatedSigner.hasBeanWarnings()) {
            return MessageLevel.WARNING;
        }
        return MessageLevel.INFO;
    }

    private static float a(String string, PDFont pDFont, float f) throws IOException {
        return pDFont.getStringWidth(string) / 1000.0f * f;
    }

    private PDFReportPage f() throws IOException {
        PDFReportPage pDFReportPage = new PDFReportPage(this.v);
        ++this.K;
        this.I.put(Integer.toString(this.K), pDFReportPage);
        this.a(pDFReportPage);
        this.b(pDFReportPage);
        return pDFReportPage;
    }

    private void a(PDFReportPage pDFReportPage) throws IOException {
        float f;
        float f2;
        String string;
        if (!Util.isNullOrEmpty((String)this.w)) {
            string = this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0067_VERIFIER, new Object[0]) + " " + this.w;
            f2 = this.q.getStringWidth(string) / 1000.0f * 12.0f;
            f = this.q.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * 12.0f;
            pDFReportPage.getContentStream().setNonStrokingColor(j);
            this.a(pDFReportPage, string, this.q, 12.0f, pDFReportPage.getPDPage().getMediaBox().getWidth() - f2 - 20.0f, pDFReportPage.getPDPage().getMediaBox().getHeight() - 10.0f - f);
        }
        string = this.B.getMessage((EsecurityMessage)ReportMessageEnum.R0005_REPORT_TITLE, new Object[0]).toUpperCase();
        f2 = this.p.getStringWidth(string) / 1000.0f * 12.0f;
        f = this.p.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * 12.0f;
        pDFReportPage.getContentStream().setNonStrokingColor(j);
        this.a(pDFReportPage, string, this.p, 12.0f, pDFReportPage.getPDPage().getMediaBox().getWidth() - f2 - 20.0f, pDFReportPage.getPDPage().getMediaBox().getHeight() - f - 10.0f - f);
    }

    private void b(PDFReportPage pDFReportPage) throws IOException {
        pDFReportPage.getContentStream().setNonStrokingColor(j);
        this.a(pDFReportPage, Integer.toString(this.v.getNumberOfPages()), this.p, 10.0f, this.o.getWidth() - 20.0f, 20.0f);
    }
}

