/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf.parser;

import esecurity.validator.bean.PadesSpecific;
import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.PadesCertificationLevel;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.CRLUtils;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.pdf.PadesSignatureInformation;
import it.actalis.ellips.capi.pdf.RevisionInformation;
import it.actalis.ellips.capi.pdf.SignedPDF;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class PadesParser
extends SignatureParser {
    private DateFormat a = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public PadesParser(SignatureParserBuilder signatureParserBuilder) {
        super(signatureParserBuilder);
        this.a.setTimeZone(Constants.DEFAULT_TIMEZONE);
    }

    public ParsedTransientDocument parse(InputHandler inputHandler, EventHandlerSelector eventHandlerSelector, NetworkConfig networkConfig, TimeZone timeZone, File file) throws ParsingException {
        if (timeZone != null) {
            this.a.setTimeZone(timeZone);
        }
        return this.parse(inputHandler, null);
    }

    public ParsedTransientDocument parse(InputHandler object, byte[] object22) throws ParsingException {
        SignedPDF signedPDF;
        ParsedTransientDocument parsedTransientDocument;
        block25: {
            parsedTransientDocument = new ParsedTransientDocument((InputHandler)object);
            signedPDF = null;
            try {
                signedPDF = new SignedPDF(object.getInputAsNewStream(), (byte[])object22);
                if (signedPDF.isSigned()) {
                    RefOcsp refOcsp;
                    Object object2;
                    Object object3;
                    Object object4;
                    Serializable serializable;
                    object = signedPDF.getCerts();
                    Iterator iterator = ((AbstractSequentialList)object).iterator();
                    while (iterator.hasNext()) {
                        serializable = (X509Certificate)iterator.next();
                        object4 = Utils.calculateDigest((InputStream)new ByteArrayInputStream(((Certificate)serializable).getEncoded()), (String)Constants.SHA256);
                        object3 = new RefCertificate();
                        object3.setId((String)object4);
                        object3.setContent(((Certificate)serializable).getEncoded());
                        object3.setCapiCertificate(new it.actalis.ellips.capi.core.Certificate((X509Certificate)serializable));
                        parsedTransientDocument.addCert((RefCertificate)object3);
                    }
                    List<RevisionInformation> list = signedPDF.getRevisions().subList(0, signedPDF.getRevisions().size());
                    Collections.reverse(list);
                    serializable = new LinkedList();
                    object4 = new LinkedList();
                    for (RevisionInformation revisionInformation : list) {
                        object2 = new LinkedList();
                        for (PadesSignatureInformation padesSignatureInformation : revisionInformation.getSignatures()) {
                            InputHandler inputHandler;
                            Object object5;
                            parsedTransientDocument.setSigned(true);
                            SignatureInformation signatureInformation = new SignatureInformation();
                            signatureInformation.setSignatureInfo(padesSignatureInformation.getRawSignature());
                            if (!padesSignatureInformation.getSubFilter().equals("ETSI.RFC3161")) {
                                signatureInformation.setFormat(SignatureFormat.PADES);
                            } else {
                                signatureInformation.setFormat(SignatureFormat.TST);
                            }
                            signatureInformation.setContainerFormat(ContainerFormat.SELF);
                            signatureInformation.setContainsGraphometricInfo(padesSignatureInformation.getGraphometricInfo() != null);
                            signatureInformation.setCorrupted(!padesSignatureInformation.isValidSignature());
                            Object object6 = new PadesSpecific();
                            if (padesSignatureInformation.getCertificationLevel() == PadesCertificationLevel.NOT_CERTIFIED.getLevelValue()) {
                                object6.setCertificationLevel(PadesCertificationLevel.NOT_CERTIFIED);
                            } else if (padesSignatureInformation.getCertificationLevel() == PadesCertificationLevel.CERTIFIED_SIGN_FORM_FILLING_AND_ANNOTATIONS.getLevelValue()) {
                                object6.setCertificationLevel(PadesCertificationLevel.CERTIFIED_SIGN_FORM_FILLING_AND_ANNOTATIONS);
                            }
                            if (padesSignatureInformation.getCertificationLevel() == PadesCertificationLevel.CERTIFIED_SIGN_FORM_FILLING.getLevelValue()) {
                                object6.setCertificationLevel(PadesCertificationLevel.CERTIFIED_SIGN_FORM_FILLING);
                            }
                            if (padesSignatureInformation.getCertificationLevel() == PadesCertificationLevel.CERTIFIED_NO_CHANGES_ALLOWED.getLevelValue()) {
                                object6.setCertificationLevel(PadesCertificationLevel.CERTIFIED_NO_CHANGES_ALLOWED);
                            }
                            object6.setLocation(padesSignatureInformation.getLocation());
                            object6.setReason(padesSignatureInformation.getReason());
                            object6.setSubFilter(padesSignatureInformation.getSubFilter());
                            object6.setNextRevisionsUpdateAnnotation(padesSignatureInformation.nextRevisionUpdateAnnotation());
                            object6.setNextRevisionsUpdateForm(padesSignatureInformation.nextRevisionUpdateField());
                            object6.setNextRevisionsUpdateObject(padesSignatureInformation.nextRevisionsUpdateObject());
                            object6.setNextRevisionsSigned(padesSignatureInformation.nextRevisionsSigned());
                            object6.setSignatureDate(this.a.format(padesSignatureInformation.getSignDate().getTime()));
                            object6.setAllRevisionsCovered(padesSignatureInformation.isSignature_cover_all_revision());
                            object6.setCertInDictionary(padesSignatureInformation.getCertificateInSigDictionary() != null);
                            object6.setMultipleSigners(padesSignatureInformation.hasMultipleSigners());
                            signatureInformation.setPadesSpecific(object6);
                            signatureInformation.setSignatureDate(this.a.format(padesSignatureInformation.getSignDate().getTime()));
                            if (padesSignatureInformation.getSignerCertificate() != null) {
                                object6 = padesSignatureInformation.getSignerCertificate();
                                object5 = Utils.calculateDigest((InputStream)new ByteArrayInputStream(object6.getInternalCert().getEncoded()), (String)Constants.SHA256);
                                signatureInformation.setRefsCertId((String)object5);
                                signatureInformation.setSignerName(object6.getName());
                                inputHandler = new RefCertificate();
                                inputHandler.setId((String)object5);
                                inputHandler.setContent(object6.getInternalCert().getEncoded());
                                inputHandler.setCapiCertificate((it.actalis.ellips.capi.core.Certificate)object6);
                                parsedTransientDocument.addCert((RefCertificate)inputHandler);
                            } else {
                                signatureInformation.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                            }
                            ((LinkedList)object2).add(signatureInformation);
                            object6 = padesSignatureInformation.getSignatureTimeStampToken();
                            object5 = padesSignatureInformation.getSignature();
                            if (object6 != null) {
                                inputHandler = DataHandlerBuilder.get().setBytes((byte[])object5).buildInput();
                                signatureInformation.addTimeStampToken(TSTUtils.tstToVol((TransientDocument)parsedTransientDocument, (byte[])object6, (InputHandler)inputHandler, (String)"", (DateFormat)this.a));
                            }
                            if (!((AbstractCollection)object4).isEmpty()) {
                                signatureInformation.setTimeStampTokens((LinkedList)object4);
                            }
                            if (!SignatureFormat.TST.equals((Object)signatureInformation.getFormat())) continue;
                            ((LinkedList)object4).add(signatureInformation);
                        }
                        Collections.reverse(object2);
                        refOcsp = ((AbstractSequentialList)object2).iterator();
                        while (refOcsp.hasNext()) {
                            SignatureInformation signatureInformation = (SignatureInformation)refOcsp.next();
                            ((LinkedList)serializable).add(signatureInformation);
                        }
                    }
                    Collections.reverse(serializable);
                    object3 = ((AbstractSequentialList)((Object)serializable)).iterator();
                    while (object3.hasNext()) {
                        SignatureInformation signatureInformation = (SignatureInformation)object3.next();
                        parsedTransientDocument.addSignerInfo(signatureInformation);
                    }
                    for (RefCertificate refCertificate : parsedTransientDocument.getCerts()) {
                        if (((LinkedList)object).contains(refCertificate.getCapiCertificate().getInternalCert())) continue;
                        ((LinkedList)object).add(refCertificate.getCapiCertificate().getInternalCert());
                    }
                    for (CRL cRL : signedPDF.getCrls()) {
                        CRLUtils.addRefCrl((LinkedList)parsedTransientDocument.getCrls(), (CRL)cRL, signedPDF.getCerts());
                    }
                    for (BasicOCSPResp basicOCSPResp : signedPDF.getOcsps()) {
                        object2 = Utils.calculateDigest((InputStream)new ByteArrayInputStream(basicOCSPResp.getEncoded()), (String)Constants.SHA256);
                        refOcsp = new RefOcsp();
                        refOcsp.setId((String)object2);
                        refOcsp.setContent(basicOCSPResp.getEncoded());
                        parsedTransientDocument.addOcspresp(refOcsp);
                    }
                    break block25;
                }
                parsedTransientDocument.setSigned(false);
            }
            catch (Exception exception) {
                try {
                    throw new ParsingException("Unable to parse file", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    Util.closeQuietly(null);
                    if (signedPDF != null) {
                        signedPDF.close();
                    }
                    throw throwable;
                }
            }
        }
        Util.closeQuietly(null);
        signedPDF.close();
        return parsedTransientDocument;
    }
}

