/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.xades;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;
import java.util.List;

public class XadesStepSignatureEIDASSignedPropertiesCheck
extends MultipleValidationSubStepImpl {
    public XadesStepSignatureEIDASSignedPropertiesCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        linkedList = new LinkedList();
        if (validationContextParameters != null && validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getSignerInfoData() != null) {
            XadesSignerInfoData xadesSignerInfoData = (XadesSignerInfoData)validationContextParameters.getSignature().getSignerInfoData();
            if (!xadesSignerInfoData.hasSignedProperties()) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0007_NOSIGNTIME, new Object[0]));
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0012_XADES_NOSIGNCERT, new Object[0]));
            } else {
                if (!xadesSignerInfoData.hasSigningTime()) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0007_NOSIGNTIME, new Object[0]));
                }
                if (xadesSignerInfoData.getSigningCertificates() == null || xadesSignerInfoData.getSigningCertificates().isEmpty()) {
                    linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0012_XADES_NOSIGNCERT, new Object[0]));
                }
            }
        }
        return linkedList;
    }
}

