/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.AbstractSequentialList;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;

public class SignedEnvelopeUtils {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static X509Certificate searchSigningCertificate(SignerInformation object, LinkedList<X509Certificate> linkedList) throws CapiException {
        ESSCertID eSSCertID = SignedEnvelopeUtils.getSignignCertificateV1(object);
        if (eSSCertID != null) {
            byte[] byArray = eSSCertID.getCertHash();
            object = byArray;
            return SignedEnvelopeUtils.a(byArray, "SHA-1", linkedList);
        }
        eSSCertID = SignedEnvelopeUtils.getSigningCertificateV2(object);
        if (eSSCertID == null) {
            a.debug("Missing signing certificate attribute");
            return null;
        }
        byte[] byArray = eSSCertID.getCertHash();
        object = byArray;
        return SignedEnvelopeUtils.a(byArray, eSSCertID.getHashAlgorithm().getAlgorithm().getId(), linkedList);
    }

    private static X509Certificate a(byte[] byArray, String object, LinkedList<X509Certificate> object2) {
        try {
            object = MessageDigest.getInstance((String)object, ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.error(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            return null;
        }
        object2 = ((AbstractSequentialList)object2).iterator();
        while (object2.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)object2.next();
            try {
                if (!MessageDigest.isEqual(byArray, ((MessageDigest)object).digest(x509Certificate.getEncoded()))) continue;
                return x509Certificate;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            }
        }
        return null;
    }

    public static ESSCertID getSignignCertificateV1(SignerInformation signerInformation) {
        if ((signerInformation = signerInformation.getSignedAttributes()) == null) {
            a.debug("No signed attribute table found.");
            return null;
        }
        if ((signerInformation = signerInformation.get(PKCSObjectIdentifiers.id_aa_signingCertificate)) == null) {
            a.debug("No signing certificate attribute found.");
            return null;
        }
        a.debug("Found signing certificate attribute V1");
        signerInformation = SigningCertificate.getInstance((Object)signerInformation.getAttrValues().getObjectAt(0));
        return ESSCertID.getInstance((Object)signerInformation.getCerts()[0]);
    }

    public static ESSCertIDv2 getSigningCertificateV2(SignerInformation object) throws CapiException {
        if ((object = object.getSignedAttributes()) == null) {
            a.debug("No signed attribute table found.");
            return null;
        }
        if ((object = object.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2)) == null) {
            a.debug("No signing certificate attribute V2 found.");
            return null;
        }
        a.debug("Found signing certificate attribute V2.");
        object = (ASN1Sequence)object.getAttrValues().getObjectAt(0);
        ESSCertIDv2[] eSSCertIDv2Array = SigningCertificateV2.getInstance((Object)object);
        try {
            eSSCertIDv2Array = eSSCertIDv2Array.getCerts();
            return eSSCertIDv2Array[0];
        }
        catch (Exception exception) {
            a.debug("Cannot instantiate ESSCertIDv2: Exception " + exception.getMessage() + ". Retrying...");
            object = ASN1Sequence.getInstance((Object)object.getObjectAt(0));
            if (object.size() <= 0) {
                throw new CapiException("Cannot parse ESSCertIDv2", 3010);
            }
            if ((object = ASN1Sequence.getInstance((Object)object.getObjectAt(0))).size() == 1) {
                a.debug("ESSCertIDv2 contains only SHA256 Hash");
                object = ASN1OctetString.getInstance((Object)object.getObjectAt(0).toASN1Primitive()).getOctets();
                return new ESSCertIDv2(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256), (byte[])object);
            }
            return ESSCertIDv2.getInstance((Object)object);
        }
    }

    public static TimeStampToken getTimeStampToken(AttributeTable object) throws CapiException, IOException {
        if ((object = object.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) == null) {
            return null;
        }
        object = ContentInfo.getInstance((Object)object.getAttrValues().getObjectAt(0).toASN1Primitive());
        object = object.getEncoded("DER");
        return new TimeStampToken((byte[])object);
    }
}

