/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.util;

import it.actalis.ellips.capi.http.util.LiveBytePushQueue;
import it.actalis.ellips.capi.http.util.MemoryUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CacheOutputStream
extends OutputStream {
    private static final int MIN_IN_MEM_CACHE_SIZE = 2048;
    private static final int MAX_IN_MEM_CACHE_SIZE = (int)(MemoryUtils.getMaxHeapBytes() / 50L);
    private int inMemCacheSize = 2048;
    private LiveBytePushQueue inMemCache = null;
    private File onDiskFile = null;
    private String flushFilePath = "";
    private long bytesWritten = 0L;
    private OutputStream diskStream = null;
    private boolean keepTempFileAfterClosing = false;
    private List<InputStream> createdAndTrackedStreams = new ArrayList<InputStream>();
    private int untrackedAndOpenedStreams = 0;
    private final Object untrackedAndOpenedStreamsLock = new Object();

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    void setCacheSizeForced(int cacheSize) {
        this.inMemCacheSize = cacheSize;
        this.inMemCache = new LiveBytePushQueue(this.inMemCacheSize);
    }

    private void flushMemToDisk() throws IOException {
        if (this.onDiskFile == null) {
            this.onDiskFile = File.createTempFile("data", ".tmp");
            this.onDiskFile.deleteOnExit();
            this.flushFilePath = this.onDiskFile.getAbsolutePath();
            this.diskStream = new BufferedOutputStream(new FileOutputStream(this.onDiskFile));
        }
        this.diskStream.write(this.inMemCache.getDataCopy(), 0, this.inMemCache.getCount());
    }

    private void flushDisk() throws IOException {
        if (this.diskStream != null) {
            this.diskStream.flush();
        }
    }

    public String getFlushFilePath() {
        return this.flushFilePath;
    }

    private void close(boolean forceDeletion) {
        if (this.createdAndTrackedStreams != null) {
            for (InputStream is : this.createdAndTrackedStreams) {
                CacheOutputStream.closeQuietly(is);
            }
        }
        this.createdAndTrackedStreams = null;
        if (this.diskStream != null) {
            CacheOutputStream.closeQuietly(this.diskStream);
        }
        this.diskStream = null;
        if (forceDeletion || !this.keepTempFileAfterClosing) {
            if (this.onDiskFile != null && this.onDiskFile.exists()) {
                this.onDiskFile.delete();
                this.onDiskFile = null;
            }
            this.inMemCache = null;
        }
    }

    public CacheOutputStream(int inMemCacheSize) throws IOException {
        this.inMemCacheSize = Math.min(Math.max(2048, inMemCacheSize), MAX_IN_MEM_CACHE_SIZE);
        this.inMemCache = new LiveBytePushQueue(this.inMemCacheSize);
    }

    public CacheOutputStream() throws IOException {
        this(10000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getCache(boolean track) throws IOException {
        this.flushDisk();
        this.keepTempFileAfterClosing = this.keepTempFileAfterClosing || !track;
        CacheCompositeInputStream is = new CacheCompositeInputStream();
        is.isTracked = track;
        if (track) {
            this.createdAndTrackedStreams.add(is);
        } else {
            Object object = this.untrackedAndOpenedStreamsLock;
            synchronized (object) {
                ++this.untrackedAndOpenedStreams;
            }
        }
        return is;
    }

    public InputStream getCache() throws IOException {
        return this.getCache(true);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.flushDisk();
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bytesWritten >= (long)this.inMemCacheSize) {
            if (this.diskStream == null) {
                this.flushMemToDisk();
            }
            this.diskStream.write((byte)b);
        } else {
            this.inMemCache.offer((byte)b);
        }
        ++this.bytesWritten;
    }

    @Override
    public void close() {
        this.close(false);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class CacheCompositeInputStream
    extends InputStream {
        private boolean isTracked = true;
        private int memIndex = 0;
        private InputStream readFileStream = null;

        @Override
        public int read() throws IOException {
            if (this.readFileStream != null) {
                return this.readFileStream.read();
            }
            if (this.memIndex < CacheOutputStream.this.inMemCache.getCount()) {
                int read = CacheOutputStream.this.inMemCache.getByte(this.memIndex) & 0xFF;
                ++this.memIndex;
                return read;
            }
            if (this.memIndex >= CacheOutputStream.this.inMemCache.getCount()) {
                if (!CacheOutputStream.this.inMemCache.isFull()) {
                    return -1;
                }
                if (CacheOutputStream.this.onDiskFile != null && this.readFileStream == null) {
                    this.readFileStream = new BufferedInputStream(new FileInputStream(CacheOutputStream.this.onDiskFile));
                    this.readFileStream.skip(this.memIndex);
                    return this.readFileStream.read();
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            super.close();
            if (!this.isTracked) {
                Object object = CacheOutputStream.this.untrackedAndOpenedStreamsLock;
                synchronized (object) {
                    CacheOutputStream.this.untrackedAndOpenedStreams--;
                }
                if (CacheOutputStream.this.untrackedAndOpenedStreams <= 0) {
                    CacheOutputStream.this.close(true);
                }
            }
            if (this.readFileStream != null) {
                this.readFileStream.close();
            }
            this.readFileStream = null;
        }
    }
}

