/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.ldap;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.crypto.gui.ldap.LdapEndPoint;
import esecurity.crypto.gui.ldap.cuneygui;
import esecurity.crypto.gui.ldap.kvgxsbpg;
import esecurity.crypto.gui.properties.AppProperties;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LdapEndPointLoader {
    private static final EllipsLogger logger = LdapEndPointLoader.cX("dls6p0", Constants.CAPI_LOGGER_NAME);
    private static final File LDAP_DATA_FILE;
    private static final File DEFAULT_LDAP_DATA_FILE;
    private static List<LdapEndPoint> ldapDataLoader;

    public static void load() {
        ldapDataLoader = LdapEndPointLoader.loadFromFile();
    }

    public static List<LdapEndPoint> getEndPoints() {
        if (ldapDataLoader == null) {
            LdapEndPointLoader.load();
        }
        return ldapDataLoader;
    }

    public static void addEndPoint(LdapEndPoint endPoint) {
        LdapEndPointLoader.getEndPoints().add(endPoint);
    }

    public static void removeEndPoint(LdapEndPoint endPoint) {
        if (endPoint == null) {
            return;
        }
        LdapEndPointLoader.getEndPoints().remove(endPoint);
    }

    public static void removeEndPoint(String name) {
        if (name == null || LdapEndPointLoader.cX("1bl06ou", name) != false) {
            return;
        }
        List<LdapEndPoint> endPoints = LdapEndPointLoader.getEndPoints();
        boolean found = false;
        for (int i = 0; !found && i < endPoints.size(); ++i) {
            if (LdapEndPointLoader.cX("1on06oo", name, LdapEndPointLoader.cX("1m0g6op", endPoints.get(i))) == false) continue;
            endPoints.remove(i);
            found = true;
        }
    }

    public static void saveToFile() {
        ObjectMapper om = new ObjectMapper();
        LdapEndPointLoader.cX("t406ob", om, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, (boolean)false);
        try {
            LdapEndPointLoader.cX("60u6oa", om, LDAP_DATA_FILE, LdapEndPointLoader.getEndPoints());
        }
        catch (IOException ex) {
            LdapEndPointLoader.cX("1gps6p4", logger, LdapEndPointLoader.cX("koa6p5", ex), (Object)ex);
        }
    }

    private static List<LdapEndPoint> loadFromFile() {
        ArrayList<LdapEndPoint> endpoints = new ArrayList<LdapEndPoint>();
        ObjectMapper om = new ObjectMapper();
        LdapEndPointLoader.cX("t406ob", om, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, (boolean)false);
        if (LdapEndPointLoader.cX("15j06p7", DEFAULT_LDAP_DATA_FILE) != false) {
            try {
                LdapEndPointLoader.cX("17ji6p1", endpoints, (Collection)LdapEndPointLoader.cX("-8tpp6q", om, DEFAULT_LDAP_DATA_FILE, (Object)new TypeReference<List<LdapEndPoint>>(){}));
            }
            catch (IOException ex) {
                LdapEndPointLoader.cX("1gps6p4", logger, LdapEndPointLoader.cX("koa6p5", ex), (Object)ex);
            }
        }
        if (LdapEndPointLoader.cX("15j06p7", LDAP_DATA_FILE) != false) {
            try {
                LdapEndPointLoader.cX("17ji6p1", endpoints, (Collection)LdapEndPointLoader.cX("-8tpp6q", om, LDAP_DATA_FILE, (Object)new TypeReference<List<LdapEndPoint>>(){}));
            }
            catch (IOException ex) {
                LdapEndPointLoader.cX("1gps6p4", logger, LdapEndPointLoader.cX("koa6p5", ex), (Object)ex);
            }
        }
        return endpoints;
    }

    static {
        char[] cArray = "\u29cf\u5972\u5ee7\u25e4\uad99\ud715\ubb10\ue8e1\uc9a6\u01c8".toCharArray();
        cArray[7] = (char)(cArray[7] ^ 0x57C7);
        LDAP_DATA_FILE = new File((String)LdapEndPointLoader.cX("-37fp7k", LdapEndPointLoader.cX("-1gd5p7j", LdapEndPointLoader.cX("-1gd5p7j", LdapEndPointLoader.cX("-1gd5p7j", new StringBuilder(), LdapEndPointLoader.cX("1gtk6oi", LdapEndPointLoader.cX("-va7p7d"), AppProperties.WORK_FOLDER, (Object)"")), File.separator), cuneygui.l(cArray, (short)6154, true, false))));
        char[] cArray2 = "\u0896\u42db\u4121\uf86c\u5733\ua54d\u6b82\u2693\u7bfd\ubd65\u7c1d\u0339\u74da\u2cc3".toCharArray();
        cArray2[1] = (char)(cArray2[1] ^ 0x3A90);
        DEFAULT_LDAP_DATA_FILE = new File((String)LdapEndPointLoader.cX("-37fp7k", LdapEndPointLoader.cX("-1gd5p7j", LdapEndPointLoader.cX("-1gd5p7j", LdapEndPointLoader.cX("-1gd5p7j", new StringBuilder(), LdapEndPointLoader.cX("1gtk6oi", LdapEndPointLoader.cX("-va7p7d"), AppProperties.BASE_FOLDER, (Object)"")), File.separator), cuneygui.l(cArray2, (short)30210, false, true))));
    }

    private static Object cX(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(kvgxsbpg.m(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

