/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.logger.utils;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.logging.LoggerConfig;
import it.actalis.ellips.capi.logging.LoggerLevel;
import it.arubapec.ca.update.conf.UpdateConf;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateLogger {
    private static final String DEFAULT_LOGFILE_PATTERN = "-%d{MM-dd-yyyy}-%i.log.gz";
    private static final String DEFAULT_LOG_CRON = "0 0 0 1/1 * ? *";
    private static final int DEFAULT_LOG_MAXSIZE_MB = 100;
    private static boolean bIsInitialized = false;
    private static Logger logger = null;
    private static String loggerFilePath = "";

    public static Logger get() {
        if (logger == null) {
            UpdateLogger.initLogger();
        }
        return logger;
    }

    public static void initLogger() {
        if (logger != null) {
            return;
        }
        try {
            File dir = new File(UpdateConf.getLogDirPath());
            String logFilePath = "";
            if (dir.exists() && dir.isDirectory()) {
                logFilePath = UpdateConf.getLogDirPath() + File.separator + UpdateConf.getLogNamePrefix() + "Updater.log";
                String logName = UpdateConf.getUpdateCallerName() + "Updater";
                UpdateLogger.initLogger(logFilePath, logName);
            }
            if (logger != null) {
                logger.info(" ");
                logger.info("[ArubaUpdater] aperto file di log per " + UpdateConf.getUpdateCallerName() + ": " + logFilePath);
            } else {
                logger = LoggerFactory.getLogger(UpdateLogger.class);
                logger.info("[ArubaUpdater] instanziato logger di default.");
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static void initLogger(String logFilePath, String appName) throws IOException {
        loggerFilePath = logFilePath;
        try {
            LoggerConfig config = new LoggerConfig();
            config.setFileAppender(new File(logFilePath));
            config.setSpaceRolling(100L);
            File dir = new File(logFilePath).getParentFile();
            if (dir.exists() && dir.isDirectory()) {
                String debug = System.getProperty("esecurity.logger.debug");
                boolean bSystemDebug = debug != null && debug.equals("true");
                logger = bSystemDebug ? EllipsLoggerFactory.createLogger((String)appName, null, (LoggerLevel)LoggerLevel.DEBUG, (LoggerConfig)config) : EllipsLoggerFactory.createLogger((String)appName, null, (LoggerLevel)LoggerLevel.INFO, (LoggerConfig)config);
                bIsInitialized = true;
            }
        }
        catch (Exception ex) {
            bIsInitialized = false;
            System.err.println(ex.getMessage());
        }
    }

    public static String getLoggerFilePath() {
        return loggerFilePath;
    }

    public static void release() throws CapiException {
        EllipsLoggerFactory.removeLogger((EllipsLogger)((EllipsLogger)logger));
        logger = null;
        bIsInitialized = false;
    }

    public static boolean isInitialized() {
        return bIsInitialized;
    }
}

