/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.vol.volstream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class ResettableFileInputStream
extends InputStream {
    RandomAccessFile raFile;
    long mark;

    public ResettableFileInputStream(File file) throws IOException {
        this.raFile = new RandomAccessFile(file, "r");
    }

    @Override
    public int read() throws IOException {
        return this.raFile.read();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.mark = readlimit;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void mark() {
        try {
            this.mark = this.raFile.getFilePointer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raFile.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.raFile.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.raFile.seek(this.mark);
    }

    @Override
    public int available() throws IOException {
        return (int)(this.raFile.length() - this.raFile.getFilePointer());
    }

    @Override
    public void close() throws IOException {
        this.raFile.close();
    }

    @Override
    public long skip(long n) throws IOException {
        long s = this.raFile.getFilePointer() + n;
        if (this.raFile.getFilePointer() + n > this.raFile.length()) {
            n = this.raFile.length() - this.raFile.getFilePointer();
        }
        this.raFile.seek(this.raFile.getFilePointer() + n);
        return n;
    }
}

