/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class StepX509VersionCompliance
extends SingleValidationSubStepImpl {
    public StepX509VersionCompliance() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param != null && param.getSignerCertificate() != null && param.getSignature() == null || param.getSignature().getFormat() != null && !param.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
            boolean valid = false;
            try {
                if (param.getSignerCertificate().getCert().getVersion() == 3) {
                    valid = true;
                }
            }
            catch (CapiException e) {
                valid = false;
            }
            if (!valid) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0017_INVALID_CERT_VERSION, new Object[0]);
            }
        }
        return null;
    }
}

