/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.security.cert.CertificateEncodingException;
import java.util.LinkedList;

public class StepX509AIACheck
extends SingleValidationSubStepImpl {
    public StepX509AIACheck() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        block11: {
            if (param != null && param.getSignerCertificate() != null && (param.getSignature() == null || param.getSignature().getFormat() != null && !param.getSignature().getFormat().equals((Object)SignatureFormat.TST)) && param.getSignerCertificate().getIssuer() != null) {
                CertDBItem root = null;
                try {
                    root = param.getCertDB().contains(param.getSignerCertificate().getIssuer().getCert().getInternalCert().getEncoded());
                }
                catch (CertificateEncodingException ex) {
                    root = null;
                }
                catch (CapiException ex) {
                    root = null;
                }
                try {
                    String[] aiaInfos = param.getSignerCertificate().getCert().getAuthorityInfoAccess();
                    if (aiaInfos == null || aiaInfos.length == 0) {
                        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0007_AIA_NOT_PRESENT, new Object[0]);
                    }
                    if (root != null && root.getCertificate() != null && root.getCertificate().getSubjectDN().equals(root.getCertificate().getIssuerDN())) break block11;
                    boolean aiaValid = false;
                    try {
                        String caIssuer = param.getSignerCertificate().getCert().getCaIssuer();
                        if (caIssuer != null && !caIssuer.isEmpty()) {
                            aiaValid = true;
                        }
                    }
                    catch (CapiException ex) {
                        aiaValid = false;
                    }
                    if (!aiaValid) {
                        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0015_CAISSUER_NOT_PRESENT, new Object[0]);
                    }
                }
                catch (CapiException capiException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

