/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dts.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class Connection {
    public static final int DEFAULT_PORT = 23;
    private Socket sock = null;
    private InputStream inStream = null;
    private OutputStream outStream = null;

    public Connection(String host) throws IOException {
        this(host, 23);
    }

    public Connection(String host, int port) throws IOException {
        this(new Socket(host, port));
    }

    public Connection(Socket sock) throws IOException {
        this.sock = sock;
        this.inStream = sock.getInputStream();
        this.outStream = sock.getOutputStream();
    }

    public byte read() throws IOException {
        int c = this.inStream.read();
        if (c == -1) {
            throw new IOException("EOF reached.");
        }
        if (c < 0 || c > 255) {
            throw new IOException("Expected byte value; read " + c);
        }
        return (byte)c;
    }

    public void write(byte[] msg) throws IOException {
        this.write(msg, false);
    }

    public void write(byte[] msg, boolean flush) throws IOException {
        this.outStream.write(msg);
        if (flush) {
            this.outStream.flush();
        }
    }

    public void close() throws IOException {
        this.inStream.close();
        this.outStream.close();
        this.sock.close();
    }
}

