/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.functionality;

import esecurity.crypto.gui.facade.StatusLevel;
import esecurity.crypto.gui.functionality.EncryptFacade$DecryptFacade;
import esecurity.crypto.gui.functionality.EncryptFacade$ValidationFacade;
import esecurity.crypto.gui.functionality.ValidationFacade$ValidationFacade;
import esecurity.crypto.gui.functionality.fszpagix;
import esecurity.crypto.gui.model.FileToSign;
import esecurity.crypto.gui.model.OperationResult;
import esecurity.crypto.gui.model.SignatureRequest;
import esecurity.crypto.gui.model.Status;
import esecurity.crypto.gui.properties.ServerProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.MutableASiCOptions;
import it.actalis.ellips.capi.asic.generator.ASiCGenerator;
import it.actalis.ellips.capi.asic.generator.ASiCGeneratorOptions;
import it.actalis.ellips.capi.cms.CadesSignatureGenerator;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.pades.PadesSignatureGenerator;
import it.actalis.ellips.capi.pades.PadesSignatureOptions;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.ellips.capi.signature.SignatureOperation;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.ArubaDTSClient;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.xades.XadesSignatureGenerator;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import it.actalis.ellips.capi.xades.exception.XadesModeException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;

public class SignatureFacade {
    private static final EllipsLogger logger = SignatureFacade.AH("-1q83p3e", Constants.CAPI_LOGGER_NAME);
    private static final I18N i18n;
    private static Status signatureStatus;

    private static void validate(SignatureRequest request) throws CapiException {
        if (SignatureFacade.AH("-q47p9k", request) == null) {
            char[] cArray = "]\u13b4\u3027\u0e4a\ue923\u2740\u7c04\ua27f\u8521\ubf38\u2ee0\u16d9\u4a89\u3829\u74da\u64d2\u51d0\u6d6a\ud789\u7177\ued9c\u659f\u90a5\ua461\u5a7c\u62ef".toCharArray();
            cArray[7] = (char)(cArray[7] ^ 0x1326);
            throw new CapiException(EncryptFacade$ValidationFacade.Z(cArray, (short)29168, (short)2, (byte)3), 1001);
        }
        if (SignatureFacade.AH("-s7fp9h", request) == null) {
            char[] cArray = "\u5484\u5d32\uf000\u1285\u9c09\uaece\uc43a\u01c1\ud69f\u5ade\u220f\uac50\u0385\uc626\ud5c3\ub69c\u3477\u2dc1\uc168\uba18\u6ee3".toCharArray();
            cArray[4] = (char)(cArray[4] ^ 0x51BF);
            throw new CapiException(EncryptFacade$ValidationFacade.Z(cArray, (short)25500, (short)2, (byte)1), 1001);
        }
        if (SignatureFacade.AH("10oe6m2", request) == null) {
            char[] cArray = "\u9026\u5540\ud6a5\u05e0\u4ea1\ucff2\ucd09\u73e6\u8722\u84b3\u91bf\u8e69\u9d58\ud474\u79e7\u3473\ue88b\u6370".toCharArray();
            cArray[15] = (char)(cArray[15] ^ 0x574E);
            throw new CapiException(EncryptFacade$ValidationFacade.Z(cArray, (short)11987, (short)4, (byte)4), 1001);
        }
        if (SignatureFacade.AH("-1tlpp9r", request) == null) {
            char[] cArray = "\u7be9\ue12aC\u0c1d\uaa1b\ub9f0\u6d6f\u21dc\ub49a\uee3d\u34cc\u930f\u0a16\u867a\ud3b3\uefc5\uc509\u962f\u12e5\u64a6\u635f\u31f4\ucfb9\u0133\u0da7\ue71c\u76dd\uaa91\u590c".toCharArray();
            cArray[6] = (char)(cArray[6] ^ 0x7034);
            throw new CapiException(EncryptFacade$ValidationFacade.Z(cArray, (short)455, (short)2, (byte)3), 1001);
        }
        if (SignatureFacade.AH("-1if7pa0", request).isEmpty()) {
            char[] cArray = "\u5e57\ufdd6\u7f3b\u5c40\u3fcb\u75fe\uc749\u5735\u8261\u23e3\ubdc9\u1676\u4136\u73d4\ucb05\u2a14\u6c42\ub74d\uee41\u97c0\u292f\u2ef8\u17cc\u5cbe".toCharArray();
            cArray[5] = (char)(cArray[5] ^ 0x1D9F);
            throw new CapiException(EncryptFacade$ValidationFacade.Z(cArray, (short)25163, (short)1, (byte)3), 1001);
        }
        if (SignatureFacade.AH("jjs6m3", request) == null && SignatureFacade.AH("-lc7p9q", (Object)SignatureType.ASICE, SignatureFacade.AH("-q47p9k", request)) != false) {
            char[] cArray = "\ua114\ucf14\u17da\u9ebb\ue6ba\u9195\uf45d\ud856\ubb62\u84cb\uee1d\u1a47\uf4d1\ud0a1\u2546\u5d1b\ud9df\u8ed7\u4602\u2880\uf436\uac34\uc43a\u964d\ubea1\u0007\ua3e3\u9736\ud5a1\uf41d\u7911\u9e72\u3da0\u9db7\uc732\u05b3\uf631\ue3ce\u28f5\u8f3e\u6313\ud005\u45fb\u7aae\u52c4\u4dda\uef3f\u6919\u980a\u6c54\u94ec\ud7a0\u1c40\uf322\u0b28".toCharArray();
            cArray[18] = (char)(cArray[18] ^ 0x4F4B);
            throw new CapiException(EncryptFacade$ValidationFacade.Z(cArray, (short)14098, (short)2, (byte)3), 1001);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationResult sign(SignatureRequest request) {
        try {
            SignatureFacade.validate(request);
            if (SignatureFacade.AH("rhq6m4", SignatureFacade.AH("qo66lp", request), SignatureLevel.LT) != false && SignatureFacade.AH("1js66m7", request) == null) {
                char[] cArray = "\u3e81\u2e01\u300e\u29e1\u7192\uc276\ua98e\ue6f6\u8521\u319c\u740f\u1558\uc78d\u90d2\u245a\ue294\u9a9b\u4927\u4ae5\u993a\u080a\ud2e1\ueb44\u3b26\uea59\u41c6\u74d5\u251e\ub438\u8572\u5ca5\u56f2\u38d5\ua3e1\u8492\u4f7b\udeb7\u5c54\uc663\u6c79\u7010\u67b4".toCharArray();
                cArray[35] = (char)(cArray[35] ^ 0x5483);
                OperationResult operationResult = new OperationResult(new Status(StatusLevel.ERROR, ValidationFacade$ValidationFacade.s(cArray, (short)1479, 5, (short)2)), SignatureFacade.AH("-1if7pa0", request), (File)SignatureFacade.AH("-9sbpa6", request));
                return operationResult;
            }
            signatureStatus = null;
            boolean withError = false;
            block4 : switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.AH("-16vfp9v", SignatureFacade.AH("-q47p9k", request))]) {
                case 1: 
                case 2: 
                case 3: {
                    FileToSign file;
                    SignatureOptions signatureOptions = SignatureFacade.getAdesSignatureOptions(request);
                    SignatureGenerator signatureGenerator = SignatureFacade.getAdesSignatureGenerator(request);
                    Iterator iterator = SignatureFacade.AH("-1if7pa0", request).iterator();
                    while (iterator.hasNext()) {
                        file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signAdESDocument(file, request, signatureOptions, signatureGenerator);
                        if (signatureStatus == null || SignatureFacade.AH("16u66lr", (Object)StatusLevel.ERROR, SignatureFacade.AH("q806lo", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 4: {
                    FileToSign file;
                    SignatureOptions signatureOptions = SignatureFacade.getAdesSignatureOptions(request);
                    SignatureGenerator signatureGenerator = SignatureFacade.getAdesSignatureGenerator(request);
                    Iterator iterator = SignatureFacade.AH("-1if7pa0", request).iterator();
                    while (iterator.hasNext()) {
                        file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signPAdESDocument(file, request, signatureOptions, signatureGenerator);
                        if (signatureStatus == null || SignatureFacade.AH("16u66lr", (Object)StatusLevel.ERROR, SignatureFacade.AH("q806lo", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 5: {
                    ASiCGenerator asicGenerator = new ASiCGenerator();
                    MutableASiCOptions mutableASiCOptions = new MutableASiCOptions();
                    ASiCGeneratorOptions aSiCGeneratorOptions = new ASiCGeneratorOptions();
                    TimeStampOptions tstOpts = SignatureFacade.getAsicTstOptions(request);
                    Iterator iterator = SignatureFacade.AH("-1if7pa0", request).iterator();
                    while (iterator.hasNext()) {
                        FileToSign file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signAsicS(file, request, tstOpts, aSiCGeneratorOptions, mutableASiCOptions, asicGenerator);
                        if (signatureStatus == null || SignatureFacade.AH("16u66lr", (Object)StatusLevel.ERROR, SignatureFacade.AH("q806lo", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 6: {
                    withError |= SignatureFacade.signAsicE(request);
                    break;
                }
                default: {
                    char[] cArray = "\u6a47\ube8b\u77bf\u8470\ub36a\ud053\u3b35\ube64\u3fde\u5d69\u97a4\u09e8\uea67\ued4a\u77ed\u92fc\u35bf\u1500\udef7\u92ea\udcbd\u8f9d\ub702\ub45b\ue169\u06b5\u7f84\u16a7".toCharArray();
                    cArray[8] = (char)(cArray[8] ^ 0x435A);
                    OperationResult operationResult = new OperationResult(new Status(StatusLevel.ERROR, ValidationFacade$ValidationFacade.s(cArray, (short)26630, 2, (short)0)), SignatureFacade.AH("-1if7pa0", request), (File)SignatureFacade.AH("-9sbpa6", request));
                    return operationResult;
                }
            }
            if (withError && signatureStatus == null) {
                boolean allError = true;
                Iterator ftsIt = SignatureFacade.AH("-1if7pa0", request).iterator();
                while (ftsIt.hasNext() && allError) {
                    allError = SignatureFacade.AH("16u66lr", (Object)StatusLevel.SUCCESS, SignatureFacade.AH("q806lo", SignatureFacade.AH("-18v9ph2", (FileToSign)ftsIt.next()))) == false;
                }
                signatureStatus = allError ? new Status(StatusLevel.ERROR, "") : new Status(StatusLevel.WARNING, "");
            } else if (signatureStatus == null) {
                signatureStatus = new Status(StatusLevel.SUCCESS, "");
            }
        }
        catch (Throwable ex) {
            SignatureFacade.AH("1k4c6su", logger, SignatureFacade.AH("jra6t6", ex), (Object)ex);
            signatureStatus = new Status(StatusLevel.ERROR, ex);
        }
        finally {
            SignatureFacade.AH("-njnpa3");
        }
        return new OperationResult(signatureStatus, SignatureFacade.AH("-1if7pa0", request), (File)SignatureFacade.AH("-9sbpa6", request));
    }

    private static SignatureGenerator getAdesSignatureGenerator(SignatureRequest request) {
        switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.AH("-16vfp9v", SignatureFacade.AH("-q47p9k", request))]) {
            case 1: 
            case 3: {
                return new CadesSignatureGenerator();
            }
            case 4: {
                return new PadesSignatureGenerator();
            }
            case 2: {
                return new XadesSignatureGenerator();
            }
        }
        return null;
    }

    private static TimeStampOptions getAsicTstOptions(SignatureRequest request) throws IllegalParamException {
        if (SignatureFacade.AH("rhq6m4", SignatureFacade.AH("qo66lp", request), SignatureLevel.BES) != false) {
            return null;
        }
        TimeStampOptions tstOpts = new TimeStampOptions();
        SignatureFacade.AH("-1i8pphf", tstOpts, true);
        SignatureFacade.AH("150a6ev", tstOpts, new ArubaDTSClient((TSAData)SignatureFacade.AH("-ekhph4", request), (NetworkConfig)SignatureFacade.AH("17g46te", SignatureFacade.AH("lcq6sg"))));
        SignatureFacade.AH("1kbi6ei", tstOpts, DigestAlgorithm.SHA256);
        SignatureFacade.AH("-r7vphb", tstOpts, "");
        return tstOpts;
    }

    private static SignatureOptions getAdesSignatureOptions(SignatureRequest request) throws IllegalParamException {
        CadesSignatureOptions signatureOptions = null;
        switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.AH("-16vfp9v", SignatureFacade.AH("-q47p9k", request))]) {
            case 1: 
            case 3: {
                signatureOptions = new CadesSignatureOptions();
                SignatureFacade.AH("-797phd", signatureOptions, SignatureFacade.AH("-1hunphg", request));
                break;
            }
            case 4: {
                signatureOptions = new PadesSignatureOptions();
                SignatureFacade.AH("-1ortp9n", (PadesSignatureOptions)signatureOptions, SignatureFacade.AH("152k6em", request));
                break;
            }
            case 2: {
                signatureOptions = new XadesSignatureOptions();
                SignatureFacade.AH("-797phd", signatureOptions, SignatureFacade.AH("-1hunphg", request));
            }
        }
        if (SignatureFacade.AH("rhq6m4", SignatureFacade.AH("qo66lp", request), SignatureLevel.BES) == false) {
            TimeStampOptions timeStampOptions = new TimeStampOptions();
            SignatureFacade.AH("-1i8pphf", timeStampOptions, true);
            SignatureFacade.AH("150a6ev", timeStampOptions, new ArubaDTSClient((TSAData)SignatureFacade.AH("-ekhph4", request), (NetworkConfig)SignatureFacade.AH("17g46te", SignatureFacade.AH("lcq6sg"))));
            SignatureFacade.AH("1kbi6ei", timeStampOptions, DigestAlgorithm.SHA256);
            SignatureFacade.AH("-r7vphb", timeStampOptions, "");
            SignatureFacade.AH("-1507phc", signatureOptions, timeStampOptions);
            SignatureFacade.AH("-1l5bph9", signatureOptions, SignatureFacade.AH("qo66lp", request));
            if (SignatureFacade.AH("rhq6m4", SignatureFacade.AH("qo66lp", request), SignatureLevel.LT) != false) {
                SignatureFacade.AH("1pie6ma", signatureOptions, SignatureFacade.AH("1js66m7", request));
            }
        }
        SignatureFacade.AH("1em6md", signatureOptions, SignatureFacade.AH("17g46te", SignatureFacade.AH("lcq6sg")));
        SignatureFacade.AH("9926m8", signatureOptions, SignatureFacade.AH("-s7fp9h", request));
        SignatureFacade.AH("13mg6mb", signatureOptions, SignatureFacade.AH("10oe6m2", request));
        SignatureFacade.AH("-8jppgi", signatureOptions, SignatureFacade.AH("-1tlpp9r", request));
        return signatureOptions;
    }

    private static boolean signPAdESDocument(FileToSign file, SignatureRequest request, SignatureOptions signatureOptions, SignatureGenerator signatureGenerator) throws IOException {
        boolean withAppearance;
        boolean withError = false;
        int appearancesCount = 0;
        int i = 0;
        boolean bl = withAppearance = SignatureFacade.AH("1k806f1", file) != null && !SignatureFacade.AH("1k806f1", file).isEmpty();
        if (withAppearance) {
            appearancesCount = SignatureFacade.AH("1k806f1", file).size();
        }
        File destFile = SignatureFacade.createDestinationFile(file, request);
        FileToSign convert = file;
        if (SignatureFacade.AH("-12l7pgk", file) != false) {
            Object c = SignatureFacade.AH("15766ff", file);
            convert = new FileToSign((File)c);
            SignatureFacade.AH("13s86f5", convert, SignatureFacade.AH("1rho6f2", file));
            SignatureFacade.AH("dtg6f0", convert, SignatureFacade.AH("-15fp3c", file));
            SignatureFacade.AH("1mem6f3", convert, SignatureFacade.AH("vm06sn", file));
        }
        ArrayDeque toDelete = new ArrayDeque();
        Object fileName = SignatureFacade.AH("-m7vp2u", convert);
        do {
            File toDel;
            File tmp;
            block41: {
                if (withAppearance) {
                    SignatureFacade.setUpAppearance((PadesSignatureOptions)signatureOptions, (CapiPDFApparence)SignatureFacade.AH("1k806f1", file).get(i));
                }
                tmp = SignatureFacade.AH("-7avpgq", fileName, SignatureFacade.AH("vm06sn", convert), (FileAttribute[])new FileAttribute[0]).toFile();
                SignatureFacade.AH("-18ubph7", toDelete, tmp);
                try {
                    Object ih = SignatureFacade.AH("-1ut7p4a", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-1e5fp4g"), convert));
                    Throwable throwable = null;
                    try {
                        Object oh = SignatureFacade.AH("-1cebp4c", SignatureFacade.AH("-fo1p4n", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-1e5fp4g"), tmp), true));
                        Throwable throwable2 = null;
                        try {
                            SignatureFacade.AH("3pc6f4", signatureOptions, ih);
                            SignatureFacade.AH("-1ihfpgp", signatureOptions, oh);
                            char[] cArray = "\ubd70\u4301".toCharArray();
                            cArray[0] = (char)(cArray[0] ^ 0x1AC7);
                            SignatureFacade.AH("dtg6f0", convert, SignatureFacade.AH("-12t5p48", SignatureFacade.AH("-bsrph6", destFile), 0, (int)SignatureFacade.AH("-17rph3", SignatureFacade.AH("-bsrph6", destFile), EncryptFacade$DecryptFacade.P(cArray, (short)21979, (byte)3, true))));
                            try {
                                if (SignatureFacade.AH("9re6eo", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.AH("26u6er", signatureGenerator, signatureOptions);
                                    if (SignatureFacade.AH("-lc7p9q", SignatureFacade.AH("-q47p9k", request), (Object)SignatureType.TSD) != false) {
                                        SignatureFacade.AH("vme6rb", SignatureFacade.AH("14t06fu", signatureOptions));
                                        char[] cArray2 = "\ud777\u21ee\u3ed8\ube4a\u602b\u6fbe\u279d\u87da\ub1d3\u147b\uab19\u61cc\u420d\uf297\u2841\ua118\ud3a0\u106e\u31c4\uffef\u84b8\u86dd\u129d".toCharArray();
                                        cArray2[0] = (char)(cArray2[0] ^ 0x455D);
                                        SignatureFacade.AH("19k26t0", SignatureFacade.AH("-1ut7p4a", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-1e5fp4g"), tmp)), SignatureFacade.AH("-1cebp4c", SignatureFacade.AH("-fo1p4n", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-1e5fp4g"), tmp), true)), (Object)SignatureFacade.AH("-ekhph4", request), (Object)SignatureFacade.AH("-m7vp2u", file), (Object)EncryptFacade$DecryptFacade.P(cArray2, (short)15885, (byte)5, false), (Object)SignatureFacade.AH("1his6t5"), (boolean)false);
                                    }
                                    break block41;
                                }
                                if (SignatureFacade.AH("9re6eo", request) == SignatureOperation.COUNTER_SIGN) {
                                    SignatureFacade.AH("-k6vpg4", signatureOptions, SignatureFacade.AH("-u9dpgf", request));
                                }
                                SignatureFacade.AH("-1q73pg1", signatureGenerator, signatureOptions);
                            }
                            catch (XadesModeException e) {
                                if (SignatureFacade.AH("-pppge", (Object)e) == null) {
                                    throw e;
                                }
                                SignatureFacade.AH("-797phd", signatureOptions, SignatureFacade.AH("-pppge", (Object)e));
                                if (SignatureFacade.AH("9re6eo", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.AH("26u6er", signatureGenerator, signatureOptions);
                                    break block41;
                                }
                                SignatureFacade.AH("-1q73pg1", signatureGenerator, signatureOptions);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (oh != null) {
                                if (throwable2 != null) {
                                    try {
                                        SignatureFacade.AH("vme6rb", oh);
                                    }
                                    catch (Throwable throwable4) {
                                        SignatureFacade.AH("1coe6se", throwable2, throwable4);
                                    }
                                } else {
                                    SignatureFacade.AH("vme6rb", oh);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ih != null) {
                            if (throwable != null) {
                                try {
                                    SignatureFacade.AH("1m4c6s1", ih);
                                }
                                catch (Throwable throwable6) {
                                    SignatureFacade.AH("1coe6se", throwable, throwable6);
                                }
                            } else {
                                SignatureFacade.AH("1m4c6s1", ih);
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    withError = true;
                    SignatureFacade.AH("1k4c6su", logger, SignatureFacade.AH("jra6t6", ex), (Object)ex);
                    if (SignatureFacade.isTokenException(ex)) {
                        signatureStatus = new Status(StatusLevel.ERROR, ex);
                    }
                    SignatureFacade.AH("-fv1p2t", file, new Status(StatusLevel.ERROR, ex));
                }
            }
            if (SignatureFacade.AH("-18v9ph2", file) == null) {
                char[] cArray = "\ub9f0\ubcfc\u1b6c".toCharArray();
                cArray[0] = (char)(cArray[0] ^ 0x28EC);
                SignatureFacade.AH("-fv1p2t", file, new Status(StatusLevel.SUCCESS, EncryptFacade$DecryptFacade.P(cArray, (short)946, (byte)5, true)));
            }
            convert = new FileToSign(tmp);
            SignatureFacade.AH("13s86f5", convert, SignatureFacade.AH("1rho6f2", file));
            SignatureFacade.AH("1mem6f3", convert, SignatureFacade.AH("vm06sn", file));
            ++i;
            if (SignatureFacade.AH("-1fh9pgb", toDelete) <= 2 || (toDel = (File)SignatureFacade.AH("-plrpgg", toDelete)) == null) continue;
            SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", toDel));
        } while (i < appearancesCount && !withError);
        if (!withError) {
            SignatureFacade.AH("-7i3p3u", SignatureFacade.AH("jqu6fm", convert), SignatureFacade.AH("n5m6sf", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        Object object = SignatureFacade.AH("-dcvpgn", toDelete);
        while (object.hasNext()) {
            File del = (File)object.next();
            SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", del));
        }
        return withError;
    }

    private static void setUpAppearance(PadesSignatureOptions signatureOptions, CapiPDFApparence appearance) {
        if (appearance == null) {
            return;
        }
        SignatureFacade.AH("-1lsrpgc", signatureOptions, appearance);
        SignatureFacade.AH("-iu5pgm", signatureOptions, SignatureFacade.AH("-1qofpg9", appearance));
        SignatureFacade.AH("-1a5ppgo", signatureOptions, SignatureFacade.AH("vb26fd", appearance));
        SignatureFacade.AH("bok6ge", signatureOptions, SignatureFacade.AH("15d86fb", appearance));
        SignatureFacade.AH("-he3pfk", signatureOptions, (boolean)SignatureFacade.AH("-arrpfv", appearance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static boolean signAdESDocument(FileToSign fileToSign, SignatureRequest request, SignatureOptions signatureOptions, SignatureGenerator signatureGenerator) throws IOException {
        block45: {
            docError = false;
            withError = false;
            destFile = SignatureFacade.createDestinationFile(fileToSign, request);
            outTmpFile = SignatureFacade.AH("-7avpgq", SignatureFacade.AH("-m7vp2u", fileToSign), SignatureFacade.AH("vm06sn", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile();
            tsdIntTmp = null;
            defOut = SignatureFacade.AH("-ms9pfh", request) != false ? (tsdIntTmp = SignatureFacade.AH("-7avpgq", SignatureFacade.AH("-m7vp2u", fileToSign), SignatureFacade.AH("vm06sn", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile()) : outTmpFile;
            try {
                block44: {
                    ih = SignatureFacade.AH("-1ut7p4a", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-1e5fp4g"), fileToSign));
                    var11_12 = null;
                    try {
                        oh = SignatureFacade.AH("-1cebp4c", SignatureFacade.AH("-fo1p4n", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-1e5fp4g"), defOut), true));
                        var13_16 = null;
                        try {
                            SignatureFacade.AH("3pc6f4", signatureOptions, ih);
                            SignatureFacade.AH("-1ihfpgp", signatureOptions, oh);
                            v0 = "\ua9ed\u03a1".toCharArray();
                            v0[0] = (char)(v0[0] ^ 5289);
                            SignatureFacade.AH("dtg6f0", fileToSign, SignatureFacade.AH("-12t5p48", SignatureFacade.AH("-bsrph6", destFile), 0, (int)SignatureFacade.AH("-17rph3", SignatureFacade.AH("-bsrph6", destFile), EncryptFacade$ValidationFacade.Z(v0, (short)13849, (short)3, (byte)2))));
                            try {
                                switch (1.$SwitchMap$it$actalis$ellips$capi$signature$SignatureOperation[SignatureFacade.AH("-ealpal", SignatureFacade.AH("9re6eo", request))]) {
                                    case 1: {
                                        SignatureFacade.AH("26u6er", signatureGenerator, signatureOptions);
                                        if (SignatureFacade.AH("-ms9pfh", request) == false) break;
                                        SignatureFacade.applyTsd(signatureOptions, tsdIntTmp, outTmpFile, (String)SignatureFacade.AH("-m7vp2u", fileToSign));
                                        break;
                                    }
                                    case 2: {
                                        SignatureFacade.AH("-k6vpg4", signatureOptions, SignatureFacade.AH("-u9dpgf", request));
                                    }
                                    case 3: {
                                        SignatureFacade.AH("-1q73pg1", signatureGenerator, signatureOptions);
                                    }
                                }
                            }
                            catch (XadesModeException e) {
                                if (SignatureFacade.AH("-pppge", (Object)e) == null) {
                                    throw e;
                                }
                                SignatureFacade.AH("-797phd", signatureOptions, SignatureFacade.AH("-pppge", (Object)e));
                                if (SignatureFacade.AH("9re6eo", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.AH("26u6er", signatureGenerator, signatureOptions);
                                    break block44;
                                }
                                SignatureFacade.AH("-1q73pg1", signatureGenerator, signatureOptions);
                            }
                        }
                        catch (Throwable var14_19) {
                            var13_16 = var14_19;
                            throw var14_19;
                        }
                        finally {
                            if (oh != null) {
                                if (var13_16 != null) {
                                    try {
                                        SignatureFacade.AH("vme6rb", oh);
                                    }
                                    catch (Throwable var14_18) {
                                        SignatureFacade.AH("1coe6se", var13_16, var14_18);
                                    }
                                } else {
                                    SignatureFacade.AH("vme6rb", oh);
                                }
                            }
                        }
                    }
                    catch (Throwable var12_15) {
                        var11_12 = var12_15;
                        throw var12_15;
                    }
                    finally {
                        if (ih != null) {
                            if (var11_12 != null) {
                                try {
                                    SignatureFacade.AH("1m4c6s1", ih);
                                }
                                catch (Throwable var12_14) {
                                    SignatureFacade.AH("1coe6se", var11_12, var12_14);
                                }
                            } else {
                                SignatureFacade.AH("1m4c6s1", ih);
                            }
                        }
                    }
                }
                if (docError) break block45;
            }
            catch (Throwable ex) {
                block46: {
                    try {
                        withError = true;
                        docError = true;
                        SignatureFacade.AH("1k4c6su", SignatureFacade.logger, SignatureFacade.AH("jra6t6", ex), (Object)ex);
                        if (SignatureFacade.isTokenException(ex)) {
                            SignatureFacade.signatureStatus = new Status(StatusLevel.ERROR, ex);
                        } else {
                            SignatureFacade.AH("-fv1p2t", fileToSign, new Status(StatusLevel.ERROR, ex));
                        }
                        if (docError) break block46;
                    }
                    catch (Throwable var19_24) {
                        if (!docError) {
                            SignatureFacade.AH("-7i3p3u", SignatureFacade.AH("n5m6sf", outTmpFile), SignatureFacade.AH("n5m6sf", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        }
                        SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", outTmpFile));
                        if (tsdIntTmp != null) {
                            SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", tsdIntTmp));
                        }
                        throw var19_24;
                    }
                    SignatureFacade.AH("-7i3p3u", SignatureFacade.AH("n5m6sf", outTmpFile), SignatureFacade.AH("n5m6sf", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", outTmpFile));
                if (tsdIntTmp != null) {
                    SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", tsdIntTmp));
                } else {
                    ** GOTO lbl108
                }
            }
            SignatureFacade.AH("-7i3p3u", SignatureFacade.AH("n5m6sf", outTmpFile), SignatureFacade.AH("n5m6sf", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", outTmpFile));
        if (tsdIntTmp != null) {
            SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", tsdIntTmp));
        }
        if (SignatureFacade.AH("-18v9ph2", fileToSign) == null) {
            v1 = "\u7ea7\u8bb0\u3afb".toCharArray();
            v1[0] = (char)(v1[0] ^ 21616);
            SignatureFacade.AH("-fv1p2t", fileToSign, new Status(StatusLevel.SUCCESS, EncryptFacade$ValidationFacade.Z(v1, (short)18068, (short)0, (byte)0)));
        }
        return withError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean signAsicS(FileToSign fileToSign, SignatureRequest request, TimeStampOptions tstOpts, ASiCGeneratorOptions aSiCGeneratorOptions, MutableASiCOptions mutableASiCOptions, ASiCGenerator asicGenerator) throws IOException {
        File tmp;
        boolean withError;
        block35: {
            boolean docError = false;
            withError = false;
            File destFile = SignatureFacade.createDestinationFile(fileToSign, request);
            tmp = SignatureFacade.AH("-7avpgq", SignatureFacade.AH("-m7vp2u", fileToSign), SignatureFacade.AH("vm06sn", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile();
            try {
                Object inDoc = SignatureFacade.AH("-1ut7p4a", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-1e5fp4g"), fileToSign));
                Throwable throwable = null;
                try {
                    Object outH = SignatureFacade.AH("-1cebp4c", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-fo1p4n", SignatureFacade.AH("-1e5fp4g"), true), tmp));
                    Throwable throwable2 = null;
                    try {
                        SignatureOptions entry = new SignatureOptions();
                        SignatureFacade.AH("3pc6f4", entry, inDoc);
                        SignatureFacade.AH("qpk6g2", entry, DigestAlgorithm.SHA256);
                        SignatureFacade.AH("-797phd", entry, SignatureMode.DETACHED);
                        SignatureFacade.AH("9926m8", entry, SignatureFacade.AH("-s7fp9h", request));
                        SignatureFacade.AH("-8jppgi", entry, SignatureFacade.AH("-1tlpp9r", request));
                        SignatureFacade.AH("13mg6mb", entry, SignatureFacade.AH("10oe6m2", request));
                        SignatureFacade.AH("1em6md", entry, SignatureFacade.AH("17g46te", SignatureFacade.AH("lcq6sg")));
                        if (SignatureFacade.AH("rhq6m4", SignatureFacade.AH("qo66lp", request), SignatureLevel.BES) == false) {
                            SignatureFacade.AH("-1507phc", entry, tstOpts);
                            SignatureFacade.AH("-1l5bph9", entry, SignatureFacade.AH("qo66lp", request));
                            if (SignatureFacade.AH("rhq6m4", SignatureFacade.AH("qo66lp", request), SignatureLevel.LT) != false) {
                                SignatureFacade.AH("1pie6ma", entry, SignatureFacade.AH("1js66m7", request));
                            }
                        }
                        ArrayList<SignatureOptions> signEntries = new ArrayList<SignatureOptions>();
                        signEntries.add(entry);
                        SignatureFacade.AH("-gehpfr", mutableASiCOptions, ASiCFormat.SIMPLE);
                        SignatureFacade.AH("-1o4jpft", mutableASiCOptions, SignatureFacade.AH("150k6g0", request));
                        SignatureFacade.AH("qvg6g6", aSiCGeneratorOptions, mutableASiCOptions);
                        SignatureFacade.AH("-hh1pg7", aSiCGeneratorOptions, signEntries);
                        SignatureFacade.AH("kjm6g4", aSiCGeneratorOptions, outH);
                        char[] cArray = "\u99eb\u5941".toCharArray();
                        cArray[0] = (char)(cArray[0] ^ 0x32A);
                        SignatureFacade.AH("dtg6f0", fileToSign, SignatureFacade.AH("-12t5p48", SignatureFacade.AH("-bsrph6", destFile), 0, (int)SignatureFacade.AH("-17rph3", SignatureFacade.AH("-bsrph6", destFile), EncryptFacade$DecryptFacade.P(cArray, (short)3456, (byte)1, false))));
                        SignatureFacade.AH("-19blpfp", asicGenerator, aSiCGeneratorOptions);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outH != null) {
                            if (throwable2 != null) {
                                try {
                                    SignatureFacade.AH("vme6rb", outH);
                                }
                                catch (Throwable throwable4) {
                                    SignatureFacade.AH("1coe6se", throwable2, throwable4);
                                }
                            } else {
                                SignatureFacade.AH("vme6rb", outH);
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inDoc != null) {
                        if (throwable != null) {
                            try {
                                SignatureFacade.AH("1m4c6s1", inDoc);
                            }
                            catch (Throwable throwable6) {
                                SignatureFacade.AH("1coe6se", throwable, throwable6);
                            }
                        } else {
                            SignatureFacade.AH("1m4c6s1", inDoc);
                        }
                    }
                }
                if (docError) break block35;
            }
            catch (Throwable ex) {
                block36: {
                    try {
                        withError = true;
                        docError = true;
                        SignatureFacade.AH("15386qr", logger, SignatureFacade.AH("jra6t6", ex));
                        if (SignatureFacade.isTokenException(ex)) {
                            signatureStatus = new Status(StatusLevel.ERROR, ex);
                        } else {
                            SignatureFacade.AH("-fv1p2t", fileToSign, new Status(StatusLevel.ERROR, ex));
                        }
                        if (docError) break block36;
                    }
                    catch (Throwable throwable) {
                        if (!docError) {
                            SignatureFacade.AH("-7i3p3u", SignatureFacade.AH("n5m6sf", tmp), SignatureFacade.AH("n5m6sf", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        }
                        SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", tmp));
                        throw throwable;
                    }
                    SignatureFacade.AH("-7i3p3u", SignatureFacade.AH("n5m6sf", tmp), SignatureFacade.AH("n5m6sf", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", tmp));
            }
            SignatureFacade.AH("-7i3p3u", SignatureFacade.AH("n5m6sf", tmp), SignatureFacade.AH("n5m6sf", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", tmp));
        if (SignatureFacade.AH("-18v9ph2", fileToSign) == null) {
            char[] cArray = "\u88e8\ud330\u2752".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x567A);
            SignatureFacade.AH("-fv1p2t", fileToSign, new Status(StatusLevel.SUCCESS, EncryptFacade$DecryptFacade.P(cArray, (short)32574, (byte)0, true)));
        }
        return withError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean signAsicE(SignatureRequest request) throws IOException, IllegalParamException {
        File tmp;
        File destFile;
        ArrayList<SignatureOptions> signEntries;
        boolean withError;
        boolean docError;
        block24: {
            docError = false;
            withError = false;
            signEntries = new ArrayList<SignatureOptions>();
            destFile = SignatureFacade.createDestinationFile((FileToSign)SignatureFacade.AH("jjs6m3", request), request);
            char[] cArray = "\u5767\u836c\u9333\u260c\ua3cb\ue90e\u619a".toCharArray();
            cArray[3] = (char)(cArray[3] ^ 0x192D);
            tmp = SignatureFacade.AH("-7avpgq", SignatureFacade.AH("-bsrph6", destFile), EncryptFacade$DecryptFacade.P(cArray, (short)11818, (byte)1, true), (FileAttribute[])new FileAttribute[0]).toFile();
            ASiCGenerator asicGenerator = new ASiCGenerator();
            MutableASiCOptions mutableASiCOptions = new MutableASiCOptions();
            ASiCGeneratorOptions aSiCGeneratorOptions = new ASiCGeneratorOptions();
            TimeStampOptions tstOpts = SignatureFacade.getAsicTstOptions(request);
            try {
                Throwable throwable;
                Iterator oh;
                block25: {
                    oh = SignatureFacade.AH("-1cebp4c", SignatureFacade.AH("-fo1p4n", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-1e5fp4g"), tmp), true));
                    throwable = null;
                    Iterator iterator = SignatureFacade.AH("-1if7pa0", request).iterator();
                    while (iterator.hasNext()) {
                        FileToSign file = (FileToSign)iterator.next();
                        SignatureOptions entry = new SignatureOptions();
                        Object inDoc = SignatureFacade.AH("-1ut7p4a", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-1e5fp4g"), file));
                        SignatureFacade.AH("3pc6f4", entry, inDoc);
                        SignatureFacade.AH("qpk6g2", entry, DigestAlgorithm.SHA256);
                        SignatureFacade.AH("-797phd", entry, SignatureMode.DETACHED);
                        SignatureFacade.AH("9926m8", entry, SignatureFacade.AH("-s7fp9h", request));
                        SignatureFacade.AH("-8jppgi", entry, SignatureFacade.AH("-1tlpp9r", request));
                        SignatureFacade.AH("13mg6mb", entry, SignatureFacade.AH("10oe6m2", request));
                        if (SignatureFacade.AH("rhq6m4", SignatureFacade.AH("qo66lp", request), SignatureLevel.BES) == false) {
                            SignatureFacade.AH("-1507phc", entry, tstOpts);
                            SignatureFacade.AH("-1l5bph9", entry, SignatureFacade.AH("qo66lp", request));
                            if (SignatureFacade.AH("rhq6m4", SignatureFacade.AH("qo66lp", request), SignatureLevel.LT) != false) {
                                SignatureFacade.AH("1pie6ma", entry, SignatureFacade.AH("1js66m7", request));
                            }
                        }
                        signEntries.add(entry);
                    }
                    SignatureFacade.AH("-gehpfr", mutableASiCOptions, ASiCFormat.EXTENDED);
                    SignatureFacade.AH("-1o4jpft", mutableASiCOptions, SignatureFacade.AH("150k6g0", request));
                    SignatureFacade.AH("qvg6g6", aSiCGeneratorOptions, mutableASiCOptions);
                    SignatureFacade.AH("-hh1pg7", aSiCGeneratorOptions, signEntries);
                    SignatureFacade.AH("kjm6g4", aSiCGeneratorOptions, oh);
                    SignatureFacade.AH("-19blpfp", asicGenerator, aSiCGeneratorOptions);
                    if (oh == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        SignatureFacade.AH("vme6rb", oh);
                    }
                    catch (Throwable throwable2) {
                        SignatureFacade.AH("1coe6se", throwable, throwable2);
                    }
                    break block24;
                }
                SignatureFacade.AH("vme6rb", oh);
                break block24;
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (oh != null) {
                            if (throwable != null) {
                                try {
                                    SignatureFacade.AH("vme6rb", oh);
                                }
                                catch (Throwable throwable5) {
                                    SignatureFacade.AH("1coe6se", throwable, throwable5);
                                }
                            } else {
                                SignatureFacade.AH("vme6rb", oh);
                            }
                        }
                        throw throwable4;
                    }
                }
            }
            catch (Throwable ex) {
                try {
                    withError = true;
                    docError = true;
                    SignatureFacade.AH("15386qr", logger, SignatureFacade.AH("jra6t6", ex));
                    signatureStatus = new Status(StatusLevel.ERROR, ex);
                }
                catch (Throwable throwable) {
                    for (SignatureOptions entry : signEntries) {
                        if (SignatureFacade.AH("-1uh3pg6", entry) == null) continue;
                        SignatureFacade.AH("1m4c6s1", SignatureFacade.AH("-1uh3pg6", entry));
                    }
                    if (!docError) {
                        SignatureFacade.AH("-7i3p3u", SignatureFacade.AH("n5m6sf", tmp), SignatureFacade.AH("n5m6sf", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    }
                    SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", tmp));
                    throw throwable;
                }
                for (SignatureOptions entry : signEntries) {
                    if (SignatureFacade.AH("-1uh3pg6", entry) == null) continue;
                    SignatureFacade.AH("1m4c6s1", SignatureFacade.AH("-1uh3pg6", entry));
                }
                if (!docError) {
                    SignatureFacade.AH("-7i3p3u", SignatureFacade.AH("n5m6sf", tmp), SignatureFacade.AH("n5m6sf", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", tmp));
            }
        }
        for (SignatureOptions entry : signEntries) {
            if (SignatureFacade.AH("-1uh3pg6", entry) == null) continue;
            SignatureFacade.AH("1m4c6s1", SignatureFacade.AH("-1uh3pg6", entry));
        }
        if (!docError) {
            SignatureFacade.AH("-7i3p3u", SignatureFacade.AH("n5m6sf", tmp), SignatureFacade.AH("n5m6sf", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.AH("16c66fj", SignatureFacade.AH("n5m6sf", tmp));
        return withError;
    }

    private static void applyTsd(SignatureOptions signatureOptions, File inputFile, File outputFile, String outFileName) throws Exception {
        TSAData tsaData = new TSAData();
        Object prop = SignatureFacade.AH("lcq6sg");
        SignatureFacade.AH("1ogc6fo", tsaData, SignatureFacade.AH("j9u6ft", prop, ServerProperties.TSA_ACCOUNT, (Object)""));
        SignatureFacade.AH("6u6fr", tsaData, SignatureFacade.AH("j9u6ft", prop, ServerProperties.TSA_SERVER_ADDRESS, (Object)""));
        SignatureFacade.AH("ass6gu", tsaData, SignatureFacade.AH("j9u6ft", prop, ServerProperties.TSA_POLICY, (Object)""));
        SignatureFacade.AH("-lrlpff", tsaData, SignatureFacade.AH("j9u6ft", prop, ServerProperties.TSA_PASSWORD, (Object)""));
        Object inputHandlerFile = SignatureFacade.AH("-1ut7p4a", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-1e5fp4g"), inputFile));
        Throwable throwable = null;
        try {
            Object outputHandlerFile = SignatureFacade.AH("-1cebp4c", SignatureFacade.AH("-fo1p4n", SignatureFacade.AH("-1m87p4d", SignatureFacade.AH("-1e5fp4g"), outputFile), true));
            Throwable throwable2 = null;
            try {
                SignatureFacade.AH("vme6rb", SignatureFacade.AH("14t06fu", signatureOptions));
                char[] cArray = "\ucae9\uf4ab\u09a9\u2615\u2eac\u1581\u93fa\u15c9\u78a7\uc383\ua76d\u9c5d\u7f97\u97c2\uc490\u967d\u7371\ue23c\u8dba\u3358\ua67c\u4d5b\u0d2b".toCharArray();
                cArray[13] = (char)(cArray[13] ^ 0x238B);
                SignatureFacade.AH("19k26t0", inputHandlerFile, outputHandlerFile, (Object)tsaData, (Object)outFileName, (Object)EncryptFacade$DecryptFacade.P(cArray, (short)6035, (byte)0, true), (Object)SignatureFacade.AH("1his6t5"), (boolean)false);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (outputHandlerFile != null) {
                    if (throwable2 != null) {
                        try {
                            SignatureFacade.AH("vme6rb", outputHandlerFile);
                        }
                        catch (Throwable throwable4) {
                            SignatureFacade.AH("1coe6se", throwable2, throwable4);
                        }
                    } else {
                        SignatureFacade.AH("vme6rb", outputHandlerFile);
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            if (inputHandlerFile != null) {
                if (throwable != null) {
                    try {
                        SignatureFacade.AH("1m4c6s1", inputHandlerFile);
                    }
                    catch (Throwable throwable6) {
                        SignatureFacade.AH("1coe6se", throwable, throwable6);
                    }
                } else {
                    SignatureFacade.AH("1m4c6s1", inputHandlerFile);
                }
            }
        }
    }

    private static File createDestinationFile(FileToSign src, SignatureRequest request) throws IOException {
        Object destinationFolder = SignatureFacade.AH("-9sbpa6", request);
        if (destinationFolder == null) {
            destinationFolder = SignatureFacade.AH("fo26s9", src);
        }
        if (SignatureFacade.AH("9re6eo", request) == SignatureOperation.NEW_SIGN) {
            return SignatureFacade.AH("1sjo6ri", destinationFolder, SignatureFacade.AH("-15fp3c", src), (Object)SignatureFacade.AH("vm06sn", src));
        }
        if (SignatureFacade.AH("-lc7p9q", (Object)SignatureType.ASICE, SignatureFacade.AH("-q47p9k", request)) != false) {
            return new File((String)SignatureFacade.AH("17ie6r8", SignatureFacade.AH("-4jvp4m", SignatureFacade.AH("-4jvp4m", SignatureFacade.AH("-4jvp4m", SignatureFacade.AH("a4a6gs", new StringBuilder(), destinationFolder), File.separator), SignatureFacade.AH("-15fp3c", src)), SignatureFacade.AH("vm06sn", src))));
        }
        return new File((String)SignatureFacade.AH("17ie6r8", SignatureFacade.AH("-4jvp4m", SignatureFacade.AH("-4jvp4m", SignatureFacade.AH("-4jvp4m", SignatureFacade.AH("-4jvp4m", new StringBuilder(), SignatureFacade.AH("19tc6gv", src)), File.separator), SignatureFacade.AH("-15fp3c", src)), SignatureFacade.AH("vm06sn", src))));
    }

    private static boolean isTokenException(Throwable ex) {
        if (!(ex instanceof CapiException)) {
            return false;
        }
        CapiException capiException = (CapiException)ex;
        return SignatureFacade.AH("-o8rpfe", (Object)capiException) == 2014 || SignatureFacade.AH("-o8rpfe", (Object)capiException) == 2001 || SignatureFacade.AH("-o8rpfe", (Object)capiException) == 10013;
    }

    static /* synthetic */ I18N access$000() {
        return i18n;
    }

    static {
        char[] cArray = "\uce49\ud5f6\u4956\ue0a9\u9e12\ub82e\udd01\uc504\u9054\u1288\uf5b6\uade5\u2d9a\u418c\u54f3\u54b6\ue4d1\u45ab\u3fc2\u08ad\u1c1b\u5c8e\uf119\u2a26\ud80a\u9eff\ud1e4\u6a4f\uf74b\u2446\u3aef\u7372\u1748\uccfd\u78d1\udf68\u7cff".toCharArray();
        cArray[7] = (char)(cArray[7] ^ 0x48FB);
        i18n = SignatureFacade.AH("-1monpfb", EncryptFacade$DecryptFacade.P(cArray, (short)20111, (byte)0, false));
        signatureStatus = null;
    }

    private static Object AH(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(fszpagix.x(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }

    public static final class SignatureFormat
    extends Enum<SignatureFormat> {
        public static final /* enum */ SignatureFormat T;
        public static final /* enum */ SignatureFormat LT;
        public static final /* enum */ SignatureFormat TSD;
        private final SignatureLevel signatureLevel;
        private static final /* synthetic */ SignatureFormat[] $VALUES;

        public static SignatureFormat[] values() {
            return (SignatureFormat[])$VALUES.clone();
        }

        public static SignatureFormat valueOf(String name) {
            return (SignatureFormat)((Object)SignatureFormat.ev("qra6sl", SignatureFormat.class, name));
        }

        private SignatureFormat(SignatureLevel signatureLevel) {
            this.signatureLevel = signatureLevel;
        }

        public SignatureLevel getSignatureLevel() {
            return this.signatureLevel;
        }

        static {
            char[] cArray = "\u8661\u49a3".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x4F6A);
            T = new SignatureFormat(SignatureLevel.T);
            char[] cArray2 = "\u29c5\ufd0d\u5613".toCharArray();
            cArray2[0] = (char)(cArray2[0] ^ 0x595E);
            LT = new SignatureFormat(SignatureLevel.LT);
            char[] cArray3 = "\ue965\u2f93\ua0bf\u3e2e".toCharArray();
            cArray3[2] = (char)(cArray3[2] ^ 0x2320);
            TSD = new SignatureFormat(SignatureLevel.BES);
            $VALUES = new SignatureFormat[]{T, LT, TSD};
        }

        private static Object ev(Object object, Object object2, Object object3) {
            try {
                return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(fszpagix.x(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
            }
            catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                throw new BootstrapMethodError(reflectiveOperationException);
            }
        }
    }

    public static final class SignatureType
    extends Enum<SignatureType> {
        public static final /* enum */ SignatureType CADES;
        public static final /* enum */ SignatureType PADES;
        public static final /* enum */ SignatureType XADES;
        public static final /* enum */ SignatureType ASICS;
        public static final /* enum */ SignatureType ASICE;
        public static final /* enum */ SignatureType TSD;
        private final String extension;
        private final String name;
        private final String fullName;
        private final String description;
        private static final /* synthetic */ SignatureType[] $VALUES;

        public static SignatureType[] values() {
            return (SignatureType[])$VALUES.clone();
        }

        public static SignatureType valueOf(String name) {
            return (SignatureType)((Object)SignatureType.OE("qra6sl", SignatureType.class, name));
        }

        private SignatureType(String name, String ext, String fullName, String description) {
            this.name = name;
            this.extension = ext;
            this.fullName = fullName;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getFullName() {
            Object temp = SignatureType.OE("-fvvpaj", SignatureType.OE("1bo26la"), this.fullName, (Object[])new Object[0]);
            char[] cArray = "\u68ac\u5537\u6be1".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x5C42);
            char[] cArray2 = "\uf0fd\ubf03\u22c4".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x45C);
            if (SignatureType.OE("182c6s7", temp, SignatureType.OE("17ie6r8", SignatureType.OE("-4jvp4m", SignatureType.OE("-4jvp4m", SignatureType.OE("-4jvp4m", new StringBuilder(), EncryptFacade$DecryptFacade.P(cArray, (short)668, (byte)3, false)), this.fullName), EncryptFacade$DecryptFacade.P(cArray2, (short)27226, (byte)2, true)))) != false) {
                return this.fullName;
            }
            return temp;
        }

        public String getDescription() {
            Object temp = SignatureType.OE("-fvvpaj", SignatureType.OE("1bo26la"), this.description, (Object[])new Object[0]);
            char[] cArray = "\u76d9\u23bd\u5eca".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x2DFC);
            char[] cArray2 = "\u993a\u4222\u5b8c".toCharArray();
            cArray2[0] = (char)(cArray2[0] ^ 0x2CC4);
            if (SignatureType.OE("182c6s7", temp, SignatureType.OE("17ie6r8", SignatureType.OE("-4jvp4m", SignatureType.OE("-4jvp4m", SignatureType.OE("-4jvp4m", new StringBuilder(), EncryptFacade$ValidationFacade.Z(cArray, (short)17223, (short)2, (byte)0)), this.description), EncryptFacade$ValidationFacade.Z(cArray2, (short)31732, (short)4, (byte)5)))) != false) {
                return this.description;
            }
            return temp;
        }

        static {
            char[] cArray = "\u18de\u475f\u9121\ub614\ua472\u1e5b".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x2732);
            char[] cArray2 = "\u4ff1\ua2e5p\ub5d4\udf45\u6705".toCharArray();
            cArray2[2] = (char)(cArray2[2] ^ 0xF51);
            char[] cArray3 = "\u583d\u8d67\uc388\ud684\u0aec".toCharArray();
            cArray3[0] = (char)(cArray3[0] ^ 0x6ACF);
            char[] cArray4 = "\u634e\uccac\u111b\u3894\ud1b4\ub85d\uac4c\ude23\u8289\u5743\u1ef6\u2175\ub4bc\u023f\ufd3e\u10c5\u4b6b\u631b\u357d\uda07\uceae\ued07\u03db\u4fe2\u9a34\u4036\ubf51\u3913\u1077\u5905\u4f12\u685c\u06d5\uf1fa\u8eea\u9518\u2b1c".toCharArray();
            cArray4[13] = (char)(cArray4[13] ^ 0x55D5);
            char[] cArray5 = "\u72f9\ua3a6\u2ca3\ud312\ucd41\u9eff\u2b28\uef3a\u6146\u991d\ue9e4\uf8cc\u6920\u212d\ubc8b\u9d14\ub39b\ueff6\u34b0\u934c\uc52e\u4bb0\u3559\u9ecf\u2a9f\ufefb\u474b\u07f3\uf627\u3ab6\u85d0\u5f64\uebfb\u86c3\u2aef\udc95\u0f36\udab8\u53be\u4980".toCharArray();
            cArray5[31] = (char)(cArray5[31] ^ 0x58A);
            CADES = new SignatureType(EncryptFacade$ValidationFacade.Z(cArray2, (short)9605, (short)2, (byte)1), EncryptFacade$ValidationFacade.Z(cArray3, (short)11715, (short)5, (byte)4), EncryptFacade$ValidationFacade.Z(cArray4, (short)11650, (short)2, (byte)1), EncryptFacade$ValidationFacade.Z(cArray5, (short)2500, (short)4, (byte)3));
            char[] cArray6 = "\u8f26\uc657\u9628\u9b01\u5dc8\u65c9".toCharArray();
            cArray6[2] = (char)(cArray6[2] ^ 0x777E);
            char[] cArray7 = "\u95d4\u4df6\u4a21\u9c12\u3335\u1332".toCharArray();
            cArray7[0] = (char)(cArray7[0] ^ 0x255C);
            char[] cArray8 = "\u6845\ud6b1\ua273\uec49\u4b0c".toCharArray();
            cArray8[0] = (char)(cArray8[0] ^ 0xE36);
            char[] cArray9 = "\ud3e2\u5f34\u9411\u721b\uc1bc\u0cd4\ue77a\u9c62\u27e8\u078b\u1313\u060e\ud458\u7646\u4434\u92ac\ubad5\u4cc4\ud7f1\ud676\u3dcc\u738b\ucfb0\u19a0\ue422\u67ba\u4722\ue3a8\uc65a\ucc47\u81d2\u64b1\u0f22\ub900\uce0c\u7ad8\u0d91".toCharArray();
            cArray9[19] = (char)(cArray9[19] ^ 0x6BB4);
            char[] cArray10 = "\u67be\u6c6c\u8e42\uc8c3\uf4ca\uc3eb\u3048\u25fe\u69b1\uf41d\u9305\u021a\u8628\ua98d\u75d3\ua761\ucac9\u1cf1\ua5ef\u6d5b\u570c\u7936\ud50a\ud598\u48b3\uab63\u838a\ufaa4\u73aa\uba69\u385b\u5f16\u2fbc/\ud16d\u6e16\ub886\ud11d\u203c\u61f2".toCharArray();
            cArray10[5] = (char)(cArray10[5] ^ 0x4A1);
            PADES = new SignatureType(EncryptFacade$ValidationFacade.Z(cArray7, (short)16391, (short)5, (byte)4), EncryptFacade$ValidationFacade.Z(cArray8, (short)7458, (short)5, (byte)0), EncryptFacade$ValidationFacade.Z(cArray9, (short)24236, (short)5, (byte)3), EncryptFacade$ValidationFacade.Z(cArray10, (short)13174, (short)5, (byte)2));
            char[] cArray11 = "\u1f1c\u331f\u33fe\uc105\u5d08\u4153".toCharArray();
            cArray11[4] = (char)(cArray11[4] ^ 0x5BD9);
            char[] cArray12 = "\u7c45\u8fa5\uc188\u238a\u9d32\u3f2e".toCharArray();
            cArray12[4] = (char)(cArray12[4] ^ 0x1750);
            char[] cArray13 = "\ue4af\uddbb\u90f9\u1502\u764d".toCharArray();
            cArray13[0] = (char)(cArray13[0] ^ 0x4EF6);
            char[] cArray14 = "\u2e60\ucdda\u32a3\u7de7\uc939\u8667\ue1ae\ua858\u578f\u08a4\u89fe\u2aee\u5c72\uc8b6\u4ed8\ua81f\u25de\u0f62\u88f7\ufd63\u90ef\u848e\u97cb\u8bfc\u3d1a\u4fa3\u3b55\u7af9\u8059\uc7da\u84a6\ue1a3\ucbf2\u7d0a\u21da\u0cc9\u2641".toCharArray();
            cArray14[12] = (char)(cArray14[12] ^ 0x1712);
            char[] cArray15 = "\u4ab6\u2685\ub519\ub65a\u3f64\u63a0\ude7e\u32af\u5210\u391f\uc794\uba3e\u7d2f\u50b1\uaa1e\u4c85\uc0b5\u6467\u9cc7\uc5b6\u22a5\u3bd3\u96c2\u4d20\ufbf4\u5da4\ud3f0\u9673\u380b\uc9a8\uf0bb\u81a4\ue930\uc864\u1c06\u573f\uc331\u71a3\u177a\u050e".toCharArray();
            cArray15[34] = (char)(cArray15[34] ^ 0x4C4C);
            XADES = new SignatureType(EncryptFacade$ValidationFacade.Z(cArray12, (short)6654, (short)1, (byte)2), EncryptFacade$ValidationFacade.Z(cArray13, (short)20232, (short)1, (byte)0), EncryptFacade$ValidationFacade.Z(cArray14, (short)26943, (short)4, (byte)0), EncryptFacade$ValidationFacade.Z(cArray15, (short)23539, (short)0, (byte)3));
            char[] cArray16 = "\u2a25\ucabc\udae8\u821e\u7e62\u4986".toCharArray();
            cArray16[4] = (char)(cArray16[4] ^ 0x3120);
            char[] cArray17 = "\u9571\uaf85\ueb18\u4ce7\ub2c7\u1d11\u5b48".toCharArray();
            cArray17[1] = (char)(cArray17[1] ^ 0x6477);
            char[] cArray18 = "\u7b5b\u7391\u9068\u74d6\u72f2\u0d11\u4c58".toCharArray();
            cArray18[2] = (char)(cArray18[2] ^ 0x30E8);
            char[] cArray19 = "\u3a74\uadf3\u07b7\uc9bc\uc842\u5006\u67dc".toCharArray();
            cArray19[4] = (char)(cArray19[4] ^ 0x30BF);
            char[] cArray20 = "\u0e83\u2dae\u5c4a\u59eb\u1fdd\u6bcd\ua65a\udc21\u1e4b\uc342\u0664\u8c0d\u49fa\uf9e2\u5a87\u1bf4\u252b\u1e93\u7798\u5d35\u9e93\u4d82\u50b0\u95d8\u784f\u7e49\u981c\u9deb\u308e\u179f\u92be\uf185\u4d1a\u917e\u8d3a\u75ff\u86d8\u9bd2\u76d2".toCharArray();
            cArray20[34] = (char)(cArray20[34] ^ 0x4C17);
            ASICS = new SignatureType(EncryptFacade$ValidationFacade.Z(cArray17, (short)1280, (short)4, (byte)5), EncryptFacade$ValidationFacade.Z(cArray18, (short)21350, (short)1, (byte)0), EncryptFacade$ValidationFacade.Z(cArray19, (short)2526, (short)0, (byte)5), EncryptFacade$ValidationFacade.Z(cArray20, (short)1943, (short)4, (byte)0));
            char[] cArray21 = "\u469b\uc3fa\u7b2a\udf80\uc06c\u0945".toCharArray();
            cArray21[2] = (char)(cArray21[2] ^ 0x371A);
            char[] cArray22 = "\uf308\u46ae\ufc16\u26b7\u4260\udf86\u59ef".toCharArray();
            cArray22[1] = (char)(cArray22[1] ^ 0x2C80);
            char[] cArray23 = "\u6261\u5d80\uc652\uc9cf\ua3ec\u1cbe\u4d3c".toCharArray();
            cArray23[5] = (char)(cArray23[5] ^ 0x753);
            char[] cArray24 = "\u2904\ue412\u35c3\u6f0f\ua4d8\ucffe\u2019".toCharArray();
            cArray24[5] = (char)(cArray24[5] ^ 0x26);
            char[] cArray25 = "\uf844\u0763\uacad\uc159\u8f81\u0ec2\u0bd6\u0a8a\u8822\u43a9\u4343\uf976\u3808\u8bab\u9d45\uc80a\u43ab\u7494\uf584\u9ac1\ue517\u9c44\ubb3d\u5709\u3151\ubaef\u6b9b\uae9b\uf5d3\u9495\ub847\u0a90\ub059\u8af7\u4487\ud277\uc888\u8de4\u2d78".toCharArray();
            cArray25[12] = (char)(cArray25[12] ^ 0x76A7);
            ASICE = new SignatureType(EncryptFacade$ValidationFacade.Z(cArray22, (short)17978, (short)2, (byte)0), EncryptFacade$ValidationFacade.Z(cArray23, (short)1491, (short)1, (byte)5), EncryptFacade$ValidationFacade.Z(cArray24, (short)17604, (short)1, (byte)3), EncryptFacade$ValidationFacade.Z(cArray25, (short)21003, (short)1, (byte)5));
            char[] cArray26 = "\ue6cc\ub960\u329c\u5113".toCharArray();
            cArray26[2] = (char)(cArray26[2] ^ 0x6B76);
            char[] cArray27 = "\u2aa0\u543d\u6387\u1d6a".toCharArray();
            cArray27[2] = (char)(cArray27[2] ^ 0x123D);
            char[] cArray28 = "\u0bd7\u95e2\u157e\u1c50\u0c5f".toCharArray();
            cArray28[2] = (char)(cArray28[2] ^ 0x727B);
            char[] cArray29 = "\ua34c\u7779\u5327\u710c".toCharArray();
            cArray29[0] = (char)(cArray29[0] ^ 0x2CEA);
            TSD = new SignatureType(EncryptFacade$ValidationFacade.Z(cArray27, (short)27064, (short)0, (byte)3), EncryptFacade$ValidationFacade.Z(cArray28, (short)24954, (short)4, (byte)5), EncryptFacade$ValidationFacade.Z(cArray29, (short)20289, (short)0, (byte)5), "");
            $VALUES = new SignatureType[]{CADES, PADES, XADES, ASICS, ASICE, TSD};
        }

        private static Object OE(Object object, Object object2, Object object3) {
            try {
                return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(fszpagix.x(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
            }
            catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                throw new BootstrapMethodError(reflectiveOperationException);
            }
        }
    }
}

