/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import com.sun.jna.Platform;
import esecurity.desktop.swt.SWTClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WIN_OS {
    private static final Logger logger = LoggerFactory.getLogger(WIN_OS.class);

    public static long GetForegroundWindow() {
        try {
            if (Platform.is64Bit()) {
                return (Long)SWTClass.WIN_OS.getRef().callStaticMethod("GetForegroundWindow", new Object[0]);
            }
            return ((Integer)SWTClass.WIN_OS.getRef().callStaticMethod("GetForegroundWindow", new Object[0])).intValue();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return 0L;
        }
    }

    public static boolean SetForegroundWindow(long hWnd) {
        try {
            if (Platform.is64Bit()) {
                return (Boolean)SWTClass.WIN_OS.getRef().callStaticMethod("SetForegroundWindow", hWnd);
            }
            return (Boolean)SWTClass.WIN_OS.getRef().callStaticMethod("SetForegroundWindow", (int)hWnd);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return false;
        }
    }

    public static int GetWindowThreadProcessId(long hWnd, int[] lpdwProcessId) {
        try {
            if (Platform.is64Bit()) {
                return (Integer)SWTClass.WIN_OS.getRef().callStaticMethod("GetWindowThreadProcessId", hWnd, lpdwProcessId);
            }
            return (Integer)SWTClass.WIN_OS.getRef().callStaticMethod("GetWindowThreadProcessId", (int)hWnd, lpdwProcessId);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return 0;
        }
    }

    public static boolean AttachThreadInput(int idAttach, int idAttachTo, boolean fAttach) {
        try {
            return (Boolean)SWTClass.WIN_OS.getRef().callStaticMethod("AttachThreadInput", idAttach, idAttachTo, fAttach);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return false;
        }
    }

    public static boolean BringWindowToTop(long hWnd) {
        try {
            if (Platform.is64Bit()) {
                return (Boolean)SWTClass.WIN_OS.getRef().callStaticMethod("BringWindowToTop", hWnd);
            }
            return (Boolean)SWTClass.WIN_OS.getRef().callStaticMethod("BringWindowToTop", (int)hWnd);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return false;
        }
    }

    public static boolean UpdateWindow(long hWnd) {
        try {
            if (Platform.is64Bit()) {
                return (Boolean)SWTClass.WIN_OS.getRef().callStaticMethod("UpdateWindow", hWnd);
            }
            return (Boolean)SWTClass.WIN_OS.getRef().callStaticMethod("UpdateWindow", (int)hWnd);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return false;
        }
    }

    public static long SetActiveWindow(long hWnd) {
        try {
            if (Platform.is64Bit()) {
                return (Long)SWTClass.WIN_OS.getRef().callStaticMethod("SetActiveWindow", hWnd);
            }
            return ((Integer)SWTClass.WIN_OS.getRef().callStaticMethod("SetActiveWindow", (int)hWnd)).intValue();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return 0L;
        }
    }
}

